/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.cont.ContinuableRecordInput;
import org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.StringUtil;

public class UnicodeString
implements Comparable {
    private static POILogger _logger;
    private short field_1_charCount;
    private byte field_2_optionflags;
    private String field_3_string;
    private List field_4_format_runs;
    private ExtRst field_5_ext_rst;
    private static final BitField highByte;
    private static final BitField extBit;
    private static final BitField richText;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hssf.record.common.UnicodeString");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = POILogFactory.getLogger(clazz);
        highByte = BitFieldFactory.getInstance(1);
        extBit = BitFieldFactory.getInstance(4);
        richText = BitFieldFactory.getInstance(8);
    }

    private UnicodeString() {
    }

    public UnicodeString(String str) {
        this.setString(str);
    }

    public int hashCode() {
        int stringHash = 0;
        if (this.field_3_string != null) {
            stringHash = this.field_3_string.hashCode();
        }
        return this.field_1_charCount + stringHash;
    }

    public boolean equals(Object o) {
        boolean eq;
        if (!(o instanceof UnicodeString)) {
            return false;
        }
        UnicodeString other = (UnicodeString)o;
        boolean bl = eq = this.field_1_charCount == other.field_1_charCount && this.field_2_optionflags == other.field_2_optionflags && this.field_3_string.equals(other.field_3_string);
        if (!eq) {
            return false;
        }
        if (this.field_4_format_runs == null && other.field_4_format_runs == null) {
            return true;
        }
        if (this.field_4_format_runs == null && other.field_4_format_runs != null || this.field_4_format_runs != null && other.field_4_format_runs == null) {
            return false;
        }
        int size = this.field_4_format_runs.size();
        if (size != other.field_4_format_runs.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            FormatRun run2;
            FormatRun run1 = (FormatRun)this.field_4_format_runs.get(i);
            if (!run1.equals(run2 = (FormatRun)other.field_4_format_runs.get(i))) {
                return false;
            }
            ++i;
        }
        if (this.field_5_ext_rst != null || other.field_5_ext_rst != null) {
            if (this.field_5_ext_rst != null && other.field_5_ext_rst != null) {
                int extCmp = this.field_5_ext_rst.compareTo(other.field_5_ext_rst);
                if (extCmp != 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public UnicodeString(RecordInputStream in) {
        this.field_1_charCount = in.readShort();
        this.field_2_optionflags = in.readByte();
        int runCount = 0;
        int extensionLength = 0;
        if (this.isRichText()) {
            runCount = in.readShort();
        }
        if (this.isExtendedText()) {
            extensionLength = in.readInt();
        }
        boolean isCompressed = (this.field_2_optionflags & 1) == 0;
        this.field_3_string = isCompressed ? in.readCompressedUnicode(this.getCharCount()) : in.readUnicodeLEString(this.getCharCount());
        if (this.isRichText() && runCount > 0) {
            this.field_4_format_runs = new ArrayList(runCount);
            int i = 0;
            while (i < runCount) {
                this.field_4_format_runs.add(new FormatRun(in));
                ++i;
            }
        }
        if (this.isExtendedText() && extensionLength > 0) {
            this.field_5_ext_rst = new ExtRst(new ContinuableRecordInput(in), extensionLength);
            if (this.field_5_ext_rst.getDataSize() + 4 != extensionLength) {
                _logger.log(POILogger.WARN, "ExtRst was supposed to be " + extensionLength + " bytes long, but seems to actually be " + (this.field_5_ext_rst.getDataSize() + 4));
            }
        }
    }

    public int getCharCount() {
        if (this.field_1_charCount < 0) {
            return this.field_1_charCount + 65536;
        }
        return this.field_1_charCount;
    }

    public short getCharCountShort() {
        return this.field_1_charCount;
    }

    public void setCharCount(short cc) {
        this.field_1_charCount = cc;
    }

    public byte getOptionFlags() {
        return this.field_2_optionflags;
    }

    public void setOptionFlags(byte of) {
        this.field_2_optionflags = of;
    }

    public String getString() {
        return this.field_3_string;
    }

    public void setString(String string) {
        this.field_3_string = string;
        this.setCharCount((short)this.field_3_string.length());
        boolean useUTF16 = false;
        int strlen = string.length();
        int j = 0;
        while (j < strlen) {
            if (string.charAt(j) > '\u00ff') {
                useUTF16 = true;
                break;
            }
            ++j;
        }
        this.field_2_optionflags = useUTF16 ? highByte.setByte(this.field_2_optionflags) : highByte.clearByte(this.field_2_optionflags);
    }

    public int getFormatRunCount() {
        if (this.field_4_format_runs == null) {
            return 0;
        }
        return this.field_4_format_runs.size();
    }

    public FormatRun getFormatRun(int index) {
        if (this.field_4_format_runs == null) {
            return null;
        }
        if (index < 0 || index >= this.field_4_format_runs.size()) {
            return null;
        }
        return (FormatRun)this.field_4_format_runs.get(index);
    }

    private int findFormatRunAt(int characterPos) {
        int size = this.field_4_format_runs.size();
        int i = 0;
        while (i < size) {
            FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
            if (r._character == characterPos) {
                return i;
            }
            if (r._character > characterPos) {
                return -1;
            }
            ++i;
        }
        return -1;
    }

    public void addFormatRun(FormatRun r) {
        int index;
        if (this.field_4_format_runs == null) {
            this.field_4_format_runs = new ArrayList();
        }
        if ((index = this.findFormatRunAt(r._character)) != -1) {
            this.field_4_format_runs.remove(index);
        }
        this.field_4_format_runs.add(r);
        Collections.sort(this.field_4_format_runs);
        this.field_2_optionflags = richText.setByte(this.field_2_optionflags);
    }

    public Iterator formatIterator() {
        if (this.field_4_format_runs != null) {
            return this.field_4_format_runs.iterator();
        }
        return null;
    }

    public void removeFormatRun(FormatRun r) {
        this.field_4_format_runs.remove(r);
        if (this.field_4_format_runs.size() == 0) {
            this.field_4_format_runs = null;
            this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
        }
    }

    public void clearFormatting() {
        this.field_4_format_runs = null;
        this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
    }

    public ExtRst getExtendedRst() {
        return this.field_5_ext_rst;
    }

    void setExtendedRst(ExtRst ext_rst) {
        this.field_2_optionflags = ext_rst != null ? extBit.setByte(this.field_2_optionflags) : extBit.clearByte(this.field_2_optionflags);
        this.field_5_ext_rst = ext_rst;
    }

    public void swapFontUse(short oldFontIndex, short newFontIndex) {
        Iterator iterator = this.field_4_format_runs.iterator();
        while (iterator.hasNext()) {
            FormatRun run = (FormatRun)iterator.next();
            if (run._fontIndex != oldFontIndex) continue;
            run._fontIndex = newFontIndex;
        }
    }

    public String toString() {
        return this.getString();
    }

    public String getDebugInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNICODESTRING]\n");
        buffer.append("    .charcount       = ").append(Integer.toHexString(this.getCharCount())).append("\n");
        buffer.append("    .optionflags     = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        buffer.append("    .string          = ").append(this.getString()).append("\n");
        if (this.field_4_format_runs != null) {
            int i = 0;
            while (i < this.field_4_format_runs.size()) {
                FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
                buffer.append("      .format_run" + i + "          = ").append(r.toString()).append("\n");
                ++i;
            }
        }
        if (this.field_5_ext_rst != null) {
            buffer.append("    .field_5_ext_rst          = ").append("\n");
            buffer.append(this.field_5_ext_rst.toString()).append("\n");
        }
        buffer.append("[/UNICODESTRING]\n");
        return buffer.toString();
    }

    public void serialize(ContinuableRecordOutput out) {
        int numberOfRichTextRuns = 0;
        int extendedDataSize = 0;
        if (this.isRichText() && this.field_4_format_runs != null) {
            numberOfRichTextRuns = this.field_4_format_runs.size();
        }
        if (this.isExtendedText() && this.field_5_ext_rst != null) {
            extendedDataSize = 4 + this.field_5_ext_rst.getDataSize();
        }
        out.writeString(this.field_3_string, numberOfRichTextRuns, extendedDataSize);
        if (numberOfRichTextRuns > 0) {
            int i = 0;
            while (i < numberOfRichTextRuns) {
                if (out.getAvailableSpace() < 4) {
                    out.writeContinue();
                }
                FormatRun r = (FormatRun)this.field_4_format_runs.get(i);
                r.serialize(out);
                ++i;
            }
        }
        if (extendedDataSize > 0) {
            this.field_5_ext_rst.serialize(out);
        }
    }

    public int compareTo(Object str2) {
        UnicodeString str = (UnicodeString)str2;
        int result = this.getString().compareTo(str.getString());
        if (result != 0) {
            return result;
        }
        if (this.field_4_format_runs == null && str.field_4_format_runs == null) {
            return 0;
        }
        if (this.field_4_format_runs == null && str.field_4_format_runs != null) {
            return 1;
        }
        if (this.field_4_format_runs != null && str.field_4_format_runs == null) {
            return -1;
        }
        int size = this.field_4_format_runs.size();
        if (size != str.field_4_format_runs.size()) {
            return size - str.field_4_format_runs.size();
        }
        int i = 0;
        while (i < size) {
            FormatRun run2;
            FormatRun run1 = (FormatRun)this.field_4_format_runs.get(i);
            result = run1.compareTo(run2 = (FormatRun)str.field_4_format_runs.get(i));
            if (result != 0) {
                return result;
            }
            ++i;
        }
        if (this.field_5_ext_rst == null && str.field_5_ext_rst == null) {
            return 0;
        }
        if (this.field_5_ext_rst == null && str.field_5_ext_rst != null) {
            return 1;
        }
        if (this.field_5_ext_rst != null && str.field_5_ext_rst == null) {
            return -1;
        }
        result = this.field_5_ext_rst.compareTo(str.field_5_ext_rst);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    private boolean isRichText() {
        return richText.isSet(this.getOptionFlags());
    }

    private boolean isExtendedText() {
        return extBit.isSet(this.getOptionFlags());
    }

    public Object clone() {
        UnicodeString str = new UnicodeString();
        str.field_1_charCount = this.field_1_charCount;
        str.field_2_optionflags = this.field_2_optionflags;
        str.field_3_string = this.field_3_string;
        if (this.field_4_format_runs != null) {
            str.field_4_format_runs = new ArrayList();
            Iterator iterator = this.field_4_format_runs.iterator();
            while (iterator.hasNext()) {
                FormatRun r = (FormatRun)iterator.next();
                str.field_4_format_runs.add(new FormatRun(r._character, r._fontIndex));
            }
        }
        if (this.field_5_ext_rst != null) {
            str.field_5_ext_rst = (ExtRst)this.field_5_ext_rst.clone();
        }
        return str;
    }

    public static class ExtRst
    implements Comparable {
        private short reserved;
        private short formattingFontIndex;
        private short formattingOptions;
        private int numberOfRuns;
        private String phoneticText;
        private PhRun[] phRuns;
        private byte[] extraData;

        private void populateEmpty() {
            this.reserved = 1;
            this.phoneticText = "";
            this.phRuns = new PhRun[0];
            this.extraData = new byte[0];
        }

        protected ExtRst() {
            this.populateEmpty();
        }

        protected ExtRst(LittleEndianInput in, int expectedLength) {
            this.reserved = in.readShort();
            if (this.reserved == -1) {
                this.populateEmpty();
                return;
            }
            if (this.reserved != 1) {
                _logger.log(POILogger.WARN, "Warning - ExtRst has wrong magic marker, expecting 1 but found " + this.reserved + " - ignoring");
                int i = 0;
                while (i < expectedLength - 2) {
                    in.readByte();
                    ++i;
                }
                this.populateEmpty();
                return;
            }
            short stringDataSize = in.readShort();
            this.formattingFontIndex = in.readShort();
            this.formattingOptions = in.readShort();
            this.numberOfRuns = in.readUShort();
            short length1 = in.readShort();
            short length2 = in.readShort();
            if (length1 == 0 && length2 > 0) {
                length2 = 0;
            }
            if (length1 != length2) {
                throw new IllegalStateException("The two length fields of the Phonetic Text don't agree! " + length1 + " vs " + length2);
            }
            this.phoneticText = StringUtil.readUnicodeLE(in, length1);
            int runData = stringDataSize - 4 - 6 - 2 * this.phoneticText.length();
            int numRuns = runData / 6;
            this.phRuns = new PhRun[numRuns];
            int i = 0;
            while (i < this.phRuns.length) {
                this.phRuns[i] = new PhRun(in);
                ++i;
            }
            int extraDataLength = runData - numRuns * 6;
            if (extraDataLength < 0) {
                System.err.println("Warning - ExtRst overran by " + (0 - extraDataLength) + " bytes");
                extraDataLength = 0;
            }
            this.extraData = new byte[extraDataLength];
            int i2 = 0;
            while (i2 < this.extraData.length) {
                this.extraData[i2] = in.readByte();
                ++i2;
            }
        }

        protected int getDataSize() {
            return 10 + 2 * this.phoneticText.length() + 6 * this.phRuns.length + this.extraData.length;
        }

        protected void serialize(ContinuableRecordOutput out) {
            int dataSize = this.getDataSize();
            out.writeContinueIfRequired(8);
            out.writeShort(this.reserved);
            out.writeShort(dataSize);
            out.writeShort(this.formattingFontIndex);
            out.writeShort(this.formattingOptions);
            out.writeContinueIfRequired(6);
            out.writeShort(this.numberOfRuns);
            out.writeShort(this.phoneticText.length());
            out.writeShort(this.phoneticText.length());
            out.writeContinueIfRequired(this.phoneticText.length() * 2);
            StringUtil.putUnicodeLE(this.phoneticText, out);
            int i = 0;
            while (i < this.phRuns.length) {
                this.phRuns[i].serialize(out);
                ++i;
            }
            out.write(this.extraData);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExtRst)) {
                return false;
            }
            ExtRst other = (ExtRst)obj;
            return this.compareTo(other) == 0;
        }

        public int compareTo(Object o2) {
            ExtRst o = (ExtRst)o2;
            int result = this.reserved - o.reserved;
            if (result != 0) {
                return result;
            }
            result = this.formattingFontIndex - o.formattingFontIndex;
            if (result != 0) {
                return result;
            }
            result = this.formattingOptions - o.formattingOptions;
            if (result != 0) {
                return result;
            }
            result = this.numberOfRuns - o.numberOfRuns;
            if (result != 0) {
                return result;
            }
            result = this.phoneticText.compareTo(o.phoneticText);
            if (result != 0) {
                return result;
            }
            result = this.phRuns.length - o.phRuns.length;
            if (result != 0) {
                return result;
            }
            int i = 0;
            while (i < this.phRuns.length) {
                result = this.phRuns[i].phoneticTextFirstCharacterOffset - o.phRuns[i].phoneticTextFirstCharacterOffset;
                if (result != 0) {
                    return result;
                }
                result = this.phRuns[i].realTextFirstCharacterOffset - o.phRuns[i].realTextFirstCharacterOffset;
                if (result != 0) {
                    return result;
                }
                result = this.phRuns[i].realTextFirstCharacterOffset - o.phRuns[i].realTextLength;
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            result = this.extraData.length - o.extraData.length;
            if (result != 0) {
                return result;
            }
            return 0;
        }

        protected Object clone() {
            ExtRst ext = new ExtRst();
            ext.reserved = this.reserved;
            ext.formattingFontIndex = this.formattingFontIndex;
            ext.formattingOptions = this.formattingOptions;
            ext.numberOfRuns = this.numberOfRuns;
            ext.phoneticText = this.phoneticText;
            ext.phRuns = new PhRun[this.phRuns.length];
            int i = 0;
            while (i < ext.phRuns.length) {
                ext.phRuns[i] = new PhRun(this.phRuns[i].phoneticTextFirstCharacterOffset, this.phRuns[i].realTextFirstCharacterOffset, this.phRuns[i].realTextLength);
                ++i;
            }
            return ext;
        }

        public short getFormattingFontIndex() {
            return this.formattingFontIndex;
        }

        public short getFormattingOptions() {
            return this.formattingOptions;
        }

        public int getNumberOfRuns() {
            return this.numberOfRuns;
        }

        public String getPhoneticText() {
            return this.phoneticText;
        }

        public PhRun[] getPhRuns() {
            return this.phRuns;
        }
    }

    public static class FormatRun
    implements Comparable {
        final short _character;
        short _fontIndex;

        public FormatRun(short character, short fontIndex) {
            this._character = character;
            this._fontIndex = fontIndex;
        }

        public FormatRun(LittleEndianInput in) {
            this(in.readShort(), in.readShort());
        }

        public short getCharacterPos() {
            return this._character;
        }

        public short getFontIndex() {
            return this._fontIndex;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FormatRun)) {
                return false;
            }
            FormatRun other = (FormatRun)o;
            return this._character == other._character && this._fontIndex == other._fontIndex;
        }

        public int compareTo(Object r2) {
            FormatRun r = (FormatRun)r2;
            if (this._character == r._character && this._fontIndex == r._fontIndex) {
                return 0;
            }
            if (this._character == r._character) {
                return this._fontIndex - r._fontIndex;
            }
            return this._character - r._character;
        }

        public String toString() {
            return "character=" + this._character + ",fontIndex=" + this._fontIndex;
        }

        public void serialize(LittleEndianOutput out) {
            out.writeShort(this._character);
            out.writeShort(this._fontIndex);
        }
    }

    public static class PhRun {
        private int phoneticTextFirstCharacterOffset;
        private int realTextFirstCharacterOffset;
        private int realTextLength;

        public PhRun(int phoneticTextFirstCharacterOffset, int realTextFirstCharacterOffset, int realTextLength) {
            this.phoneticTextFirstCharacterOffset = phoneticTextFirstCharacterOffset;
            this.realTextFirstCharacterOffset = realTextFirstCharacterOffset;
            this.realTextLength = realTextLength;
        }

        private PhRun(LittleEndianInput in) {
            this.phoneticTextFirstCharacterOffset = in.readUShort();
            this.realTextFirstCharacterOffset = in.readUShort();
            this.realTextLength = in.readUShort();
        }

        private void serialize(ContinuableRecordOutput out) {
            out.writeContinueIfRequired(6);
            out.writeShort(this.phoneticTextFirstCharacterOffset);
            out.writeShort(this.realTextFirstCharacterOffset);
            out.writeShort(this.realTextLength);
        }
    }
}

