/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormat;

public final class HSSFDataFormat
implements DataFormat {
    private static final String[] _builtinFormats = BuiltinFormats.getAll();
    private final Vector _formats = new Vector();
    private final InternalWorkbook _workbook;
    private boolean _movedBuiltins = false;

    HSSFDataFormat(InternalWorkbook workbook) {
        this._workbook = workbook;
        Iterator i = workbook.getFormats().iterator();
        while (i.hasNext()) {
            FormatRecord r = (FormatRecord)i.next();
            this.ensureFormatsSize(r.getIndexCode());
            this._formats.set(r.getIndexCode(), r.getFormatString());
        }
    }

    public static List getBuiltinFormats() {
        return Arrays.asList(_builtinFormats);
    }

    public static short getBuiltinFormat(String format) {
        return (short)BuiltinFormats.getBuiltinFormat(format);
    }

    public short getFormat(String pFormat) {
        int i;
        String format = pFormat.toUpperCase().equals("TEXT") ? "@" : pFormat;
        if (!this._movedBuiltins) {
            i = 0;
            while (i < _builtinFormats.length) {
                this.ensureFormatsSize(i);
                if (this._formats.get(i) == null) {
                    this._formats.set(i, _builtinFormats[i]);
                }
                ++i;
            }
            this._movedBuiltins = true;
        }
        i = 0;
        while (i < this._formats.size()) {
            if (format.equals(this._formats.get(i))) {
                return (short)i;
            }
            ++i;
        }
        short index = this._workbook.getFormat(format, true);
        this.ensureFormatsSize(index);
        this._formats.set(index, format);
        return index;
    }

    public String getFormat(short index) {
        if (this._movedBuiltins) {
            return (String)this._formats.get(index);
        }
        if (index == -1) {
            return null;
        }
        String fmt = this._formats.size() > index ? this._formats.get(index) : null;
        if (_builtinFormats.length > index && _builtinFormats[index] != null) {
            if (fmt != null) {
                return fmt;
            }
            return _builtinFormats[index];
        }
        return fmt;
    }

    public static String getBuiltinFormat(short index) {
        return BuiltinFormats.getBuiltinFormat(index);
    }

    public static int getNumberOfBuiltinBuiltinFormats() {
        return _builtinFormats.length;
    }

    private void ensureFormatsSize(int index) {
        if (this._formats.size() <= index) {
            this._formats.setSize(index + 1);
        }
    }
}

