/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.ss.usermodel;

/**
 * The enumeration value indicating the possible paper size for a sheet
 *
 * @author Daniele Montagni
 */
public class PaperSize {
	public static final PaperSize LETTER_PAPER = new PaperSize(0);
	public static final PaperSize LETTER_SMALL_PAPER = new PaperSize(1);
	public static final PaperSize TABLOID_PAPER = new PaperSize(2);
	public static final PaperSize LEDGER_PAPER = new PaperSize(3);
	public static final PaperSize LEGAL_PAPER = new PaperSize(4);
	public static final PaperSize STATEMENT_PAPER = new PaperSize(5);
	public static final PaperSize EXECUTIVE_PAPER = new PaperSize(6);
	public static final PaperSize A3_PAPER = new PaperSize(7);
	public static final PaperSize A4_PAPER = new PaperSize(8);
	public static final PaperSize A4_SMALL_PAPER = new PaperSize(9);
	public static final PaperSize A5_PAPER = new PaperSize(10);
	public static final PaperSize B4_PAPER = new PaperSize(11);
	public static final PaperSize B5_PAPER = new PaperSize(12);
	public static final PaperSize FOLIO_PAPER = new PaperSize(13);
	public static final PaperSize QUARTO_PAPER = new PaperSize(14);
	public static final PaperSize STANDARD_PAPER_10_14 = new PaperSize(15);
	public static final PaperSize STANDARD_PAPER_11_17 = new PaperSize(16);

	public PaperSize(int i) {
		_ordinal = i;
	}

	private int _ordinal;

	public int ordinal() {
		return _ordinal;
	}

	public static PaperSize[] values() {
		return new PaperSize[] { LETTER_PAPER, LETTER_SMALL_PAPER,
				TABLOID_PAPER, LEDGER_PAPER, LEGAL_PAPER, STATEMENT_PAPER,
				EXECUTIVE_PAPER, A3_PAPER, A4_PAPER, A4_SMALL_PAPER, A5_PAPER,
				B4_PAPER, B5_PAPER, FOLIO_PAPER, QUARTO_PAPER,
				STANDARD_PAPER_10_14, STANDARD_PAPER_11_17 };
	}
}
