/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import poi.support.Iterable;

public final class PackageRelationshipCollection
implements Iterable {
    private static POILogger logger;
    private TreeMap relationshipsByID = new TreeMap();
    private TreeMap relationshipsByType = new TreeMap();
    private PackagePart relationshipPart;
    private PackagePart sourcePart;
    private PackagePartName partName;
    private OPCPackage container;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.openxml4j.opc.PackageRelationshipCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
    }

    PackageRelationshipCollection() {
    }

    public PackageRelationshipCollection(PackageRelationshipCollection coll, String filter) {
        this();
        Iterator iterator = coll.relationshipsByID.values().iterator();
        while (iterator.hasNext()) {
            PackageRelationship rel = (PackageRelationship)iterator.next();
            if (filter != null && !rel.getRelationshipType().equals(filter)) continue;
            this.addRelationship(rel);
        }
    }

    public PackageRelationshipCollection(OPCPackage container) throws InvalidFormatException {
        this(container, null);
    }

    public PackageRelationshipCollection(PackagePart part) throws InvalidFormatException {
        this(part._container, part);
    }

    public PackageRelationshipCollection(OPCPackage container, PackagePart part) throws InvalidFormatException {
        this();
        if (container == null) {
            throw new IllegalArgumentException("container");
        }
        if (part != null && part.isRelationshipPart()) {
            throw new IllegalArgumentException("part");
        }
        this.container = container;
        this.sourcePart = part;
        this.partName = PackageRelationshipCollection.getRelationshipPartName(part);
        if (container.getPackageAccess() != PackageAccess.WRITE && container.containPart(this.partName)) {
            this.relationshipPart = container.getPart(this.partName);
            this.parseRelationshipsPart(this.relationshipPart);
        }
    }

    private static PackagePartName getRelationshipPartName(PackagePart part) throws InvalidOperationException {
        PackagePartName partName = part == null ? PackagingURIHelper.PACKAGE_ROOT_PART_NAME : part.getPartName();
        return PackagingURIHelper.getRelationshipPartName(partName);
    }

    public void addRelationship(PackageRelationship relPart) {
        this.relationshipsByID.put(relPart.getId(), relPart);
        this.relationshipsByType.put(relPart.getRelationshipType(), relPart);
    }

    public PackageRelationship addRelationship(URI targetUri, TargetMode targetMode, String relationshipType, String id) {
        if (id == null) {
            int i = 0;
            while (this.relationshipsByID.get(id = "rId" + ++i) != null) {
            }
        }
        PackageRelationship rel = new PackageRelationship(this.container, this.sourcePart, targetUri, targetMode, relationshipType, id);
        this.relationshipsByID.put(rel.getId(), rel);
        this.relationshipsByType.put(rel.getRelationshipType(), rel);
        return rel;
    }

    public void removeRelationship(String id) {
        PackageRelationship rel;
        if (this.relationshipsByID != null && this.relationshipsByType != null && (rel = (PackageRelationship)this.relationshipsByID.get(id)) != null) {
            this.relationshipsByID.remove(rel.getId());
            this.relationshipsByType.values().remove(rel);
        }
    }

    public void removeRelationship(PackageRelationship rel) {
        if (rel == null) {
            throw new IllegalArgumentException("rel");
        }
        this.relationshipsByID.values().remove(rel);
        this.relationshipsByType.values().remove(rel);
    }

    public PackageRelationship getRelationship(int index) {
        if (index < 0 || index > this.relationshipsByID.values().size()) {
            throw new IllegalArgumentException("index");
        }
        PackageRelationship retRel = null;
        int i = 0;
        Iterator iterator = this.relationshipsByID.values().iterator();
        while (iterator.hasNext()) {
            PackageRelationship rel = (PackageRelationship)iterator.next();
            if (index != i++) continue;
            return rel;
        }
        return retRel;
    }

    public PackageRelationship getRelationshipByID(String id) {
        return (PackageRelationship)this.relationshipsByID.get(id);
    }

    public int size() {
        return this.relationshipsByID.values().size();
    }

    private void parseRelationshipsPart(PackagePart relPart) throws InvalidFormatException {
        try {
            SAXReader reader = new SAXReader();
            logger.log(POILogger.DEBUG, (Object)("Parsing relationship: " + relPart.getPartName()));
            Document xmlRelationshipsDoc = reader.read(relPart.getInputStream());
            Element root = xmlRelationshipsDoc.getRootElement();
            boolean fCorePropertiesRelationship = false;
            Iterator i = root.elementIterator("Relationship");
            while (i.hasNext()) {
                URI target;
                Element element = (Element)i.next();
                String id = element.attribute("Id").getValue();
                String type = element.attribute("Type").getValue();
                if (type.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
                    if (!fCorePropertiesRelationship) {
                        fCorePropertiesRelationship = true;
                    } else {
                        throw new InvalidFormatException("OPC Compliance error [M4.1]: there is more than one core properties relationship in the package !");
                    }
                }
                Attribute targetModeAttr = element.attribute("TargetMode");
                TargetMode targetMode = TargetMode.INTERNAL;
                if (targetModeAttr != null) {
                    targetMode = targetModeAttr.getValue().toLowerCase().equals("internal") ? TargetMode.INTERNAL : TargetMode.EXTERNAL;
                }
                String value = "";
                try {
                    value = element.attribute("Target").getValue();
                    target = PackagingURIHelper.toURI(value);
                }
                catch (URISyntaxException e) {
                    logger.log(POILogger.ERROR, (Object)("Cannot convert " + value + " in a valid relationship URI-> ignored"), (Throwable)e);
                    continue;
                }
                this.addRelationship(target, targetMode, type, id);
            }
        }
        catch (Exception e) {
            logger.log(POILogger.ERROR, (Throwable)e);
            throw new InvalidFormatException(e.getMessage());
        }
    }

    public PackageRelationshipCollection getRelationships(String typeFilter) {
        PackageRelationshipCollection coll = new PackageRelationshipCollection(this, typeFilter);
        return coll;
    }

    public Iterator iterator() {
        return this.relationshipsByID.values().iterator();
    }

    public Iterator iterator(String typeFilter) {
        ArrayList<PackageRelationship> retArr = new ArrayList<PackageRelationship>();
        Iterator iterator = this.relationshipsByID.values().iterator();
        while (iterator.hasNext()) {
            PackageRelationship rel = (PackageRelationship)iterator.next();
            if (!rel.getRelationshipType().equals(typeFilter)) continue;
            retArr.add(rel);
        }
        return retArr.iterator();
    }

    public void clear() {
        this.relationshipsByID.clear();
        this.relationshipsByType.clear();
    }

    public String toString() {
        String str = this.relationshipsByID == null ? "relationshipsByID=null" : String.valueOf(this.relationshipsByID.size()) + " relationship(s) = [";
        str = this.relationshipPart != null && this.relationshipPart._partName != null ? String.valueOf(str) + "," + this.relationshipPart._partName : String.valueOf(str) + ",relationshipPart=null";
        str = this.sourcePart != null && this.sourcePart._partName != null ? String.valueOf(str) + "," + this.sourcePart._partName : String.valueOf(str) + ",sourcePart=null";
        str = this.partName != null ? String.valueOf(str) + "," + this.partName : String.valueOf(str) + ",uri=null)";
        return String.valueOf(str) + "]";
    }
}

