/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.PackageHelper;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.usermodel.SlideLayout;
import org.apache.poi.xslf.usermodel.XSLFCommentAuthors;
import org.apache.poi.xslf.usermodel.XSLFFactory;
import org.apache.poi.xslf.usermodel.XSLFNotesMaster;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTableStyles;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPresentation;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideSize;
import org.openxmlformats.schemas.presentationml.x2006.main.PresentationDocument;

public class XMLSlideShow
extends POIXMLDocument {
    private static POILogger _logger;
    private CTPresentation _presentation;
    private List _slides;
    private Map _masters;
    private List _pictures;
    private XSLFTableStyles _tableStyles;
    private XSLFNotesMaster _notesMaster;
    private XSLFCommentAuthors _commentAuthors;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.xslf.usermodel.XMLSlideShow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = POILogFactory.getLogger((Class)clazz);
    }

    public XMLSlideShow() {
        this(XMLSlideShow.empty());
    }

    public XMLSlideShow(OPCPackage pkg) {
        super(pkg);
        try {
            if (this.getCorePart().getContentType().equals(XSLFRelation.THEME_MANAGER.getContentType())) {
                this.rebase(this.getPackage());
            }
            this.load(XSLFFactory.getInstance());
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    public XMLSlideShow(InputStream is) throws IOException {
        this(PackageHelper.open(is));
    }

    static final OPCPackage empty() {
        InputStream is;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.xslf.usermodel.XMLSlideShow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((is = clazz.getResourceAsStream("empty.pptx")) == null) {
            throw new RuntimeException("Missing resource 'empty.pptx'");
        }
        try {
            return OPCPackage.open(is);
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    public XSLFSlideShow _getXSLFSlideShow() throws OpenXML4JException, IOException, XmlException {
        return new XSLFSlideShow(this.getPackage());
    }

    protected void onDocumentRead() throws IOException {
        try {
            PresentationDocument doc = PresentationDocument.Factory.parse((InputStream)this.getCorePart().getInputStream());
            this._presentation = doc.getPresentation();
            HashMap<String, XSLFSlide> shIdMap = new HashMap<String, XSLFSlide>();
            this._masters = new HashMap();
            Iterator iterator = this.getRelations().iterator();
            while (iterator.hasNext()) {
                POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
                if (p instanceof XSLFSlide) {
                    shIdMap.put(p.getPackageRelationship().getId(), (XSLFSlide)p);
                    continue;
                }
                if (p instanceof XSLFSlideMaster) {
                    XSLFSlideMaster master = (XSLFSlideMaster)p;
                    this._masters.put(p.getPackageRelationship().getId(), master);
                    continue;
                }
                if (p instanceof XSLFTableStyles) {
                    this._tableStyles = (XSLFTableStyles)p;
                    continue;
                }
                if (p instanceof XSLFNotesMaster) {
                    this._notesMaster = (XSLFNotesMaster)p;
                    continue;
                }
                if (!(p instanceof XSLFCommentAuthors)) continue;
                this._commentAuthors = (XSLFCommentAuthors)p;
            }
            this._slides = new ArrayList();
            if (this._presentation.isSetSldIdLst()) {
                List<CTSlideIdListEntry> slideIds = Arrays.asList(this._presentation.getSldIdLst().getSldIdArray());
                Iterator<CTSlideIdListEntry> iterator2 = slideIds.iterator();
                while (iterator2.hasNext()) {
                    CTSlideIdListEntry slId = iterator2.next();
                    XSLFSlide sh = (XSLFSlide)shIdMap.get(slId.getId2());
                    if (sh == null) {
                        _logger.log(POILogger.WARN, (Object)("Slide with r:id " + slId.getId() + " was defined, but didn't exist in package, skipping"));
                        continue;
                    }
                    this._slides.add(sh);
                }
            }
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
    }

    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this._presentation.save(out, xmlOptions);
        out.close();
    }

    public List getAllEmbedds() throws OpenXML4JException {
        return Collections.unmodifiableList(this.getPackage().getPartsByName(Pattern.compile("/ppt/embeddings/.*?")));
    }

    public List getAllPictures() {
        if (this._pictures == null) {
            List mediaParts = this.getPackage().getPartsByName(Pattern.compile("/ppt/media/.*?"));
            this._pictures = new ArrayList(mediaParts.size());
            Iterator iterator = mediaParts.iterator();
            while (iterator.hasNext()) {
                PackagePart part = (PackagePart)iterator.next();
                this._pictures.add(new XSLFPictureData(part, null));
            }
        }
        return Collections.unmodifiableList(this._pictures);
    }

    public XSLFSlide createSlide(XSLFSlideLayout layout) {
        CTSlideIdListEntry slideId;
        CTSlideIdList slideList;
        int slideNumber = 256;
        int cnt = 1;
        if (!this._presentation.isSetSldIdLst()) {
            slideList = this._presentation.addNewSldIdLst();
        } else {
            slideList = this._presentation.getSldIdLst();
            Iterator<CTSlideIdListEntry> iterator = Arrays.asList(slideList.getSldIdArray()).iterator();
            while (iterator.hasNext()) {
                slideId = iterator.next();
                slideNumber = (int)Math.max(slideId.getId() + 1L, (long)slideNumber);
                ++cnt;
            }
        }
        XSLFSlide slide = (XSLFSlide)this.createRelationship(XSLFRelation.SLIDE, XSLFFactory.getInstance(), cnt);
        slideId = slideList.addNewSldId();
        slideId.setId((long)slideNumber);
        slideId.setId2(slide.getPackageRelationship().getId());
        layout.copyLayout(slide);
        slide.addRelation(layout.getPackageRelationship().getId(), layout);
        PackagePartName ppName = layout.getPackagePart().getPartName();
        slide.getPackagePart().addRelationship(ppName, TargetMode.INTERNAL, layout.getPackageRelationship().getRelationshipType());
        this._slides.add(slide);
        return slide;
    }

    public XSLFSlide createSlide() {
        String masterId = this._presentation.getSldMasterIdLst().getSldMasterIdArray(0).getId2();
        XSLFSlideMaster master = (XSLFSlideMaster)this._masters.get(masterId);
        XSLFSlideLayout layout = master.getLayout(SlideLayout.BLANK);
        if (layout == null) {
            throw new IllegalArgumentException("Blank layout was not found");
        }
        return this.createSlide(layout);
    }

    public XSLFNotesMaster getNotesMaster() {
        return this._notesMaster;
    }

    public XSLFSlideMaster[] getSlideMasters() {
        return this._masters.values().toArray(new XSLFSlideMaster[this._masters.size()]);
    }

    public XSLFSlide[] getSlides() {
        return this._slides.toArray(new XSLFSlide[this._slides.size()]);
    }

    public XSLFCommentAuthors getCommentAuthors() {
        return this._commentAuthors;
    }

    public void setSlideOrder(XSLFSlide slide, int newIndex) {
        int oldIndex = this._slides.indexOf(slide);
        if (oldIndex == -1) {
            throw new IllegalArgumentException("Slide not found");
        }
        this._slides.add(newIndex, this._slides.remove(oldIndex));
        List<CTSlideIdListEntry> slideIds = Arrays.asList(this._presentation.getSldIdLst().getSldIdArray());
        CTSlideIdListEntry oldEntry = slideIds.get(oldIndex);
        slideIds.add(newIndex, oldEntry);
        slideIds.remove(oldEntry);
    }

    public XSLFSlide removeSlide(int index) {
        XSLFSlide slide = (XSLFSlide)this._slides.remove(index);
        this.removeRelation(slide);
        Arrays.asList(this._presentation.getSldIdLst().getSldIdArray()).remove(index);
        return slide;
    }

    public Dimension getPageSize() {
        CTSlideSize sz = this._presentation.getSldSz();
        int cx = sz.getCx();
        int cy = sz.getCy();
        return new Dimension((int)Units.toPoints(cx), (int)Units.toPoints(cy));
    }

    public void setPageSize(Dimension pgSize) {
        CTSlideSize sz = CTSlideSize.Factory.newInstance();
        sz.setCx(Units.toEMU(pgSize.getWidth()));
        sz.setCy(Units.toEMU(pgSize.getHeight()));
        this._presentation.setSldSz(sz);
    }

    public CTPresentation getCTPresentation() {
        return this._presentation;
    }

    public int addPicture(byte[] pictureData, int format) {
        XSLFPictureData img = this.findPictureData(pictureData);
        POIXMLRelation relDesc = XSLFPictureData.RELATIONS[format];
        if (img == null) {
            int imageNumber = this._pictures.size();
            img = (XSLFPictureData)this.createRelationship(XSLFPictureData.RELATIONS[format], XSLFFactory.getInstance(), imageNumber + 1, true);
            this._pictures.add(img);
            try {
                OutputStream out = img.getPackagePart().getOutputStream();
                out.write(pictureData);
                out.close();
            }
            catch (IOException e) {
                throw new POIXMLException(e);
            }
            return this._pictures.size() - 1;
        }
        return this._pictures.indexOf(img);
    }

    XSLFPictureData findPictureData(byte[] pictureData) {
        long checksum = IOUtils.calculateChecksum((byte[])pictureData);
        Iterator iterator = this.getAllPictures().iterator();
        while (iterator.hasNext()) {
            XSLFPictureData pic = (XSLFPictureData)iterator.next();
            if (pic.getChecksum() != checksum) continue;
            return pic;
        }
        return null;
    }

    public XSLFTableStyles getTableStyles() {
        return this._tableStyles;
    }

    CTTextParagraphProperties getDefaultParagraphStyle(int level) {
        XmlObject[] o = this._presentation.selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//p:defaultTextStyle/a:lvl" + (level + 1) + "pPr");
        if (o.length == 1) {
            return (CTTextParagraphProperties)o[0];
        }
        return null;
    }
}

