/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.VerticalAlignment;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineEndProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCell;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCellProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.STCompoundLine;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineCap;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndLength;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndType;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndWidth;
import org.openxmlformats.schemas.drawingml.x2006.main.STPenAlignment;
import org.openxmlformats.schemas.drawingml.x2006.main.STPresetLineDashVal;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;

public class XSLFTableCell
extends XSLFTextShape {
    static double defaultBorderWidth = 1.0;

    XSLFTableCell(CTTableCell cell, XSLFSheet sheet) {
        super((XmlObject)cell, sheet);
    }

    public XmlObject getXmlObject() {
        return (CTTableCell)super.getXmlObject();
    }

    protected CTTextBody getTextBody(boolean create) {
        CTTableCell cell = (CTTableCell)this.getXmlObject();
        CTTextBody txBody = cell.getTxBody();
        if (txBody == null && create) {
            txBody = cell.addNewTxBody();
            txBody.addNewBodyPr();
            txBody.addNewLstStyle();
        }
        return txBody;
    }

    static CTTableCell prototype() {
        CTTableCell cell = CTTableCell.Factory.newInstance();
        CTTableCellProperties pr = cell.addNewTcPr();
        pr.addNewLnL().addNewNoFill();
        pr.addNewLnR().addNewNoFill();
        pr.addNewLnT().addNewNoFill();
        pr.addNewLnB().addNewNoFill();
        return cell;
    }

    public void setLeftInset(double margin) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        if (pr == null) {
            pr = ((CTTableCell)this.getXmlObject()).addNewTcPr();
        }
        pr.setMarL(Units.toEMU(margin));
    }

    public void setRightInset(double margin) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        if (pr == null) {
            pr = ((CTTableCell)this.getXmlObject()).addNewTcPr();
        }
        pr.setMarR(Units.toEMU(margin));
    }

    public void setTopInset(double margin) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        if (pr == null) {
            pr = ((CTTableCell)this.getXmlObject()).addNewTcPr();
        }
        pr.setMarT(Units.toEMU(margin));
    }

    public void setBottomInset(double margin) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        if (pr == null) {
            pr = ((CTTableCell)this.getXmlObject()).addNewTcPr();
        }
        pr.setMarB(Units.toEMU(margin));
    }

    public void setBorderLeft(double width) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.isSetLnL() ? pr.getLnL() : pr.addNewLnL();
        ln.setW(Units.toEMU(width));
    }

    public double getBorderLeft() {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.getLnL();
        return ln == null || !ln.isSetW() ? defaultBorderWidth : Units.toPoints(ln.getW());
    }

    public void setBorderLeftColor(Color color) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.isSetLnL() ? pr.getLnL() : pr.addNewLnL();
        this.setLineColor(ln, color);
    }

    public Color getBorderLeftColor() {
        return this.getLineColor(((CTTableCell)this.getXmlObject()).getTcPr().getLnL());
    }

    public void setBorderRight(double width) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.isSetLnR() ? pr.getLnR() : pr.addNewLnR();
        ln.setW(Units.toEMU(width));
    }

    public double getBorderRight() {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.getLnR();
        return ln == null || !ln.isSetW() ? defaultBorderWidth : Units.toPoints(ln.getW());
    }

    public void setBorderRightColor(Color color) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.isSetLnR() ? pr.getLnR() : pr.addNewLnR();
        this.setLineColor(ln, color);
    }

    public Color getBorderRightColor() {
        return this.getLineColor(((CTTableCell)this.getXmlObject()).getTcPr().getLnR());
    }

    public void setBorderTop(double width) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.isSetLnT() ? pr.getLnT() : pr.addNewLnT();
        ln.setW(Units.toEMU(width));
    }

    public double getBorderTop() {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.getLnT();
        return ln == null || !ln.isSetW() ? defaultBorderWidth : Units.toPoints(ln.getW());
    }

    public void setBorderTopColor(Color color) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.isSetLnT() ? pr.getLnT() : pr.addNewLnT();
        this.setLineColor(ln, color);
    }

    public Color getBorderTopColor() {
        return this.getLineColor(((CTTableCell)this.getXmlObject()).getTcPr().getLnT());
    }

    public void setBorderBottom(double width) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.isSetLnB() ? pr.getLnB() : pr.addNewLnB();
        ln.setW(Units.toEMU(width));
    }

    public double getBorderBottom() {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.getLnB();
        return ln == null || !ln.isSetW() ? defaultBorderWidth : Units.toPoints(ln.getW());
    }

    public void setBorderBottomColor(Color color) {
        CTTableCellProperties pr = ((CTTableCell)this.getXmlObject()).getTcPr();
        CTLineProperties ln = pr.isSetLnB() ? pr.getLnB() : pr.addNewLnB();
        this.setLineColor(ln, color);
    }

    public Color getBorderBottomColor() {
        return this.getLineColor(((CTTableCell)this.getXmlObject()).getTcPr().getLnB());
    }

    private void setLineColor(CTLineProperties ln, Color color) {
        if (color == null) {
            ln.addNewNoFill();
            if (ln.isSetSolidFill()) {
                ln.unsetSolidFill();
            }
        } else {
            if (ln.isSetNoFill()) {
                ln.unsetNoFill();
            }
            if (!ln.isSetPrstDash()) {
                ln.addNewPrstDash().setVal(STPresetLineDashVal.SOLID);
            }
            ln.setCmpd(STCompoundLine.SNG);
            ln.setAlgn(STPenAlignment.CTR);
            ln.setCap(STLineCap.FLAT);
            ln.addNewRound();
            CTLineEndProperties hd = ln.addNewHeadEnd();
            hd.setType(STLineEndType.NONE);
            hd.setW(STLineEndWidth.MED);
            hd.setLen(STLineEndLength.MED);
            CTLineEndProperties tl = ln.addNewTailEnd();
            tl.setType(STLineEndType.NONE);
            tl.setW(STLineEndWidth.MED);
            tl.setLen(STLineEndLength.MED);
            CTSRgbColor rgb = CTSRgbColor.Factory.newInstance();
            rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            ln.addNewSolidFill().setSrgbClr(rgb);
        }
    }

    private Color getLineColor(CTLineProperties ln) {
        if (ln == null || ln.isSetNoFill() || !ln.isSetSolidFill()) {
            return null;
        }
        CTSolidColorFillProperties fill = ln.getSolidFill();
        if (!fill.isSetSrgbClr()) {
            return null;
        }
        byte[] val = fill.getSrgbClr().getVal();
        return new Color(0xFF & val[0], 0xFF & val[1], 0xFF & val[2]);
    }

    public void setFillColor(Color color) {
        CTTableCellProperties spPr = ((CTTableCell)this.getXmlObject()).getTcPr();
        if (color == null) {
            if (spPr.isSetSolidFill()) {
                spPr.unsetSolidFill();
            }
        } else {
            CTSolidColorFillProperties fill = spPr.isSetSolidFill() ? spPr.getSolidFill() : spPr.addNewSolidFill();
            CTSRgbColor rgb = CTSRgbColor.Factory.newInstance();
            rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            fill.setSrgbClr(rgb);
        }
    }

    public Color getFillColor() {
        CTTableCellProperties spPr = ((CTTableCell)this.getXmlObject()).getTcPr();
        if (!spPr.isSetSolidFill()) {
            return null;
        }
        CTSolidColorFillProperties fill = spPr.getSolidFill();
        if (!fill.isSetSrgbClr()) {
            return null;
        }
        byte[] val = fill.getSrgbClr().getVal();
        return new Color(0xFF & val[0], 0xFF & val[1], 0xFF & val[2]);
    }

    void setGridSpan(int gridSpan_) {
        ((CTTableCell)this.getXmlObject()).setGridSpan(gridSpan_);
    }

    void setRowSpan(int rowSpan_) {
        ((CTTableCell)this.getXmlObject()).setRowSpan(rowSpan_);
    }

    void setHMerge(boolean merge_) {
        ((CTTableCell)this.getXmlObject()).setHMerge(merge_);
    }

    void setVMerge(boolean merge_) {
        ((CTTableCell)this.getXmlObject()).setVMerge(merge_);
    }

    public void setVerticalAlignment(VerticalAlignment anchor) {
        CTTableCellProperties cellProps = ((CTTableCell)this.getXmlObject()).getTcPr();
        if (cellProps != null) {
            if (anchor == null) {
                if (cellProps.isSetAnchor()) {
                    cellProps.unsetAnchor();
                }
            } else {
                cellProps.setAnchor(STTextAnchoringType.Enum.forInt((int)(anchor.ordinal() + 1)));
            }
        }
    }

    public VerticalAlignment getVerticalAlignment() {
        CTTableCellProperties cellProps = ((CTTableCell)this.getXmlObject()).getTcPr();
        VerticalAlignment align = VerticalAlignment.TOP;
        if (cellProps != null && cellProps.isSetAnchor()) {
            int ival = cellProps.getAnchor().intValue();
            align = VerticalAlignment.values()[ival - 1];
        }
        return align;
    }
}

