/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.SstDocument;

public class SharedStringsTable
extends POIXMLDocumentPart {
    private final List strings = new ArrayList();
    private final Map stmap = new HashMap();
    private int count;
    private int uniqueCount;
    private SstDocument _sstDoc;
    private static final XmlOptions options = new XmlOptions();

    static {
        options.put((Object)"SAVE_INNER");
        options.put((Object)"SAVE_AGGRESSIVE_NAMESPACES");
        options.put((Object)"SAVE_USE_DEFAULT_NAMESPACE");
        options.setSaveImplicitNamespaces(Collections.singletonMap("", "http://schemas.openxmlformats.org/spreadsheetml/2006/main"));
    }

    public SharedStringsTable() {
        this._sstDoc = SstDocument.Factory.newInstance();
        this._sstDoc.addNewSst();
    }

    public SharedStringsTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            int cnt = 0;
            this._sstDoc = SstDocument.Factory.parse((InputStream)is);
            CTSst sst = this._sstDoc.getSst();
            this.count = (int)sst.getCount();
            this.uniqueCount = (int)sst.getUniqueCount();
            int i = 0;
            while (i < sst.getSiArray().length) {
                CTRst st = sst.getSiArray()[i];
                this.stmap.put(this.getKey(st), new Integer(cnt));
                this.strings.add(st);
                ++cnt;
                ++i;
            }
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    private String getKey(CTRst st) {
        return st.xmlText(options);
    }

    public CTRst getEntryAt(int idx) {
        return (CTRst)this.strings.get(idx);
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public int addEntry(CTRst st) {
        String s = this.getKey(st);
        ++this.count;
        if (this.stmap.containsKey(s)) {
            return (Integer)this.stmap.get(s);
        }
        ++this.uniqueCount;
        CTRst newSt = this._sstDoc.getSst().addNewSi();
        newSt.set((XmlObject)st);
        int idx = this.strings.size();
        this.stmap.put(s, new Integer(idx));
        this.strings.add(newSt);
        return idx;
    }

    public List getItems() {
        return this.strings;
    }

    public void writeTo(OutputStream out) throws IOException {
        XmlOptions options = new XmlOptions(DEFAULT_XML_OPTIONS);
        options.setSaveCDataLengthThreshold(1000000);
        options.setSaveCDataEntityCountThreshold(-1);
        CTSst sst = this._sstDoc.getSst();
        sst.setCount((long)this.count);
        sst.setUniqueCount((long)this.uniqueCount);
        this._sstDoc.save(out, options);
    }

    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }
}

