/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.formula.ptg.AreaErrPtg;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;

public final class XSSFRowShifter {
    private final XSSFSheet sheet;

    public XSSFRowShifter(XSSFSheet sh) {
        this.sheet = sh;
    }

    public List shiftMerged(int startRow, int endRow, int n) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        int i = 0;
        while (i < this.sheet.getNumMergedRegions()) {
            boolean inEnd;
            CellRangeAddress merged = this.sheet.getMergedRegion(i);
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (inStart && inEnd && !XSSFRowShifter.containsCell(merged, startRow - 1, 0) && !XSSFRowShifter.containsCell(merged, endRow + 1, 0)) {
                merged.setFirstRow(merged.getFirstRow() + n);
                merged.setLastRow(merged.getLastRow() + n);
                shiftedRegions.add(merged);
                this.sheet.removeMergedRegion(i);
                --i;
            }
            ++i;
        }
        Iterator iterator = shiftedRegions.iterator();
        while (iterator.hasNext()) {
            CellRangeAddress region = (CellRangeAddress)iterator.next();
            this.sheet.addMergedRegion(region);
        }
        return shiftedRegions;
    }

    private static boolean containsCell(CellRangeAddress cr, int rowIx, int colIx) {
        return cr.getFirstRow() <= rowIx && cr.getLastRow() >= rowIx && cr.getFirstColumn() <= colIx && cr.getLastColumn() >= colIx;
    }

    public void updateNamedRanges(FormulaShifter shifter) {
        XSSFWorkbook wb = (XSSFWorkbook)this.sheet.getWorkbook();
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        int i = 0;
        while (i < wb.getNumberOfNames()) {
            int sheetIndex;
            XSSFName name = (XSSFName)wb.getNameAt(i);
            String formula = name.getRefersToFormula();
            Ptg[] ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)fpb, (int)4, (int)(sheetIndex = name.getSheetIndex()));
            if (shifter.adjustFormula(ptgs, sheetIndex)) {
                String shiftedFmla = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])ptgs);
                name.setRefersToFormula(shiftedFmla);
            }
            ++i;
        }
    }

    public void updateFormulas(FormulaShifter shifter) {
        this.updateSheetFormulas(this.sheet, shifter);
        XSSFWorkbook wb = (XSSFWorkbook)this.sheet.getWorkbook();
        Iterator iterator = wb.iterator();
        while (iterator.hasNext()) {
            XSSFSheet sh = (XSSFSheet)iterator.next();
            if (this.sheet == sh) continue;
            this.updateSheetFormulas(sh, shifter);
        }
    }

    private void updateSheetFormulas(XSSFSheet sh, FormulaShifter shifter) {
        Iterator iterator = sh.iterator();
        while (iterator.hasNext()) {
            Row r = (Row)iterator.next();
            XSSFRow row = (XSSFRow)r;
            this.updateRowFormulas(row, shifter);
        }
    }

    private void updateRowFormulas(XSSFRow row, FormulaShifter shifter) {
        Iterator iterator = row.iterator();
        while (iterator.hasNext()) {
            String ref;
            String shiftedRef;
            String shiftedFormula;
            Cell c = (Cell)iterator.next();
            XSSFCell cell = (XSSFCell)c;
            CTCell ctCell = cell.getCTCell();
            if (!ctCell.isSetF()) continue;
            CTCellFormula f = ctCell.getF();
            String formula = f.getStringValue();
            if (formula.length() > 0 && (shiftedFormula = XSSFRowShifter.shiftFormula(row, formula, shifter)) != null) {
                f.setStringValue(shiftedFormula);
            }
            if (!f.isSetRef() || (shiftedRef = XSSFRowShifter.shiftFormula(row, ref = f.getRef(), shifter)) == null) continue;
            f.setRef(shiftedRef);
        }
    }

    private static String shiftFormula(XSSFRow row, String formula, FormulaShifter shifter) {
        XSSFSheet sheet = (XSSFSheet)row.getSheet();
        XSSFWorkbook wb = (XSSFWorkbook)sheet.getWorkbook();
        int sheetIndex = wb.getSheetIndex(sheet);
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        Ptg[] ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)fpb, (int)0, (int)sheetIndex);
        String shiftedFmla = null;
        if (shifter.adjustFormula(ptgs, sheetIndex)) {
            shiftedFmla = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])ptgs);
        }
        return shiftedFmla;
    }

    /*
     * Unable to fully structure code
     */
    public void updateConditionalFormatting(FormulaShifter shifter) {
        wb = (XSSFWorkbook)this.sheet.getWorkbook();
        sheetIndex = wb.getSheetIndex(this.sheet);
        fpb = XSSFEvaluationWorkbook.create(wb);
        cfList = Arrays.asList(this.sheet.getCTWorksheet().getConditionalFormattingArray());
        j = 0;
        while (j < cfList.size()) {
            cf = cfList.get(j);
            cellRanges = new ArrayList<CellRangeAddress>();
            iterator = cf.getSqref().iterator();
            while (iterator.hasNext()) {
                stRef = iterator.next();
                regions = stRef.toString().split(" ");
                i = 0;
                while (i < regions.length) {
                    cellRanges.add(CellRangeAddress.valueOf((String)regions[i]));
                    ++i;
                }
            }
            changed = false;
            temp = new ArrayList<CellRangeAddress>();
            i = 0;
            while (i < cellRanges.size()) {
                craOld = (CellRangeAddress)cellRanges.get(i);
                craNew = XSSFRowShifter.shiftRange(shifter, craOld, sheetIndex);
                if (craNew == null) {
                    changed = true;
                } else {
                    temp.add(craNew);
                    if (craNew != craOld) {
                        changed = true;
                    }
                }
                ++i;
            }
            if (!changed) ** GOTO lbl49
            nRanges = temp.size();
            if (nRanges == 0) {
                cfList.remove(j);
            } else {
                refs = new ArrayList<String>();
                iterator = temp.iterator();
                while (iterator.hasNext()) {
                    a = (CellRangeAddress)iterator.next();
                    refs.add(a.formatAsString());
                }
                cf.setSqref(refs);
lbl49:
                // 2 sources

                iterator = Arrays.asList(cf.getCfRuleArray()).iterator();
                while (iterator.hasNext()) {
                    cfRule = iterator.next();
                    formulas = Arrays.asList(cfRule.getFormulaArray());
                    i = 0;
                    while (i < formulas.size()) {
                        formula = formulas.get(i);
                        ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)fpb, (int)0, (int)sheetIndex);
                        if (shifter.adjustFormula(ptgs, sheetIndex)) {
                            shiftedFmla = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])ptgs);
                            formulas.set(i, shiftedFmla);
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
    }

    private static CellRangeAddress shiftRange(FormulaShifter shifter, CellRangeAddress cra, int currentExternSheetIx) {
        AreaPtg aptg = new AreaPtg(cra.getFirstRow(), cra.getLastRow(), cra.getFirstColumn(), cra.getLastColumn(), false, false, false, false);
        Ptg[] ptgs = new Ptg[]{aptg};
        if (!shifter.adjustFormula(ptgs, currentExternSheetIx)) {
            return cra;
        }
        Ptg ptg0 = ptgs[0];
        if (ptg0 instanceof AreaPtg) {
            AreaPtg bptg = (AreaPtg)ptg0;
            return new CellRangeAddress(bptg.getFirstRow(), bptg.getLastRow(), bptg.getFirstColumn(), bptg.getLastColumn());
        }
        if (ptg0 instanceof AreaErrPtg) {
            return null;
        }
        throw new IllegalStateException("Unexpected shifted ptg class (" + ptg0.getClass().getName() + ")");
    }
}

