/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFootnotes;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import poi.support.Iterable;

public class XWPFFootnote
implements Iterable,
IBody {
    private List paragraphs = new ArrayList();
    private List tables = new ArrayList();
    private List pictures = new ArrayList();
    private List bodyElements = new ArrayList();
    private CTFtnEdn ctFtnEdn;
    private XWPFFootnotes footnotes;

    public XWPFFootnote(CTFtnEdn note, XWPFFootnotes xFootnotes) {
        this.footnotes = xFootnotes;
        this.ctFtnEdn = note;
        Iterator<CTP> iterator = Arrays.asList(this.ctFtnEdn.getPArray()).iterator();
        while (iterator.hasNext()) {
            CTP p = iterator.next();
            this.paragraphs.add(new XWPFParagraph(p, this));
        }
    }

    public XWPFFootnote(XWPFDocument document, CTFtnEdn body) {
        Iterator<CTP> iterator = Arrays.asList(body.getPArray()).iterator();
        while (iterator.hasNext()) {
            CTP p = iterator.next();
            this.paragraphs.add(new XWPFParagraph(p, document));
        }
    }

    public List getParagraphs() {
        return this.paragraphs;
    }

    public Iterator iterator() {
        return this.paragraphs.iterator();
    }

    public List getTables() {
        return this.tables;
    }

    public List getPictures() {
        return this.pictures;
    }

    public List getBodyElements() {
        return this.bodyElements;
    }

    public CTFtnEdn getCTFtnEdn() {
        return this.ctFtnEdn;
    }

    public void setCTFtnEdn(CTFtnEdn footnote) {
        this.ctFtnEdn = footnote;
    }

    public XWPFTable getTableArray(int pos) {
        if (pos > 0 && pos < this.tables.size()) {
            return (XWPFTable)this.tables.get(pos);
        }
        return null;
    }

    public void insertTable(int pos, XWPFTable table) {
        this.bodyElements.add(pos, table);
        int i = 0;
        while (i < Arrays.asList(this.ctFtnEdn.getTblArray()).size()) {
            CTTbl tbl = this.ctFtnEdn.getTblArray(i);
            if (tbl == table.getCTTbl()) break;
            ++i;
        }
        this.tables.add(i, table);
    }

    public XWPFTable getTable(CTTbl ctTable) {
        Iterator iterator = this.tables.iterator();
        while (iterator.hasNext()) {
            XWPFTable table = (XWPFTable)iterator.next();
            if (table == null) {
                return null;
            }
            if (!table.getCTTbl().equals(ctTable)) continue;
            return table;
        }
        return null;
    }

    public XWPFParagraph getParagraph(CTP p) {
        Iterator iterator = this.paragraphs.iterator();
        while (iterator.hasNext()) {
            XWPFParagraph paragraph = (XWPFParagraph)iterator.next();
            if (!paragraph.getCTP().equals(p)) continue;
            return paragraph;
        }
        return null;
    }

    public XWPFParagraph getParagraphArray(int pos) {
        return (XWPFParagraph)this.paragraphs.get(pos);
    }

    public XWPFTableCell getTableCell(CTTc cell) {
        XmlCursor cursor = cell.newCursor();
        cursor.toParent();
        XmlObject o = cursor.getObject();
        if (!(o instanceof CTRow)) {
            return null;
        }
        CTRow row = (CTRow)o;
        cursor.toParent();
        o = cursor.getObject();
        cursor.dispose();
        if (!(o instanceof CTTbl)) {
            return null;
        }
        CTTbl tbl = (CTTbl)o;
        XWPFTable table = this.getTable(tbl);
        if (table == null) {
            return null;
        }
        XWPFTableRow tableRow = table.getRow(row);
        if (row == null) {
            return null;
        }
        return tableRow.getTableCell(cell);
    }

    private boolean isCursorInFtn(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        return verify.getObject() == this.ctFtnEdn;
    }

    public POIXMLDocumentPart getOwner() {
        return this.footnotes;
    }

    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInFtn(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, this);
            cursor.removeXmlContents();
            XmlObject o = null;
            while (!(o instanceof CTTbl) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o)) + 1;
                this.tables.add(pos, newT);
            }
            int i = 0;
            cursor = t.newCursor();
            while (cursor.toPrevSibling()) {
                o = cursor.getObject();
                if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                ++i;
            }
            this.bodyElements.add(i, newT);
            cursor = t.newCursor();
            cursor.toEndToken();
            return newT;
        }
        return null;
    }

    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (this.isCursorInFtn(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p, this);
            XmlObject o = null;
            while (!(o instanceof CTP) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTP) || (CTP)o == p) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
                this.paragraphs.add(pos, newP);
            }
            int i = 0;
            cursor.toCursor(p.newCursor());
            while (cursor.toPrevSibling()) {
                o = cursor.getObject();
                if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                ++i;
            }
            this.bodyElements.add(i, newP);
            cursor.toCursor(p.newCursor());
            cursor.toEndToken();
            return newP;
        }
        return null;
    }

    public XWPFTable addNewTbl(CTTbl table) {
        CTTbl newTable = this.ctFtnEdn.addNewTbl();
        newTable.set((XmlObject)table);
        XWPFTable xTable = new XWPFTable(newTable, this);
        this.tables.add(xTable);
        return xTable;
    }

    public XWPFParagraph addNewParagraph(CTP paragraph) {
        CTP newPara = this.ctFtnEdn.addNewP();
        newPara.set((XmlObject)paragraph);
        XWPFParagraph xPara = new XWPFParagraph(newPara, this);
        this.paragraphs.add(xPara);
        return xPara;
    }

    public XWPFDocument getXWPFDocument() {
        return this.footnotes.getXWPFDocument();
    }

    public POIXMLDocumentPart getPart() {
        return this.footnotes;
    }

    public BodyType getPartType() {
        return BodyType.FOOTNOTE;
    }
}

