/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class XWPFTableCell
implements IBody {
    private final CTTc ctTc;
    protected List paragraphs = null;
    protected List tables = null;
    protected List bodyElements = null;
    protected IBody part;
    private XWPFTableRow tableRow = null;
    private static HashMap alignMap = new HashMap();
    private static HashMap stVertAlignTypeMap;

    static {
        alignMap.put(XWPFVertAlign.TOP, STVerticalJc.Enum.forInt((int)1));
        alignMap.put(XWPFVertAlign.CENTER, STVerticalJc.Enum.forInt((int)2));
        alignMap.put(XWPFVertAlign.BOTH, STVerticalJc.Enum.forInt((int)3));
        alignMap.put(XWPFVertAlign.BOTTOM, STVerticalJc.Enum.forInt((int)4));
        stVertAlignTypeMap = new HashMap();
        stVertAlignTypeMap.put(new Integer(1), XWPFVertAlign.TOP);
        stVertAlignTypeMap.put(new Integer(2), XWPFVertAlign.CENTER);
        stVertAlignTypeMap.put(new Integer(3), XWPFVertAlign.BOTH);
        stVertAlignTypeMap.put(new Integer(4), XWPFVertAlign.BOTTOM);
    }

    public XWPFTableCell(CTTc cell, XWPFTableRow tableRow, IBody part) {
        this.ctTc = cell;
        this.part = part;
        this.tableRow = tableRow;
        if (Arrays.asList(cell.getPArray()).size() < 1) {
            cell.addNewP();
        }
        this.bodyElements = new ArrayList();
        this.paragraphs = new ArrayList();
        this.tables = new ArrayList();
        XmlCursor cursor = this.ctTc.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject o = cursor.getObject();
            if (o instanceof CTP) {
                XWPFParagraph p = new XWPFParagraph((CTP)o, this);
                this.paragraphs.add(p);
                this.bodyElements.add(p);
            }
            if (!(o instanceof CTTbl)) continue;
            XWPFTable t = new XWPFTable((CTTbl)o, this);
            this.tables.add(t);
            this.bodyElements.add(t);
        }
        cursor.dispose();
    }

    public CTTc getCTTc() {
        return this.ctTc;
    }

    public List getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    public void setParagraph(XWPFParagraph p) {
        if (this.ctTc.sizeOfPArray() == 0) {
            this.ctTc.addNewP();
        }
        this.ctTc.setPArray(0, p.getCTP());
    }

    public List getParagraphs() {
        return this.paragraphs;
    }

    public XWPFParagraph addParagraph() {
        XWPFParagraph p = new XWPFParagraph(this.ctTc.addNewP(), this);
        this.addParagraph(p);
        return p;
    }

    public void addParagraph(XWPFParagraph p) {
        this.paragraphs.add(p);
    }

    public void removeParagraph(int pos) {
        this.paragraphs.remove(pos);
        this.ctTc.removeP(pos);
    }

    public XWPFParagraph getParagraph(CTP p) {
        Iterator iterator = this.paragraphs.iterator();
        while (iterator.hasNext()) {
            XWPFParagraph paragraph = (XWPFParagraph)iterator.next();
            if (!p.equals(paragraph.getCTP())) continue;
            return paragraph;
        }
        return null;
    }

    public void setText(String text) {
        CTP ctP = this.ctTc.sizeOfPArray() == 0 ? this.ctTc.addNewP() : this.ctTc.getPArray(0);
        XWPFParagraph par = new XWPFParagraph(ctP, this);
        par.createRun().setText(text);
    }

    public XWPFTableRow getTableRow() {
        return this.tableRow;
    }

    public void setColor(String rgbStr) {
        CTTcPr tcpr = this.ctTc.isSetTcPr() ? this.ctTc.getTcPr() : this.ctTc.addNewTcPr();
        CTShd ctshd = tcpr.isSetShd() ? tcpr.getShd() : tcpr.addNewShd();
        ctshd.setColor((Object)"auto");
        ctshd.setVal(STShd.CLEAR);
        ctshd.setFill((Object)rgbStr);
    }

    public String getColor() {
        CTShd ctshd;
        String color = null;
        CTTcPr tcpr = this.ctTc.getTcPr();
        if (tcpr != null && (ctshd = tcpr.getShd()) != null) {
            color = ctshd.xgetFill().getStringValue();
        }
        return color;
    }

    public void setVerticalAlignment(XWPFVertAlign vAlign) {
        CTTcPr tcpr = this.ctTc.isSetTcPr() ? this.ctTc.getTcPr() : this.ctTc.addNewTcPr();
        CTVerticalJc va = tcpr.addNewVAlign();
        va.setVal((STVerticalJc.Enum)alignMap.get(vAlign));
    }

    public XWPFVertAlign getVerticalAlignment() {
        XWPFVertAlign vAlign = null;
        CTTcPr tcpr = this.ctTc.getTcPr();
        if (this.ctTc != null) {
            CTVerticalJc va = tcpr.getVAlign();
            vAlign = (XWPFVertAlign)stVertAlignTypeMap.get(va.getVal());
        }
        return vAlign;
    }

    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (!this.isCursorInTableCell(cursor)) {
            return null;
        }
        String uri = CTP.type.getName().getNamespaceURI();
        String localPart = "p";
        cursor.beginElement(localPart, uri);
        cursor.toParent();
        CTP p = (CTP)cursor.getObject();
        XWPFParagraph newP = new XWPFParagraph(p, this);
        XmlObject o = null;
        while (!(o instanceof CTP) && cursor.toPrevSibling()) {
            o = cursor.getObject();
        }
        if (!(o instanceof CTP) || (CTP)o == p) {
            this.paragraphs.add(0, newP);
        } else {
            int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
            this.paragraphs.add(pos, newP);
        }
        int i = 0;
        cursor.toCursor(p.newCursor());
        while (cursor.toPrevSibling()) {
            o = cursor.getObject();
            if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
            ++i;
        }
        this.bodyElements.add(i, newP);
        cursor.toCursor(p.newCursor());
        cursor.toEndToken();
        return newP;
    }

    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInTableCell(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, this);
            cursor.removeXmlContents();
            XmlObject o = null;
            while (!(o instanceof CTTbl) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o)) + 1;
                this.tables.add(pos, newT);
            }
            int i = 0;
            cursor = t.newCursor();
            while (cursor.toPrevSibling()) {
                o = cursor.getObject();
                if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                ++i;
            }
            this.bodyElements.add(i, newT);
            cursor = t.newCursor();
            cursor.toEndToken();
            return newT;
        }
        return null;
    }

    private boolean isCursorInTableCell(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        return verify.getObject() == this.ctTc;
    }

    public XWPFParagraph getParagraphArray(int pos) {
        if (pos > 0 && pos < this.paragraphs.size()) {
            return (XWPFParagraph)this.paragraphs.get(pos);
        }
        return null;
    }

    public POIXMLDocumentPart getPart() {
        return this.tableRow.getTable().getPart();
    }

    public BodyType getPartType() {
        return BodyType.TABLECELL;
    }

    public XWPFTable getTable(CTTbl ctTable) {
        int i = 0;
        while (i < this.tables.size()) {
            if (((XWPFTable)this.getTables().get(i)).getCTTbl() == ctTable) {
                return (XWPFTable)this.getTables().get(i);
            }
            ++i;
        }
        return null;
    }

    public XWPFTable getTableArray(int pos) {
        if (pos > 0 && pos < this.tables.size()) {
            return (XWPFTable)this.tables.get(pos);
        }
        return null;
    }

    public List getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public void insertTable(int pos, XWPFTable table) {
        this.bodyElements.add(pos, table);
        int i = 0;
        while (i < Arrays.asList(this.ctTc.getTblArray()).size()) {
            CTTbl tbl = this.ctTc.getTblArray(i);
            if (tbl == table.getCTTbl()) break;
            ++i;
        }
        this.tables.add(i, table);
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        Iterator iterator = this.paragraphs.iterator();
        while (iterator.hasNext()) {
            XWPFParagraph p = (XWPFParagraph)iterator.next();
            text.append(p.getText());
        }
        return text.toString();
    }

    public XWPFTableCell getTableCell(CTTc cell) {
        XmlCursor cursor = cell.newCursor();
        cursor.toParent();
        XmlObject o = cursor.getObject();
        if (!(o instanceof CTRow)) {
            return null;
        }
        CTRow row = (CTRow)o;
        cursor.toParent();
        o = cursor.getObject();
        cursor.dispose();
        if (!(o instanceof CTTbl)) {
            return null;
        }
        CTTbl tbl = (CTTbl)o;
        XWPFTable table = this.getTable(tbl);
        if (table == null) {
            return null;
        }
        XWPFTableRow tableRow = table.getRow(row);
        if (tableRow == null) {
            return null;
        }
        return tableRow.getTableCell(cell);
    }

    public XWPFDocument getXWPFDocument() {
        return this.part.getXWPFDocument();
    }

    public static class XWPFVertAlign {
        public static final XWPFVertAlign TOP = new XWPFVertAlign();
        public static final XWPFVertAlign CENTER = new XWPFVertAlign();
        public static final XWPFVertAlign BOTH = new XWPFVertAlign();
        public static final XWPFVertAlign BOTTOM = new XWPFVertAlign();
    }
}

