/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.POIDocument;
import org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.NameIdChunks;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.hsmf.parsers.POIFSChunkParser;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MAPIMessage
extends POIDocument {
    private Chunks mainChunks;
    private NameIdChunks nameIdChunks;
    private RecipientChunks[] recipientChunks;
    private AttachmentChunks[] attachmentChunks;
    private boolean returnNullOnMissingChunk = false;

    public MAPIMessage() {
        super(new POIFSFileSystem());
    }

    public MAPIMessage(String filename) throws IOException {
        this(new FileInputStream(new File(filename)));
    }

    public MAPIMessage(InputStream in) throws IOException {
        this(new POIFSFileSystem(in));
    }

    public MAPIMessage(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public MAPIMessage(NPOIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public MAPIMessage(DirectoryNode poifsDir, POIFSFileSystem fs) throws IOException {
        this(poifsDir);
    }

    public MAPIMessage(DirectoryNode poifsDir) throws IOException {
        super(poifsDir);
        ChunkGroup[] chunkGroups = POIFSChunkParser.parse(poifsDir);
        ArrayList<AttachmentChunks> attachments = new ArrayList<AttachmentChunks>();
        ArrayList<RecipientChunks> recipients = new ArrayList<RecipientChunks>();
        int i = 0;
        while (i < chunkGroups.length) {
            ChunkGroup group = chunkGroups[i];
            if (group instanceof Chunks) {
                this.mainChunks = (Chunks)group;
            } else if (group instanceof NameIdChunks) {
                this.nameIdChunks = (NameIdChunks)group;
            } else if (group instanceof RecipientChunks) {
                recipients.add((RecipientChunks)group);
            }
            if (group instanceof AttachmentChunks) {
                attachments.add((AttachmentChunks)group);
            }
            ++i;
        }
        this.attachmentChunks = attachments.toArray(new AttachmentChunks[attachments.size()]);
        this.recipientChunks = recipients.toArray(new RecipientChunks[recipients.size()]);
        Arrays.sort(this.attachmentChunks, new AttachmentChunks.AttachmentChunksSorter());
        Arrays.sort(this.recipientChunks, new RecipientChunks.RecipientChunksSorter());
    }

    public String getStringFromChunk(StringChunk chunk) throws ChunkNotFoundException {
        if (chunk == null) {
            if (this.returnNullOnMissingChunk) {
                return null;
            }
            throw new ChunkNotFoundException();
        }
        return chunk.getValue();
    }

    public String getTextBody() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.textBodyChunk);
    }

    public String getHtmlBody() throws ChunkNotFoundException {
        if (this.mainChunks.htmlBodyChunkBinary != null) {
            return this.mainChunks.htmlBodyChunkBinary.getAs7bitString();
        }
        return this.getStringFromChunk(this.mainChunks.htmlBodyChunkString);
    }

    public String getHmtlBody() throws ChunkNotFoundException {
        return this.getHtmlBody();
    }

    public String getRtfBody() throws ChunkNotFoundException {
        ByteChunk chunk = this.mainChunks.rtfBodyChunk;
        if (chunk == null) {
            if (this.returnNullOnMissingChunk) {
                return null;
            }
            throw new ChunkNotFoundException();
        }
        try {
            MAPIRtfAttribute rtf = new MAPIRtfAttribute(MAPIProperty.RTF_COMPRESSED, 258, chunk.getValue());
            return rtf.getDataString();
        }
        catch (IOException e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
    }

    public String getSubject() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.subjectChunk);
    }

    public String getDisplayFrom() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayFromChunk);
    }

    public String getDisplayTo() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayToChunk);
    }

    public String getDisplayCC() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayCCChunk);
    }

    public String getDisplayBCC() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayBCCChunk);
    }

    public String getRecipientEmailAddress() throws ChunkNotFoundException {
        return this.toSemicolonList(this.getRecipientEmailAddressList());
    }

    public String[] getRecipientEmailAddressList() throws ChunkNotFoundException {
        if (this.recipientChunks == null || this.recipientChunks.length == 0) {
            throw new ChunkNotFoundException("No recipients section present");
        }
        String[] emails = new String[this.recipientChunks.length];
        int i = 0;
        while (i < emails.length) {
            RecipientChunks rc = this.recipientChunks[i];
            String email = rc.getRecipientEmailAddress();
            if (email != null) {
                emails[i] = email;
            } else if (this.returnNullOnMissingChunk) {
                emails[i] = null;
            } else {
                throw new ChunkNotFoundException("No email address holding chunks found for the " + (i + 1) + "th recipient");
            }
            ++i;
        }
        return emails;
    }

    public String getRecipientNames() throws ChunkNotFoundException {
        return this.toSemicolonList(this.getRecipientNamesList());
    }

    public String[] getRecipientNamesList() throws ChunkNotFoundException {
        if (this.recipientChunks == null || this.recipientChunks.length == 0) {
            throw new ChunkNotFoundException("No recipients section present");
        }
        String[] names = new String[this.recipientChunks.length];
        int i = 0;
        while (i < names.length) {
            RecipientChunks rc = this.recipientChunks[i];
            String name = rc.getRecipientName();
            if (name == null) {
                throw new ChunkNotFoundException("No display name holding chunks found for the " + (i + 1) + "th recipient");
            }
            names[i] = name;
            ++i;
        }
        return names;
    }

    public void guess7BitEncoding() {
        Pattern p;
        try {
            String[] headers = this.getHeaders();
            if (headers != null && headers.length > 0) {
                p = Pattern.compile("Content-Type:.*?charset=[\"']?([^;'\"]+)[\"']?", 2);
                int i = 0;
                while (i < headers.length) {
                    Matcher m;
                    String header = headers[i];
                    if (header.startsWith("Content-Type") && (m = p.matcher(header)).matches()) {
                        String charset = m.group(1);
                        if (!charset.equalsIgnoreCase("utf-8")) {
                            this.set7BitEncoding(charset);
                        }
                        return;
                    }
                    ++i;
                }
            }
        }
        catch (ChunkNotFoundException headers) {
            // empty catch block
        }
        try {
            Matcher m;
            String html = this.getHmtlBody();
            if (html != null && html.length() > 0 && (m = (p = Pattern.compile("<META\\s+HTTP-EQUIV=\"Content-Type\"\\s+CONTENT=\"text/html;\\s+charset=(.*?)\"")).matcher(html)).find()) {
                String charset = m.group(1);
                this.set7BitEncoding(charset);
                return;
            }
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
    }

    public void set7BitEncoding(String charset) {
        Chunk c;
        int i = 0;
        while (i < this.mainChunks.getAll().length) {
            c = this.mainChunks.getAll()[i];
            if (c instanceof StringChunk) {
                ((StringChunk)c).set7BitEncoding(charset);
            }
            ++i;
        }
        if (this.nameIdChunks != null) {
            i = 0;
            while (i < this.nameIdChunks.getAll().length) {
                c = this.nameIdChunks.getAll()[i];
                if (c instanceof StringChunk) {
                    ((StringChunk)c).set7BitEncoding(charset);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.recipientChunks.length) {
            RecipientChunks rc = this.recipientChunks[i];
            int j = 0;
            while (j < rc.getAll().length) {
                Chunk c2 = rc.getAll()[j];
                if (c2 instanceof StringChunk) {
                    ((StringChunk)c2).set7BitEncoding(charset);
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean has7BitEncodingStrings() {
        Chunk c;
        int i = 0;
        while (i < this.mainChunks.getAll().length) {
            c = this.mainChunks.getAll()[i];
            if (c instanceof StringChunk && ((StringChunk)c).getType() == 30) {
                return true;
            }
            ++i;
        }
        if (this.nameIdChunks != null) {
            i = 0;
            while (i < this.nameIdChunks.getAll().length) {
                c = this.nameIdChunks.getAll()[i];
                if (c instanceof StringChunk && ((StringChunk)c).getType() == 30) {
                    return true;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.recipientChunks.length) {
            RecipientChunks rc = this.recipientChunks[i];
            int j = 0;
            while (j < rc.getAll().length) {
                Chunk c2 = rc.getAll()[j];
                if (c2 instanceof StringChunk && ((StringChunk)c2).getType() == 30) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public String[] getHeaders() throws ChunkNotFoundException {
        String headers = this.getStringFromChunk(this.mainChunks.messageHeaders);
        if (headers == null) {
            return null;
        }
        return headers.split("\\r?\\n");
    }

    public String getConversationTopic() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.conversationTopic);
    }

    public String getMessageClass() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.messageClass);
    }

    public Calendar getMessageDate() throws ChunkNotFoundException {
        if (this.mainChunks.submissionChunk != null) {
            return this.mainChunks.submissionChunk.getAcceptedAtTime();
        }
        if (this.returnNullOnMissingChunk) {
            return null;
        }
        throw new ChunkNotFoundException();
    }

    public Chunks getMainChunks() {
        return this.mainChunks;
    }

    public RecipientChunks[] getRecipientDetailsChunks() {
        return this.recipientChunks;
    }

    public NameIdChunks getNameIdChunks() {
        return this.nameIdChunks;
    }

    public AttachmentChunks[] getAttachmentFiles() {
        return this.attachmentChunks;
    }

    public void write(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Writing isn't yet supported for HSMF, sorry");
    }

    public boolean isReturnNullOnMissingChunk() {
        return this.returnNullOnMissingChunk;
    }

    public void setReturnNullOnMissingChunk(boolean returnNullOnMissingChunk) {
        this.returnNullOnMissingChunk = returnNullOnMissingChunk;
    }

    private String toSemicolonList(String[] l) {
        StringBuffer list = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < l.length) {
            String s = l[i];
            if (s != null) {
                if (first) {
                    first = false;
                } else {
                    list.append("; ");
                }
                list.append(s);
            }
            ++i;
        }
        return list.toString();
    }
}

