/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.dev;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.hsmf.parsers.POIFSChunkParser;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HSMFDump {
    private POIFSFileSystem fs;

    public HSMFDump(POIFSFileSystem fs) {
        this.fs = fs;
    }

    public void dump() throws IOException {
        ChunkGroup[] chunkGroups = POIFSChunkParser.parse(this.fs);
        int i = 0;
        while (i < chunkGroups.length) {
            ChunkGroup chunks = chunkGroups[i];
            System.out.println(chunks.getClass().getName());
            int j = 0;
            while (j < chunks.getChunks().length) {
                Chunk chunk = chunks.getChunks()[j];
                MAPIProperty attr = MAPIProperty.get(chunk.getChunkId());
                String idName = String.valueOf(attr.id) + " - " + attr.name;
                if (attr == MAPIProperty.UNKNOWN) {
                    idName = String.valueOf(chunk.getChunkId()) + " - (unknown)";
                }
                System.out.println("   " + idName + " - " + Types.asName(chunk.getType()));
                System.out.println("       " + chunk.toString());
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            String file = args[i];
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
            HSMFDump dump = new HSMFDump(fs);
            dump.dump();
            ++i;
        }
    }
}

