/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hwpf.model.FieldsDocumentPart;
import org.apache.poi.hwpf.model.FieldsTables;
import org.apache.poi.hwpf.model.PlexOfField;
import org.apache.poi.hwpf.usermodel.Field;
import org.apache.poi.hwpf.usermodel.FieldImpl;
import org.apache.poi.hwpf.usermodel.Fields;

public class FieldsImpl
implements Fields {
    private Map _fieldsByOffset;
    private PlexOfFieldComparator comparator = new PlexOfFieldComparator();

    private static int binarySearch(List list, int startIndex, int endIndex, int requiredStartOffset) {
        FieldsImpl.checkIndexForBinarySearch(list.size(), startIndex, endIndex);
        int low = startIndex;
        int mid = -1;
        int high = endIndex - 1;
        int result = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            int midStart = ((PlexOfField)list.get(mid)).getFcStart();
            if (midStart == requiredStartOffset) {
                return mid;
            }
            if (midStart < requiredStartOffset) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        if (mid < 0) {
            int insertPoint = endIndex;
            int index = startIndex;
            while (index < endIndex) {
                if (requiredStartOffset < ((PlexOfField)list.get(index)).getFcStart()) {
                    insertPoint = index;
                }
                ++index;
            }
            return -insertPoint - 1;
        }
        return -mid - (result >= 0 ? 1 : 2);
    }

    private static void checkIndexForBinarySearch(int length, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        if (length < end || start < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public FieldsImpl(FieldsTables fieldsTables) {
        this._fieldsByOffset = new HashMap(FieldsDocumentPart.values().length);
        int i = 0;
        while (i < FieldsDocumentPart.values().length) {
            FieldsDocumentPart part = FieldsDocumentPart.values()[i];
            ArrayList plexOfCps = fieldsTables.getFieldsPLCF(part);
            this._fieldsByOffset.put(part, this.parseFieldStructure(plexOfCps));
            ++i;
        }
    }

    public Collection getFields(FieldsDocumentPart part) {
        Map map = (Map)this._fieldsByOffset.get(part);
        if (map == null || map.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableCollection(map.values());
    }

    public Field getFieldByStartOffset(FieldsDocumentPart documentPart, int offset) {
        Map map = (Map)this._fieldsByOffset.get(documentPart);
        if (map == null || map.isEmpty()) {
            return null;
        }
        return (FieldImpl)map.get(new Integer(offset));
    }

    private Map parseFieldStructure(List plexOfFields) {
        if (plexOfFields == null || plexOfFields.isEmpty()) {
            return new HashMap();
        }
        Collections.sort(plexOfFields, this.comparator);
        ArrayList fields = new ArrayList(plexOfFields.size() / 3 + 1);
        this.parseFieldStructureImpl(plexOfFields, 0, plexOfFields.size(), fields);
        HashMap<Integer, FieldImpl> result = new HashMap<Integer, FieldImpl>(fields.size());
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            FieldImpl field = (FieldImpl)iterator.next();
            result.put(new Integer(field.getFieldStartOffset()), field);
        }
        return result;
    }

    private void parseFieldStructureImpl(List plexOfFields, int startOffsetInclusive, int endOffsetExclusive, List result) {
        int next = startOffsetInclusive;
        while (next < endOffsetExclusive) {
            PlexOfField startPlexOfField = (PlexOfField)plexOfFields.get(next);
            if (startPlexOfField.getFld().getBoundaryType() != 19) {
                ++next;
                continue;
            }
            int nextNodePositionInList = FieldsImpl.binarySearch(plexOfFields, next + 1, endOffsetExclusive, startPlexOfField.getFcEnd());
            if (nextNodePositionInList < 0) {
                ++next;
                continue;
            }
            PlexOfField nextPlexOfField = (PlexOfField)plexOfFields.get(nextNodePositionInList);
            switch (nextPlexOfField.getFld().getBoundaryType()) {
                case 20: {
                    PlexOfField separatorPlexOfField = nextPlexOfField;
                    int endNodePositionInList = FieldsImpl.binarySearch(plexOfFields, nextNodePositionInList, endOffsetExclusive, separatorPlexOfField.getFcEnd());
                    if (endNodePositionInList < 0) {
                        ++next;
                        break;
                    }
                    PlexOfField endPlexOfField = (PlexOfField)plexOfFields.get(endNodePositionInList);
                    if (endPlexOfField.getFld().getBoundaryType() != 21) {
                        ++next;
                        break;
                    }
                    FieldImpl field = new FieldImpl(startPlexOfField, separatorPlexOfField, endPlexOfField);
                    result.add(field);
                    if (startPlexOfField.getFcStart() + 1 < separatorPlexOfField.getFcStart() - 1) {
                        this.parseFieldStructureImpl(plexOfFields, next + 1, nextNodePositionInList, result);
                    }
                    if (separatorPlexOfField.getFcStart() + 1 < endPlexOfField.getFcStart() - 1) {
                        this.parseFieldStructureImpl(plexOfFields, nextNodePositionInList + 1, endNodePositionInList, result);
                    }
                    next = endNodePositionInList + 1;
                    break;
                }
                case 21: {
                    FieldImpl field = new FieldImpl(startPlexOfField, null, nextPlexOfField);
                    result.add(field);
                    if (startPlexOfField.getFcStart() + 1 < nextPlexOfField.getFcStart() - 1) {
                        this.parseFieldStructureImpl(plexOfFields, next + 1, nextNodePositionInList, result);
                    }
                    next = nextNodePositionInList + 1;
                    break;
                }
                default: {
                    ++next;
                }
            }
        }
    }

    private static final class PlexOfFieldComparator
    implements Comparator {
        private PlexOfFieldComparator() {
        }

        public int compare(Object o1, Object o2) {
            int anotherVal;
            int thisVal = ((PlexOfField)o1).getFcStart();
            return thisVal < (anotherVal = ((PlexOfField)o2).getFcStart()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

