/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */
package org.apache.poi.hwpf.model;



public class FieldsDocumentPart {

    /**
     * annotation subdocument
     */
	public static final FieldsDocumentPart ANNOTATIONS = new FieldsDocumentPart(
			FIBFieldHandler.PLCFFLDATN);

    /**
     * endnote subdocument
     */
	public static final FieldsDocumentPart ENDNOTES = new FieldsDocumentPart(
			FIBFieldHandler.PLCFFLDEDN);

    /**
     * footnote subdocument
     */
	public static final FieldsDocumentPart FOOTNOTES = new FieldsDocumentPart(
			FIBFieldHandler.PLCFFLDFTN);

    /**
     * header subdocument
     */
	public static final FieldsDocumentPart HEADER = new FieldsDocumentPart(
			FIBFieldHandler.PLCFFLDHDR);

    /**
     * header textbox subdoc
     */
	public static final FieldsDocumentPart HEADER_TEXTBOX = new FieldsDocumentPart(
			FIBFieldHandler.PLCFFLDHDRTXBX);

    /**
     * main document
     */
	public static final FieldsDocumentPart MAIN = new FieldsDocumentPart(
			FIBFieldHandler.PLCFFLDMOM);

    /**
     * textbox subdoc
     */
	public static final FieldsDocumentPart TEXTBOX = new FieldsDocumentPart(
			FIBFieldHandler.PLCFFLDTXBX);

    private final int fibFieldsField;

    private FieldsDocumentPart( final int fibHandlerField )
    {
        this.fibFieldsField = fibHandlerField;
    }

    public int getFibFieldsField()
    {
        return fibFieldsField;
    }

	public static FieldsDocumentPart[] values() {
		return new FieldsDocumentPart[] { ANNOTATIONS, ENDNOTES, FOOTNOTES,
				HEADER, HEADER_TEXTBOX, MAIN, TEXTBOX };
	}
}
