/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

/**
 * Word document notes types (and their FIB field indices)
 *
 * @author Sergey Vladimirov (vlsergey {at} gmail {doc} com)
 */
package org.apache.poi.hwpf.model;



public class NoteType {
    /** Ending note */
	public static final NoteType ENDNOTE = new NoteType(
			FIBFieldHandler.PLCFENDREF, FIBFieldHandler.PLCFENDTXT);

    /** Footnote */
	public static final NoteType FOOTNOTE = new NoteType(
			FIBFieldHandler.PLCFFNDREF, FIBFieldHandler.PLCFFNDTXT);

    private final int fibDescriptorsFieldIndex;
    private final int fibTextPositionsFieldIndex;

    private NoteType( int fibDescriptorsFieldIndex,
            int fibTextPositionsFieldIndex )
    {
        this.fibDescriptorsFieldIndex = fibDescriptorsFieldIndex;
        this.fibTextPositionsFieldIndex = fibTextPositionsFieldIndex;
    }

    public int getFibDescriptorsFieldIndex()
    {
        return fibDescriptorsFieldIndex;
    }

    public int getFibTextPositionsFieldIndex()
    {
        return fibTextPositionsFieldIndex;
    }

	public static final NoteType[] values() {
		return new NoteType[] { ENDNOTE, FOOTNOTE };
	}
}
