/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.primitives;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import java.io.Serializable;
import java.util.NoSuchElementException;

@GoogleInternal
public final class IntStack
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5201766662515143823L;
    private int[] elements;
    private int size = 0;
    private static final int MIN_INITIAL_CAPACITY = 8;

    public IntStack(int expectedSize) {
        this.elements = new int[Math.max(expectedSize, 8)];
    }

    public IntStack() {
        this.elements = new int[16];
    }

    public void add(int element) {
        if (this.size == this.elements.length) {
            this.growAndAdd(element);
        } else {
            this.elements[this.size++] = element;
        }
    }

    public int remove() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[--this.size];
    }

    public int element() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[this.size - 1];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public int[] toArray() {
        int[] array = new int[this.size];
        int i = this.size - 1;
        int j = 0;
        while (i >= 0) {
            array[j] = this.elements[i];
            --i;
            ++j;
        }
        return array;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = this.size - 1; i >= 0; --i) {
            buf.append(this.elements[i]).append(", ");
        }
        if (this.size > 0) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(']');
        return buf.toString();
    }

    public IntStack clone() {
        IntStack clone;
        try {
            clone = (IntStack)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        clone.elements = (int[])this.elements.clone();
        return clone;
    }

    private void growAndAdd(int element) {
        this.doubleCapacity();
        this.elements[this.size++] = element;
    }

    private void doubleCapacity() {
        int oldCapacity = this.elements.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity < 0) {
            if (oldCapacity == Integer.MAX_VALUE) {
                throw new IllegalStateException("Sorry, stack too big");
            }
            newCapacity = Integer.MAX_VALUE;
        }
        int[] newElements = new int[newCapacity];
        System.arraycopy(this.elements, 0, newElements, 0, oldCapacity);
        this.elements = newElements;
    }
}

