/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.generator;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slim3.gen.ProductInfo;
import org.slim3.gen.datastore.ArrayType;
import org.slim3.gen.datastore.BlobType;
import org.slim3.gen.datastore.CollectionType;
import org.slim3.gen.datastore.CorePrimitiveType;
import org.slim3.gen.datastore.CoreReferenceType;
import org.slim3.gen.datastore.DataType;
import org.slim3.gen.datastore.EnumType;
import org.slim3.gen.datastore.FloatType;
import org.slim3.gen.datastore.IntegerType;
import org.slim3.gen.datastore.KeyType;
import org.slim3.gen.datastore.LinkedHashSetType;
import org.slim3.gen.datastore.LinkedListType;
import org.slim3.gen.datastore.ListType;
import org.slim3.gen.datastore.LongType;
import org.slim3.gen.datastore.ModelRefType;
import org.slim3.gen.datastore.PrimitiveBooleanType;
import org.slim3.gen.datastore.PrimitiveByteType;
import org.slim3.gen.datastore.PrimitiveDoubleType;
import org.slim3.gen.datastore.PrimitiveFloatType;
import org.slim3.gen.datastore.PrimitiveIntType;
import org.slim3.gen.datastore.PrimitiveLongType;
import org.slim3.gen.datastore.PrimitiveShortType;
import org.slim3.gen.datastore.SetType;
import org.slim3.gen.datastore.ShortType;
import org.slim3.gen.datastore.SimpleDataTypeVisitor;
import org.slim3.gen.datastore.SortedSetType;
import org.slim3.gen.datastore.StringType;
import org.slim3.gen.datastore.TextType;
import org.slim3.gen.desc.AttributeMetaDesc;
import org.slim3.gen.desc.JsonAnnotation;
import org.slim3.gen.desc.ModelMetaDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.printer.Printer;

public class ModelMetaGenerator
implements Generator {
    protected final ModelMetaDesc modelMetaDesc;
    private static final Map<String, String> defaultsOfPrimitives = new HashMap<String, String>();
    private static final Set<String> jsonSupportedTypes = new HashSet<String>();

    public ModelMetaGenerator(ModelMetaDesc modelMetaDesc) {
        if (modelMetaDesc == null) {
            throw new NullPointerException("The modelMetaDesc parameter is null.");
        }
        this.modelMetaDesc = modelMetaDesc;
    }

    public void generate(Printer printer) {
        if (printer == null) {
            throw new NullPointerException("The printer parameter is null.");
        }
        this.printPackage(printer);
        this.printClass(printer);
    }

    protected void printPackage(Printer printer) {
        if (this.modelMetaDesc.getPackageName().length() != 0) {
            printer.println("package %s;", this.modelMetaDesc.getPackageName());
            printer.println();
        }
    }

    protected void printClass(Printer printer) {
        printer.println("//@javax.annotation.Generated(value = { \"%s\", \"%s\" }, date = \"%tF %<tT\")", ProductInfo.getName(), ProductInfo.getVersion(), new Date());
        printer.println("/** */", new Object[0]);
        printer.println("public final class %s extends %s<%s> {", this.modelMetaDesc.getSimpleName(), "org.slim3.datastore.ModelMeta", this.modelMetaDesc.getModelClassName());
        printer.println();
        printer.indent();
        this.printAttributeMetaFields(printer);
        this.printAttributeListenerFields(printer);
        this.printSingletonField(printer);
        this.printGetMethod(printer);
        this.printConstructor(printer);
        printer.unindent();
        printer.println();
        printer.indent();
        this.printEntityToModelMethod(printer);
        this.printModelToEntityMethod(printer);
        this.printGetKeyMethod(printer);
        this.printSetKeyMethod(printer);
        this.printGetVersionMethod(printer);
        this.printAssignKeyToModelRefIfNecessaryMethod(printer);
        this.printIncrementVersionMethod(printer);
        this.printPrePutMethod(printer);
        this.printGetSchemaVersionName(printer);
        this.printGetClassHierarchyListName(printer);
        this.printIsCipherProperty(printer);
        this.printModelToJsonMethod(printer);
        this.printJsonToModelMethod(printer);
        this.printCustomExtensionMethods(printer);
        printer.unindent();
        printer.print("}", new Object[0]);
    }

    protected void printAttributeMetaFields(Printer printer) {
        AttributeMetaFieldsGenerator generator = new AttributeMetaFieldsGenerator(printer);
        generator.generate();
    }

    protected void printAttributeListenerFields(Printer printer) {
        for (AttributeMetaDesc attr : this.modelMetaDesc.getAttributeMetaDescList()) {
            if (!attr.isPersistent() || attr.getAttributeListenerClassName() == null || attr.getAttributeListenerClassName().equals("org.slim3.datastore.AttributeListener")) continue;
            printer.println("private static final %1$s slim3_%2$sAttributeListener = new %1$s();", attr.getAttributeListenerClassName(), attr.getAttributeName());
            printer.println();
        }
    }

    protected void printSingletonField(Printer printer) {
        printer.println("private static final %1$s slim3_singleton = new %1$s();", this.modelMetaDesc.getSimpleName());
        printer.println();
    }

    protected void printConstructor(Printer printer) {
        printer.println("/** */", new Object[0]);
        printer.println("public %s() {", this.modelMetaDesc.getSimpleName());
        if (this.modelMetaDesc.getClassHierarchyList().isEmpty()) {
            printer.println("    super(\"%1$s\", %2$s.class);", this.modelMetaDesc.getKind(), this.modelMetaDesc.getModelClassName());
        } else {
            printer.print("    super(\"%1$s\", %2$s.class, %3$s.asList(", this.modelMetaDesc.getKind(), this.modelMetaDesc.getModelClassName(), Arrays.class.getName());
            Iterator<String> it = this.modelMetaDesc.getClassHierarchyList().iterator();
            while (it.hasNext()) {
                printer.printWithoutIndent("\"%s\"", it.next());
                if (!it.hasNext()) continue;
                printer.printWithoutIndent(", ", new Object[0]);
            }
            printer.printlnWithoutIndent("));", new Object[0]);
        }
        printer.println("}", new Object[0]);
    }

    protected void printGetMethod(Printer printer) {
        printer.println("/**", new Object[0]);
        printer.println(" * @return the singleton", new Object[0]);
        printer.println(" */", new Object[0]);
        printer.println("public static %1$s get() {", this.modelMetaDesc.getSimpleName());
        printer.println("   return slim3_singleton;", new Object[0]);
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printEntityToModelMethod(Printer printer) {
        EntityToModelMethodGenerator generator = new EntityToModelMethodGenerator(printer);
        generator.generate();
    }

    protected void printModelToEntityMethod(Printer printer) {
        ModelToEntityMethodGenerator generator = new ModelToEntityMethodGenerator(printer);
        generator.generate();
    }

    protected void printGetVersionMethod(final Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("protected long getVersion(Object model) {", new Object[0]);
        final AttributeMetaDesc attr = this.modelMetaDesc.getVersionAttributeMetaDesc();
        if (attr == null) {
            printer.println("    throw new IllegalStateException(\"The version property of the model(%1$s) is not defined.\");", this.modelMetaDesc.getModelClassName());
        } else {
            printer.println("    %1$s m = (%1$s) model;", this.modelMetaDesc.getModelClassName());
            DataType dataType = attr.getDataType();
            dataType.accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                protected Void defaultAction(DataType type, Void p) throws RuntimeException {
                    printer.println("    throw new IllegalStateException(\"The version property of the model(%1$s) is not defined.\");", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                    return null;
                }

                @Override
                public Void visitPrimitiveLongType(PrimitiveLongType type, Void p) throws RuntimeException {
                    printer.println("    return m.%1$s();", attr.getReadMethodName());
                    return null;
                }

                @Override
                public Void visitLongType(LongType type, Void p) throws RuntimeException {
                    printer.println("    return m.%1$s() != null ? m.%1$s().longValue() : 0L;", attr.getReadMethodName());
                    return null;
                }
            }, null);
        }
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printIncrementVersionMethod(final Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("protected void incrementVersion(Object model) {", new Object[0]);
        final AttributeMetaDesc attr = this.modelMetaDesc.getVersionAttributeMetaDesc();
        if (attr != null) {
            printer.println("    %1$s m = (%1$s) model;", this.modelMetaDesc.getModelClassName());
            DataType dataType = attr.getDataType();
            dataType.accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                protected Void defaultAction(DataType type, Void p) throws RuntimeException {
                    printer.println("    throw new IllegalStateException(\"The version property of the model(%1$s) is not defined.\");", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                    return null;
                }

                @Override
                public Void visitPrimitiveLongType(PrimitiveLongType type, Void p) throws RuntimeException {
                    printer.println("    m.%1$s(m.%2$s() + 1L);", attr.getWriteMethodName(), attr.getReadMethodName());
                    return null;
                }

                @Override
                public Void visitLongType(LongType type, Void p) throws RuntimeException {
                    printer.println("    long version = m.%1$s() != null ? m.%1$s().longValue() : 0L;", attr.getReadMethodName());
                    printer.println("    m.%1$s(Long.valueOf(version + 1L));", attr.getWriteMethodName());
                    return null;
                }
            }, null);
        }
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printGetSchemaVersionName(Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("public String getSchemaVersionName() {", new Object[0]);
        printer.println("    return \"%1$s\";", this.modelMetaDesc.getSchemaVersionName());
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printGetClassHierarchyListName(Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("public String getClassHierarchyListName() {", new Object[0]);
        printer.println("    return \"%1$s\";", this.modelMetaDesc.getClassHierarchyListName());
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printIsCipherProperty(Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("protected boolean isCipherProperty(String propertyName) {", new Object[0]);
        for (AttributeMetaDesc attr : this.modelMetaDesc.getAttributeMetaDescList()) {
            if (!attr.isPersistent() || !attr.isCipher()) continue;
            printer.println("    if (\"%1$s\".equals(propertyName)) return true;", attr.getName());
        }
        printer.println("    return false;", new Object[0]);
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printGetKeyMethod(Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("protected com.google.appengine.api.datastore.Key getKey(Object model) {", new Object[0]);
        AttributeMetaDesc attr = this.modelMetaDesc.getKeyAttributeMetaDesc();
        if (attr == null) {
            printer.println("    throw new IllegalStateException(\"The key property of the model(%1$s) is not defined.\");", this.modelMetaDesc.getModelClassName());
        } else {
            printer.println("    %1$s m = (%1$s) model;", this.modelMetaDesc.getModelClassName());
            printer.println("    return m.%1$s();", attr.getReadMethodName());
        }
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printSetKeyMethod(Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("protected void setKey(Object model, com.google.appengine.api.datastore.Key key) {", new Object[0]);
        AttributeMetaDesc attr = this.modelMetaDesc.getKeyAttributeMetaDesc();
        if (attr == null) {
            printer.println("    throw new IllegalStateException(\"The key property of the model(%1$s) is not defined.\");", this.modelMetaDesc.getModelClassName());
        } else {
            printer.println("    validateKey(key);", new Object[0]);
            printer.println("    %1$s m = (%1$s) model;", this.modelMetaDesc.getModelClassName());
            printer.println("    m.%1$s(key);", attr.getWriteMethodName());
        }
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printPrePutMethod(Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("protected void prePut(Object model) {", new Object[0]);
        boolean first = true;
        for (AttributeMetaDesc attr : this.modelMetaDesc.getAttributeMetaDescList()) {
            if (attr.getAttributeListenerClassName() == null || attr.getAttributeListenerClassName().equals("org.slim3.datastore.AttributeListener") || !attr.isPersistent()) continue;
            if (first) {
                printer.println("    %1$s m = (%1$s) model;", this.modelMetaDesc.getModelClassName());
                first = false;
            }
            printer.println("    m.%1$s(slim3_%2$sAttributeListener.prePut(m.%3$s()));", attr.getWriteMethodName(), attr.getAttributeName(), attr.getReadMethodName());
        }
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printAssignKeyToModelRefIfNecessaryMethod(Printer printer) {
        AssignKeyToModelRefIfNecessaryMethodGenerator generator = new AssignKeyToModelRefIfNecessaryMethodGenerator(printer);
        generator.generate();
    }

    protected void printModelToJsonMethod(Printer printer) {
        new ModelToJsonMethodGenerator(printer).generate();
    }

    protected void printJsonToModelMethod(Printer printer) {
        new JsonToModelMethodGenerator(printer).generate();
    }

    protected void printCustomExtensionMethods(Printer printer) {
    }

    private boolean isSupportedForJson(DataType dataType) {
        if (jsonSupportedTypes.contains(dataType.getClassName())) {
            return true;
        }
        if (jsonSupportedTypes.contains(dataType.getTypeName())) {
            return true;
        }
        if (dataType instanceof CollectionType) {
            return true;
        }
        if (dataType instanceof CorePrimitiveType) {
            return true;
        }
        if (dataType instanceof EnumType) {
            return true;
        }
        if (dataType instanceof ArrayType) {
            return true;
        }
        return dataType instanceof PrimitiveByteType;
    }

    static {
        defaultsOfPrimitives.put("boolean", "false");
        defaultsOfPrimitives.put("char", "(char)0");
        defaultsOfPrimitives.put("short", "(short)0");
        defaultsOfPrimitives.put("int", "0");
        defaultsOfPrimitives.put("long", "0L");
        defaultsOfPrimitives.put("float", "0f");
        defaultsOfPrimitives.put("double", "0.0");
        jsonSupportedTypes.addAll(Arrays.asList("java.lang.Boolean", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.String", "java.util.Date", "com.google.appengine.api.datastore.Blob", "com.google.appengine.api.blobstore.BlobKey", "com.google.appengine.api.datastore.Category", "com.google.appengine.api.datastore.Email", "com.google.appengine.api.datastore.GeoPt", "com.google.appengine.api.datastore.IMHandle", "com.google.appengine.api.datastore.Key", "com.google.appengine.api.datastore.Link", "com.google.appengine.api.datastore.PhoneNumber", "com.google.appengine.api.datastore.PostalAddress", "com.google.appengine.api.datastore.Rating", "com.google.appengine.api.datastore.ShortBlob", "com.google.appengine.api.datastore.Text", "com.google.appengine.api.users.User", "org.slim3.datastore.ModelRef"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JsonToModelMethodGenerator
    extends SimpleDataTypeVisitor<Void, AttributeMetaDesc, RuntimeException> {
        private final Printer printer;
        private String getterExp;
        private String setterExp;
        private String coderExp;
        private boolean ignoreNull;

        public JsonToModelMethodGenerator(Printer printer) {
            this.printer = printer;
        }

        public JsonToModelMethodGenerator(Printer printer, String getterExp, String setterExp, String coderExp, boolean ignoreNull) {
            this.printer = printer;
            this.getterExp = getterExp;
            this.setterExp = setterExp;
            this.coderExp = coderExp;
            this.ignoreNull = ignoreNull;
        }

        public void generate() {
            this.printer.println("@Override", new Object[0]);
            this.printer.println("protected %s jsonToModel(%s rootReader, int maxDepth, int currentDepth) {", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), "org.slim3.datastore.json.JsonRootReader");
            this.printer.indent();
            if (ModelMetaGenerator.this.modelMetaDesc.isAbstrct()) {
                this.printer.println("throw new %1$s(\"The class(%2$s) is abstract.\");", UnsupportedOperationException.class.getName(), ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
            } else {
                HashMap<String, String> decoders = new HashMap<String, String>();
                this.printer.println("%1$s m = new %1$s();", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                this.printer.println("%s reader = null;", "org.slim3.datastore.json.JsonReader");
                this.printer.println("%s decoder0 = new %1$s();", "org.slim3.datastore.json.Default");
                decoders.put("org.slim3.datastore.json.Default", "decoder0");
                for (AttributeMetaDesc attr : ModelMetaGenerator.this.modelMetaDesc.getAttributeMetaDescList()) {
                    JsonAnnotation ja = attr.getJson();
                    if (ja.isIgnore()) continue;
                    DataType dt = attr.getDataType();
                    String name = ja.getAlias();
                    if (name.length() == 0) {
                        name = attr.getAttributeName();
                    }
                    this.printer.println("reader = rootReader.newObjectReader(\"%s\");", name);
                    String cn = ja.getCoderClassName();
                    this.coderExp = (String)decoders.get(cn);
                    if (this.coderExp == null) {
                        String vn;
                        this.coderExp = vn = "decoder" + decoders.size();
                        this.printer.println("%s %s = new %1$s();", cn, vn);
                        decoders.put(cn, vn);
                    }
                    this.setterExp = attr.getWriteMethodName() != null ? "m." + attr.getWriteMethodName() : null;
                    this.getterExp = attr.getReadMethodName() != null ? "m." + attr.getReadMethodName() + "()" : this.getDefaultValue(attr.getDataType().getClassName());
                    dt.accept(this, attr);
                }
                this.printer.println("return m;", new Object[0]);
            }
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
        }

        @Override
        protected Void defaultAction(DataType type, AttributeMetaDesc p) throws RuntimeException {
            if (this.setterExp == null) {
                return null;
            }
            if (this.ignoreNull) {
                this.printer.print("%s v = ", type.getClassName());
            } else {
                this.printer.print("%s(", this.setterExp);
            }
            if (ModelMetaGenerator.this.isSupportedForJson(type)) {
                this.printer.printWithoutIndent("%s.decode(reader, %s)", this.coderExp, this.getterExp);
            } else {
                this.printer.printWithoutIndent("%s.decode(reader, %s, %s.class)", this.coderExp, this.getterExp, type.getClassName());
            }
            if (this.ignoreNull) {
                this.printer.println(";", new Object[0]);
                this.printer.println("if(v != null){", new Object[0]);
                this.printer.indent();
                this.printer.println("%s(v);", this.setterExp);
                this.printer.unindent();
                this.printer.println("}", new Object[0]);
            } else {
                this.printer.printlnWithoutIndent(");", new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitEnumType(EnumType type, AttributeMetaDesc p) throws RuntimeException {
            if (this.setterExp == null) {
                return null;
            }
            this.printer.println("%s(%s.decode(reader, %s, %s.class));", this.setterExp, this.coderExp, this.getterExp, type.getClassName());
            return null;
        }

        @Override
        public Void visitStringType(StringType type, AttributeMetaDesc p) throws RuntimeException {
            if (this.setterExp == null) {
                return null;
            }
            if (p.isCipher()) {
                this.printer.println("if(reader.read() != null){", new Object[0]);
                this.printer.indent();
                this.printer.println("reader = new %s(decrypt(reader.read()), rootReader.getModelReader());", "org.slim3.datastore.json.JsonValueReader");
                this.printer.unindent();
                this.printer.println("}", new Object[0]);
            }
            return (Void)super.visitStringType(type, p);
        }

        @Override
        public Void visitTextType(TextType type, AttributeMetaDesc p) throws RuntimeException {
            if (this.setterExp == null) {
                return null;
            }
            if (p.isCipher()) {
                this.printer.println("if(reader.read() != null){", new Object[0]);
                this.printer.indent();
                this.printer.println("reader = new %s(decrypt(reader.read()), rootReader.getModelReader());", "org.slim3.datastore.json.JsonValueReader");
                this.printer.unindent();
                this.printer.println("}", new Object[0]);
            }
            return (Void)super.visitTextType(type, p);
        }

        @Override
        public Void visitCollectionType(CollectionType type, AttributeMetaDesc p) throws RuntimeException {
            if (this.setterExp == null) {
                return null;
            }
            DataType et = type.getElementType();
            if (!ModelMetaGenerator.this.isSupportedForJson(et)) {
                return null;
            }
            String container = "java.util.ArrayList";
            if (type instanceof SortedSetType) {
                container = "java.util.TreeSet";
            } else if (type instanceof SetType) {
                container = "java.util.HashSet";
            }
            this.printer.println("{", new Object[0]);
            this.printer.indent();
            this.printer.println("%s<%s> elements = new %1$s<%2$s>();", container, et.getTypeName());
            this.printer.println("%s r = rootReader.newArrayReader(\"%s\");", "org.slim3.datastore.json.JsonArrayReader", p.getAttributeName());
            this.printer.println("if(r != null){", new Object[0]);
            this.printer.indent();
            this.printer.println("reader = r;", new Object[0]);
            this.printer.println("int n = r.length();", new Object[0]);
            this.printer.println("for(int i = 0; i < n; i++){", new Object[0]);
            this.printer.indent();
            this.printer.println("r.setIndex(i);", new Object[0]);
            if (et instanceof ModelRefType) {
                this.printer.println("%s ref = new %1$s(%s.class);", et.getTypeName(), ((ModelRefType)et).getReferenceModelTypeName());
                type.getElementType().accept(new JsonToModelMethodGenerator(this.printer, "ref", "elements.add", this.coderExp, true), p);
                this.printer.println("if(ref.getKey() != null){", new Object[0]);
                this.printer.indent();
                this.printer.println("elements.add(ref);", new Object[0]);
                this.printer.unindent();
                this.printer.println("}", new Object[0]);
            } else {
                type.getElementType().accept(new JsonToModelMethodGenerator(this.printer, "(" + et.getClassName() + ")null", "elements.add", this.coderExp, true), p);
            }
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
            this.printer.println("%s(elements);", this.setterExp);
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
            return null;
        }

        @Override
        public Void visitArrayType(ArrayType type, AttributeMetaDesc p) throws RuntimeException {
            if (this.setterExp == null) {
                return null;
            }
            DataType et = type.getComponentType();
            if (!ModelMetaGenerator.this.isSupportedForJson(et)) {
                this.printer.println("// %s(%s) is not supported.", et.getClassName(), et.getTypeName());
                return null;
            }
            if (et.getClassName().equals("byte")) {
                this.printer.println("if(%s != null){", this.getterExp);
                this.printer.indent();
                this.printer.println("%s(%s.decode(reader, new %s(%s)).getBytes());", this.setterExp, this.coderExp, "com.google.appengine.api.datastore.ShortBlob", this.getterExp);
                this.printer.unindent();
                this.printer.println("} else{", new Object[0]);
                this.printer.indent();
                this.printer.println("%s v = %s.decode(reader, (%1$s)null);", "com.google.appengine.api.datastore.ShortBlob", this.coderExp);
                this.printer.println("if(v != null){", new Object[0]);
                this.printer.indent();
                this.printer.println("%s(v.getBytes());", this.setterExp);
                this.printer.unindent();
                this.printer.println("} else{", new Object[0]);
                this.printer.indent();
                this.printer.println("%s(null);", this.setterExp);
                this.printer.unindent();
                this.printer.println("}", new Object[0]);
                this.printer.unindent();
                this.printer.println("}", new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitModelRefType(ModelRefType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("%s.decode(reader, %s, maxDepth, currentDepth);", this.coderExp, this.getterExp);
            return null;
        }

        private String getDefaultValue(String className) {
            String def = (String)defaultsOfPrimitives.get(className);
            if (def != null) {
                return def;
            }
            return "(" + className + ")null";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ModelToJsonMethodGenerator
    extends SimpleDataTypeVisitor<Void, AttributeMetaDesc, RuntimeException> {
        private final Printer printer;
        private String valueExp;
        private String coderExp;
        private int indent;

        public ModelToJsonMethodGenerator(Printer printer) {
            this.printer = printer;
        }

        public ModelToJsonMethodGenerator(Printer printer, String coderExp, String valueExp) {
            this.printer = printer;
            this.valueExp = valueExp;
            this.coderExp = coderExp;
        }

        public void generate() {
            this.printer.println("@Override", new Object[0]);
            this.printer.println("protected void modelToJson(%s writer, %s model, int maxDepth, int currentDepth) {", "org.slim3.datastore.json.JsonWriter", "java.lang.Object");
            this.printer.indent();
            if (ModelMetaGenerator.this.modelMetaDesc.isAbstrct()) {
                this.printer.println("throw new %1$s(\"The class(%2$s) is abstract.\");", UnsupportedOperationException.class.getName(), ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
            } else {
                HashMap<String, String> encoders = new HashMap<String, String>();
                this.printer.println("%s m = (%1$s) model;", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                this.printer.println("writer.beginObject();", new Object[0]);
                this.printer.println("%s encoder0 = new %1$s();", "org.slim3.datastore.json.Default");
                encoders.put("org.slim3.datastore.json.Default", "encoder0");
                for (AttributeMetaDesc attr : ModelMetaGenerator.this.modelMetaDesc.getAttributeMetaDescList()) {
                    String name;
                    DataType dataType;
                    if (attr.getReadMethodName() == null) continue;
                    this.valueExp = "m." + attr.getReadMethodName() + "()";
                    this.indent = 0;
                    JsonAnnotation ja = attr.getJson();
                    if (ja.isIgnore()) continue;
                    String cn = ja.getCoderClassName();
                    this.coderExp = (String)encoders.get(cn);
                    if (this.coderExp == null) {
                        String vn;
                        this.coderExp = vn = "encoder" + encoders.size();
                        this.printer.println("%s %s = new %1$s();", cn, vn);
                        encoders.put(cn, vn);
                    }
                    if (!((dataType = attr.getDataType()) instanceof CorePrimitiveType) && ja.isIgnoreNull()) {
                        this.printer.print("if(%s != null", this.valueExp);
                        if (dataType instanceof TextType) {
                            this.printer.printWithoutIndent(" && %s.getValue() != null", this.valueExp);
                        } else if (dataType instanceof BlobType) {
                            this.printer.printWithoutIndent(" && %s.getBytes() != null", this.valueExp);
                        } else if (dataType instanceof ModelRefType) {
                            this.printer.printWithoutIndent(" && %s.getKey() != null", this.valueExp);
                        }
                        this.printer.printlnWithoutIndent("){", new Object[0]);
                        this.printer.indent();
                        ++this.indent;
                    }
                    if ((name = ja.getAlias()).length() == 0) {
                        name = attr.getAttributeName();
                    }
                    this.printer.println("writer.setNextPropertyName(\"%1$s\");", name);
                    dataType.accept(this, attr);
                    for (int i = 0; i < this.indent; ++i) {
                        this.printer.unindent();
                        this.printer.println("}", new Object[0]);
                    }
                }
                this.printer.println("writer.endObject();", new Object[0]);
            }
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
            this.printer.println();
        }

        @Override
        protected Void defaultAction(DataType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("%s.encode(writer, %s);", this.coderExp, this.valueExp);
            return null;
        }

        @Override
        public Void visitBlobType(BlobType type, AttributeMetaDesc p) throws RuntimeException {
            if (!p.getJson().isIgnoreNull()) {
                this.printer.println("if(%s == null || %1$s.getBytes() == null){", this.valueExp);
                this.printer.indent();
                this.printer.println("%s.encode(writer, (%s)null);", this.coderExp, "com.google.appengine.api.datastore.Blob");
                this.printer.unindent();
                this.printer.println("} else{", new Object[0]);
                this.printer.indent();
                ++this.indent;
            }
            return (Void)super.visitBlobType(type, p);
        }

        @Override
        public Void visitTextType(TextType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isCipher()) {
                if (!p.getJson().isIgnoreNull()) {
                    this.printer.println("if(%s == null || %1$s.getValue() == null){", this.valueExp);
                    this.printer.indent();
                    this.printer.println("%s.encode(writer, %s);", this.coderExp, this.valueExp);
                    this.printer.unindent();
                    this.printer.println("} else{", new Object[0]);
                    this.printer.indent();
                    ++this.indent;
                }
                this.printer.println("%s.encode(writer, new %s(encrypt(%s.getValue())));", this.coderExp, "com.google.appengine.api.datastore.Text", this.valueExp);
                return null;
            }
            return (Void)super.visitTextType(type, p);
        }

        @Override
        public Void visitStringType(StringType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isCipher()) {
                if (!p.getJson().isIgnoreNull()) {
                    this.printer.println("if(%s == null){", this.valueExp);
                    this.printer.indent();
                    this.printer.println("%s.encode(writer, %s);", this.coderExp, this.valueExp);
                    this.printer.unindent();
                    this.printer.println("} else{", new Object[0]);
                    this.printer.indent();
                    ++this.indent;
                }
                this.printer.println("%s.encode(writer, encrypt(%s));", this.coderExp, this.valueExp);
                return null;
            }
            return (Void)super.visitStringType(type, p);
        }

        @Override
        public Void visitCollectionType(CollectionType type, AttributeMetaDesc p) throws RuntimeException {
            DataType et = type.getElementType();
            if (!ModelMetaGenerator.this.isSupportedForJson(et)) {
                this.printer.println("// %s is not supported.", et.getClassName());
                return null;
            }
            if (!p.getJson().isIgnoreNull()) {
                this.printer.println("if(%s == null){", this.valueExp);
                this.printer.indent();
                this.printer.println("writer.writeNull();", new Object[0]);
                this.printer.unindent();
                this.printer.println("} else{", new Object[0]);
                this.printer.indent();
                ++this.indent;
            }
            this.printer.println("writer.beginArray();", new Object[0]);
            this.printer.println("for(%s v : %s){", et.getClassName(), this.valueExp);
            this.printer.indent();
            ModelToJsonMethodGenerator gen = new ModelToJsonMethodGenerator(this.printer, this.coderExp, "v");
            et.accept(gen, p);
            for (int i = 0; i < gen.indent; ++i) {
                this.printer.unindent();
                this.printer.println("}", new Object[0]);
            }
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
            this.printer.println("writer.endArray();", new Object[0]);
            return null;
        }

        @Override
        public Void visitArrayType(ArrayType type, AttributeMetaDesc p) throws RuntimeException {
            DataType et = type.getComponentType();
            if (!ModelMetaGenerator.this.isSupportedForJson(et)) {
                this.printer.println("// %s(%s) is not supported.", et.getClassName(), et.getTypeName());
                return null;
            }
            if (et.getClassName().equals("byte")) {
                if (!p.getJson().isIgnoreNull()) {
                    this.printer.println("if(%s == null){", this.valueExp);
                    this.printer.indent();
                    this.printer.println("%s.encode(writer, (%s)null);", this.coderExp, "com.google.appengine.api.datastore.ShortBlob");
                    this.printer.unindent();
                    this.printer.println("} else{", new Object[0]);
                    this.printer.indent();
                    ++this.indent;
                }
                this.printer.println("%s.encode(writer, new %s(%s));", this.coderExp, "com.google.appengine.api.datastore.ShortBlob", this.valueExp);
            } else {
                if (!p.getJson().isIgnoreNull()) {
                    this.printer.println("if(%s == null){", this.valueExp);
                    this.printer.indent();
                    this.printer.println("%s.encode(writer, (%s));", this.coderExp, this.valueExp);
                    this.printer.unindent();
                    this.printer.println("} else{", new Object[0]);
                    this.printer.indent();
                    ++this.indent;
                }
                this.printer.println("writer.beginArray();", new Object[0]);
                this.printer.println("for(%s v : %s){", et.getClassName(), this.valueExp);
                this.printer.indent();
                ModelToJsonMethodGenerator gen = new ModelToJsonMethodGenerator(this.printer, this.coderExp, "v");
                et.accept(gen, p);
                for (int i = 0; i < gen.indent; ++i) {
                    this.printer.unindent();
                    this.printer.println("}", new Object[0]);
                }
                this.printer.unindent();
                this.printer.println("}", new Object[0]);
                this.printer.println("writer.endArray();", new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitModelRefType(ModelRefType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("%s.encode(writer, %s, maxDepth, currentDepth);", this.coderExp, this.valueExp);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AssignKeyToModelRefIfNecessaryMethodGenerator
    extends SimpleDataTypeVisitor<Void, AttributeMetaDesc, RuntimeException> {
        protected final Printer printer;

        public AssignKeyToModelRefIfNecessaryMethodGenerator(Printer printer) {
            this.printer = printer;
        }

        public void generate() {
            this.printer.println("@Override", new Object[0]);
            this.printer.println("protected void assignKeyToModelRefIfNecessary(%1$s ds, %2$s model) {", "com.google.appengine.api.datastore.AsyncDatastoreService", "java.lang.Object");
            this.printer.indent();
            if (ModelMetaGenerator.this.modelMetaDesc.isAbstrct()) {
                this.printer.println("throw new %1$s(\"The class(%2$s) is abstract.\");", UnsupportedOperationException.class.getName(), ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
            } else {
                boolean found = false;
                for (AttributeMetaDesc attr : ModelMetaGenerator.this.modelMetaDesc.getAttributeMetaDescList()) {
                    if (!attr.isPersistent() || !(attr.getDataType() instanceof ModelRefType)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.printer.println("%1$s m = (%1$s) model;", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                    for (AttributeMetaDesc attr : ModelMetaGenerator.this.modelMetaDesc.getAttributeMetaDescList()) {
                        if (!attr.isPersistent() || attr.isPrimaryKey()) continue;
                        DataType dataType = attr.getDataType();
                        dataType.accept(this, attr);
                    }
                }
            }
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
            this.printer.println();
        }

        @Override
        protected Void defaultAction(DataType type, AttributeMetaDesc p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitModelRefType(ModelRefType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("if (m.%1$s() == null) {", p.getReadMethodName());
            this.printer.println("    throw new NullPointerException(\"The property(%1$s) must not be null.\");", p.getAttributeName());
            this.printer.println("}", new Object[0]);
            this.printer.println("m.%1$s().assignKeyIfNecessary(ds);", p.getReadMethodName());
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ModelToEntityMethodGenerator
    extends SimpleDataTypeVisitor<Void, AttributeMetaDesc, RuntimeException> {
        protected final Printer printer;

        public ModelToEntityMethodGenerator(Printer printer) {
            this.printer = printer;
        }

        public void generate() {
            this.printer.println("@Override", new Object[0]);
            this.printer.println("public %1$s modelToEntity(%2$s model) {", "com.google.appengine.api.datastore.Entity", "java.lang.Object");
            this.printer.indent();
            if (ModelMetaGenerator.this.modelMetaDesc.isAbstrct()) {
                this.printer.println("throw new %1$s(\"The class(%2$s) is abstract.\");", UnsupportedOperationException.class.getName(), ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
            } else {
                this.printer.println("%1$s m = (%1$s) model;", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                this.printer.println("%1$s entity = null;", "com.google.appengine.api.datastore.Entity");
                this.printer.println("if (m.%1$s() != null) {", ModelMetaGenerator.this.modelMetaDesc.getKeyAttributeMetaDesc().getReadMethodName());
                this.printer.println("    entity = new %1$s(m.%2$s());", "com.google.appengine.api.datastore.Entity", ModelMetaGenerator.this.modelMetaDesc.getKeyAttributeMetaDesc().getReadMethodName());
                this.printer.println("} else {", new Object[0]);
                this.printer.println("    entity = new %1$s(kind);", "com.google.appengine.api.datastore.Entity");
                this.printer.println("}", new Object[0]);
                for (AttributeMetaDesc attr : ModelMetaGenerator.this.modelMetaDesc.getAttributeMetaDescList()) {
                    if (!attr.isPersistent() || attr.isPrimaryKey()) continue;
                    DataType dataType = attr.getDataType();
                    dataType.accept(this, attr);
                }
                int schemaVersion = ModelMetaGenerator.this.modelMetaDesc.getSchemaVersion();
                if (schemaVersion > 0) {
                    this.printer.println("entity.setProperty(\"%1$s\", %2$s);", ModelMetaGenerator.this.modelMetaDesc.getSchemaVersionName(), ModelMetaGenerator.this.modelMetaDesc.getSchemaVersion());
                }
                if (!ModelMetaGenerator.this.modelMetaDesc.getClassHierarchyList().isEmpty()) {
                    this.printer.println("entity.setProperty(\"%1$s\", classHierarchyList);", ModelMetaGenerator.this.modelMetaDesc.getClassHierarchyListName());
                }
                this.printer.println("return entity;", new Object[0]);
            }
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
            this.printer.println();
        }

        @Override
        protected Void defaultAction(DataType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("entity.setUnindexedProperty(\"%1$s\", serializableToBlob(m.%2$s()));", p.getName(), p.getReadMethodName());
            return null;
        }

        @Override
        public Void visitCorePrimitiveType(CorePrimitiveType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isUnindexed()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            } else {
                this.printer.println("entity.setProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            }
            return null;
        }

        @Override
        public Void visitCoreReferenceType(CoreReferenceType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isUnindexed()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            } else {
                this.printer.println("entity.setProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            }
            return null;
        }

        @Override
        public Void visitStringType(StringType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isLob() && p.isCipher()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", stringToText(encrypt(m.%2$s())));", p.getName(), p.getReadMethodName());
                return null;
            }
            if (p.isLob()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", stringToText(m.%2$s()));", p.getName(), p.getReadMethodName());
                return null;
            }
            if (p.isCipher()) {
                this.printer.println("entity.setProperty(\"%1$s\", encrypt(m.%2$s()));", p.getName(), p.getReadMethodName());
                return null;
            }
            return (Void)super.visitStringType(type, p);
        }

        @Override
        public Void visitEnumType(EnumType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isUnindexed()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", enumToString(m.%2$s()));", p.getName(), p.getReadMethodName());
            } else {
                this.printer.println("entity.setProperty(\"%1$s\", enumToString(m.%2$s()));", p.getName(), p.getReadMethodName());
            }
            return null;
        }

        @Override
        public Void visitTextType(TextType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isCipher()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", encrypt(m.%2$s()));", p.getName(), p.getReadMethodName());
                return null;
            }
            this.printer.println("entity.setUnindexedProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            return null;
        }

        @Override
        public Void visitModelRefType(ModelRefType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("if (m.%1$s() == null) {", p.getReadMethodName());
            this.printer.println("    throw new NullPointerException(\"The property(%1$s) must not be null.\");", p.getAttributeName());
            this.printer.println("}", new Object[0]);
            if (p.isUnindexed()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", m.%2$s().getKey());", p.getName(), p.getReadMethodName());
            } else {
                this.printer.println("entity.setProperty(\"%1$s\", m.%2$s().getKey());", p.getName(), p.getReadMethodName());
            }
            return null;
        }

        @Override
        public Void visitArrayType(ArrayType type, final AttributeMetaDesc attr) throws RuntimeException {
            DataType componentType = type.getComponentType();
            boolean accepted = componentType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitPrimitiveByteType(PrimitiveByteType type, Void p) throws RuntimeException {
                    if (attr.isLob()) {
                        ModelToEntityMethodGenerator.this.printer.println("entity.setUnindexedProperty(\"%1$s\", bytesToBlob(m.%2$s()));", attr.getName(), attr.getReadMethodName());
                    } else if (attr.isUnindexed()) {
                        ModelToEntityMethodGenerator.this.printer.println("entity.setUnindexedProperty(\"%1$s\", bytesToShortBlob(m.%2$s()));", attr.getName(), attr.getReadMethodName());
                    } else {
                        ModelToEntityMethodGenerator.this.printer.println("entity.setProperty(\"%1$s\", bytesToShortBlob(m.%2$s()));", attr.getName(), attr.getReadMethodName());
                    }
                    return true;
                }
            }, null);
            if (accepted) {
                return null;
            }
            return (Void)super.visitArrayType(type, attr);
        }

        @Override
        public Void visitCollectionType(CollectionType type, final AttributeMetaDesc attr) throws RuntimeException {
            if (attr.isLob()) {
                return (Void)super.visitCollectionType(type, attr);
            }
            DataType componentType = type.getElementType();
            boolean accepted = componentType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitEnumType(EnumType type, Void p) throws RuntimeException {
                    if (attr.isUnindexed()) {
                        ModelToEntityMethodGenerator.this.printer.println("entity.setUnindexedProperty(\"%1$s\", enumListToStringListm.%2$s()));", attr.getName(), attr.getReadMethodName());
                    } else {
                        ModelToEntityMethodGenerator.this.printer.println("entity.setProperty(\"%1$s\", enumListToStringList(m.%2$s()));", attr.getName(), attr.getReadMethodName());
                    }
                    return true;
                }
            }, null);
            if (accepted) {
                return null;
            }
            if (attr.isUnindexed()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", m.%2$s());", attr.getName(), attr.getReadMethodName());
            } else {
                this.printer.println("entity.setProperty(\"%1$s\", m.%2$s());", attr.getName(), attr.getReadMethodName());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntityToModelMethodGenerator
    extends SimpleDataTypeVisitor<Void, AttributeMetaDesc, RuntimeException> {
        protected final Printer printer;

        public EntityToModelMethodGenerator(Printer printer) {
            this.printer = printer;
        }

        public void generate() {
            this.printer.println("@Override", new Object[0]);
            this.printer.println("public %1$s entityToModel(%2$s entity) {", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), "com.google.appengine.api.datastore.Entity");
            this.printer.indent();
            if (ModelMetaGenerator.this.modelMetaDesc.isAbstrct()) {
                this.printer.println("throw new %1$s(\"The class(%2$s) is abstract.\");", UnsupportedOperationException.class.getName(), ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
            } else {
                this.printer.println("%1$s model = new %1$s();", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                for (AttributeMetaDesc attr : ModelMetaGenerator.this.modelMetaDesc.getAttributeMetaDescList()) {
                    if (!attr.isPersistent()) continue;
                    DataType dataType = attr.getDataType();
                    dataType.accept(this, attr);
                }
                this.printer.println("return model;", new Object[0]);
            }
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
            this.printer.println();
        }

        @Override
        protected Void defaultAction(DataType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("%1$s _%2$s = blobToSerializable((%3$s) entity.getProperty(\"%4$s\"));", type.getTypeName(), p.getAttributeName(), "com.google.appengine.api.datastore.Blob", p.getName());
            this.printer.println("model.%1$s(_%2$s);", p.getWriteMethodName(), p.getAttributeName());
            return null;
        }

        @Override
        public Void visitPrimitiveBooleanType(PrimitiveBooleanType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(booleanToPrimitiveBoolean((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), type.getWrapperClassName(), p.getName());
            return null;
        }

        @Override
        public Void visitPrimitiveDoubleType(PrimitiveDoubleType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(doubleToPrimitiveDouble((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), type.getWrapperClassName(), p.getName());
            return null;
        }

        @Override
        public Void visitPrimitiveFloatType(PrimitiveFloatType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(doubleToPrimitiveFloat((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Double", p.getName());
            return null;
        }

        @Override
        public Void visitPrimitiveIntType(PrimitiveIntType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(longToPrimitiveInt((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Long", p.getName());
            return null;
        }

        @Override
        public Void visitPrimitiveLongType(PrimitiveLongType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(longToPrimitiveLong((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), type.getWrapperClassName(), p.getName());
            return null;
        }

        @Override
        public Void visitPrimitiveShortType(PrimitiveShortType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(longToPrimitiveShort((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Long", p.getName());
            return null;
        }

        @Override
        public Void visitCoreReferenceType(CoreReferenceType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s((%2$s) entity.getProperty(\"%3$s\"));", p.getWriteMethodName(), type.getTypeName(), p.getName());
            return null;
        }

        @Override
        public Void visitFloatType(FloatType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(doubleToFloat((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Double", p.getName());
            return null;
        }

        @Override
        public Void visitIntegerType(IntegerType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(longToInteger((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Long", p.getName());
            return null;
        }

        @Override
        public Void visitShortType(ShortType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(longToShort((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Long", p.getName());
            return null;
        }

        @Override
        public Void visitStringType(StringType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isLob() && p.isCipher()) {
                this.printer.println("model.%1$s(decrypt(textToString((%2$s) entity.getProperty(\"%3$s\"))));", p.getWriteMethodName(), "com.google.appengine.api.datastore.Text", p.getName());
                return null;
            }
            if (p.isLob()) {
                this.printer.println("model.%1$s(textToString((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "com.google.appengine.api.datastore.Text", p.getName());
                return null;
            }
            if (p.isCipher()) {
                this.printer.println("model.%1$s(decrypt((%2$s)entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), type.getTypeName(), p.getName());
                return null;
            }
            return (Void)super.visitStringType(type, p);
        }

        @Override
        public Void visitEnumType(EnumType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(stringToEnum(%2$s.class, (%3$s) entity.getProperty(\"%4$s\")));", p.getWriteMethodName(), type.getTypeName(), "java.lang.String", p.getName());
            return null;
        }

        @Override
        public Void visitTextType(TextType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isCipher()) {
                this.printer.println("model.%1$s(decrypt((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), type.getTypeName(), p.getName());
                return null;
            }
            return (Void)super.visitTextType(type, p);
        }

        @Override
        public Void visitKeyType(KeyType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isPrimaryKey()) {
                this.printer.println("model.%1$s(entity.getKey());", p.getWriteMethodName());
            } else {
                this.printer.println("model.%1$s((%2$s) entity.getProperty(\"%3$s\"));", p.getWriteMethodName(), type.getTypeName(), p.getName());
            }
            return null;
        }

        @Override
        public Void visitModelRefType(ModelRefType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("if (model.%1$s() == null) {", p.getReadMethodName());
            this.printer.println("    throw new NullPointerException(\"The property(%1$s) is null.\");", p.getAttributeName());
            this.printer.println("}", new Object[0]);
            this.printer.println("model.%1$s().setKey((%2$s) entity.getProperty(\"%3$s\"));", p.getReadMethodName(), "com.google.appengine.api.datastore.Key", p.getName());
            return null;
        }

        @Override
        public Void visitArrayType(ArrayType type, final AttributeMetaDesc attr) throws RuntimeException {
            DataType componentType = type.getComponentType();
            boolean accepted = componentType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitPrimitiveByteType(PrimitiveByteType type, Void p) throws RuntimeException {
                    if (attr.isLob()) {
                        EntityToModelMethodGenerator.this.printer.println("model.%1$s(blobToBytes((%2$s) entity.getProperty(\"%3$s\")));", attr.getWriteMethodName(), "com.google.appengine.api.datastore.Blob", attr.getName());
                    } else {
                        EntityToModelMethodGenerator.this.printer.println("model.%1$s(shortBlobToBytes((%2$s) entity.getProperty(\"%3$s\")));", attr.getWriteMethodName(), "com.google.appengine.api.datastore.ShortBlob", attr.getName());
                    }
                    return true;
                }
            }, null);
            if (accepted) {
                return null;
            }
            return (Void)super.visitArrayType(type, attr);
        }

        @Override
        public Void visitListType(ListType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            Boolean handled = elementType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitCoreReferenceType(CoreReferenceType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(toList(%2$s.class, entity.getProperty(\"%3$s\")));", attr.getWriteMethodName(), type.getClassName(), attr.getName());
                    return true;
                }

                @Override
                public Boolean visitShortType(ShortType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(longListToShortList(entity.getProperty(\"%2$s\")));", attr.getWriteMethodName(), attr.getName());
                    return true;
                }

                @Override
                public Boolean visitIntegerType(IntegerType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(longListToIntegerList(entity.getProperty(\"%2$s\")));", attr.getWriteMethodName(), attr.getName());
                    return true;
                }

                @Override
                public Boolean visitFloatType(FloatType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(doubleListToFloatList(entity.getProperty(\"%2$s\")));", attr.getWriteMethodName(), attr.getName());
                    return true;
                }
            }, null);
            return handled != false ? null : (Void)super.visitListType(collectionType, attr);
        }

        @Override
        public Void visitLinkedListType(LinkedListType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            Boolean handled = elementType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitCoreReferenceType(CoreReferenceType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %4$s<%2$s>(toList(%2$s.class, entity.getProperty(\"%3$s\"))));", attr.getWriteMethodName(), type.getClassName(), attr.getName(), "java.util.LinkedList");
                    return true;
                }

                @Override
                public Boolean visitShortType(ShortType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToShortList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedList", "java.lang.Short");
                    return true;
                }

                @Override
                public Boolean visitIntegerType(IntegerType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToIntegerList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedList", "java.lang.Integer");
                    return true;
                }

                @Override
                public Boolean visitFloatType(FloatType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(doubleListToFloatList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedList", "java.lang.Float");
                    return true;
                }
            }, null);
            return handled != false ? null : (Void)super.visitListType(collectionType, attr);
        }

        @Override
        public Void visitSetType(SetType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            Boolean handled = elementType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitCoreReferenceType(CoreReferenceType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %4$s<%2$s>(toList(%2$s.class, entity.getProperty(\"%3$s\"))));", attr.getWriteMethodName(), type.getClassName(), attr.getName(), "java.util.HashSet");
                    return true;
                }

                @Override
                public Boolean visitShortType(ShortType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToShortList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.HashSet", "java.lang.Short");
                    return true;
                }

                @Override
                public Boolean visitIntegerType(IntegerType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToIntegerList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.HashSet", "java.lang.Integer");
                    return true;
                }

                @Override
                public Boolean visitFloatType(FloatType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(doubleListToFloatList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.HashSet", "java.lang.Float");
                    return true;
                }
            }, null);
            return handled != false ? null : (Void)super.visitSetType(collectionType, attr);
        }

        @Override
        public Void visitLinkedHashSetType(LinkedHashSetType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            Boolean handled = elementType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitCoreReferenceType(CoreReferenceType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %4$s<%2$s>(toList(%2$s.class, entity.getProperty(\"%3$s\"))));", attr.getWriteMethodName(), type.getClassName(), attr.getName(), "java.util.LinkedHashSet");
                    return true;
                }

                @Override
                public Boolean visitShortType(ShortType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToShortList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedHashSet", "java.lang.Short");
                    return true;
                }

                @Override
                public Boolean visitIntegerType(IntegerType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToIntegerList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedHashSet", "java.lang.Integer");
                    return true;
                }

                @Override
                public Boolean visitFloatType(FloatType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(doubleListToFloatList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedHashSet", "java.lang.Float");
                    return true;
                }
            }, null);
            return handled != false ? null : (Void)super.visitSetType(collectionType, attr);
        }

        @Override
        public Void visitSortedSetType(SortedSetType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            Boolean handled = elementType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitCoreReferenceType(CoreReferenceType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %4$s<%2$s>(toList(%2$s.class, entity.getProperty(\"%3$s\"))));", attr.getWriteMethodName(), type.getClassName(), attr.getName(), "java.util.TreeSet");
                    return true;
                }

                @Override
                public Boolean visitShortType(ShortType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToShortList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.TreeSet", "java.lang.Short");
                    return true;
                }

                @Override
                public Boolean visitIntegerType(IntegerType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToIntegerList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.TreeSet", "java.lang.Integer");
                    return true;
                }

                @Override
                public Boolean visitFloatType(FloatType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(doubleListToFloatList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.TreeSet", "java.lang.Float");
                    return true;
                }
            }, null);
            return handled != false ? null : (Void)super.visitSortedSetType(collectionType, attr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeMetaFieldsGenerator
    extends SimpleDataTypeVisitor<Void, AttributeMetaDesc, RuntimeException> {
        protected final Printer printer;

        protected AttributeMetaFieldsGenerator(Printer printer) {
            this.printer = printer;
        }

        public void generate() {
            for (AttributeMetaDesc attr : ModelMetaGenerator.this.modelMetaDesc.getAttributeMetaDescList()) {
                if (!attr.isPersistent()) continue;
                DataType dataType = attr.getDataType();
                dataType.accept(this, attr);
            }
        }

        @Override
        protected Void defaultAction(DataType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isLob() || p.isUnindexed()) {
                this.printer.println("/** */", new Object[0]);
                this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.UnindexedAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getTypeName(), p.getAttributeName(), p.getName(), type.getClassName());
                this.printer.println();
            }
            return null;
        }

        @Override
        public Void visitCorePrimitiveType(CorePrimitiveType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.CoreAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getWrapperClassName(), p.getAttributeName(), p.getName(), type.getClassName());
            this.printer.println();
            return null;
        }

        @Override
        public Void visitCoreReferenceType(CoreReferenceType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            if (p.isLob() || p.isUnindexed()) {
                this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.CoreUnindexedAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getTypeName(), p.getAttributeName(), p.getName(), type.getClassName());
            } else {
                this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.CoreAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getTypeName(), p.getAttributeName(), p.getName(), type.getClassName());
            }
            this.printer.println();
            return null;
        }

        @Override
        public Void visitModelRefType(ModelRefType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            this.printer.println("public final %1$s<%2$s, %3$s, %4$s> %5$s = new %1$s<%2$s, %3$s, %4$s>(this, \"%6$s\", \"%5$s\", %7$s.class, %8$s.class);", "org.slim3.datastore.ModelRefAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getTypeName(), type.getReferenceModelTypeName(), p.getAttributeName(), p.getName(), type.getClassName(), type.getReferenceModelTypeName());
            this.printer.println();
            return null;
        }

        @Override
        public Void visitKeyType(KeyType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.CoreAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getTypeName(), p.getAttributeName(), p.getName(), type.getClassName());
            this.printer.println();
            return null;
        }

        @Override
        public Void visitStringType(StringType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            if (p.isLob() || p.isUnindexed()) {
                this.printer.println("public final %1$s<%2$s> %3$s = new %1$s<%2$s>(this, \"%4$s\", \"%3$s\");", "org.slim3.datastore.StringUnindexedAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), p.getAttributeName(), p.getName(), type.getClassName());
            } else {
                this.printer.println("public final %1$s<%2$s> %3$s = new %1$s<%2$s>(this, \"%4$s\", \"%3$s\");", "org.slim3.datastore.StringAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), p.getAttributeName(), p.getName());
            }
            this.printer.println();
            return null;
        }

        @Override
        public Void visitBlobType(BlobType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.UnindexedAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getClassName(), p.getAttributeName(), p.getName(), type.getClassName());
            this.printer.println();
            return null;
        }

        @Override
        public Void visitTextType(TextType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.UnindexedAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getClassName(), p.getAttributeName(), p.getName(), type.getClassName());
            this.printer.println();
            return null;
        }

        @Override
        public Void visitCollectionType(final CollectionType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            elementType.accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitStringType(StringType type, Void p) throws RuntimeException {
                    AttributeMetaFieldsGenerator.this.printer.println("/** */", new Object[0]);
                    if (attr.isLob() || attr.isUnindexed()) {
                        AttributeMetaFieldsGenerator.this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.StringCollectionUnindexedAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), collectionType.getTypeName(), attr.getAttributeName(), attr.getName(), collectionType.getClassName());
                    } else {
                        AttributeMetaFieldsGenerator.this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.StringCollectionAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), collectionType.getTypeName(), attr.getAttributeName(), attr.getName(), collectionType.getClassName());
                    }
                    AttributeMetaFieldsGenerator.this.printer.println();
                    return null;
                }

                @Override
                public Void visitCoreReferenceType(CoreReferenceType elementType, Void p) throws RuntimeException {
                    AttributeMetaFieldsGenerator.this.printer.println("/** */", new Object[0]);
                    if (attr.isLob() || attr.isUnindexed()) {
                        AttributeMetaFieldsGenerator.this.printer.println("public final %1$s<%2$s, %3$s, %4$s> %5$s = new %1$s<%2$s, %3$s, %4$s>(this, \"%6$s\", \"%5$s\", %7$s.class);", "org.slim3.datastore.CollectionUnindexedAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), collectionType.getTypeName(), elementType.getTypeName(), attr.getAttributeName(), attr.getName(), collectionType.getClassName());
                    } else {
                        AttributeMetaFieldsGenerator.this.printer.println("public final %1$s<%2$s, %3$s, %4$s> %5$s = new %1$s<%2$s, %3$s, %4$s>(this, \"%6$s\", \"%5$s\", %7$s.class);", "org.slim3.datastore.CollectionAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), collectionType.getTypeName(), elementType.getTypeName(), attr.getAttributeName(), attr.getName(), collectionType.getClassName());
                    }
                    AttributeMetaFieldsGenerator.this.printer.println();
                    return null;
                }
            }, null);
            return null;
        }

        @Override
        public Void visitArrayType(ArrayType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            if (p.isLob() || p.isUnindexed()) {
                this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.CoreUnindexedAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getTypeName(), p.getAttributeName(), p.getName(), type.getClassName());
            } else {
                this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.CoreAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getTypeName(), p.getAttributeName(), p.getName(), type.getClassName());
            }
            this.printer.println();
            return null;
        }
    }
}

