/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.printer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Formatter;
import org.slim3.gen.printer.Printer;

public class FilePrinter
implements Printer {
    protected static final String INDENT_SPACE = "    ";
    protected StringBuilder indent = new StringBuilder();
    protected final Formatter formatter;

    public FilePrinter(Writer writer) throws IOException {
        if (writer == null) {
            throw new NullPointerException("The writer parameter is null.");
        }
        this.formatter = new Formatter(new BufferedWriter(writer));
    }

    public FilePrinter(File file, String encoding) throws IOException {
        if (file == null) {
            throw new NullPointerException("The file parameter is null.");
        }
        if (encoding == null) {
            throw new NullPointerException("The encoding parameter is null.");
        }
        this.formatter = new Formatter(file, encoding);
    }

    public void print(String format, Object ... args) {
        this.formatter.format(this.indent + format, this.escapse(args));
    }

    public void printWithoutIndent(String format, Object ... args) {
        this.formatter.format(format, this.escapse(args));
    }

    public void println(String format, Object ... args) {
        this.formatter.format(this.indent + format, this.escapse(args));
        this.formatter.format("%n", new Object[0]);
    }

    public void printlnWithoutIndent(String format, Object ... args) {
        this.formatter.format(format, this.escapse(args));
        this.formatter.format("%n", new Object[0]);
    }

    public void println() {
        this.formatter.format("%n", new Object[0]);
    }

    public void indent() {
        this.indent.append(INDENT_SPACE);
    }

    public void unindent() {
        if (this.indent.length() >= INDENT_SPACE.length()) {
            this.indent.setLength(this.indent.length() - INDENT_SPACE.length());
        }
    }

    public void close() {
        this.formatter.close();
    }

    protected Object[] escapse(Object ... args) {
        if (args.length == 0) {
            return args;
        }
        Object[] results = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof String) {
                String text = (String)args[i];
                results[i] = text.replaceAll("\"", "\\\\\"");
                continue;
            }
            results[i] = args[i];
        }
        return results;
    }
}

