/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.File;
import org.slim3.gen.desc.ClassDesc;
import org.slim3.gen.util.StringUtil;

public class JavaFile {
    protected final File baseDir;
    protected final ClassDesc classDesc;
    protected final String suffix;
    protected final File file;

    public JavaFile(File baseDir, ClassDesc classDesc) {
        this(baseDir, classDesc, "");
    }

    public JavaFile(File baseDir, ClassDesc classDesc, String suffix) {
        this.baseDir = baseDir;
        this.classDesc = classDesc;
        this.suffix = suffix;
        this.file = this.createFile(baseDir, classDesc, suffix);
    }

    protected File createFile(File baseDir, ClassDesc classDesc, String suffix) {
        File packageDir = null;
        packageDir = StringUtil.isEmpty(classDesc.getPackageName()) ? baseDir : new File(baseDir, classDesc.getPackageName().replace(".", File.separator));
        this.mkdirs(packageDir);
        return new File(packageDir, classDesc.getSimpleName().replace('.', '/') + suffix + ".java");
    }

    protected void mkdirs(File dir) {
        dir.mkdirs();
    }

    public String getClassName() {
        return this.classDesc.getQualifiedName() + this.suffix;
    }

    public File getFile() {
        return this.file;
    }
}

