//
//  PT1Device.cpp
//

#include <IOKit/IOLib.h>
#include <IOKit/assert.h>
#include "PT1Device.h"

#define __iomem
typedef UInt8 __u8;
typedef UInt16 __u16;
typedef UInt32 __u32;

extern "C" {

#define PCI_PT1_ID 0x211a
#define PCI_PT2_ID 0x222a

// import from pt1_com.h : start
#ifndef		__PT1_COM_H__
#define		__PT1_COM_H__
/***************************************************************************/
/* I2Cデータ位置定義                                                       */
/***************************************************************************/
#define		MAX_CHANNEL			4		// チャネル数
#define		FALSE		0
#define		TRUE		1
#define		MAX_TUNER			2		//チューナ数
enum{
	CHANNEL_TYPE_ISDB_S,
	CHANNEL_TYPE_ISDB_T,
	CHANNEL_TYPE_MAX
};
/***************************************************************************/
/* 状態                                                                    */
/***************************************************************************/
enum{
	STATE_STOP,			// 初期化直後
	STATE_START,		// 通常
	STATE_FULL			// ストッパー
};
#endif
// import from pt1_com.h : end

// import from pt1_pci.h : start
#ifndef		__PT1_PCI_H__
#define		__PT1_PCI_H__
/***************************************************************************/
/* PCIアドレス定義                                                         */
/***************************************************************************/
#define		FIFO_GO			0x04			// FIFO実行
#define		FIFO_DONE		0x80			// FIFO 実行中ビット
/***************************************************************************/
/* PCIアドレス定義                                                         */
/***************************************************************************/
#define		FIFO_GO_ADDR		0x00			// FIFO 実行アドレス
#define		FIFO_RESULT_ADDR	0x00			// FIFO 結果情報
#define		I2C_RESULT_ADDR		0x08			// I2C処理結果
#define		FIFO_ADDR			0x10			// FIFOに書くアドレス
#define		DMA_ADDR			0x14			// DMA設定に書くアドレス
#define		TS_TEST_ENABLE_ADDR	0x08			//
#define     CFG_REGS_ADDR       0x04

/***************************************************************************/
/* DMAエラー定義                                                           */
/***************************************************************************/
#define		MICROPACKET_ERROR		1			// Micro Packetエラー
#define		BIT_RAM_OVERFLOW		(1 << 3)	//
#define		BIT_INITIATOR_ERROR		(1 << 4)	//
#define		BIT_INITIATOR_WARNING	(1 << 5)	//
#endif
// import from pt1_pci.h : end

// import from pt1_i2c.h : start
#ifndef		__PT1_I2C_H__
#define		__PT1_I2C_H__
//#include <linux/mutex.h>
/***************************************************************************/
/* I2Cデータ位置定義                                                       */
/***************************************************************************/
#define		MAX_CHANNEL			4		// チャネル数

#define		FALSE		0
#define		TRUE		1

/***************************************************************************/
/* I2Cデータ位置定義                                                       */
/***************************************************************************/
#define		I2C_ADDRESS		10		// I2Cアドレス(10ビット)

#define		I2C_DATA_EN		10
#define		I2C_CLOCK		11
#define		I2C_WRIET_MODE	12		// I2C書き込み／読み込み
#define		I2C_BUSY		13
#define		I2C_DATA		18		// I2Cデータ(18ビット)
/***************************************************************************/
/* I2C定義                                                                 */
/***************************************************************************/
#define		WRITE_EN		1		// 書き込み
#define		READ_EN			0		// 読み込み
#define		DATA_EN			1		// データあり
#define		DATA_DIS		0		// データなし
#define		CLOCK_EN		1		// CLOCKあり
#define		CLOCK_DIS		0		// CLOCKなし
#define		BUSY_EN			1		// BUSYあり
#define		BUSY_DIS		0		// BUSYなし

/***************************************************************************/
/*                                                                         */
/***************************************************************************/
#define		PCI_LOCKED			1
#define		RAM_LOCKED			2
#define		RAM_SHIFT			4
/***************************************************************************/
/* ビット                                                                  */
/***************************************************************************/
#define		WRITE_PCI_RESET		(1 << 16)
#define		WRITE_PCI_RESET_	(1 << 24)
#define		WRITE_RAM_RESET		(1 << 17)
#define		WRITE_RAM_RESET_	(1 << 25)
#define		WRITE_RAM_ENABLE	(1 << 1)

#define		WRITE_PULSE			(1 << 3)
#define		I2C_READ_SYNC		(1 << 29)
#define		READ_DATA			(1 << 30)
#define		READ_UNLOCK			(1 << 31)

#define		XC3S_PCI_CLOCK		(512 / 4)
#define		XC3S_PCI_CLOCK_PT2  (166)
/***************************************************************************/
/* I2Cアドレス定義                                                         */
/***************************************************************************/
#define		T0_ISDB_S			0X1B		// チューナ0 ISDB-S
#define		T1_ISDB_S			0X19		// チューナ1 ISDB-S

#define		T0_ISDB_T			0X1A		// チューナ0 ISDB-T
#define		T1_ISDB_T			0X18		// チューナ1 ISDB-T

/***************************************************************************/
/* I2C書き込みデータ定義                                                   */
/***************************************************************************/
typedef	struct	_WBLOCK{
	__u8	addr ;			// I2Cデバイスアドレス
	__u32	count ;			// 転送個数
	__u8	value[16];		// 書き込み値
}WBLOCK;

/***************************************************************************/
/* 関数定義                                                                */
/***************************************************************************/
//extern	__u32	makei2c(void __iomem *, __u32, __u32, __u32, __u32, __u32, __u32);
//extern	int		xc3s_init(void __iomem *);
//extern	void	SetStream(void __iomem *, __u32, __u32);
//extern	void	blockwrite(void __iomem *, WBLOCK *);
//extern	void	i2c_write(void __iomem *, struct mutex *, WBLOCK *);
//extern	__u32	i2c_read(void __iomem *, struct mutex *, WBLOCK *, int);

#endif
// import from pt1_i2c.h : start

// import from pt1_tuner.h : start
#ifndef		__PT1_TUNER_H__
#define		__PT1_TUNER_H__
/***************************************************************************/
/* チューナ状態定義                                                        */
/***************************************************************************/
// SLEEPモード設定	
enum	{
	TYPE_SLEEP,
	TYPE_WAKEUP
};

// チューナパワーモード設定	
enum {
	BIT_TUNER,
	BIT_LNB_UP,
	BIT_LNB_DOWN,
	BIT_RESET,
    BIT_33A1,
    BIT_33A2,
    BIT_5A_,
    BIT_5A1,
    BIT_5A2
};

// LNBパワー設定
enum{
	LNB_OFF,						// LNB OFF
	LNB_11V,						// +11 V
	LNB_15V							// +15 V

};
enum{								// 電源／ハードウェアリセット
	TUNER_POWER_OFF,				// オフ／イネーブル
	TUNER_POWER_ON_RESET_ENABLE,	// オン／イネーブル
	TUNER_POWER_ON_RESET_DISABLE	// オン／ディセーブル
};
/***************************************************************************/
/* チューナ状態定義                                                        */
/***************************************************************************/
#define		MAX_BS_TS_ID		8			// TS-ID取得最大値
#define		MAX_ISDB_T_INFO		3			// 地デジ階層情報数
#define		MAX_ISDB_T_INFO_LEN		2			// 地デジ階層情報数
/***************************************************************************/
/* ISDB-S状態定義                                                         */
/***************************************************************************/
typedef struct  _ISDB_S_CH_TABLE{
	int		channel ;		// 入力チャンネル番号
	int		real_chno ;		// 実際のテーブル番号
	int		slotno ;		// スロット番号
}ISDB_S_CH_TABLE ;

/***************************************************************************/
/* ISDB-S状態定義                                                         */
/***************************************************************************/
typedef	struct	_ISDB_S_TS_ID{
	__u16	ts_id ;			// TS-ID
	__u16	dmy ;			// PAD
	__u8	low_mode ;		// 低階層 モード
	__u8	low_slot ;		// 低階層 スロット数
	__u8	high_mode ;		// 高階層 モード
	__u8	high_slot ;		// 高階層 スロット数
}ISDB_S_TS_ID;
typedef	struct	_ISDB_S_TMCC{
	ISDB_S_TS_ID	ts_id[MAX_BS_TS_ID];	// 相対TS番号nに対するTS ID情報
#if 0
	__u32	indicator;				// 変更指示 (5ビット)
	__u32	emergency;				// 起動制御信号 (1ビット)
	__u32	uplink;					// アップリンク制御情報 (4ビット)
	__u32	ext;					// 拡張フラグ (1ビット)
	__u32	extdata[2];				// 拡張領域 (61ビット)
#endif
	__u32	agc ;					// AGC
	__u32	clockmargin ;			// クロック周波数誤差
	__u32	carriermargin ;			// キャリア周波数誤差
}ISDB_S_TMCC;

// 階層情報
typedef	struct	_ISDB_T_INFO{
	__u32	mode;				// キャリア変調方式 (3ビット)
	__u32	rate;				// 畳込み符号化率 (3ビット)
	__u32	interleave;			// インターリーブ長 (3ビット)
	__u32	segment; 			// セグメント数 (4ビット)
}ISDB_T_INFO;

typedef	struct	_ISDB_T_TMCC {
#if 0
	__u32	sysid;		// システム識別 (2ビット)
	__u32	indicator;	// 伝送パラメータ切り替え指標 (4ビット)
	__u32	emergency;	// 緊急警報放送用起動フラグ (1ビット)
#endif
	ISDB_T_INFO	info[MAX_ISDB_T_INFO];
#if 0
						// カレント情報
	__u32	partial;	// 部分受信フラグ (1ビット)
	__u32	Phase;		// 連結送信位相補正量 (3ビット)
	__u32	Reserved;	// リザーブ (12ビット)
#endif
	__u32	cn[2] ;					// CN
	__u32	agc ;					// AGC
	__u32	clockmargin ;			// クロック周波数誤差
	__u32	carriermargin ;			// キャリア周波数誤差
}ISDB_T_TMCC;
/***************************************************************************/
/* チューナ状態定義                                                        */
/***************************************************************************/
//extern	void	settuner_reset(void __iomem *, __u32, __u32);
//extern	int		tuner_init(void __iomem *, struct mutex *, int);
//extern	void	set_sleepmode(void __iomem *, struct mutex *, int, int, int);

//extern	int		bs_tune(void __iomem *, struct mutex *, int, int, ISDB_S_TMCC *);
//extern  int     ts_lock(void __iomem *, struct mutex *, int, __u16);

//extern	int		isdb_t_tune(void __iomem *, struct mutex *, int, int, ISDB_T_TMCC *);
//extern	int		isdb_t_frequency(void __iomem *, struct mutex *, int, int, int);
//extern	int		isdb_s_read_signal_strength(void __iomem *, struct mutex *, int);
WBLOCK	isdb_t_signal1 = {
	0,
	1,
	{0x8C}
};
WBLOCK	isdb_t_signal2 = {
	0,
	1,
	{0x8D}
};

typedef	struct	_TUNER_INFO{
	int		isdb_s ;
	int		isdb_t ;
}TUNER_INFO;

TUNER_INFO	tuner_info[2] = {
	{T0_ISDB_S, T0_ISDB_T},
	{T1_ISDB_S, T1_ISDB_T}
};

//extern	int		isdb_t_read_signal_strength(void __iomem *, struct mutex *, int);

#endif
// import from pt1_tuner.h : end

// import from pt1_tuner_data.h : start
#ifndef		__PT1_TUNER_DATA_H__
#define		__PT1_TUNER_DATA_H__
/***************************************************************************/
/*                                                                         */
/***************************************************************************/
#define     PT1_MAX_ISDB_S_INIT         19          // ISDB-S 初期化データ数
#define     PT2_MAX_ISDB_S_INIT         18          // ISDB-S 初期化データ数
#define     PT1_MAX_ISDB_T_INIT         16          // ISDB-S 初期化データ数
#define     PT2_MAX_ISDB_T_INIT         12          // ISDB-S 初期化データ数
#define     MAX_BS_CHANNEL              36          // 周波数テーブル数
#define     MAX_ISDB_T_CHANNEL          113         // 周波数テーブル数(地デジタル)
#define     MAX_BS_CHANNEL_PLL_COMMAND  3           // PLLロックするためのコマンド数
/***************************************************************************/
/*                                                                         */
/***************************************************************************/

/***************************************************************************/
/*                                                                         */
/***************************************************************************/
typedef	struct	_WBLOCK_BS_PLL{
	WBLOCK	*wblock[MAX_BS_CHANNEL_PLL_COMMAND] ;
}WBLOCK_BS_PLL;

/***************************************************************************/
/*                                                                         */
/***************************************************************************/
//extern	WBLOCK	com_initdata;		//初期化(共通)
//extern	WBLOCK	isdb_s_init1;		//ISDB-S先頭
//extern	WBLOCK	isdb_s_init21;		//ISDB-S最終
//extern	WBLOCK	isdb_t_init17;		//ISDB-T最終
//extern	WBLOCK	bs_pll_lock;		//ISDB-S PLLロック確認
/***************************************************************************/
/* ＢＳ周波数ロックチェック                                                */
/***************************************************************************/
WBLOCK	bs_pll_lock = {
	0,
	2,
	{0xFE, 0xC1}
};

//extern	WBLOCK	*isdb_s_initial[MAX_ISDB_S_INIT];
//extern	WBLOCK	*isdb_t_initial[MAX_ISDB_T_INIT];

/***************************************************************************/
/* BS用データ定義                                                          */
/***************************************************************************/

/***************************************************************************/
/* BS共通テーブル                                                          */
/***************************************************************************/
WBLOCK	bs_com_step2 = {
	0,
	3,
	{0xFE, 0xC0, 0xE4}
};
/***************************************************************************/
/* BS-1                                                                    */
/***************************************************************************/
WBLOCK	bs_1_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x48, 0x29, 0xE0, 0xD2}
};
WBLOCK	bs_1_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xD6}
};
/***************************************************************************/
/* BS-3                                                                    */
/***************************************************************************/
WBLOCK	bs_3_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0x40, 0xE0, 0xE2}
};
WBLOCK	bs_3_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xE6}
};
/***************************************************************************/
/* BS-5                                                                    */
/***************************************************************************/
WBLOCK	bs_5_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0x66, 0xE0, 0xE2}
};
WBLOCK	bs_5_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xE6}
};
/***************************************************************************/
/* BS-7                                                                    */
/***************************************************************************/
WBLOCK	bs_7_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0x8D, 0xE0, 0x20}
};
WBLOCK	bs_7_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-9                                                                    */
/***************************************************************************/
WBLOCK	bs_9_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0xB3, 0xE0, 0x20}
};
WBLOCK	bs_9_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-11                                                                   */
/***************************************************************************/
WBLOCK	bs_11_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0xD9, 0xE0, 0x20}
};
WBLOCK	bs_11_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-13                                                                   */
/***************************************************************************/
WBLOCK	bs_13_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x00, 0xE0, 0x20}
};
WBLOCK	bs_13_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-15                                                                   */
/***************************************************************************/
WBLOCK	bs_15_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x26, 0xE0, 0x40}
};
WBLOCK	bs_15_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x44}
};
/***************************************************************************/
/* BS-17                                                                   */
/***************************************************************************/
WBLOCK	bs_17_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x73, 0xE0, 0x40}
};
WBLOCK	bs_17_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0X44}
};
/***************************************************************************/
/* BS-19                                                                   */
/***************************************************************************/
WBLOCK	bs_19_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x73, 0xE0, 0x40}
};
WBLOCK	bs_19_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x44}
};
/***************************************************************************/
/* BS-21                                                                   */
/***************************************************************************/
WBLOCK	bs_21_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x99, 0xE0, 0x40}
};
WBLOCK	bs_21_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x44}
};
/***************************************************************************/
/* BS-23                                                                   */
/***************************************************************************/
WBLOCK	bs_23_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0xBF, 0xE0, 0x60}
};
WBLOCK	bs_23_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x64}
};

/***************************************************************************/
/* ND 2                                                                    */
/***************************************************************************/
WBLOCK	nd_2_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x46, 0x4D, 0xE0, 0x60}
};
WBLOCK	nd_2_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x64}
};

/***************************************************************************/
/* ND 4                                                                    */
/***************************************************************************/
WBLOCK	nd_4_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x46, 0x75, 0xE0, 0x80}
};
WBLOCK	nd_4_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x84}
};

/***************************************************************************/
/* ND 6                                                                    */
/***************************************************************************/
WBLOCK	nd_6_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x46, 0x9D, 0xE0, 0x80}
};
WBLOCK	nd_6_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x84}
};

/***************************************************************************/
/* ND 8                                                                    */
/***************************************************************************/
WBLOCK	nd_8_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x46, 0xC5, 0xE0, 0x80}
};
WBLOCK	nd_8_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x84}
};

/***************************************************************************/
/* ND 10                                                                   */
/***************************************************************************/
WBLOCK	nd_10_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x46, 0xED, 0xE0, 0x80}
};
WBLOCK	nd_10_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x84}
};

/***************************************************************************/
/* ND 12                                                                   */
/***************************************************************************/
WBLOCK	nd_12_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0x15, 0xE0, 0xA0}
};
WBLOCK	nd_12_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xA4}
};

/***************************************************************************/
/* ND 14                                                                   */
/***************************************************************************/
WBLOCK	nd_14_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0x3D, 0xE0, 0xA0}
};
WBLOCK	nd_14_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xA4}
};

/***************************************************************************/
/* ND 16                                                                   */
/***************************************************************************/
WBLOCK	nd_16_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0x65, 0xE0, 0xA0}
};
WBLOCK	nd_16_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xA4}
};

/***************************************************************************/
/* ND 18                                                                   */
/***************************************************************************/
WBLOCK	nd_18_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0x8D, 0xE0, 0xA0}
};
WBLOCK	nd_18_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xA4}
};

/***************************************************************************/
/* ND 20                                                                   */
/***************************************************************************/
WBLOCK	nd_20_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0xB5, 0xE0, 0xC0}
};
WBLOCK	nd_20_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xC4}
};

/***************************************************************************/
/* ND 22                                                                   */
/***************************************************************************/
WBLOCK	nd_22_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0xDD, 0xE0, 0xC0}
};
WBLOCK	nd_22_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xC4}
};

/***************************************************************************/
/* ND 24                                                                   */
/***************************************************************************/
WBLOCK	nd_24_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x48, 0x05, 0xE0, 0xC0}
};
WBLOCK	nd_24_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xC4}
};

/***************************************************************************/
/* ND 1                                                                    */
/***************************************************************************/
WBLOCK	nd_1_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x46, 0x39, 0xE0, 0x60}
};
WBLOCK	nd_1_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x64}
};

/***************************************************************************/
/* ND 3                                                                    */
/***************************************************************************/
WBLOCK	nd_3_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x46, 0x61, 0xE0, 0x80}
};
WBLOCK	nd_3_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x84}
};

/***************************************************************************/
/* ND 5                                                                    */
/***************************************************************************/
WBLOCK	nd_5_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x46, 0x89, 0xE0, 0x80}
};
WBLOCK	nd_5_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x84}
};

/***************************************************************************/
/* ND 7                                                                    */
/***************************************************************************/
WBLOCK	nd_7_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x46, 0xB1, 0xE0, 0x80}
};
WBLOCK	nd_7_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x84}
};

/***************************************************************************/
/* ND 9                                                                    */
/***************************************************************************/
WBLOCK	nd_9_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x46, 0xD9, 0xE0, 0x80}
};
WBLOCK	nd_9_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x84}
};

/***************************************************************************/
/* ND 11                                                                   */
/***************************************************************************/
WBLOCK	nd_11_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0x01, 0xE0, 0xA0}
};
WBLOCK	nd_11_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xA4}
};

/***************************************************************************/
/* ND 13                                                                   */
/***************************************************************************/
WBLOCK	nd_13_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0x29, 0xE0, 0xA0}
};
WBLOCK	nd_13_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xA4}
};

/***************************************************************************/
/* ND 15                                                                   */
/***************************************************************************/
WBLOCK	nd_15_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0x51, 0xE0, 0xA0}
};
WBLOCK	nd_15_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xA4}
};

/***************************************************************************/
/* ND 17                                                                   */
/***************************************************************************/
WBLOCK	nd_17_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0x79, 0xE0, 0xA0}
};
WBLOCK	nd_17_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xA4}
};

/***************************************************************************/
/* ND 19                                                                   */
/***************************************************************************/
WBLOCK	nd_19_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0xA1, 0xE0, 0xA0}
};
WBLOCK	nd_19_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xA4}
};

/***************************************************************************/
/* ND 21                                                                   */
/***************************************************************************/
WBLOCK	nd_21_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0xC9, 0xE0, 0xC0}
};
WBLOCK	nd_21_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xC4}
};

/***************************************************************************/
/* ND 23                                                                   */
/***************************************************************************/
WBLOCK	nd_23_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x47, 0xF1, 0xE0, 0xC0}
};
WBLOCK	nd_23_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xC4}
};


//extern	WBLOCK_BS_PLL	bs_pll[MAX_BS_CHANNEL] ;	// 周波数テーブル
/***************************************************************************/
/* BS-周波数テーブル                                                       */
/***************************************************************************/
WBLOCK_BS_PLL	bs_pll[MAX_BS_CHANNEL] = {
	{&bs_1_step1, &bs_com_step2, &bs_1_step3},
	{&bs_3_step1, &bs_com_step2, &bs_3_step3},
	{&bs_5_step1, &bs_com_step2, &bs_5_step3},
	{&bs_7_step1, &bs_com_step2, &bs_7_step3},
	{&bs_9_step1, &bs_com_step2, &bs_9_step3},
	{&bs_11_step1, &bs_com_step2, &bs_11_step3},
	{&bs_13_step1, &bs_com_step2, &bs_13_step3},
	{&bs_15_step1, &bs_com_step2, &bs_15_step3},
	{&bs_17_step1, &bs_com_step2, &bs_17_step3},
	{&bs_19_step1, &bs_com_step2, &bs_19_step3},
	{&bs_21_step1, &bs_com_step2, &bs_21_step3},
	{&bs_23_step1, &bs_com_step2, &bs_21_step3},
	{&nd_2_step1, &bs_com_step2, &nd_2_step3},
	{&nd_4_step1, &bs_com_step2, &nd_4_step3},
	{&nd_6_step1, &bs_com_step2, &nd_6_step3},
	{&nd_8_step1, &bs_com_step2, &nd_8_step3},
	{&nd_10_step1, &bs_com_step2, &nd_10_step3},
	{&nd_12_step1, &bs_com_step2, &nd_12_step3},
	{&nd_14_step1, &bs_com_step2, &nd_14_step3},
	{&nd_16_step1, &bs_com_step2, &nd_16_step3},
	{&nd_18_step1, &bs_com_step2, &nd_18_step3},
	{&nd_20_step1, &bs_com_step2, &nd_20_step3},
	{&nd_22_step1, &bs_com_step2, &nd_22_step3},
	{&nd_24_step1, &bs_com_step2, &nd_24_step3},
	{&nd_1_step1, &bs_com_step2, &nd_1_step3},
	{&nd_3_step1, &bs_com_step2, &nd_3_step3},
	{&nd_5_step1, &bs_com_step2, &nd_5_step3},
	{&nd_7_step1, &bs_com_step2, &nd_7_step3},
	{&nd_9_step1, &bs_com_step2, &nd_9_step3},
	{&nd_11_step1, &bs_com_step2, &nd_11_step3},
	{&nd_13_step1, &bs_com_step2, &nd_13_step3},
	{&nd_15_step1, &bs_com_step2, &nd_15_step3},
	{&nd_17_step1, &bs_com_step2, &nd_17_step3},
	{&nd_19_step1, &bs_com_step2, &nd_19_step3},
	{&nd_21_step1, &bs_com_step2, &nd_21_step3},
	{&nd_23_step1, &bs_com_step2, &nd_23_step3}
};

/***************************************************************************/
/* TMCC取得                                                                */
/***************************************************************************/
WBLOCK	bs_get_slot_ts_id_1 = {
	0,
	1,
	{0xCE}
};
WBLOCK	bs_get_slot_ts_id_2 = {
	0,
	1,
	{0xD2}
};
WBLOCK	bs_get_slot_ts_id_3 = {
	0,
	1,
	{0xD6}
};
WBLOCK	bs_get_slot_ts_id_4 = {
	0,
	1,
	{0xDA}
};

//extern	WBLOCK	*bs_get_ts_id[(MAX_BS_TS_ID / 2)] ;	// TS-ID取得テーブル
WBLOCK	*bs_get_ts_id[(MAX_BS_TS_ID / 2)] = {
	&bs_get_slot_ts_id_1,
	&bs_get_slot_ts_id_2,
	&bs_get_slot_ts_id_3,
	&bs_get_slot_ts_id_4
};

//extern	WBLOCK	bs_tmcc_get_1;						// TMCC取得テーブル
//extern	WBLOCK	bs_tmcc_get_2;						// TMCC取得テーブル
/***************************************************************************/
/* TMCC取得                                                                */
/***************************************************************************/
WBLOCK	bs_tmcc_get_1 = {
	0,
	2,
	{0x03, 0x01}
};
WBLOCK	bs_tmcc_get_2 = {
	0,
	1,
	{0xC3}
};

//extern	WBLOCK	bs_get_ts_lock;
/***************************************************************************/
/* TS-ID取得                                                               */
/***************************************************************************/
WBLOCK	bs_get_ts_lock = {
	0,
	1,
	{0xE6}
};

//extern	WBLOCK	bs_set_ts_lock;
/***************************************************************************/
/* TS-IDロック                                                             */
/***************************************************************************/
WBLOCK	bs_set_ts_lock = {
	0,
	3,
	{0x8F, 0x00, 0x00}
};

//extern	WBLOCK	bs_get_slot;
/***************************************************************************/
/* スロット取得                                                            */
/***************************************************************************/
WBLOCK	bs_get_slot = {
	0,
	1,
	{0xE8}
};

//extern	WBLOCK	bs_get_clock;
/***************************************************************************/
/* クロック周波数誤差取得                                                  */
/***************************************************************************/
WBLOCK	bs_get_clock = {
	0,
	1,
	{0xBE}
};

//extern	WBLOCK	bs_get_carrir;
/***************************************************************************/
/* キャリア周波数誤差取得                                                  */
/***************************************************************************/
WBLOCK	bs_get_carrir = {
	0,
	1,
	{0xBB}
};

//extern	WBLOCK	bs_get_signal1;
//extern	WBLOCK	bs_get_signal2;
//extern	WBLOCK	bs_get_agc;
/***************************************************************************/
/* CN/AGC/MAXAGC取得                                                       */
/***************************************************************************/
WBLOCK	bs_get_signal1 = {
	0,
	1,
	{0xBC}
};
WBLOCK	bs_get_signal2 = {
	0,
	1,
	{0xBD}
};
WBLOCK	bs_get_agc = {
	0,
	1,
	{0xBA}
};

/***************************************************************************/
/* 地デジ用データ定義                                                      */
/***************************************************************************/
//extern	WBLOCK	isdb_t_pll_base;			// 地デジ用周波数テーブルbase
WBLOCK isdb_t_pll_base = {
	0,
	2,
	{0xFE, 0xC2, 0, 0, 0, 0, 0, 0}
};

//extern	WBLOCK	isdb_t_pll_lock;
WBLOCK	isdb_t_pll_lock = {
	0,
	2,
	{0xFE, 0xC3}
};

//extern	WBLOCK_BS_PLL	isdb_t_info[MAX_ISDB_T_INFO_LEN];
//extern	WBLOCK	isdb_t_check_tune;
WBLOCK	isdb_t_check_tune = {
	0,
	2,
	{0x01, 0x40}
};

//extern	WBLOCK	isdb_t_tune_read;
WBLOCK	isdb_t_tune_read = {
	0,
	1,
	{0x80}
};

//extern	WBLOCK	isdb_t_tmcc_read_1;
//extern	WBLOCK	isdb_t_tmcc_read_1;
//extern	WBLOCK	isdb_t_signal1;
//extern	WBLOCK	isdb_t_signal2;
//extern	WBLOCK	isdb_t_agc2;
WBLOCK	isdb_t_agc2 = {
	0,
	1,
	{0x82}
};

//extern	WBLOCK	isdb_t_get_clock;
WBLOCK	isdb_t_get_clock = {
	0,
	1,
	{0x86}
};
#if 0
WBLOCK	isdb_s_wake = {
	0,
	4,
	{0xFE, 0xC0, 0xF0, 0x04}
};
WBLOCK	isdb_s_sleep = {
	0,
	2,
	{0x17, 0x00}
};

WBLOCK	isdb_t_wake = {
	0,
	2,
	{0xFE, 0xC2}
};
WBLOCK	isdb_t_sleep = {
	0,
	2,
	{0x03, 0x80}
};
#else
/***************************************************************************/
/* 省電力テーブル                                                          */
/***************************************************************************/
/*
ISDB-S省電力
送信:7Bit Address Mode(1b):17:01

ISDB-S省電力OFF
送信:7Bit Address Mode(1b):fe:c0:e4:fe:c0:f4:d6
送信:7Bit Address Mode(1b):17:00
*/
WBLOCK  isdb_s_sleep = {
        0,
        2,
        {0x17, 0x00}
};
WBLOCK  isdb_s_wake = {
        0,
        7,
        {0xFE, 0xC0, 0xE4, 0xFE, 0xC0, 0xF4, 0xD6}
};
WBLOCK  isdb_s_wake2 = {
        0,
        2,
        {0x17, 0x01}
};

/*
ISDB-T省電力
送信:7Bit Address Mode(1a):03:90

ISDB-T省電力OFF
送信:7Bit Address Mode(1a):fe:c2:0e:7f:c1:84:80
送信:7Bit Address Mode(1a):03:80
*/
WBLOCK  isdb_t_sleep = {
        0,
        2,
        {0x03, 0x80}
};
WBLOCK  isdb_t_wake = {
        0,
        7,
        {0xFE, 0xC2, 0x0E, 0x7F, 0xC1, 0x84, 0x80}
};
WBLOCK  isdb_t_wake2 = {
        0,
        2,
        {0x03, 0x90}
};
#endif

/***************************************************************************/
/* 初期化データ定義(共通)                                                  */
/***************************************************************************/
WBLOCK	com_initdata = {
	0,
	2,
	{0x01, 0x80}
};
/***************************************************************************/
/* 初期化データ定義(ISDB-S)                                                */
/***************************************************************************/
// ISDB-S初期化値(PT2)１
WBLOCK  isdb_s_init_pt2_1 ={
        0,
        1,
        {0x0f}
};
// ISDB-S初期化値１
WBLOCK	isdb_s_init1 ={
	0,
	1,
	{0x07}
};
// ISDB-S初期化値２
WBLOCK	isdb_s_init2 ={
	0,
	2,
	{0x04, 0x02}
};

// ISDB-S初期化値３
WBLOCK	isdb_s_init3 ={
	0,
	2,
	{0x0D, 0x55}
};
// ISDB-S初期化値４
WBLOCK	isdb_s_init4 ={
	0,
	2,
	{0x11, 0x40}
};
// ISDB-S初期化値５
WBLOCK	isdb_s_init5 ={
	0,
	2,
	{0x13, 0x80}
};
// ISDB-S初期化値６
WBLOCK	isdb_s_init6 ={
	0,
	2,
	{0x17, 0x01}
};
// ISDB-S初期化値７
WBLOCK	isdb_s_init7 ={
	0,
	2,
	{0x1C, 0x0A}
};
// ISDB-S初期化値８
WBLOCK	isdb_s_init8 ={
	0,
	2,
	{0x1D, 0xAA}
};
// ISDB-S初期化値９
WBLOCK	isdb_s_init9 ={
	0,
	2,
	{0x1E, 0x20}
};
// ISDB-S初期化値１０
WBLOCK	isdb_s_init10 ={
	0,
	2,
	{0x1F, 0x88}
};
// ISDB-S初期化値１１
WBLOCK	isdb_s_init11 ={
	0,
	2,
	{0x51, 0xB0}
};
// ISDB-S初期化値１２
WBLOCK	isdb_s_init12 ={
	0,
	2,
	{0x52, 0x89}
};
// ISDB-S初期化値１３
WBLOCK	isdb_s_init13 ={
	0,
	2,
	{0x53, 0xB3}
};
// ISDB-S初期化値１４
WBLOCK	isdb_s_init14 ={
	0,
	2,
	{0x5A, 0x2D}
};
// ISDB-S初期化値１５
WBLOCK	isdb_s_init15 ={
	0,
	2,
	{0x5B, 0xD3}
};
// ISDB-S初期化値１６
WBLOCK	isdb_s_init16 ={
	0,
	2,
	{0x85, 0x69}
};
// ISDB-S初期化値１７
WBLOCK	isdb_s_init17 ={
	0,
	2,
	{0x87, 0x04}
};
// ISDB-S初期化値１８
WBLOCK	isdb_s_init18 ={
	0,
	2,
	{0x8E, 0x02}
};
// ISDB-S初期化値１９
WBLOCK	isdb_s_init19 ={
	0,
	2,
	{0xA3, 0xF7}
};
// ISDB-S初期化値２０
WBLOCK	isdb_s_init20 ={
	0,
	2,
	{0xA5, 0xC0}
};
// ISDB-S初期化値２１
WBLOCK	isdb_s_init21 ={
	0,
	4,
	{0xFE, 0xC0, 0xF0, 0x04}
};
/***************************************************************************/
/* 初期化データ定義(ISDB-T)                                                */
/***************************************************************************/
// ISDB-T初期化値１
WBLOCK	isdb_t_init1 ={
	0,
	2,
	{0x03, 0x90}
};
// ISDB-T初期化値２
WBLOCK	isdb_t_init2 ={
	0,
	2,
	{0x14, 0x8F}
};
// ISDB-T初期化値３
WBLOCK	isdb_t_init3 ={
	0,
	2,
	{0x1C, 0x2A}
};
// ISDB-T初期化値４
WBLOCK	isdb_t_init4 ={
	0,
	2,
	{0x1D, 0xA8}
};
// ISDB-T初期化値５
WBLOCK	isdb_t_init5 ={
	0,
	2,
	{0x1E, 0xA2}
};
// ISDB-T初期化値６
WBLOCK	isdb_t_init6 ={
	0,
	2,
	{0x22, 0x83}
};
// ISDB-T初期化値７
WBLOCK	isdb_t_init7 ={
	0,
	2,
	{0x31, 0x0D}
};
// ISDB-T初期化値８
WBLOCK	isdb_t_init8 ={
	0,
	2,
	{0x32, 0xE0}
};
// ISDB-T初期化値９
WBLOCK	isdb_t_init9 ={
	0,
	2,
	{0x39, 0xD3}
};
// ISDB-T初期化値１０
WBLOCK	isdb_t_init10 ={
	0,
	2,
	{0x3A, 0x00}
};
// ISDB-T初期化値１１
WBLOCK	isdb_t_init11 ={
	0,
	2,
	{0x5C, 0x40}
};
// ISDB-T初期化値１２
WBLOCK	isdb_t_init12 ={
	0,
	2,
	{0x5F, 0x80}
};
// ISDB-T初期化値１３
WBLOCK	isdb_t_init13 ={
	0,
	2,
	{0x75, 0x02}
};
// ISDB-T初期化値１４
WBLOCK	isdb_t_init14 ={
	0,
	2,
	{0x76, 0x4E}
};
// ISDB-T初期化値１５
WBLOCK	isdb_t_init15 ={
	0,
	2,
	{0x77, 0x03}
};
// ISDB-T初期化値１６
WBLOCK	isdb_t_init16 ={
	0,
	2,
	{0xEF, 0x01}
};
// ISDB-T初期化値１７
WBLOCK	isdb_t_init17 ={
	0,
	7,
	{0xFE, 0xC2, 0x01, 0x8F, 0xC1, 0x80, 0x80}
};

/***************************************************************************/
/* 初期化データブロック定義(ISDB-S)                                        */
/***************************************************************************/
WBLOCK	*isdb_s_initial_pt1[PT1_MAX_ISDB_S_INIT] =
{
	&isdb_s_init2, &isdb_s_init3, &isdb_s_init4, &isdb_s_init5,
	&isdb_s_init6, &isdb_s_init7, &isdb_s_init8, &isdb_s_init9,
	&isdb_s_init10, &isdb_s_init11, &isdb_s_init12, &isdb_s_init13,
	&isdb_s_init14, &isdb_s_init15, &isdb_s_init16, &isdb_s_init17,
	&isdb_s_init18, &isdb_s_init19, &isdb_s_init20
};
WBLOCK  *isdb_s_initial_pt2[PT2_MAX_ISDB_S_INIT] =
{
    &isdb_s_init2, &isdb_s_init4, &isdb_s_init5,
    &isdb_s_init6, &isdb_s_init7, &isdb_s_init8, &isdb_s_init9,
    &isdb_s_init10, &isdb_s_init11, &isdb_s_init12, &isdb_s_init13,
    &isdb_s_init14, &isdb_s_init15, &isdb_s_init16, &isdb_s_init17,
    &isdb_s_init18, &isdb_s_init19, &isdb_s_init20
};
    
/***************************************************************************/
/* 初期化データブロック定義(ISDB-T)                                        */
/***************************************************************************/
WBLOCK	*isdb_t_initial_pt1[PT1_MAX_ISDB_T_INIT] =
{
	&isdb_t_init1, &isdb_t_init2, &isdb_t_init3, &isdb_t_init4,
	&isdb_t_init5, &isdb_t_init6, &isdb_t_init7, &isdb_t_init8,
	&isdb_t_init9, &isdb_t_init10, &isdb_t_init11, &isdb_t_init12,
	&isdb_t_init13, &isdb_t_init14, &isdb_t_init15, &isdb_t_init16
};
WBLOCK  *isdb_t_initial_pt2[PT2_MAX_ISDB_T_INIT] =
{
    &isdb_t_init1, &isdb_t_init3, &isdb_t_init4,
    &isdb_t_init5, &isdb_t_init6,
    &isdb_t_init10, &isdb_t_init11, &isdb_t_init12,
    &isdb_t_init13, &isdb_t_init14, &isdb_t_init15, &isdb_t_init16
};


//extern	WBLOCK	isdb_t_get_carrir;


void writel(__u32 val, void __iomem *reg)
{
    if (reg)
    {
        *(__u32 *)reg = val;
    }
}

__u32 readl(void __iomem *reg)
{
    __u32 ret = 0xffffffff;
    if (reg)
    {
        ret = *(__u32 *)reg;
    }
    return ret;
}

void schedule_timeout_interruptible(__u32 msec)
{
//    IOLog("%s()\n", __FUNCTION__);
    IOSleep(msec);
}

__u32 msecs_to_jiffies(__u32 msec)
{
//    IOLog("%s()\n", __FUNCTION__);
    return msec;
}


#define		PROGRAM_ADDRESS		1024
static	int		state = STATE_STOP ;


// PCIに書き込むI2Cデータ生成
void	makei2c(void __iomem *regs, __u32 base_addr, __u32 i2caddr, __u32 writemode, __u32 data_en, __u32 clock, __u32 busy)
{

	__u32		val ;
	val =  ((base_addr << I2C_DATA) | (writemode << I2C_WRIET_MODE) |
			( data_en << I2C_DATA_EN) | 
			(clock << I2C_CLOCK) | (busy << I2C_BUSY) | i2caddr) ;
	writel(val, (char *)regs + FIFO_ADDR);
}

static	void begin_i2c(void __iomem *regs, __u32 *address, __u32 *clock)
{
	// bus FREE
	makei2c(regs, *address, *address, 0, 0, 0, 0);
	*address += 1 ;

	//  bus busy
	makei2c(regs, *address, *address + 1, 0, 0, 0, 1);
	*address += 1 ;
	*clock = FALSE ;
}

static	void	start_i2c(void __iomem *regs, __u32 *address, __u32 *clock, __u32 data)
{
	// データが残っていなければデータを下げる
	if(!data){
		// CLOCKがあればCLOCKを下げる
		if(*clock != TRUE){
			*clock = TRUE ;
			makei2c(regs, *address, *address + 1, 0, 1, 1, 1);
			*address += 1 ;
		}
		makei2c(regs, *address, *address + 1, 0, 0, 1, 1);
		*address += 1 ;
	}

	if(*clock != FALSE){
		*clock = FALSE ;
		makei2c(regs, *address, *address + 1, 0, 0, 0, 1);
		*address += 1;
	}
	makei2c(regs, *address, *address + 1, 0, 1, 0, 1);
	*address += 1;
	*clock = FALSE ;
}

static	void	stop_i2c(void __iomem *regs, __u32 *address, __u32 *clock, __u32 data, __u32 end)
{
	// データが残っていて
	if(data){
		// クロックがあれば
		if(*clock != TRUE){
			*clock = TRUE ;
			makei2c(regs, *address, *address + 1, 0, 0, 1, 1);
			*address += 1;
		}
		makei2c(regs, *address, *address + 1, 0, 1, 1, 1);
		*address += 1 ;
	}
	// クロックが落ちていれば
	if(*clock){
		*clock = FALSE ;
		makei2c(regs, *address, *address + 1, 0, 1, 0, 1);
		*address += 1 ;
	}

	if(end){
		makei2c(regs, *address, 0, 0, 0, 0, 1);
	}else{
		makei2c(regs, *address, *address + 1, 0, 0, 0, 1);
		*address += 1 ;
	}
}

static	void	writebits(void __iomem *regs, __u32 *address, __u32 old_bits, __u32 bits)
{
	// CLOCK UP
	makei2c(regs, *address, *address + 1, 0, (old_bits ^ 1), 1, 1);
	*address += 1 ;

	// CLOCK UP
	makei2c(regs, *address, *address + 1, 0, (bits ^ 1), 1, 1);
	*address += 1 ;

	// CLOCK DOWN
	makei2c(regs, *address, *address + 1, 0, (bits ^ 1), 0, 1);
	*address += 1 ;

}

static	int		i2c_lock(void __iomem *regs, __u32 firstval, __u32  secondval, __u32 lockval)
{

	__u32	val ;
	int		lp ;

	writel(firstval, regs);
	writel(secondval, regs);

	// RAMがロックされた？
	for(lp = 0 ; lp < XC3S_PCI_CLOCK ; lp++){
		val = readl(regs);
		if((val & lockval)){
			return 0 ;
		}
		schedule_timeout_interruptible(msecs_to_jiffies(1));
	}
	return -1;//EIO ;
}

static	int		i2c_lock_one(void __iomem *regs, __u32 firstval, __u32 lockval)
{

	__u32	val ;
	__u32	val2 ;
	int		lp ;

	val = (readl(regs) & lockval);
	writel(firstval, regs);

	// RAMがロックされた？
	for(lp = 0 ; lp < 10 ; lp++){
		for(lp = 0 ; lp < 1024 ; lp++){
			val2 = readl(regs);
			// 最初に取得したデータと逆になればOK
			if(((val2 & lockval) != val)){
				return 0 ;
			}
		}
		schedule_timeout_interruptible(msecs_to_jiffies(1));
	}
//	printk(KERN_INFO "PT1:Lock Fault(%x:%x)\n", val, val2);
	return -1;//EIO ;
}
static	int		i2c_unlock(void __iomem *regs, int lockval)
{
	int		lp ;
	__u32	val ;

	writel(WRITE_PULSE, regs);

	for(lp = 0 ; lp < 3 ; lp++){
		val = readl(regs);
		if((val &lockval)){
			return 0 ;
		}
		schedule_timeout_interruptible(msecs_to_jiffies(1));
	}
	return -1;//EIO ;
}

//
//
//BIT 0. 1 : Tuner番号 (Enable/Disable)
//BIT 8. 9 : Tuner番号
//
//
void	SetStream(void __iomem *regs, __u32 channel, __u32 enable)
{
	__u32	val ;

	val = (1 << (8 + channel));
	if(enable){
		val |= (1 << channel);
	}
	writel(val, (char *)regs + TS_TEST_ENABLE_ADDR);
}


int		xc3s_init(void __iomem *regs, uint16_t deviceID)
{

	__u32	val ;
	int		lp ;
	int		rc ;
    int     phase = XC3S_PCI_CLOCK;

/*
	val = (1 << 19) | (1 << 27) | (1 << 16) | (1 << 24) | (1 << 17) | (1 << 25);
	writel(WRITE_PULSE, regs);
BIT 19, 19+8 ON
BIT 16, 16+8 ON
BIT 17, 17+8 ON
 */
	// XC3S初期化
	for(lp = 0 ; lp < PROGRAM_ADDRESS ; lp++){
		makei2c(regs, lp, 0, READ_EN, DATA_DIS, CLOCK_DIS, BUSY_DIS);
	}   
	// XC3S 初期化待ち (512 PCI Clocks)
	for(lp = 0 ; lp <  XC3S_PCI_CLOCK ; lp++){
		makei2c(regs, 0, 0, READ_EN, DATA_DIS, CLOCK_DIS, BUSY_DIS);
	}
	// プロテクト解除
	// これは何を意図しているんだろう？
	// 元コードが良く判らない
	for(lp = 0 ; lp < 57 ; lp++){
		val = readl(regs);
		if(val & I2C_READ_SYNC){
			break ;
		}
		writel(WRITE_PULSE, regs);
	}

	for(lp = 0 ; lp < 57 ; lp++){
		val = readl(regs);
		if(val & READ_DATA){
			break ;
		}
		writel(WRITE_PULSE, regs);
	}

	// UNLOCK
	rc = i2c_unlock(regs, READ_UNLOCK);
	if(rc < 0){
		return rc ;
	}

	// Enable PCI
	rc =i2c_lock(regs, (WRITE_PCI_RESET | WRITE_PCI_RESET_), WRITE_PCI_RESET_, PCI_LOCKED);
	if(rc < 0){
		return -1;//EIO ;
	}

	// Enable RAM
	rc =i2c_lock(regs, (WRITE_RAM_RESET | WRITE_RAM_RESET_), WRITE_RAM_RESET_, RAM_LOCKED);
	if(rc){
		return -1;//EIO ;
	}
    switch (deviceID)
    {
    case PCI_PT1_ID:
        phase = XC3S_PCI_CLOCK;
        break;
    case PCI_PT2_ID:
        phase = XC3S_PCI_CLOCK_PT2;
        break;
    default:
        return -1;
    }
	for(lp = 0 ; lp < phase; lp++){
		rc = i2c_lock_one(regs, WRITE_RAM_ENABLE, RAM_SHIFT);
		if(rc < 0){
//			printk(KERN_ERR "PT1:LOCK FALUT\n");
			return rc ;
		}
	}

	// ストリームごとの転送制御(OFF)
	for(lp = 0 ; lp < MAX_CHANNEL ; lp++){
		SetStream(regs, lp, 0);
		SetStream(regs, lp, 0);
	}
	return 0 ;
}


void	blockwrite(void __iomem *regs, WBLOCK *wblock)
{
	int		lp ;
	int		bitpos ;
	__u32	bits ;
	__u32	old_bits = 1 ;
	__u32	address = 0;
	__u32	clock = 0;

	begin_i2c(regs, &address, &clock);
	if(state == STATE_STOP){
		start_i2c(regs, &address, &clock, old_bits);
		old_bits = 0 ;
		stop_i2c(regs, &address, &clock, old_bits, FALSE);
		state = STATE_START ;
	}
	old_bits = 1 ;
	start_i2c(regs, &address, &clock, old_bits);
	old_bits = 0 ;

	// まずアドレスを書く
	for(bitpos = 0 ; bitpos < 7 ; bitpos++){
		bits  = ((wblock->addr >> (6 - bitpos)) & 1);
		writebits(regs, &address, old_bits, bits);
		old_bits = bits ;
	}
	// タイプ：WRT
	writebits(regs, &address, old_bits, 0);
	// ACK/NACK用(必ず1)
	writebits(regs, &address, 0, 1);

	old_bits = 1 ;
	// 実際のデータを書く
	for (lp = 0 ; lp < wblock->count ; lp++){
		for(bitpos = 0 ; bitpos < 8 ; bitpos++){
			bits  = ((wblock->value[lp] >> (7 - bitpos)) & 1);
			writebits(regs, &address, old_bits, bits);
			old_bits = bits ;
		}
		// ACK/NACK用(必ず1)
		writebits(regs, &address, old_bits, 1);
		old_bits = 1 ;
	}

	// Clock negedge
	makei2c(regs, address, address + 1, 0, (old_bits ^ 1), 1, 1);
	clock = TRUE ;
	address += 1 ;
	stop_i2c(regs, &address, &clock, old_bits, TRUE);

}

void	blockread(void __iomem *regs, WBLOCK *wblock, int count)
{
	int		lp ;
	int		bitpos ;
	__u32	bits ;
	__u32	old_bits = 1 ;
	__u32	address = 0;
	__u32	clock = 0;

	begin_i2c(regs, &address, &clock);
	if(state == STATE_STOP){
		start_i2c(regs, &address, &clock, old_bits);
		old_bits = 0 ;
		stop_i2c(regs, &address, &clock, old_bits, FALSE);
		state = STATE_START ;
	}
	old_bits = 1 ;
	start_i2c(regs, &address, &clock, old_bits);
	old_bits = 0 ;

	// まずアドレスを書く
	for(bitpos = 0 ; bitpos < 7 ; bitpos++){
		bits  = ((wblock->addr >> (6 - bitpos)) & 1);
		writebits(regs, &address, old_bits, bits);
		old_bits = bits ;
	}
	// タイプ：WRT
	writebits(regs, &address, old_bits, 0);
	// ACK/NACK用(必ず1)
	writebits(regs, &address, 0, 1);

	old_bits = 1 ;
	// 実際のデータを書く
	for (lp = 0 ; lp < wblock->count ; lp++){
		for(bitpos = 0 ; bitpos < 8 ; bitpos++){
			bits  = ((wblock->value[lp] >> (7 - bitpos)) & 1);
			writebits(regs, &address, old_bits, bits);
			old_bits = bits ;
		}
		// ACK/NACK用(必ず1)
		writebits(regs, &address, old_bits, 1);
		old_bits = 1 ;
	}

	// Clock negedge
	makei2c(regs, address, address + 1, 0, (old_bits ^ 1), 1, 1);
	clock = TRUE ;
	address += 1 ;

	// ここから Read 
	start_i2c(regs, &address, &clock, old_bits);
	old_bits = 0 ;
	// まずアドレスを書く
	for(bitpos = 0 ; bitpos < 7 ; bitpos++){
		bits  = ((wblock->addr >> (6 - bitpos)) & 1);
		writebits(regs, &address, old_bits, bits);
		old_bits = bits ;
	}
	// タイプ：RD
	writebits(regs, &address, old_bits, 1);
	// ACK/NACK用(必ず1)
	writebits(regs, &address, 1, 1);

	old_bits = 1 ;
	// 実際のデータを書く
	for (lp = 0 ; lp < count ; lp++){
		for(bitpos = 0 ; bitpos < 8 ; bitpos++){
			writebits(regs, &address, old_bits, 1);
			// Read Mode Set
			makei2c(regs, address, address + 1, 1, 0, 0, 1);
			address += 1 ;
			old_bits = 1 ;
		}
		if(lp >= (count - 1)){
			// ACK/NACK用(必ず1)
			writebits(regs, &address, old_bits, 1);
			old_bits = 0 ;
		}else{
			// ACK/NACK用(必ず1)
			writebits(regs, &address, old_bits, 0);
			old_bits = 1 ;
		}
	}

	// Clock negedge
	makei2c(regs, address, address + 1, 0, 0, 1, 1);
	clock = TRUE ;
	address += 1 ;
	old_bits = 1 ;
	stop_i2c(regs, &address, &clock, old_bits, TRUE);

}


void	i2c_write(void __iomem *regs, struct mutex *lock, WBLOCK *wblock)
{

	int		lp;
	__u32	val ;

	// ロックする
//	mutex_lock(lock);
#if 0
	printk(KERN_INFO "Addr=%x(%d)\n", wblock->addr, wblock->count);
	for(lp = 0 ; lp  < wblock->count ; lp++){
		printk(KERN_INFO "%x\n", wblock->value[lp]);
	}
	printk(KERN_INFO "\n");
#endif

	blockwrite(regs, wblock);
	writel(FIFO_GO, (char *)regs + FIFO_GO_ADDR);
	//とりあえずロックしないように。
	for(lp = 0 ; lp < 100 ; lp++){
		val = readl((char *)regs + FIFO_RESULT_ADDR);
		if(!(val & FIFO_DONE)){
			break ;
		}
		schedule_timeout_interruptible(msecs_to_jiffies(1));
	}
//	mutex_unlock(lock);
}

__u32	i2c_read(void __iomem *regs, struct mutex *lock, WBLOCK *wblock, int size)
{

	int		lp;
	__u32	val ;

	// ロックする
//	mutex_lock(lock);
#if 0
	printk(KERN_INFO "Addr=%x:%d:%d\n", wblock->addr, wblock->count, size);
	for(lp = 0 ; lp  < wblock->count ; lp++){
		printk(KERN_INFO "%x\n", wblock->value[lp]);
	}
	printk(KERN_INFO "\n");
#endif
	blockread(regs, wblock, size);

	writel(FIFO_GO, (char *)regs + FIFO_GO_ADDR);

	for(lp = 0 ; lp < 100 ; lp++){
		schedule_timeout_interruptible(msecs_to_jiffies(1));
		val = readl((char *)regs + FIFO_RESULT_ADDR);
		if(!(val & FIFO_DONE)){
			break ;
		}
	}

	val = readl((char *)regs + I2C_RESULT_ADDR);
//	mutex_unlock(lock);
	return val ;
}



/***************************************************************************/
/* 省電力用データ定義                                                      */
/***************************************************************************/
//extern	WBLOCK	isdb_s_wake;
//extern	WBLOCK	isdb_t_wake;

//extern	WBLOCK	isdb_s_sleep;
//extern	WBLOCK	isdb_t_sleep;

//extern	ISDB_S_CH_TABLE	isdb_t_table[11];

#endif
// import from pt1_tuner_data.h : end

//extern __u32 getfrequency_add(__u32 channel);
//extern __u32 getfrequency(__u32 channel, int addfreq);

typedef	struct	_isdb_t_freq_add_table{
	__u16		pos ;		// 追加するチャンネルポジション
	__u16		add_freq ;	// 追加する値
}isdb_t_freq_add_table;

isdb_t_freq_add_table	isdb_t_freq_add[10] = {
	{  7,  0x8081},				// 0〜7迄
	{ 12, 0x80A1},				// 8〜12迄
	{ 21, 0x8062},				// 13〜21迄
	{ 39, 0x80A2},				// 22〜39迄
	{ 51, 0x80E2},				// 40〜51迄
	{ 59, 0x8064},				// 52〜59迄
	{ 75, 0x8084},				// 60〜75迄
	{ 84, 0x80a4},				// 76〜84迄
	{100, 0x80C4},				// 85〜100迄
	{112, 0x80E4}				// 101〜112迄
};

__u32	getfrequency_add(__u32 channel)
{
	int		lp ;

	for(lp = 0 ; lp < 10 ; lp++){
		if(channel <= isdb_t_freq_add[lp].pos){
			return isdb_t_freq_add[lp].add_freq ;
		}
	}
	return 0 ;
}
__u32	getfrequency(__u32 channel, int addfreq)
{
	__u32	frequencyoffset = 0;
	__u32	frequencyOffset = 0;

	if (12 <= channel){
		frequencyoffset += 2;
	}else if (17 <= channel){
		frequencyoffset = 0;
	}else if (63 <= channel){
		frequencyoffset += 2;
	}
#if 0
	return (((93 + channel * 6 + frequencyOffset) + addfreq) * 7) + 400;
#endif
	frequencyOffset = 93 + channel * 6 + frequencyoffset;
	frequencyOffset = 7 * (frequencyOffset + addfreq);
	return frequencyOffset + 400;

}

static	int		init_isdb_s(void __iomem *regs, uint16_t deviceID, struct mutex *lock, __u32 addr)
{

	WBLOCK	wk;
	int		lp ;
	__u32	val ;

	// ISDB-S/T初期化
	memcpy(&wk, &com_initdata, sizeof(WBLOCK));

    if (deviceID == PCI_PT1_ID)
    {
        // 初期化１(なぜかREADなので)
        memcpy(&wk, &isdb_s_init1, sizeof(WBLOCK));
        wk.addr = addr;
        val = i2c_read(regs, lock, &wk, 1);

        if((val & 0xff) != 0x41){
//          printk(KERN_INFO "PT1:ISDB-S Read(%x)\n", val);
            return -1;//EIO ;
        }
        for(lp = 0 ; lp < PT1_MAX_ISDB_S_INIT ; lp++){
            memcpy(&wk, isdb_s_initial_pt1[lp], sizeof(WBLOCK));
            wk.addr = addr;
            i2c_write(regs, lock, &wk);
        }
    }
    else if (deviceID == PCI_PT2_ID)
    {
        // 初期化１(なぜかREADなので)
        memcpy(&wk, &isdb_s_init_pt2_1, sizeof(WBLOCK));
        wk.addr = addr;
        val = i2c_read(regs, lock, &wk, 1);

        if ((val & 0xff) != 0x52)
        {
//            printk(KERN_INFO "PT2:ISDB-S Read(%x)\n", val);
            IOLog("PT1Device::init_isdb_s 0x%08x", (unsigned int)val);
            return -1;//-EIO ;
        }
        for(lp = 0 ; lp < PT2_MAX_ISDB_S_INIT ; lp++) {
            memcpy(&wk, isdb_s_initial_pt2[lp], sizeof(WBLOCK));
            wk.addr = addr;
            i2c_write(regs, lock, &wk);
        }
	}
	else
	{
		return -1;
	}

	return 0 ;
}
static	void	init_isdb_t(void __iomem *regs, uint16_t deviceID, struct mutex *lock, __u32 addr)
{
	int		lp ;
	WBLOCK	wk;

	// ISDB-S/T初期化
    if (deviceID == PCI_PT1_ID)
    {
        for(lp = 0 ; lp < PT1_MAX_ISDB_T_INIT ; lp++){
            memcpy(&wk, isdb_t_initial_pt1[lp], sizeof(WBLOCK));
            wk.addr = addr;
            i2c_write(regs, lock, &wk);
        }
    }
    else if (deviceID == PCI_PT2_ID)
    {
        for(lp = 0 ; lp < PT2_MAX_ISDB_T_INIT ; lp++){
            memcpy(&wk, isdb_t_initial_pt2[lp], sizeof(WBLOCK));
            wk.addr = addr;
            i2c_write(regs, lock, &wk);
        }
    }
}

int		tuner_init(void __iomem *regs, uint16_t deviceID, struct mutex *lock, int tuner_no)
{

	int		rc ;
	WBLOCK	wk;

	// ISDB-S/T初期化
	memcpy(&wk, &com_initdata, sizeof(WBLOCK));

	// 初期化(共通)
	wk.addr = tuner_info[tuner_no].isdb_t ;
	i2c_write(regs, lock, &wk);
	wk.addr = tuner_info[tuner_no].isdb_s ;
	i2c_write(regs, lock, &wk);

	rc = init_isdb_s(regs, deviceID, lock, tuner_info[tuner_no].isdb_s);
	if(rc < 0){
		return rc ;
	}
	init_isdb_t(regs, deviceID, lock, tuner_info[tuner_no].isdb_t);

	memcpy(&wk, &isdb_s_init21, sizeof(WBLOCK));
	wk.addr = tuner_info[tuner_no].isdb_s ;
	i2c_write(regs, lock, &wk);

	memcpy(&wk, &isdb_t_init17, sizeof(WBLOCK));
	wk.addr = tuner_info[tuner_no].isdb_t ;
	i2c_write(regs, lock, &wk);

	return 0 ;
}

void	set_sleepmode(void __iomem *regs, struct mutex *lock, int address, int tuner_type, int type)
{
	WBLOCK	wk;
#if 0
	if(type == TYPE_WAKEUP){
		switch(tuner_type){
			case CHANNEL_TYPE_ISDB_S:memcpy(&wk, &isdb_s_wake, sizeof(WBLOCK));break ;
			case CHANNEL_TYPE_ISDB_T:memcpy(&wk, &isdb_t_wake, sizeof(WBLOCK));break ;
		}
		wk.addr = address ;
		i2c_write(regs, lock, &wk);
	}
	switch(tuner_type){
		case CHANNEL_TYPE_ISDB_S:
//			printk(KERN_INFO "PT1:ISDB-S Sleep\n");
			memcpy(&wk, &isdb_s_sleep, sizeof(WBLOCK));
			if(type == TYPE_WAKEUP){
				wk.value[1] = 0x01 ;
			}
			break ;
		case CHANNEL_TYPE_ISDB_T:
//			printk(KERN_INFO "PT1:ISDB-T Sleep\n");
			memcpy(&wk, &isdb_t_sleep, sizeof(WBLOCK));
			if(type == TYPE_WAKEUP){
				wk.value[1] = 0x90 ;
			}
			break ;
	}
	wk.addr = address;
	i2c_write(regs, lock, &wk);
#else
    if (type == TYPE_WAKEUP)
    {
        switch (tuner_type)
        {
        case CHANNEL_TYPE_ISDB_S:
//            printk(KERN_INFO "PT1:ISDB-S Wakeup\n");
            memcpy(&wk, &isdb_s_wake, sizeof(WBLOCK));
            wk.addr = address;
            i2c_write(regs, lock, &wk);

            memcpy(&wk, &isdb_s_wake2, sizeof(WBLOCK));
            wk.addr = address;
            i2c_write(regs, lock, &wk);
            break;
        case CHANNEL_TYPE_ISDB_T:
//            printk(KERN_INFO "PT1:ISDB-T Wakeup\n");
            memcpy(&wk, &isdb_t_wake, sizeof(WBLOCK));
            wk.addr = address;
            i2c_write(regs, lock, &wk);

            memcpy(&wk, &isdb_t_wake2, sizeof(WBLOCK));
            wk.addr = address;
            i2c_write(regs, lock, &wk);
            break;
        }
    }
    if (type == TYPE_SLEEP)
    {
        switch (tuner_type)
        {
        case CHANNEL_TYPE_ISDB_S:
//            printk(KERN_INFO "PT1:ISDB-S Sleep\n");
            memcpy(&wk, &isdb_s_sleep, sizeof(WBLOCK));
            wk.addr = address;
            i2c_write(regs, lock, &wk);
            break;
        case CHANNEL_TYPE_ISDB_T:
//            printk(KERN_INFO "PT1:ISDB-T Sleep\n");
            memcpy(&wk, &isdb_t_sleep, sizeof(WBLOCK));
            wk.addr = address;
            i2c_write(regs, lock, &wk);
            break;
        }
    }
#endif
}


int		isdb_s_read_signal_strength(void __iomem *regs, struct mutex *lock, int addr)
{
	WBLOCK	wk;
	__u32	val ;
	__u32	val2;
	int		val3 ;

	memcpy(&wk, &bs_get_signal1, sizeof(WBLOCK));
	wk.addr = addr;
	val = i2c_read(regs, lock, &wk, 1);

	memcpy(&wk, &bs_get_signal2, sizeof(WBLOCK));
	wk.addr = addr;
	val2 = i2c_read(regs, lock, &wk, 1);
	val3 = (((val << 8) & 0XFF00) | (val2 & 0XFF));

	return val3 ;
}


int		isdb_t_read_signal_strength(void __iomem *regs, struct mutex *lock, int addr)
{
	__u32	val ;
	__u32	val2;
	__u32	val3;
	WBLOCK	wk;

	memcpy(&wk, &isdb_t_signal1, sizeof(WBLOCK));
	wk.addr = addr;
	val = i2c_read(regs, lock, &wk, 1);
//	printk(KERN_INFO "CN(1)Val(%x)\n", val);

	memcpy(&wk, &isdb_t_signal2, sizeof(WBLOCK));
	wk.addr = addr;
	val2 = i2c_read(regs, lock, &wk, 1);
	val3 = (((val << 8) & 0XFF00) | (val2 & 0XFF));
	return val3 ;
}


}

static int i2c_address[MAX_CHANNEL] = {T0_ISDB_S, T0_ISDB_T, T1_ISDB_S, T1_ISDB_T};

#define super IOService

// Even though we are defining the convenience macro super for the superclass, you must use the actual class name
// in the OS*MetaClass macros. Note that the class name is different when supporting Mac OS X 10.4.

#if MAC_OS_X_VERSION_MIN_REQUIRED <= MAC_OS_X_VERSION_10_4
OSDefineMetaClassAndStructors(PT1Device, IOService)
#else
OSDefineMetaClassAndStructors(PT1Device, IOService)
#endif

#pragma mark
// We override init only to log that it has been called to make it easier to follow the driver's lifecycle.
// Production drivers would only need to override init if they want to initialize data members.
bool PT1Device::init(OSDictionary* dictionary)
{
    if (!super::init(dictionary))
    {
        return false;
	}

	// This IOLog must follow super::init because getName relies on the superclass initialization.
	IOLog("%s[%p]::%s(%p)\n", getName(), this, __FUNCTION__, dictionary);

    // This is where you could set the initial value of your driver's data members.

    // 初期化
    _deviceID = 0xFFFF;
    _lnbPower = LNB_POWER_OFF;
    _lnbPowerWhenClose = LNB_POWER_OFF;
    _tunerPowerReset = kTunerPowerOff;
    for (int i = 0; i < 4; ++i)
    {
        _streamEnable[i] = false;
        _streamGray[i] = 0;
    }
    _transfer = false;

    // 初期化：DMAバッファ関連
    _bufferInfo.LockSize     = 0;
    _bufferInfo.VirtualSize  = 0;
    _bufferInfo.VirtualCount = 0;
    _bmdAddress = NULL;
    _bmdData = NULL;
    _dmaCmdAddress = NULL;
    _dmaCmdData    = NULL;

	return true;
}

// We override probe only to log that it has been called to make it easier to follow the driver's lifecycle.
// Production drivers can override probe if they need to make an active decision whether the driver is appropriate for
// the provider.
IOService* PT1Device::probe(IOService* provider, SInt32* score)
{
	IOLog("%s[%p]::%s(%p, %p)\n", getName(), this, __FUNCTION__, provider, score);

    IOService *res = super::probe(provider, score);

    return res;
}

bool PT1Device::start(IOService* provider)
{
	IOLog("%s[%p]::%s(%p)\n", getName(), this, __FUNCTION__, provider);
    
    if (!super::start(provider))
    {
        return false;
    }

    assert( OSDynamicCast( IOPCIDevice, provider ));
    _device = (IOPCIDevice *) provider;

    // for Power Management
    PMinit();
    if (registerPowerDriver(this, (IOPMPowerState *)ourPowerStates, kNumPT1States) != kIOReturnSuccess)
    {
        IOLog("%s: Failed to registerPowerDriver.\n", getName());
    }
    provider->joinPMtree(this);

    //
    // RevisionIDチェック
    //
    uint8_t revision = _device->configRead8(kIOPCIConfigRevisionID);
    if (revision != 0x01)
    {
        IOLog("RevisionID Check NG. %d\n", revision);
        return false;
    }
//    IOLog("RevisionID = 0x%02X.\n", revision);

    _deviceID = _device->configRead16(kIOPCIConfigDeviceID);
    if (_deviceID != PCI_PT1_ID && _deviceID != PCI_PT2_ID)
    {
        IOLog("%s[%p]::%s() DeviceID Check NG. %d\n", getName(), this, __FUNCTION__, _deviceID);
    }
	IOLog("%s[%p]::%s() DeviceID = 0x%04x\n", getName(), this, __FUNCTION__, _deviceID);

#if 0
    //
    // CheckBus
    //
    for (uint i = 0; i < 2; ++i)
    {
        uint data = (i == 0) ? 0x00000000 : 0xffffffff;
        for (uint j = 0; j < 32; ++j)
        {
            uint writeData = data ^ (BIT_1(1) << i);
            uint readData;

            fPCIDevice->configWrite32(A_CONFIG_DATA, writeData);
            readData = fPCIDevice->configRead32(A_CONFIG_DATA);

            if (readData != writeData)
            {
                IOLog("CheckBus PH1 NG.\n");
                return false;
            }
        }
    }

    uint writeData = 0;
    uint readData;

    fPCIDevice->configWrite32(A_CONFIG_DATA, writeData);
    readData = fPCIDevice->configRead32(A_CONFIG_DATA);

    if (readData != writeData)
    {
        IOLog("CheckBus PH2 NG.\n");
        return false;
    }

    for (uint i = 0; i < 4; ++i)
    {
        fPCIDevice->configWrite8(A_CONFIG_DATA + i, 0xff);
        readData = fPCIDevice->configRead32(A_CONFIG_DATA);
        writeData <<= 8;
        writeData |= 0xff;
        if (readData != writeData)
        {
            IOLog("CheckBus PH3 NG.\n");
            return false;
        }
    }
#endif

    //
    // ???
    //
    _device->configWrite16(kIOPCIConfigCommand, 0x03);


    //
    // Enable memory response from the card
    //
    _device->setMemoryEnable(true);
//    IOLog("setMemoryEnable() = %d\n", _device->setMemoryEnable(true));
//    IOLog("setMemoryEnable() = %d\n", _device->setMemoryEnable(true));

    //
    // Bus Master
    //
    _device->setBusMasterEnable(true);
//    IOLog("setBusMasterEnable() = %d\n", _device->setBusMasterEnable(true));
//    IOLog("setBusMasterEnable() = %d\n", _device->setBusMasterEnable(true));


    /* map a range based on its config space base address register,
     * this is how the driver gets access to its memory mapped registers
     * the getVirtualAddress() method returns a kernel virtual address
     * for the register mapping */
    
    _map = _device->mapDeviceMemoryWithRegister(kIOPCIConfigBaseAddress0);
    if (!_map)
    {
        IOLog("Can't map device memory\n");
        return false;
    }
    _reg = (void *)_map->getVirtualAddress();

    /* publish ourselves so clients can find us */
    registerService();

    return( true );
}


// We override stop only to log that it has been called to make it easier to follow the driver's lifecycle.
void PT1Device::stop(IOService* provider)
{
	IOLog("%s[%p]::%s(%p)\n", getName(), this, __FUNCTION__, provider);

    if (_map != NULL)
    {
        _map->release();
        _reg = NULL;
    }
    
    super::stop(provider);
}

// We override free only to log that it has been called to make it easier to follow the driver's lifecycle.
void PT1Device::free(void)
{
	IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);
    
    super::free();
}

bool PT1Device::open(IOService *forClient, IOOptionBits options, void *arg)
{
    IOLog("%s[%p]::%s(%p, %d, %p)\n", getName(), this, __FUNCTION__, forClient, (int)options, arg);

    uint status = kStatusInternalError;

    if (super::open(forClient, options, arg))
    {
        if (xc3s_init(_reg, _deviceID) < 0)
        {
            super::close(forClient);
        }
        else
        {
            status = kStatusSuccess;
        }
    }

    if (arg != NULL)
    {
        *(uint32_t *)arg = status;
    }

//    IOLog("%s[%p]::%s() %s\n", getName(), this, __FUNCTION__, ((status == kStatusSuccess) ? "ok." : "ng."));

    return (status == kStatusSuccess);
}

#pragma mark 未実装
void PT1Device::close(IOService *forClient, IOOptionBits options)
{
    IOLog("%s[%p]::%s(%p, %d)\n", getName(), this, __FUNCTION__, forClient, (int)options);

    if (_transfer)
    {
        uint32_t status;
        setTransferEnable(&status, false);
    }

    clearBuffer();
#if 0
			_ASSERTE(mDevice2);
			mDevice2->SetAT45DB041D(mAT45DB041D);

			for (uint i=0; i<sizeof(mTuner)/sizeof(*mTuner); i++) {
				Tuner *tuner = &mTuner[i];
				_ASSERTE(tuner);
				delete_(tuner->TC90512);
				delete_(tuner->TDA6651);
				delete_(tuner->QM1D1B0004);

				for (uint j=0; j<2; j++) {
					tuner->Sleep           [j] = true;
					tuner->FrequencyChannel[j] = 0;
					tuner->FrequencyOffset [j] = 0;
				}				
			}

			delete_(mXC3S);

			_ASSERTE(mDevice2);
			mDevice2->SetXC3S(mXC3S);

			if (mDevice) {
				mDevice->Delete();
				mDevice = NULL;
			}
#endif
    super::close(forClient, options);
}

// We override willTerminate only to log that it has been called to make it easier to follow the driver's lifecycle.
//
// willTerminate is called at the beginning of the termination process. It is a notification
// that a provider has been terminated, sent before recursing up the stack, in root-to-leaf order.
//
// This is where any pending I/O should be terminated. At this point the user client has been marked
// inactive and any further requests from the user process should be returned with an error.
bool PT1Device::willTerminate(IOService* provider, IOOptionBits options)
{
	IOLog("%s[%p]::%s(%p, %ld)\n", getName(), this, __FUNCTION__, provider, (long int)options);
	
	return super::willTerminate(provider, options);
}


// We override didTerminate only to log that it has been called to make it easier to follow the driver's lifecycle.
//
// didTerminate is called at the end of the termination process. It is a notification
// that a provider has been terminated, sent after recursing up the stack, in leaf-to-root order.
bool PT1Device::didTerminate(IOService* provider, IOOptionBits options, bool* defer)
{
	IOLog("%s[%p]::%s(%p, %ld, %p)\n", getName(), this, __FUNCTION__, provider, (long int)options, defer);
	
	return super::didTerminate(provider, options, defer);
}


// We override terminate only to log that it has been called to make it easier to follow the driver's lifecycle.
// Production drivers will rarely need to override terminate. Termination processing should be done in
// willTerminate or didTerminate instead.
bool PT1Device::terminate(IOOptionBits options)
{
    bool	success;
    
	IOLog("%s[%p]::%s(%ld)\n", getName(), this, __FUNCTION__, (long int)options);

    success = super::terminate(options);
    
    return success;
}


// We override finalize only to log that it has been called to make it easier to follow the driver's lifecycle.
// Production drivers will rarely need to override finalize.
bool PT1Device::finalize(IOOptionBits options)
{
    bool	success;
    
	IOLog("%s[%p]::%s(%ld)\n", getName(), this, __FUNCTION__, (long int)options);
    
    success = super::finalize(options);

    return success;
}

IOReturn PT1Device::clientMemoryForType(UInt32 type, IOOptionBits * options, IOMemoryDescriptor ** memory)
{
	IOLog("%s[%p]::%s(%ld)\n", getName(), this, __FUNCTION__, (long int)type);

    IOReturn result = kIOReturnNoMemory;

    *memory = NULL;
    *options = 0;

    switch (type)
    {
    case kIODefaultMemoryType:
        if (_bmdData != NULL)
        {
            // You don't need to balance with a release() because the user client does the release() for you.
            _bmdData->retain();

            *memory = _bmdData;
            *options = 0;
            result = kIOReturnSuccess;
        }
        break;

    default:
        IOLog("PT1Device - Unknown memory type %ld\n", (long int)type);
        break;
    }
    
    return result;
}

IOReturn PT1Device::setPowerState(unsigned long whatState, IOService* dontCare)
{
	IOLog("%s[%p]::%s(%s)\n", getName(), this, __FUNCTION__, whatState == kPT1OffState ? "OFF" : "ON");

    switch (whatState)
    {
    case kPT1OffState:
        if (_tunerPowerReset != kTunerPowerOff)
        {
            uint32_t status;
            setTunerPowerReset(&status, kTunerPowerOff);
        }
        break;
    case kPT1OnState:
        break;
    }
    return IOPMAckImplied;
}

void PT1Device::clearBuffer(void)
{
//    IOLog("clearBuffer().\n");
    if (_dmaCmdAddress != NULL)
    {
        if (_dmaCmdAddress->getMemoryDescriptor() != NULL)
        {
            _dmaCmdAddress->clearMemoryDescriptor();
        }
        _dmaCmdAddress->release();
        _dmaCmdAddress = NULL;
    }
    if (_dmaCmdData != NULL)
    {
        if (_dmaCmdData->getMemoryDescriptor() != NULL)
        {
            _dmaCmdData->clearMemoryDescriptor();
        }
        _dmaCmdData->release();
        _dmaCmdData = NULL;
    }
    if (_bmdAddress != NULL)
    {
        _bmdAddress->release();
        _bmdAddress = NULL;
    }
    if (_bmdData != NULL)
    {
        _bmdData->release();
        _bmdData = NULL;
    }

    _bufferInfo.VirtualSize = 0;
    _bufferInfo.VirtualCount = 0;
    _bufferInfo.LockSize = 0;
}

#pragma mark
#pragma mark ############### I/O用メソッド ###############
UInt8 PT1Device::memoryRead8(UInt16 offset)
{
    UInt8 value = 0xff;
    if (_map)
    {
        value = *(UInt8 *)(_map->getVirtualAddress() + offset);
    }
    return value;
}

UInt16 PT1Device::memoryRead16(UInt16 offset)
{
    UInt16 value = 0xff;
    if (_map)
    {
        value = *(UInt16 *)(_map->getVirtualAddress() + offset);
    }
    return value;
}

UInt32 PT1Device::memoryRead32(UInt16 offset)
{
    UInt32 value = 0xff;
    if (_map)
    {
        value = *(UInt32 *)(_map->getVirtualAddress() + offset);
    }
    return value;
}

void PT1Device::memoryWrite8(UInt16 offset, UInt8 value)
{
    if (_map)
    {
        *(UInt8 *)(_map->getVirtualAddress() + offset) = value;
    }
}

void PT1Device::memoryWrite16(UInt16 offset, UInt16 value)
{
    if (_map)
    {
        *(UInt16 *)(_map->getVirtualAddress() + offset) = value;
    }
}

void PT1Device::memoryWrite32(UInt16 offset, UInt32 value)
{
    if (_map)
    {
        *(UInt32 *)(_map->getVirtualAddress() + offset) = value;
    }
}

static bool ConvertData(uint16_t deviceID, LnbPower lnbPower, TunerPowerReset tunerPowerReset, uint32_t *data)
{
    if (data == NULL)
    {
        return false;
    }
#if 0
    uint data_ = 0;

    switch (lnbPower)
    {
    case LNB_POWER_OFF:
        data_ |= (0 << 1 | 0 << 2);
        break;

    case LNB_POWER_15V:
        data_ |= (1 << 1 | 1 << 2);
        break;

    case LNB_POWER_11V:
        data_ |= (0 << 1 | 1 << 2);
        break;

    default:
        return false;
    }

    switch (tunerPowerReset)
    {
    case TUNER_POWER_OFF:
        data_ |= (0 << 0 | 0 << 3);
        break;

    case TUNER_POWER_ON_RESET_ENABLE:
        data_ |= (1 << 0 | 0 << 3);
        break;

    case TUNER_POWER_ON_RESET_DISABLE:
        data_ |= (1 << 0 | 1 << 3);
        break;

    default:
        return false;
    }
#else
    uint data_ = TUNER_POWER_OFF;
    switch (lnbPower)
    {
    case LNB_POWER_11V:
        data_ = (1 << BIT_LNB_DOWN);
        break;
    case LNB_POWER_15V:
        data_ = (1 << BIT_LNB_UP) | (1 << BIT_LNB_DOWN);
        break;
    case LNB_POWER_OFF:
        break;
    default:
        return false;
    }

    if (deviceID == PCI_PT1_ID)
    {
        switch (tunerPowerReset)
        {
        case TUNER_POWER_ON_RESET_ENABLE:
            data_ |= (1 << BIT_TUNER);
            break;
        case TUNER_POWER_ON_RESET_DISABLE:
            data_ |= (1 << BIT_TUNER) | (1 << BIT_RESET);
            break;
        case TUNER_POWER_OFF:
            break;
        default:
            return false;
        }
    }
    else if (deviceID == PCI_PT2_ID)
    {
        switch (tunerPowerReset)
        {
        case TUNER_POWER_ON_RESET_ENABLE:
            data_ |= (1 << BIT_TUNER)
                    | (1 << BIT_33A1)
                    | (1 << BIT_33A2)
                    | (1 << BIT_5A_)
                    | (1 << BIT_5A1)
                    | (1 << BIT_5A2);
            break;
        case TUNER_POWER_ON_RESET_DISABLE:
            data_ |= (1 << BIT_TUNER)
                    | (1 << BIT_RESET)
                    | (1 << BIT_33A1)
                    | (1 << BIT_33A2)
                    | (1 << BIT_5A_)
                    | (1 << BIT_5A1)
                    | (1 << BIT_5A2);
            break;
        case TUNER_POWER_OFF:
            break;
        default:
            return false;
        }
    }
#endif
    *data = data_;

    return true;
}

#pragma mark
#pragma mark ############### User Interface ###############

IOReturn PT1Device::getDeviceInfo(DeviceInfo *deviceInfo, uint32_t *structSize)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    if (deviceInfo)
    {
        deviceInfo->Bus = _device->getBusNumber();
        deviceInfo->Slot = _device->getDeviceNumber();
        deviceInfo->Function = _device->getFunctionNumber();
        deviceInfo->BadBitCount = 0;
    }

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::getPciClockCounter(uint32_t *status, uint32_t *counter)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    if ((status == NULL) || (counter == NULL))
    {
        return kIOReturnError;
    }

//    *counter = memoryRead32(0x04);
    *status = kStatusNotImplemented;

    return kIOReturnSuccess;
}

IOReturn PT1Device::setPciLatencyTimer(uint32_t *status, uint32_t latencyTimer)
{
//    IOLog("%s[%p]::%s(latencyTimer = 0x%08x)\n", getName(), this, __FUNCTION__, latencyTimer);

    if (status == NULL)
    {
        return kIOReturnError;
    }

    _device->configWrite8(kIOPCIConfigLatencyTimer, (UInt8)latencyTimer);
    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

IOReturn PT1Device::getPciLatencyTimer(uint32_t *status, uint32_t *latencyTimer)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    if ((status == NULL) || (latencyTimer == NULL))
    {
        return kIOReturnError;
    }

    *latencyTimer = (uint32_t)_device->configRead8(kIOPCIConfigLatencyTimer);
    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

IOReturn PT1Device::setLnbPower(uint32_t *status, uint32_t lnbPower)
{
//    IOLog("%s[%p]::%s(lnbPower = 0x%08x)\n", getName(), this, __FUNCTION__, lnbPower);

    if (status == NULL)
    {
        return kIOReturnError;
    }

    uint32_t data;
    if (ConvertData(_deviceID, (LnbPower)lnbPower, _tunerPowerReset, &data))
    {
        memoryWrite32(CFG_REGS_ADDR, data);
        _lnbPower = (LnbPower)lnbPower;
        *status = kStatusSuccess;
    }
    else
    {
        IOLog("%s[%p]::%s() Convert Error.\n", getName(), this, __FUNCTION__);
        *status = kStatusIOError;
    }

    return kIOReturnSuccess;
}

IOReturn PT1Device::getLnbPower(uint32_t *status, uint32_t *lnbPower)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);
    
    if ((status == NULL) || (lnbPower == NULL))
    {
        return kIOReturnError;
    }

    *lnbPower = (uint32_t)_lnbPower;
    *status = kStatusSuccess;
    
    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::setLnbPowerWhenClose(uint32_t *status, uint32_t lnbPower)
{
//    IOLog("%s[%p]::%s(lnbPower = 0x%08x)\n", getName(), this, __FUNCTION__, lnbPower);

    *status = kStatusNotImplemented;

    return kIOReturnSuccess;
}

IOReturn PT1Device::getLnbPowerWhenClose(uint32_t *status, uint32_t *lnbPower)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    if ((status == NULL) || (lnbPower))
    {
        return kIOReturnError;
    }

    *lnbPower = (uint32_t)_lnbPowerWhenClose;
    *status = kStatusSuccess; 

    return kIOReturnSuccess;
}

IOReturn PT1Device::setTunerPowerReset(uint32_t *status, uint32_t tunerPowerReset)
{
//    IOLog("%s[%p]::%s(tunerPowerReset = 0x%08x)\n", getName(), this, __FUNCTION__, tunerPowerReset);

    if (status == NULL)
    {
        return kIOReturnError;
    }

    uint32_t data;
    if (ConvertData(_deviceID, _lnbPower, (TunerPowerReset)tunerPowerReset, &data))
    {
        memoryWrite32(CFG_REGS_ADDR, data);
        _tunerPowerReset = (TunerPowerReset)tunerPowerReset;
        *status = kStatusSuccess;
    }
    else
    {
        IOLog("%s[%p]::%s() Convert Error.\n", getName(), this, __FUNCTION__);
        *status = kStatusIOError;
    }

    return kIOReturnSuccess;
}

IOReturn PT1Device::getTunerPowerReset(uint32_t *status, uint32_t *tunerPowerReset)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    if ((status == NULL) || (tunerPowerReset == NULL))
    {
        return kIOReturnError;
    }

    *tunerPowerReset = (uint32_t)_tunerPowerReset;
    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

IOReturn PT1Device::initTuner(uint32_t *status, uint32_t tuner)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x)\n", getName(), this, __FUNCTION__, tuner);

    if (status == NULL)
    {
        return kIOReturnError;
    }

    if (tuner_init(_reg, _deviceID, NULL, tuner) < 0)
    {
        *status = kStatusInternalError;
    }
    else
    {
        *status = kStatusSuccess;
    }

//    IOLog("%s[%p]::%s() %s\n", getName(), this, __FUNCTION__, ((*status == kStatusSuccess) ? "ok." : "ng."));

    return kIOReturnSuccess;
}

IOReturn PT1Device::setTunerSleep(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t sleep)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x, sleep = 0x%08x)\n",
//            getName(), this, __FUNCTION__, tuner, isdb, sleep);

    if (status == NULL)
    {
        return kIOReturnError;
    }

    if ((tuner > 1) || (isdb >= ISDB_COUNT))
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    int ch_type = ((isdb == ISDB_S) ? CHANNEL_TYPE_ISDB_S : CHANNEL_TYPE_ISDB_T);
    int type = ((sleep) ? TYPE_WAKEUP : TYPE_SLEEP);

    set_sleepmode(_reg, NULL, i2c_address[tuner * 2 + isdb], ch_type, type);
    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::getTunerSleep(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t *sleep)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, isdb);

    *status = kStatusNotImplemented;
    *sleep = 0x12345678;

    return kIOReturnSuccess;
}

uint32_t PT1Device::setFrequency_ISDB_S(uint32_t tuner, ISDB isdb, uint32_t channel, int32_t offset)
{
    uint32_t retval;
    WBLOCK wk;
    bool tmcclock = FALSE;

    // ISDB-S PLLロック
    for (int i = 0; i < MAX_BS_CHANNEL_PLL_COMMAND; ++i)
    {
        memcpy(&wk, bs_pll[channel].wblock[i], sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + isdb];
        i2c_write(_reg, NULL, &wk);
    }
    // PLLロック確認
    // チェック用
    for (int i = 0; i < 200; ++i)
    {
        __u32 val;
        memcpy(&wk, &bs_pll_lock, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + isdb];
        val = i2c_read(_reg, NULL, &wk, 1);
        if (((val & 0xFF) != 0) && ((val & 0XFF) != 0XFF))
        {
            tmcclock = TRUE;
            break;
        }
    }

    if (tmcclock)
    {
        retval = kStatusSuccess;

        TmccS tmcc;
        uint32_t status_;
        getTmccS(&status_, tuner, &tmcc);
        if (status_ == kStatusSuccess)
        {
            setIdS(&status_, tuner, tmcc.Id[offset]);
        }
    }
    else
    {
//        IOLog("PLL LOCK ERROR\n");
        retval = kStatusInternalError;
    }

    return retval;
}

uint32_t PT1Device::setFrequency_ISDB_T(uint32_t tuner, ISDB isdb, uint32_t channel, int32_t offset)
{
    uint32_t retval;
    WBLOCK wk;
    bool tmcclock = FALSE;

    union {
        __u8  charfreq[2];
        __u16 freq;
    } freq[2];

    freq[0].freq = getfrequency(channel, offset);
    freq[1].freq = getfrequency_add(channel);
    //指定周波数
    memcpy(&wk, &isdb_t_pll_base, sizeof(WBLOCK));
    wk.addr = i2c_address[tuner * 2 + isdb];
    // 計算した周波数を設定
    wk.value[wk.count] = freq[0].charfreq[1];
    wk.count += 1 ;
    wk.value[wk.count] = freq[0].charfreq[0];
    wk.count += 1 ;

    // 計算した周波数付加情報を設定
    wk.value[wk.count] = freq[1].charfreq[1];
    wk.count += 1 ;
    wk.value[wk.count] = freq[1].charfreq[0];
    wk.count += 1 ;

    i2c_write(_reg, NULL, &wk);

    __u32 val;
    for (int i = 0; i < 100; ++i)
    {
        memcpy(&wk, &isdb_t_pll_lock, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + isdb];
        val = i2c_read(_reg, NULL, &wk, 1);
        if (((val & 0xFF) != 0XFF) && ((val & 0X50) == 0x50))
        {
            tmcclock = TRUE;
            break;
        }
    }
    if (tmcclock)
    {
//        IOLog("PT1:ISDB-T LOCK OK(%08x)\n", (unsigned int)val);
        retval = kStatusSuccess;

        TmccT tmcc;
        uint32_t status_;
        getTmccT(&status_, tuner, &tmcc);

    }
    else
    {
//        IOLog("PT1:ISDB-T LOCK NG(%08x)\n", (unsigned int)val);
        retval = kStatusInternalError;
    }
    return retval;
}

#pragma mark 未実装
IOReturn PT1Device::setFrequency(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t channel, int32_t offset)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x, channel = 0x%08x, offset = 0x%08x)\n",
//            getName(), this, __FUNCTION__, tuner, isdb, channel, offset);

    if (status == NULL)
    {
        return kIOReturnError;
    }

    if ((tuner > 1) || (isdb >= ISDB_COUNT) ||
        ((isdb == ISDB_S) && (channel >= MAX_BS_CHANNEL)) ||
        ((isdb == ISDB_T) && (channel >= MAX_ISDB_T_CHANNEL)))
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    WBLOCK wk;
    bool tmcclock = FALSE;
    switch (isdb)
    {
    case ISDB_S:
#if 0
        // ISDB-S PLLロック
        for (int i = 0; i < MAX_BS_CHANNEL_PLL_COMMAND; ++i)
        {
            memcpy(&wk, bs_pll[channel].wblock[i], sizeof(WBLOCK));
            wk.addr = i2c_address[tuner * 2 + isdb];
            i2c_write(_reg, NULL, &wk);
        }
        // PLLロック確認
        // チェック用
        for (int i = 0; i < 200; ++i)
        {
            __u32 val;
            memcpy(&wk, &bs_pll_lock, sizeof(WBLOCK));
            wk.addr = i2c_address[tuner * 2 + isdb];
            val = i2c_read(_reg, NULL, &wk, 1);
            if (((val & 0xFF) != 0) && ((val & 0XFF) != 0XFF))
            {
                tmcclock = TRUE;
                break;
            }
        }

        if (tmcclock)
        {
            *status = kStatusSuccess;

            TmccS tmcc;
            uint32_t status_;
            getTmccS(&status_, tuner, &tmcc);
            if (status_ == kStatusSuccess)
            {
                setIdS(&status_, tuner, tmcc.Id[offset]);
            }
        }
        else
        {
            IOLog("PLL LOCK ERROR\n");
            *status = kStatusInternalError;
        }
#else
        *status = setFrequency_ISDB_S(tuner, isdb, channel, offset);
#endif

        break;

    case ISDB_T:
#if 1
        union {
            __u8  charfreq[2];
            __u16 freq;
        } freq[2];

        freq[0].freq = getfrequency(channel, offset);
        freq[1].freq = getfrequency_add(channel);
        //指定周波数
        memcpy(&wk, &isdb_t_pll_base, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + isdb];
        // 計算した周波数を設定
        wk.value[wk.count] = freq[0].charfreq[1];
        wk.count += 1 ;
        wk.value[wk.count] = freq[0].charfreq[0];
        wk.count += 1 ;

        // 計算した周波数付加情報を設定
        wk.value[wk.count] = freq[1].charfreq[1];
        wk.count += 1 ;
        wk.value[wk.count] = freq[1].charfreq[0];
        wk.count += 1 ;
#if 1
    {
    WBLOCK isdb_t_chset[113] = {
    {0, 6, {0xfe, 0xc2, 0x04, 0x1b, 0x80, 0x81}},   //   0
    {0, 4, {0xfe, 0xc2, 0x04, 0x45, 0x00, 0x00}},   //   1
    {0, 4, {0xfe, 0xc2, 0x04, 0x6f, 0x00, 0x00}},   //   2
    {0, 4, {0xfe, 0xc2, 0x04, 0x99, 0x00, 0x00}},   //   3
    {0, 4, {0xfe, 0xc2, 0x04, 0xc3, 0x00, 0x00}},   //   4
    {0, 4, {0xfe, 0xc2, 0x04, 0xed, 0x00, 0x00}},   //   5
    {0, 4, {0xfe, 0xc2, 0x05, 0x17, 0x00, 0x00}},   //   6
    {0, 4, {0xfe, 0xc2, 0x05, 0x41, 0x00, 0x00}},   //   7
//    {0, 6, {0xfe, 0xc2, 0x05, 0x6b, 0x80, 0xa1}},   //   8
    {0, 4, {0xfe, 0xc2, 0x05, 0x6b, 0x00, 0x00}},   //   8
    {0, 4, {0xfe, 0xc2, 0x05, 0x95, 0x00, 0x00}},   //   9
    {0, 4, {0xfe, 0xc2, 0x05, 0xbf, 0x00, 0x00}},   //  10
    {0, 4, {0xfe, 0xc2, 0x05, 0xe9, 0x00, 0x00}},   //  11
    {0, 4, {0xfe, 0xc2, 0x06, 0x21, 0x00, 0x00}},   //  12
//    {0, 6, {0xfe, 0xc2, 0x06, 0x4b, 0x80, 0x62}},   //  13
    {0, 4, {0xfe, 0xc2, 0x06, 0x4b, 0x00, 0x00}},   //  13
    {0, 4, {0xfe, 0xc2, 0x06, 0x75, 0x00, 0x00}},   //  14
    {0, 4, {0xfe, 0xc2, 0x06, 0x9f, 0x00, 0x00}},   //  15
    {0, 4, {0xfe, 0xc2, 0x06, 0xc9, 0x00, 0x00}},   //  16
    {0, 4, {0xfe, 0xc2, 0x06, 0xe5, 0x00, 0x00}},   //  17
    {0, 4, {0xfe, 0xc2, 0x07, 0x0f, 0x00, 0x00}},   //  18
    {0, 4, {0xfe, 0xc2, 0x07, 0x39, 0x00, 0x00}},   //  19
    {0, 4, {0xfe, 0xc2, 0x07, 0x63, 0x00, 0x00}},   //  20
    {0, 4, {0xfe, 0xc2, 0x07, 0x8d, 0x00, 0x00}},   //  21
//   {0, 6, {0xfe, 0xc2, 0x07, 0xb7, 0x80, 0xa2}},   //  22
    {0, 4, {0xfe, 0xc2, 0x07, 0xb7, 0x00, 0x00}},   //  22
    {0, 4, {0xfe, 0xc2, 0x07, 0xe1, 0x00, 0x00}},   //  23
    {0, 4, {0xfe, 0xc2, 0x08, 0x0b, 0x00, 0x00}},   //  24
    {0, 4, {0xfe, 0xc2, 0x08, 0x35, 0x00, 0x00}},   //  25
    {0, 4, {0xfe, 0xc2, 0x08, 0x5f, 0x00, 0x00}},   //  26
    {0, 4, {0xfe, 0xc2, 0x08, 0x89, 0x00, 0x00}},   //  27
    {0, 4, {0xfe, 0xc2, 0x08, 0xb3, 0x00, 0x00}},   //  28
    {0, 4, {0xfe, 0xc2, 0x08, 0xdd, 0x00, 0x00}},   //  29
    {0, 4, {0xfe, 0xc2, 0x09, 0x07, 0x00, 0x00}},   //  30
    {0, 4, {0xfe, 0xc2, 0x09, 0x31, 0x00, 0x00}},   //  31
    {0, 4, {0xfe, 0xc2, 0x09, 0x5b, 0x00, 0x00}},   //  32
    {0, 4, {0xfe, 0xc2, 0x09, 0x85, 0x00, 0x00}},   //  33
    {0, 4, {0xfe, 0xc2, 0x09, 0xaf, 0x00, 0x00}},   //  34
    {0, 4, {0xfe, 0xc2, 0x09, 0xd9, 0x00, 0x00}},   //  35
    {0, 4, {0xfe, 0xc2, 0x0a, 0x03, 0x00, 0x00}},   //  36
    {0, 4, {0xfe, 0xc2, 0x0a, 0x2d, 0x00, 0x00}},   //  37
    {0, 4, {0xfe, 0xc2, 0x0a, 0x57, 0x00, 0x00}},   //  38
    {0, 4, {0xfe, 0xc2, 0x0a, 0x81, 0x00, 0x00}},   //  39
//    {0, 6, {0xfe, 0xc2, 0x0a, 0xab, 0x80, 0xe2}},   //  40
    {0, 4, {0xfe, 0xc2, 0x0a, 0xab, 0x00, 0x00}},   //  40
    {0, 4, {0xfe, 0xc2, 0x0a, 0xd5, 0x00, 0x00}},   //  41
    {0, 4, {0xfe, 0xc2, 0x0a, 0xff, 0x00, 0x00}},   //  42
    {0, 4, {0xfe, 0xc2, 0x0b, 0x29, 0x00, 0x00}},   //  43
    {0, 4, {0xfe, 0xc2, 0x0b, 0x53, 0x00, 0x00}},   //  44
    {0, 4, {0xfe, 0xc2, 0x0b, 0x7d, 0x00, 0x00}},   //  45
    {0, 4, {0xfe, 0xc2, 0x0b, 0xa7, 0x00, 0x00}},   //  46
    {0, 4, {0xfe, 0xc2, 0x0b, 0xd1, 0x00, 0x00}},   //  47
    {0, 4, {0xfe, 0xc2, 0x0b, 0xfb, 0x00, 0x00}},   //  48
    {0, 4, {0xfe, 0xc2, 0x0c, 0x25, 0x00, 0x00}},   //  49
    {0, 4, {0xfe, 0xc2, 0x0c, 0x4f, 0x00, 0x00}},   //  50
    {0, 4, {0xfe, 0xc2, 0x0c, 0x79, 0x00, 0x00}},   //  51
//    {0, 6, {0xfe, 0xc2, 0x0c, 0xa3, 0x80, 0x64}},   //  52
    {0, 4, {0xfe, 0xc2, 0x0c, 0xa3, 0x00, 0x00}},   //  52
    {0, 4, {0xfe, 0xc2, 0x0c, 0xcd, 0x00, 0x00}},   //  53
    {0, 4, {0xfe, 0xc2, 0x0c, 0xf7, 0x00, 0x00}},   //  54
    {0, 4, {0xfe, 0xc2, 0x0d, 0x21, 0x00, 0x00}},   //  55
    {0, 4, {0xfe, 0xc2, 0x0d, 0x4b, 0x00, 0x00}},   //  56
    {0, 4, {0xfe, 0xc2, 0x0d, 0x75, 0x00, 0x00}},   //  57
    {0, 4, {0xfe, 0xc2, 0x0d, 0x9f, 0x00, 0x00}},   //  58
    {0, 4, {0xfe, 0xc2, 0x0d, 0xc9, 0x00, 0x00}},   //  59
    {0, 6, {0xfe, 0xc2, 0x0d, 0xf3, 0x80, 0x84}},   //  60
    {0, 4, {0xfe, 0xc2, 0x0e, 0x1d, 0x00, 0x00}},   //  61
    {0, 4, {0xfe, 0xc2, 0x0e, 0x47, 0x00, 0x00}},   //  62
    {0, 4, {0xfe, 0xc2, 0x0e, 0x7f, 0x00, 0x00}},   //  63
    {0, 4, {0xfe, 0xc2, 0x0e, 0xa9, 0x00, 0x00}},   //  64
    {0, 4, {0xfe, 0xc2, 0x0e, 0xd3, 0x00, 0x00}},   //  65
    {0, 4, {0xfe, 0xc2, 0x0e, 0xfd, 0x00, 0x00}},   //  66
    {0, 4, {0xfe, 0xc2, 0x0f, 0x27, 0x00, 0x00}},   //  67
    {0, 4, {0xfe, 0xc2, 0x0f, 0x51, 0x00, 0x00}},   //  68
    {0, 4, {0xfe, 0xc2, 0x0f, 0x7b, 0x00, 0x00}},   //  69
    {0, 4, {0xfe, 0xc2, 0x0f, 0xa5, 0x00, 0x00}},   //  70
    {0, 4, {0xfe, 0xc2, 0x0f, 0xcf, 0x00, 0x00}},   //  71
    {0, 4, {0xfe, 0xc2, 0x0f, 0xf9, 0x00, 0x00}},   //  72
    {0, 4, {0xfe, 0xc2, 0x10, 0x23, 0x00, 0x00}},   //  73
    {0, 4, {0xfe, 0xc2, 0x10, 0x4d, 0x00, 0x00}},   //  74
    {0, 4, {0xfe, 0xc2, 0x10, 0x77, 0x00, 0x00}},   //  75
//    {0, 6, {0xfe, 0xc2, 0x10, 0xa1, 0x80, 0xa4}},   //  76
    {0, 4, {0xfe, 0xc2, 0x10, 0xa1, 0x00, 0x00}},   //  76
    {0, 4, {0xfe, 0xc2, 0x10, 0xcb, 0x00, 0x00}},   //  77
    {0, 4, {0xfe, 0xc2, 0x10, 0xf5, 0x00, 0x00}},   //  78
    {0, 4, {0xfe, 0xc2, 0x11, 0x1f, 0x00, 0x00}},   //  79
    {0, 4, {0xfe, 0xc2, 0x11, 0x49, 0x00, 0x00}},   //  80
    {0, 4, {0xfe, 0xc2, 0x11, 0x73, 0x00, 0x00}},   //  81
    {0, 4, {0xfe, 0xc2, 0x11, 0x9d, 0x00, 0x00}},   //  82
    {0, 4, {0xfe, 0xc2, 0x11, 0xc7, 0x00, 0x00}},   //  83
    {0, 4, {0xfe, 0xc2, 0x11, 0xf1, 0x00, 0x00}},   //  84
//    {0, 6, {0xfe, 0xc2, 0x12, 0x1b, 0x80, 0xc4}},   //  85
    {0, 4, {0xfe, 0xc2, 0x12, 0x1b, 0x00, 0x00}},   //  85
    {0, 4, {0xfe, 0xc2, 0x12, 0x45, 0x00, 0x00}},   //  86
    {0, 4, {0xfe, 0xc2, 0x12, 0x6f, 0x00, 0x00}},   //  87
    {0, 4, {0xfe, 0xc2, 0x12, 0x99, 0x00, 0x00}},   //  88
    {0, 4, {0xfe, 0xc2, 0x12, 0xc3, 0x00, 0x00}},   //  89
    {0, 4, {0xfe, 0xc2, 0x12, 0xed, 0x00, 0x00}},   //  90
    {0, 4, {0xfe, 0xc2, 0x13, 0x17, 0x00, 0x00}},   //  91
    {0, 4, {0xfe, 0xc2, 0x13, 0x41, 0x00, 0x00}},   //  92
    {0, 4, {0xfe, 0xc2, 0x13, 0x6b, 0x00, 0x00}},   //  93
    {0, 4, {0xfe, 0xc2, 0x13, 0x95, 0x00, 0x00}},   //  94
    {0, 4, {0xfe, 0xc2, 0x13, 0xbf, 0x00, 0x00}},   //  95
    {0, 4, {0xfe, 0xc2, 0x13, 0xe9, 0x00, 0x00}},   //  96
    {0, 4, {0xfe, 0xc2, 0x14, 0x13, 0x00, 0x00}},   //  97
    {0, 4, {0xfe, 0xc2, 0x14, 0x3d, 0x00, 0x00}},   //  98
    {0, 4, {0xfe, 0xc2, 0x14, 0x67, 0x00, 0x00}},   //  99
    {0, 4, {0xfe, 0xc2, 0x14, 0x91, 0x00, 0x00}},   // 100
//    {0, 6, {0xfe, 0xc2, 0x14, 0xbb, 0x80, 0xe4}},   // 101
    {0, 4, {0xfe, 0xc2, 0x14, 0xbb, 0x00, 0x00}},   // 101
    {0, 4, {0xfe, 0xc2, 0x14, 0xe5, 0x00, 0x00}},   // 102
    {0, 4, {0xfe, 0xc2, 0x15, 0x0f, 0x00, 0x00}},   // 103
    {0, 4, {0xfe, 0xc2, 0x15, 0x39, 0x00, 0x00}},   // 104
    {0, 4, {0xfe, 0xc2, 0x15, 0x63, 0x00, 0x00}},   // 105
    {0, 4, {0xfe, 0xc2, 0x15, 0x8d, 0x00, 0x00}},   // 106
    {0, 4, {0xfe, 0xc2, 0x15, 0xb7, 0x00, 0x00}},   // 107
    {0, 4, {0xfe, 0xc2, 0x15, 0xe1, 0x00, 0x00}},   // 108
    {0, 4, {0xfe, 0xc2, 0x16, 0x0b, 0x00, 0x00}},   // 109
    {0, 4, {0xfe, 0xc2, 0x16, 0x35, 0x00, 0x00}},   // 110
    {0, 4, {0xfe, 0xc2, 0x16, 0x5f, 0x00, 0x00}},   // 111
    {0, 4, {0xfe, 0xc2, 0x16, 0x89, 0x00, 0x00}}};  // 112

//IOLog("%d, %02X %02X %02X %02X\n", wk.count, wk.value[2], wk.value[3], wk.value[4], wk.value[5]);
        memcpy(&wk, &isdb_t_chset[channel], sizeof(WBLOCK));

        // 計算した周波数付加情報を設定
        wk.value[wk.count] = freq[1].charfreq[1];
        wk.count += 1 ;
        wk.value[wk.count] = freq[1].charfreq[0];
        wk.count += 1 ;


//IOLog("%d, %02X %02X %02X %02X\n", wk.count, wk.value[2], wk.value[3], wk.value[4], wk.value[5]);
        wk.addr = i2c_address[tuner * 2 + isdb];

    }
#endif
        i2c_write(_reg, NULL, &wk);

        __u32 val;
        for (int i = 0; i < 100; ++i)
        {
            memcpy(&wk, &isdb_t_pll_lock, sizeof(WBLOCK));
            wk.addr = i2c_address[tuner * 2 + isdb];
            val = i2c_read(_reg, NULL, &wk, 1);
            if (((val & 0xFF) != 0XFF) && ((val & 0X50) == 0x50))
            {
                tmcclock = TRUE;
                break;
            }
        }
        if (tmcclock)
        {
            *status = kStatusSuccess;
        }
        else
        {
//            IOLog("PT1:ISDB-T LOCK NG(%08x)\n", (unsigned int)val);
            *status = kStatusInternalError;
        }
#else
//        *status = setFrequency_ISDB_T(tuner, isdb, channel, offset);
        if (isdb_t_frequency(_reg, NULL, i2c_address[tuner * 2 + ISDB_T], channel, offset) < 0)
        {
            *status = kStatusInternalError;
        }
#endif
        break;

    default:
        *status = kStatusParamError;
        break;
	}

//    IOLog("%s[%p]::%s() %s\n", getName(), this, __FUNCTION__, ((*status == kStatusSuccess) ? "ok." : "ng."));

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::getFrequency(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t *channel, int32_t *offset)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, isdb);

    *status = kStatusNotImplemented;
    *channel = 0x12345678;
    *offset  = 0x23456789;

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::getFrequencyOffset(uint32_t *status, uint32_t tuner, ISDB isdb, int32_t *clock, int32_t *carrier)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, isdb);

    if ((status == NULL) || (clock == NULL) || (carrier == NULL))
    {
        return kIOReturnError;
    }
    if ((tuner > 1) || (isdb >= ISDB_COUNT))
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    WBLOCK wk;
    switch (isdb)
    {
    case ISDB_S:
        memcpy(&wk, &bs_get_clock, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + isdb];
        *clock = i2c_read(_reg, NULL, &wk, 1) & 0xff;

        memcpy(&wk, &bs_get_carrir, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + isdb];
        *carrier = i2c_read(_reg, NULL, &wk, 1) & 0xff;
        *carrier *= 80000;
        *status = kStatusSuccess;
        break;

    case ISDB_T:
        memcpy(&wk, &isdb_t_get_clock, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + isdb];
        *clock = i2c_read(_reg, NULL, &wk, 1) & 0xff;

        memcpy(&wk, &bs_get_carrir, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + isdb];
        *carrier = i2c_read(_reg, NULL, &wk, 1) & 0xff;
        *status = kStatusSuccess;
        break;

    default:
        *status = kStatusParamError;
        break;
    }

//    IOLog("%s[%p]::%s() clock = %d, carrier = %d\n", getName(), this, __FUNCTION__, *clock, *carrier);

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::getCnAgc(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t *cn100, uint32_t *currentAgc, uint32_t *maxAgc)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, isdb);

    if ((status == NULL) || (cn100 == NULL) || (currentAgc == NULL) || (maxAgc == NULL))
    {
        return kIOReturnError;
    }
    if ((tuner > 1) || (isdb >= ISDB_COUNT))
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    WBLOCK wk;
    switch (isdb)
    {
    case ISDB_S:
        *cn100 = isdb_s_read_signal_strength(_reg, NULL, i2c_address[tuner * 2 + isdb]);
        memcpy(&wk, &bs_get_agc, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + isdb];
        *currentAgc = i2c_read(_reg, NULL, &wk, 1) & 0xff;
        *maxAgc = 127;
        *status = kStatusSuccess;
        break;

    case ISDB_T:
        *cn100 = isdb_t_read_signal_strength(_reg, NULL, i2c_address[tuner * 2 + isdb]);
        memcpy(&wk, &isdb_t_agc2, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + isdb];
        *currentAgc = i2c_read(_reg, NULL, &wk, 1) & 0xff;
        *maxAgc = 255;
        *status = kStatusSuccess;
        break;

    default:
        *status = kStatusParamError;
        break;
    }

//    IOLog("%s[%p]::%s() %s.\n", getName(), this, __FUNCTION__, (*status == kStatusSuccess) ? "ok" : "ng");

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::setIdS(uint32_t *status, uint32_t tuner, uint32_t tsid)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, tsid = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, tsid);

    if (status == NULL)
    {
        return kIOReturnError;
    }
    if (tuner > 1)
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    WBLOCK wk;
    union {
        __u8  ts[2];
        __u16 tsid;
    } uts_id;

    uts_id.tsid = tsid;
    memcpy(&wk, &bs_set_ts_lock, sizeof(WBLOCK));
    wk.addr = i2c_address[tuner * 2 + ISDB_S];
	// TS-ID設定
    wk.value[1] = uts_id.ts[1];
    wk.value[2] = uts_id.ts[0];
    i2c_write(_reg, NULL, &wk);

    *status = kStatusInternalError;
    for (int i = 0; i < 100; ++i)
    {
        memcpy(&wk, &bs_get_ts_lock, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + ISDB_S];
        __u32 val = i2c_read(_reg, NULL, &wk, 2);
        if ((val & 0xFFFF) == tsid)
        {
            *status = kStatusSuccess;
            break;
		}
	}

//    IOLog("%s[%p]::%s() %s.\n", getName(), this, __FUNCTION__, (*status == kStatusSuccess) ? "ok" : "ng");

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::getIdS(uint32_t *status, uint32_t tuner, uint32_t *tsid)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x)\n", getName(), this, __FUNCTION__, tuner);

    if ((status == NULL) || (tsid == NULL))
    {
        return kIOReturnError;
    }
    if (tuner > 1)
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    WBLOCK wk;
    memcpy(&wk, &bs_get_ts_lock, sizeof(WBLOCK));
    wk.addr = i2c_address[tuner * 2 + ISDB_S];
    *tsid = i2c_read(_reg, NULL, &wk, 2) & 0xffff;

    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::getCorrectedErrorRate(uint32_t *status, uint32_t tuner, ISDB isdb, LayerIndex layerIndex, ErrorRate *errorRate)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x, layerIndex = 0x%08x)\n",
//            getName(), this, __FUNCTION__, tuner, isdb, layerIndex);

    *status = kStatusNotImplemented;
    errorRate->Numerator = 0x12345678;
    errorRate->Denominator = 0x23456789;

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::resetCorrectedErrorCount(uint32_t *status, uint32_t tuner, ISDB isdb)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, isdb);

    *status = kStatusNotImplemented;

    return kIOReturnSuccess;
}

IOReturn PT1Device::getErrorCount(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t *count)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, isdb);

    if ((status == NULL) || (count == NULL))
    {
        return kIOReturnError;
    }
    if ((tuner > 1) || (isdb >= ISDB_COUNT))
    {
        return kIOReturnError;
    }

    uint32_t gray = memoryRead32((0x04 + (tuner * 2 + isdb)) * 4);    

    uint32_t binary = 0;

    for (uint32_t i = 0; i < 32; ++i)
    {
        uint32_t k = 0;
        for (uint32_t j = i; j < 32; ++j)
        {
            k = k ^ BIT_SHIFT_MASK(gray, j, 1);
        }
        binary |= (k << i);
    }

    *count = binary;
    
    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::getTmccS(uint32_t *status, uint32_t tuner, TmccS *tmcc)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x)\n", getName(), this, __FUNCTION__, tuner);

    if ((status == NULL) || (tmcc == NULL))
    {
        return kIOReturnError;
    }
    if (tuner > 1)
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    WBLOCK wk;
    union {
        __u16 ts[2];
        __u32 tsid;
    } ts_id;

    memcpy(&wk, &bs_tmcc_get_1, sizeof(WBLOCK));
    wk.addr = i2c_address[tuner * 2 + ISDB_S];
    i2c_write(_reg, NULL, &wk);

    bool tmcclock = FALSE ;

    for(int i = 0; i < 200; ++i)
    {
        __u32 val;
        memcpy(&wk, &bs_tmcc_get_2, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + ISDB_S];
		val = i2c_read(_reg, NULL, &wk, 1);
        if (((val & 0XFF) != 0XFF) && (!(val & 0x10)))
        {
            tmcclock = TRUE;
            break;
        }
    }

    if (tmcclock)
    {
        // 該当周波数のTS-IDを取得
        for (int i = 0; i < (MAX_BS_TS_ID / 2); ++i)
        {
            for (int j = 0; j < 100; ++j)
            {
                memcpy(&wk, bs_get_ts_id[i], sizeof(WBLOCK));
                wk.addr = i2c_address[tuner * 2 + ISDB_S];
                ts_id.tsid = i2c_read(_reg, NULL, &wk, 4);
                // TS-IDが0の場合は再取得する
                if ((ts_id.ts[0] != 0) && (ts_id.ts[1] != 0))
                {
                    break;
                }
            }
            tmcc->Id[i * 2    ] = ts_id.ts[1];
            tmcc->Id[i * 2 + 1] = ts_id.ts[0] ;
        }
    }
    else
    {
//        IOLog("TMCC LOCK ERROR\n");
        *status = kStatusInternalError;
	}

//    IOLog("%s[%p]::%s() %s\n", getName(), this, __FUNCTION__, ((*status == kStatusSuccess) ? "ok." : "ng."));

    return kIOReturnSuccess;
}

IOReturn PT1Device::getLayerS(uint32_t *status, uint32_t tuner, LayerS *layer)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x)\n", getName(), this, __FUNCTION__, tuner);

    if ((status == NULL) || (layer == NULL))
    {
        return kIOReturnError;
    }
    if (tuner > 1)
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    union {
        __u8  slot[4];
        __u32 u32slot;
    } ts_slot;
    WBLOCK wk;

    //スロット取得
    memcpy(&wk, &bs_get_slot, sizeof(WBLOCK));
    wk.addr = i2c_address[tuner * 2 + ISDB_S];
    ts_slot.u32slot = i2c_read(_reg, NULL, &wk, 3);
    layer->Count[0] = ts_slot.slot[0];
    layer->Count[1] = ts_slot.slot[1];
    layer->Mode[0] = ts_slot.slot[2];
    layer->Mode[1] = 0;

    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

IOReturn PT1Device::getTmccT(uint32_t *status, uint32_t tuner, TmccT *tmcc)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x)\n", getName(), this, __FUNCTION__, tuner);

    if ((status == NULL) || (tmcc == NULL))
    {
        return kIOReturnError;
    }
    if (tuner > 1)
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    WBLOCK wk;
    memcpy(&wk, &isdb_t_check_tune, sizeof(WBLOCK));
    wk.addr = i2c_address[tuner * 2 + ISDB_T];
    i2c_write(_reg, NULL, &wk);

    __u32 val;
    bool tmcclock = FALSE;
    for (int i = 0; i < 2000; ++i)
    {
        memcpy(&wk, &isdb_t_tune_read, sizeof(WBLOCK));
        wk.addr = i2c_address[tuner * 2 + ISDB_T];
        val = i2c_read(_reg, NULL, &wk, 1);
        if (((val & 0xFF) != 0xFF) && ((val & 0x8) != 8))
        {
            tmcclock = TRUE;
            break;
        }
    }

    if (tmcclock)
    {
        tmcc->System = 0;
        for (int i = 0; i < 3; ++i)
        {
            tmcc->Mode[i] = 0;
            tmcc->Rate[i] = 0;
            tmcc->Interleave[i] = 0;
            tmcc->Segment[i] = 0;
        }
    }
    else
    {
//        IOLog("TMCC LOCK ERROR. val = 0x%08x\n", (unsigned int)val);
        *status = kStatusInternalError;
	}

//    IOLog("%s[%p]::%s() %s\n", getName(), this, __FUNCTION__, ((*status == kStatusSuccess) ? "ok." : "ng."));

    return kIOReturnSuccess;
}

IOReturn PT1Device::getLockedT(uint32_t *status, uint32_t tuner, bool locked[LAYER_COUNT_T])
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x)\n", getName(), this, __FUNCTION__, tuner);

    *status = kStatusSuccess;

    for (int i = 0; i < LAYER_COUNT_T; ++i)
    {
        locked[i] = (bool)(i % 2);
    }

    return kIOReturnSuccess;
}

IOReturn PT1Device::setLayerEnable(uint32_t *status, uint32_t tuner, ISDB isdb, LayerMask layerMask)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x, layerMask = 0x%08x)\n",
//            getName(), this, __FUNCTION__, tuner, isdb, layerMask);

    *status = kStatusNotImplemented;

    return kIOReturnSuccess;
}

IOReturn PT1Device::getLayerEnable(uint32_t *status, uint32_t tuner, ISDB isdb, LayerMask *layerMask)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, isdb);

    *status = kStatusNotImplemented;
    *layerMask = (LayerMask)0x12345678;

    return kIOReturnSuccess;
}

IOReturn PT1Device::setBufferInfo(uint32_t *status, const BufferInfo *bufferInfo)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    // パラメータチェック
    if ((status == NULL) || (bufferInfo == NULL))
    {
        return kIOReturnError;
    }
    if ((bufferInfo->LockSize == 0) || (bufferInfo->VirtualSize == 0) || (bufferInfo->VirtualCount == 0))
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }
    if ((bufferInfo->VirtualSize % bufferInfo->LockSize) != 0)
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }
    if (_bufferInfo.VirtualSize != 0)
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    *status = kStatusInternalError;

    do {
        // アドレス用DMAバッファ
        mach_vm_size_t bufferSize = kPageSize * bufferInfo->VirtualSize * bufferInfo->VirtualCount;
//        IOOptionBits options = kIOMemoryKernelUserShared | kIOMemoryPhysicallyContiguous;
        IOOptionBits options = kIOMemoryKernelUserShared | kIOMemoryPhysicallyContiguous | kIODirectionOut;
        _bmdAddress = IOBufferMemoryDescriptor::inTaskWithPhysicalMask(kernel_task, options, bufferSize, 0x00000000FFFFF000ULL);
        if (_bmdAddress == NULL)
        {
            IOLog("_bmdAddress ng.\n");
            break;
        }

        _dmaCmdAddress = IODMACommand::withSpecification(kIODMACommandOutputHost32, 32, 0, IODMACommand::kMapped, 0, 1);
        if (_dmaCmdAddress == NULL)
        {
            IOLog("_dmaCmdAddress ng.\n");
            break;
        }

        if (_dmaCmdAddress->setMemoryDescriptor(_bmdAddress) != kIOReturnSuccess)
        {
            IOLog("_dmaCmdAddress->setMemoryDescriptor failed.\n");
            break;
        }

        IOReturn err = kIOReturnSuccess;
        UInt64 offset = 0;
        while ((kIOReturnSuccess == err) && (offset < _bmdAddress->getLength()))
        {
            // use the 32 bit variant to match outSegFunc
            IODMACommand::Segment32 segments[1];
            UInt32 numSeg = 1;

            // use the 32 bit variant to match outSegFunc
            err = _dmaCmdAddress->gen32IOVMSegments(&offset, &segments[0], &numSeg);
//            IOLog("addr: gen32IOVMSegments(%x) addr 0x%lx, len 0x%lx, nsegs %ld\n",
//                  err, segments[0].fIOVMAddr, segments[0].fLength, numSeg);
        }

        // データ用DMAバッファ
        bufferSize = kPageSize * kBufferPageCount * bufferInfo->VirtualSize * bufferInfo->VirtualCount;
//        options = kIOMemoryKernelUserShared | kIOMemoryPhysicallyContiguous;
        options = kIOMemoryKernelUserShared | kIOMemoryPhysicallyContiguous | kIODirectionIn;
        _bmdData = IOBufferMemoryDescriptor::inTaskWithPhysicalMask(kernel_task, options, bufferSize, 0x00000000FFFFF000ULL);
        if (_bmdData == NULL)
        {
            IOLog("_bmdData ng.\n");
            break;
        }
        _dmaCmdData = IODMACommand::withSpecification(kIODMACommandOutputHost32, 32, 0, IODMACommand::kMapped, 0, 1);
        if (_dmaCmdData == NULL)
        {
            IOLog("_dmaCmdData ng.\n");
            break;
        }
        if (_dmaCmdData->setMemoryDescriptor(_bmdData) != kIOReturnSuccess)
        {
            IOLog("_dmaCmdData->setMemoryDescriptor failed.\n");
            break;
        }

        err = kIOReturnSuccess;
        offset = 0;
        while ((kIOReturnSuccess == err) && (offset < _bmdData->getLength()))
        {
            // use the 32 bit variant to match outSegFunc
            IODMACommand::Segment32 segments[1];
            UInt32 numSeg = 1;

            // use the 32 bit variant to match outSegFunc
            err = _dmaCmdData->gen32IOVMSegments(&offset, &segments[0], &numSeg);
//            IOLog("data: gen32IOVMSegments(%x) addr 0x%lx, len 0x%lx, nsegs %ld\n",
//                  err, segments[0].fIOVMAddr, segments[0].fLength, numSeg);
        }

        //
        IOMemoryMap *map = _bmdAddress->map();
        for (uint i = 0; i < bufferInfo->VirtualSize * bufferInfo->VirtualCount; ++i)
        {
            uint next = (i + 1) % (bufferInfo->VirtualSize * bufferInfo->VirtualCount);
            IOPhysicalAddress addr = _bmdAddress->getPhysicalSegment(next * kPageSize, NULL);
            uint32_t *ptr = (uint32_t *)(map->getVirtualAddress() + kPageSize * i);
            *(ptr++) = (addr >> 12);

            for (uint j = 0; j < kBufferPageCount; ++j)
            {
                addr = _bmdData->getPhysicalSegment(i * kPageSize * kBufferPageCount + j * kPageSize, NULL);
                *(ptr++) = (addr >> 12);
            }
        }
        map->release();

        *status = kStatusSuccess;

    } while (false);

    if (*status == kStatusSuccess)
    {
//        IOLog("success.\n");
        _bufferInfo = *bufferInfo;
    }
    else
    {
//        IOLog("failed.\n");
        clearBuffer();
    }

    return kIOReturnSuccess;
}

IOReturn PT1Device::getBufferInfo(uint32_t *status, BufferInfo *bufferInfo)
{
//  IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    if ((status == NULL) || (bufferInfo == NULL))
    {
        return kIOReturnError;
    }

    *bufferInfo = _bufferInfo;
    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::resetTransferCounter(uint32_t *status)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    if (status == NULL)
    {
        return kIOReturnError;
    }

    memoryWrite32(0x00, 0x00000010);

    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

#pragma mark 未実装
IOReturn PT1Device::incrementTransferCounter(uint32_t *status)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    if (status == NULL)
    {
        return kIOReturnError;
    }

    memoryWrite32(0x00, 0x00000020);

    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

IOReturn PT1Device::setStreamEnable(uint32_t *status, uint32_t tuner, ISDB isdb, bool enable)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x, enable = 0x%08x)\n",
//            getName(), this, __FUNCTION__, tuner, isdb, enable);

    if (status == NULL)
    {
        return kIOReturnError;
    }
    if ((tuner > 1) || (isdb >= ISDB_COUNT))
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    SetStream(_reg, (tuner * 2  + isdb), enable);
	_streamEnable[tuner * 2  + isdb] = enable;

    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

IOReturn PT1Device::getStreamEnable(uint32_t *status, uint32_t tuner, ISDB isdb, bool *enable)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, isdb);

    if ((status == NULL) || (enable == NULL))
    {
        return kIOReturnError;
    }
    if ((tuner > 1) || (isdb >= ISDB_COUNT))
    {
        return kIOReturnError;
    }

    *enable = _streamEnable[tuner * 2 + isdb];
    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

IOReturn PT1Device::setStreamGray(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t gray)
{
//  IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x, gray = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, isdb, gray);

    if (status == NULL)
    {
        return kIOReturnError;
    }
    if ((tuner > 1) || (isdb >= ISDB_COUNT) ||((1<<(3)) <= gray))
    {
        *status = kStatusParamError;
        return kIOReturnSuccess;
    }

    uint32_t index = tuner * 2 + isdb;
    uint32_t data = (BIT_1(1) << 3 | gray) << (4 * index);

    _streamGray[index] = gray;

    memoryWrite32(0x0c, data);

    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

IOReturn PT1Device::getStreamGray(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t *gray)
{
//    IOLog("%s[%p]::%s(tuner = 0x%08x, isdb = 0x%08x)\n", getName(), this, __FUNCTION__, tuner, isdb);

    if ((status == NULL) || (gray == NULL))
    {
        return kIOReturnError;
    }
    if ((tuner > 1) || (isdb >= ISDB_COUNT))
    {
        return kIOReturnError;
    }

    *gray = _streamGray[tuner * 2 + isdb];
    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

IOReturn PT1Device::setTransferEnable(uint32_t *status, bool enable)
{
//    IOLog("%s[%p]::%s(enable = 0x%08x)\n", getName(), this, __FUNCTION__, enable);

    if (status == NULL)
    {
        return kIOReturnError;
    }

    _transfer = enable;
    if (_transfer)
    {
        // 開始
        IOPhysicalAddress addr = _bmdAddress->getPhysicalSegment(0, NULL);
        memoryWrite32(0x14, (addr >> 12));
        memoryWrite32(0x00, 0x0c000040);
    }
    else
    {
        // 停止
        memoryWrite32(0x00, 0x08080000);
        for (uint i = 0; i < 10; ++i)
        {
            UInt32 val = memoryRead32(0x00);
            if (!(val & (1 << 6)))
            {
                break;
            }
            IOSleep(1);
        }
    }

    *status = kStatusSuccess;

    return kIOReturnSuccess;
}

IOReturn PT1Device::getTransferEnable(uint32_t *status, bool *enable)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    if ((status == NULL) || (enable == NULL))
    {
        return kIOReturnError;
    }

    *status = kStatusSuccess;
    *enable = _transfer;

    return kIOReturnSuccess;
}

    enum {
        kBIT_RAM_OVERFLOW = 3,
        kBIT_INITIATOR_ERROR,
        kBIT_INITIATOR_WARNING,
        kBIT_INITIATOR_BUSY
    };

#pragma mark 未実装
IOReturn PT1Device::getTransferInfo(uint32_t *status, TransferInfo *transferInfo)
{
//    IOLog("%s[%p]::%s()\n", getName(), this, __FUNCTION__);

    *status = kStatusNotImplemented;
    if ((status == NULL) || (transferInfo == NULL))
    {
        return kIOReturnError;
    }

    uint32_t data = memoryRead32(0x00);


    transferInfo->BufferOverflow   = BIT_SHIFT_MASK(data, kBIT_RAM_OVERFLOW     , 1);
    transferInfo->TransferCounter0 = BIT_SHIFT_MASK(data, kBIT_INITIATOR_ERROR  , 1);
    transferInfo->TransferCounter1 = BIT_SHIFT_MASK(data, kBIT_INITIATOR_WARNING, 1);
    //            InitiatorBusy    = BIT_SHIFT_MASK(data, kBIT_INITIATOR_BUSY   , 1);

    *status = kStatusSuccess;

    return kIOReturnSuccess;
}



