/*
 *  Dictionary.h
 */

#ifndef __DICTIONARY_H__
#define __DICTIONARY_H__

#ifdef __DICTIONARY_IMPL__
#import <Cocoa/Cocoa.h>
#endif

class Dictionary
{
private:
#ifdef __DICTIONARY_IMPL__
    bool init(NSDictionary *dictionary);
#endif
protected:
#ifdef __DICTIONARY_IMPL__
    id  _dict;
#endif
public:
    Dictionary();
    virtual ~Dictionary();
    bool init();
    bool init(Dictionary *dictionary);

    int integerForKey(const char *key);
    bool setIntegerForKey(int value, const char *key);
    Dictionary *dictionaryForKey(const char *key);
    bool setDictionaryForKey(Dictionary *dictionary, const char *key);
    bool boolForKey(const char *key);
    bool setBoolForKey(bool value, const char *key);
    char *stringForKey(const char *key);
    bool setStringForKey(const char *str, const char *key);
    bool setStringWithEncodingForKey(const char *str, const char *encoding, const char *key);

    void writeXmlData(int fd);
    void dump();
};

#endif