/*
 *  Dictionary.cpp
 */
#include <stdio.h>

#define __DICTIONARY_IMPL__
#include "Dictionary.h"

Dictionary::Dictionary()
{
    _dict = nil;
    init();
}

Dictionary::~Dictionary()
{
    [_dict release];
}

bool Dictionary::init()
{
    [_dict release];
    _dict = [[NSMutableDictionary alloc] initWithCapacity:0];
    return true;
}

bool Dictionary::init(NSDictionary *dictionary)
{
    [_dict release];
    _dict = [[NSMutableDictionary alloc] initWithDictionary:dictionary];
    return true;
}

bool Dictionary::init(Dictionary *dictionary)
{
    return init(dictionary->_dict);
}

int Dictionary::integerForKey(const char *key)
{
    int result = 0;
    if ((key != NULL) && (_dict != nil))
    {
        NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
        NSString *k = [NSString stringWithCString:key encoding:NSUTF8StringEncoding];
        if (k != nil)
        {
            result = [[_dict objectForKey:k] intValue];
        }
        [pool release];
    }
    return result;
}

bool Dictionary::setIntegerForKey(int value, const char *key)
{
    bool result = false;
    if (key != NULL)
    {
        NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
        NSNumber *v = [NSNumber numberWithInt:value];
        NSString *k = [NSString stringWithCString:key encoding:NSUTF8StringEncoding];
        if ((v != nil) && (k != nil))
        {
            [_dict setObject:v forKey:k];
            result = true;
        }
        [pool release];
    }
    return result;
}

Dictionary *Dictionary::dictionaryForKey(const char *key)
{
    Dictionary *result = NULL;
    if (key != NULL)
    {
        NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
        NSString *k = [NSString stringWithCString:key encoding:NSUTF8StringEncoding];
        if (k != nil)
        {
            id obj = [_dict objectForKey:k];
            if ((obj != nil) && [obj isKindOfClass:[NSDictionary class]])
            {
                Dictionary *r = new Dictionary();
                if (r->init(obj))
                {
                    result = r;
                }
                else
                {
                    delete r;
                }
            }
        }
        [pool release];
    }
    return result;
}

bool Dictionary::setDictionaryForKey(Dictionary *dictionary, const char *key)
{
    bool result = false;
    if ((dictionary != NULL) && (key != NULL))
    {
        if (dictionary->_dict != nil)
        {
            NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
            NSString *k = [NSString stringWithCString:key encoding:NSUTF8StringEncoding];
            if (k != nil)
            {
                [_dict setObject:dictionary->_dict forKey:k];
                result = true;
            }
            [pool release];
        }
    }
    return result;
}

bool Dictionary::boolForKey(const char *key)
{
    bool result = false;
    if (key != NULL)
    {
        NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
        NSString *k = [NSString stringWithCString:key encoding:NSUTF8StringEncoding];
        if (k != nil)
        {
            result = [[_dict objectForKey:k] boolValue];
        }
        [pool release];
    }
    return result;
}

bool Dictionary::setBoolForKey(bool value, const char *key)
{
    bool result = false;
    if (key != NULL)
    {
        NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
        NSString *k = [NSString stringWithCString:key encoding:NSUTF8StringEncoding];
        if (k != nil)
        {
            [_dict setObject:[NSNumber numberWithBool:value] forKey:k];
            result = true;
        }
        [pool release];
    }
    return result;
}

char *Dictionary::stringForKey(const char *key)
{
    char *result = NULL;
    if (key != NULL)
    {
        NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
        NSString *k = [NSString stringWithCString:key encoding:NSUTF8StringEncoding];
        if (k != nil)
        {
            NSString *s = [_dict objectForKey:k];
            if ((s != nil) && ![s isEqualToString:@""])
            {
                result = strdup([s cStringUsingEncoding:NSUTF8StringEncoding]);
            }
        }
        [pool release];
    }
    return result;
}

bool Dictionary::setStringForKey(const char *str, const char *key)
{
    bool result = false;
    if ((str != NULL) && (key != NULL))
    {
        NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
        NSString *s = [NSString stringWithCString:str encoding:NSUTF8StringEncoding];
        NSString *k = [NSString stringWithCString:key encoding:NSUTF8StringEncoding];
        if ((s != nil) && (k != nil))
        {
            [_dict setObject:s forKey:k];
            result = true;
        }
        [pool release];
    }
    return result;
}

bool Dictionary::setStringWithEncodingForKey(const char *str, const char *encoding, const char *key)
{
    bool result = false;
    if ((str != NULL) && (encoding != NULL) && (key != NULL))
    {
        NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
        NSStringEncoding enc = NSUTF8StringEncoding;
        if (strcmp("UTF-8", encoding) == 0)
        {
        }
        else if (strcmp("EUCJP", encoding) == 0)
        {
            enc = NSJapaneseEUCStringEncoding;
        }
        NSString *s = [NSString stringWithCString:str encoding:enc];
        NSString *k = [NSString stringWithCString:key encoding:NSUTF8StringEncoding];
        if ((s != nil) && (k != nil))
        {
            [_dict setObject:s forKey:k];
            result = true;
        }
        [pool release];
    }
    return result;
}

void Dictionary::writeXmlData(int fd)
{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];

    NSData *xmlData;
    NSString *error = nil;
    xmlData = [NSPropertyListSerialization dataFromPropertyList:_dict
                                                         format:NSPropertyListXMLFormat_v1_0
                                               errorDescription:&error];
    if (xmlData)
    {
        write(fd, [xmlData bytes], [xmlData length]);
    }
    [pool release];
}

void Dictionary::dump()
{
    NSLog(@"%@", _dict);
}

