package net.morilib.db.schema;

import java.io.IOException;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.fichier.Fichier;
import net.morilib.db.fichier.SandboxBaseFichier;

public abstract class SqlSchemaFactory {

	private static final String URI_T = "jdbc:relations:error";
	private static final String URI_S = "jdbc:relations:sandbox";
	private static final Pattern URI_LOCAL = Pattern.compile(
			"jdbc:relations://(/([^:/,]+/)+)");

	private static final SqlSchemaFactory
	_FAC = new SqlSchemaFactory() {

		@Override
		public SqlSchema getByURL(
				String url) throws IOException, SQLException {
			FabriqueDeFichier f;
			Matcher m;

			if(url.equals(URI_T)) {
				return MemorySqlSchema.readProperties(
						"ERROR_MSG",
						"CODE",
						"MESSAGE",
						SqlSchemaFactory.class.getResourceAsStream(
								"/net/morilib/db/misc/relations_errors.properties"));
			} else if(url.equals(URI_S)) {
				f = new SandboxBaseFichier();
				return new FileSqlSchema(f, (Fichier)f);
			} else if((m = URI_LOCAL.matcher(url)).matches()) {
				f = FabriqueDeFichier.getDefault();
				return new FileSqlSchema(f, f.newInstance(m.group(1)));
			}
			return null;
		}

	};

	SqlSchemaFactory() { }

	/**
	 * 
	 * @return
	 */
	public static SqlSchemaFactory getInstance() {
		return _FAC;
	}

	/**
	 * 
	 * @param url
	 * @return
	 */
	public abstract SqlSchema getByURL(
			String url) throws IOException, SQLException;

}
