/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import net.morilib.db.engine.SqlEngine;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.dml.SqlSelectDistinct;

public interface Relation {

	/**
	 * 
	 * @return
	 */
	public RelationCursor iterator();

	/**
	 * 
	 * @return
	 */
	public List<SqlColumnDefinition> getColumnNames();

	/**
	 * 
	 * @return
	 */
	public SqlColumnDefinition getDefinition(String name);

	/**
	 * 
	 * @param names
	 * @return
	 * @throws SQLException
	 */
	public Relation project(List<String> names) throws SQLException;

	/**
	 * 
	 * @param v
	 * @param f
	 * @param pred
	 * @param m
	 * @param d
	 * @param c
	 * @param group
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	public Relation select(SqlEngine v, SqlSchema f,
			RelationExpression pred, RelationAggregate m,
			SqlSelectDistinct d, RelationTuple c,
			List<String> group,
			List<Object> h) throws IOException, SQLException;

}
