/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import net.morilib.db.delay.Delay;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;

public class RelationTernaryOperate extends RelationExpression {

	//
	private RelationTernaryOperator op;
	private RelationExpression pa, pb, pc;

	public RelationTernaryOperate(RelationTernaryOperator o,
			RelationExpression a, RelationExpression b,
			RelationExpression c) {
		op = o;
		pa = a;  pb = b;  pc = c;
	}

	@Override
	public Object eval(SqlEngine v, SqlSchema f,
			RelationTuple tuple, RelationAggregate m,
			List<String> group,
			List<Object> h) throws IOException, SQLException {
		final Object o, p, q;

		o = pa.eval(v, f, tuple, m, group, h);
		p = pb.eval(v, f, tuple, m, group, h);
		q = pc.eval(v, f, tuple, m, group, h);
		if(o instanceof Delay) {
			return o;
		} else if(p instanceof Delay) {
			return p;
		} else if(q instanceof Delay) {
			return q;
		} else {
			return op.op(o, p, q);
		}
	}

	@Override
	public boolean isAggregate() throws SQLException {
		return pa.isAggregate() || pb.isAggregate() ||
				pc.isAggregate();
	}

	@Override
	public Object init(SqlEngine v, SqlSchema f) throws SQLException {
		final Object o, p, q;

		o = pa.init(v, f);
		p = pb.init(v, f);
		q = pc.init(v, f);
		if(o instanceof Delay && p instanceof Delay &&
				q instanceof Delay) {
			return new Delay() {

				@Override
				public Object force() throws SQLException {
					return op.op(((Delay)o).force(),
							((Delay)p).force(),
							((Delay)q).force());
				}

				@Override
				public void add(Object... args) throws SQLException {
					((Delay)o).add(args);
					((Delay)p).add(args);
					((Delay)q).add(args);
				}

			};
		} else if(o instanceof Delay && p instanceof Delay) {
			return new Delay() {

				@Override
				public Object force() throws SQLException {
					return op.op(
							((Delay)o).force(), ((Delay)p).force(), q);
				}

				@Override
				public void add(Object... args) throws SQLException {
					((Delay)o).add(args);
					((Delay)p).add(args);
				}

			};
		} else if(o instanceof Delay && q instanceof Delay) {
			return new Delay() {

				@Override
				public Object force() throws SQLException {
					return op.op(
							((Delay)o).force(), p, ((Delay)q).force());
				}

				@Override
				public void add(Object... args) throws SQLException {
					((Delay)o).add(args);
					((Delay)q).add(args);
				}

			};
		} else if(p instanceof Delay && q instanceof Delay) {
			return new Delay() {

				@Override
				public Object force() throws SQLException {
					return op.op(
							o, ((Delay)p).force(), ((Delay)q).force());
				}

				@Override
				public void add(Object... args) throws SQLException {
					((Delay)p).add(args);
					((Delay)q).add(args);
				}

			};
		} else if(o instanceof Delay) {
			return new Delay() {

				@Override
				public Object force() throws SQLException {
					return op.op(((Delay)o).force(), p, q);
				}

				@Override
				public void add(Object... args) throws SQLException {
					((Delay)o).add(args);
				}

			};
		} else if(p instanceof Delay) {
			return new Delay() {

				@Override
				public Object force() throws SQLException {
					return op.op(o, ((Delay)p).force(), q);
				}

				@Override
				public void add(Object... args) throws SQLException {
					((Delay)p).add(args);
				}

			};
		} else if(q instanceof Delay) {
			return new Delay() {

				@Override
				public Object force() throws SQLException {
					return op.op(o, p, ((Delay)q).force());
				}

				@Override
				public void add(Object... args) throws SQLException {
					((Delay)q).add(args);
				}

			};
		} else {
			return op.op(o, p, q);
		}
	}

}
