/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.schema;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;

import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.NullBoolean;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public class ReadonlySqlSchema implements SqlSchema {

	private SqlSchema wrap;

	/**
	 * 
	 * @param w
	 */
	public ReadonlySqlSchema(SqlSchema w) {
		wrap = w;
	}

	@Override
	public NamedRelation readRelation(String name,
			String as) throws IOException, SQLException {
		return wrap.readRelation(name, as);
	}

	@Override
	public void writeRelation(String name,
			Collection<RelationTuple> z
			) throws IOException, SQLException {
		throw ErrorBundle.getDefault(10017);
	}

	@Override
	public SqlCreateTable getCreateTable(
			String name) throws IOException, SQLException {
		return wrap.getCreateTable(name);
	}

	@Override
	public boolean isTable(
			String name) throws IOException, SQLException {
		return wrap.isTable(name);
	}

	@Override
	public void putCreateTable(String name,
			SqlCreateTable table) throws IOException, SQLException {
		throw ErrorBundle.getDefault(10017);
	}

	@Override
	public Collection<String> getTableNames(
			) throws IOException, SQLException {
		return wrap.getTableNames();
	}

	@Override
	public void truncateTable(
			String name) throws IOException, SQLException {
		throw ErrorBundle.getDefault(10017);
	}

	@Override
	public void removeCreateTable(
			String name) throws IOException, SQLException {
		throw ErrorBundle.getDefault(10017);
	}

	@Override
	public void alterCreateTable(String name,
			SqlCreateTable table) throws IOException, SQLException {
		throw ErrorBundle.getDefault(10017);
	}

	@Override
	public SqlSchema fork() {
		return new ReadonlySqlSchema(wrap.fork());
	}

	@Override
	public NullBoolean isReadonly() {
		return NullBoolean.TRUE;
	}

	@Override
	public NullBoolean usesLocalFiles() {
		return wrap.usesLocalFiles();
	}

	@Override
	public NullBoolean usesLocalFilePerTable() {
		return wrap.usesLocalFilePerTable();
	}

	@Override
	public FabriqueDeFichier fabrique() {
		return wrap.fabrique();
	}

	@Override
	public void bindSchema(String name, Relation r) {
		wrap.bindSchema(name, r);
	}

}
