/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlSelect implements SqlSetExpression {

	//
	private List<SqlTableColumn> data;
	private List<SqlRelation> tables;
	private SqlExpression where;
	private List<String> groupby;
	private SqlExpression having;
	private List<SqlOrderBy> orderby;
	private SqlSelectDistinct distinct;

	SqlSelect(List<SqlTableColumn> data, SqlSelectDistinct d,
			List<SqlRelation> tables, SqlExpression where,
			List<String> groupby, SqlExpression having,
			List<SqlOrderBy> orderby, int dum) {
		this.data = data;
		this.tables = tables;
		this.where = where;
		this.groupby = groupby;
		this.having = having;
		this.orderby = orderby;
		this.distinct = d;
	}

	public SqlSelect(List<SqlTableColumn> data, SqlSelectDistinct d,
			List<SqlRelation> tables, SqlExpression where,
			List<String> groupby, SqlExpression having,
			List<SqlOrderBy> orderby) {
		this(new ArrayList<SqlTableColumn>(data), d,
				tables != null ?
						new ArrayList<SqlRelation>(tables) : null,
				where,
				groupby != null ?
						new ArrayList<String>(groupby) : null,
				having,
				orderby != null ?
						new ArrayList<SqlOrderBy>(orderby) : null,
				72);
	}

	public List<SqlTableColumn> getData() {
		return Collections.unmodifiableList(data);
	}

	public List<SqlRelation> getTables() {
		if(tables != null) {
			return Collections.unmodifiableList(tables);
		} else {
			return null;
		}
	}

	public SqlExpression getWhere() {
		return where;
	}

	public List<String> getGroupby() {
		if(groupby != null) {
			return Collections.unmodifiableList(groupby);
		} else {
			return null;
		}
	}

	public SqlExpression getHaving() {
		return having;
	}

	public List<SqlOrderBy> getOrderby() {
		if(orderby != null) {
			return Collections.unmodifiableList(orderby);
		} else {
			return null;
		}
	}

	/**
	 * @return the distinct
	 */
	public SqlSelectDistinct getDistinct() {
		return distinct;
	}

	public String toString() {
		StringBuffer b = new StringBuffer("(select ");
		char d;

		d = '(';
		for(SqlTableColumn c : data) {
			b.append(d).append(c);  d = ' ';
		}
		b.append(") ");

		if(tables != null && tables.size() > 0) {
			d = '(';
			for(SqlRelation c : tables) {
				b.append(d).append(c);  d = ' ';
			}
			b.append(") ");
		} else {
			b.append("#f ");
		}

		if(where != null) {
			b.append(where).append(' ');
		} else {
			b.append("#t ");
		}

		if(groupby != null && groupby.size() > 0) {
			d = '(';
			for(String c : groupby) {
				b.append(d).append(c);  d = ' ';
			}
			b.append(") ");
		} else {
			b.append("#f ");
		}

		if(having != null) {
			b.append(having).append(' ');
		} else {
			b.append("#t ");
		}

		if(orderby != null && orderby.size() > 0) {
			d = '(';
			for(SqlOrderBy c : orderby) {
				b.append(d).append(c);  d = ' ';
			}
			b.append("))");
		} else {
			b.append("#f)");
		}
		return b.toString();
	}

}
