/**
 * 
 */
package saccubus.info;

import java.util.Properties;

/**
 * @author PSI
 *
 */
public class NetworkInfo implements Info {
	public NetworkInfo() {
	}
	/**
	 * @param useProxy
	 * @param proxy
	 * @param proxyPort
	 */
	public NetworkInfo(boolean useProxy, String proxy, int proxyPort) {
		UseProxy = useProxy;
		Proxy = proxy;
		ProxyPort = proxyPort;
	}

	/**
	 * o[A萔`
	 */
	//vLV͎ǵH
	private boolean UseProxy;
	private final static boolean DefUseProxy = false;
	private final static String PropUseProxy = "UseProxy";
	//vLṼAhX́H
	private String Proxy;
	private final static String DefProxy = "127.0.0.1";
	private final static String PropProxy = "Proxy";
	//vLṼ|[ǵH
	private int ProxyPort;
	private final static int DefProxyPort = 8080;
	private final static String PropProxyPort = "ProxyPort";
	
	/**
	 * \bh`
	 */
	
	/* (non-Javadoc)
	 * @see saccubus.info.Info#loadInfo(java.util.Properties)
	 */
	public boolean loadInfo(Properties prop) {
		String str;
		//vLV͎ǵH
		str = prop.getProperty(PropUseProxy);
		if(str != null){
			UseProxy = Boolean.parseBoolean(str);
		}else{
			UseProxy = DefUseProxy;
		}
		//vLṼAhX́H
		str = prop.getProperty(PropProxy);
		if(str != null){
			Proxy = str;
		}else{
			Proxy = DefProxy;
		}
		
		//vLṼ|[ǵH
		str = prop.getProperty(PropProxyPort);
		if(str != null){
			try {
				ProxyPort = Integer.parseInt(str);
			} catch (NumberFormatException e) {
				ProxyPort = -1;
			}
		}else{
			ProxyPort = DefProxyPort;
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see saccubus.info.Info#saveInfo(java.util.Properties)
	 */
	public boolean saveInfo(Properties prop) {
		//vLV͎ǵH
		prop.setProperty(PropUseProxy, Boolean.toString(UseProxy));
		//vLṼAhX́H
		prop.setProperty(PropProxy, Proxy);
		//vLṼ|[ǵH
		prop.setProperty(PropProxyPort, Integer.toString(ProxyPort));
		return true;
	}
	/**
	 * @return proxy
	 */
	public String getProxy() {
		return Proxy;
	}
	/**
	 * @return proxyPort
	 */
	public int getProxyPort() {
		return ProxyPort;
	}
	/**
	 * @return useProxy
	 */
	public boolean isUseProxy() {
		return UseProxy;
	}
	/**
	 * @param proxy ݒ肷 proxy
	 */
	public void setProxy(String proxy) {
		Proxy = proxy;
	}
	/**
	 * @param proxyPort ݒ肷 proxyPort
	 */
	public void setProxyPort(int proxyPort) {
		ProxyPort = proxyPort;
	}
	/**
	 * @param useProxy ݒ肷 useProxy
	 */
	public void setUseProxy(boolean useProxy) {
		UseProxy = useProxy;
	}
}
