/**
 * 
 */
package saccubus.process.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import saccubus.info.NetworkInfo;
import saccubus.info.NicoInfo;

/**
 * @author PSI
 *
 */
public class ConnectionMaker {
	private Proxy Proxy;
	private NicoCookie Cookie;
	/**
	 * @param netInfo
	 */
	public ConnectionMaker(NicoInfo nicoInfo,NetworkInfo netInfo) {
		Proxy = new Proxy(netInfo);
		Cookie = new NicoCookie(nicoInfo,this);
	}
	/**
	 * |Xg𗘗pRlNV͂
	 * @param url
	 * @param post
	 * @return
	 */
	protected Connection makeConnection(boolean last_failed, String url,String post){
		return makeConnection(last_failed, true,true,url,post);
	}
	/**
	 * |Xg𗘗pNbL[pȂRlNV𒣂
	 * @param last_failed
	 * @param follow_redirect
	 * @param url
	 * @param post
	 * @return
	 */
	protected Connection makeConnection(boolean last_failed, boolean follow_redirect,String url,String post){
		return makeConnection(last_failed, false, follow_redirect,url,post);
	}
	/**
	 * |Xg𗘗pRlNV͂
	 * @param use_cookie
	 * @param url
	 * @param post
	 * @return
	 */
	protected Connection makeConnection(boolean last_failed, boolean use_cookie,boolean follow_redirect,String url,String post){
		try {
			HttpURLConnection con;
			con = (HttpURLConnection) (new URL(url)).openConnection(Proxy.getProxy());
			con.setInstanceFollowRedirects(follow_redirect);
			//NGXg[h̐ݒ
			con.setDoOutput(true);
			con.setDoInput(true);
			con.setRequestMethod("POST");
			//jRjR̃TCgȂ΃NbL[ݒ肷B
			if(checkNicoURL(url)){
				String cookie = Cookie.getCookie(last_failed);
				if(cookie == null){
					return null;
				}
				con.addRequestProperty("Cookie", cookie);
			}
			//RlNV͖؂Ăǂ񂶂ȂȂB
			con.addRequestProperty("Connection", "close");
			con.connect();
			//POSTf[^
			OutputStream os = con.getOutputStream();
			os.write(url.getBytes("UTF-8"));
			os.flush();
			os.close();
			//X|XR[h̎擾
			int rescode = con.getResponseCode();
			if (rescode != HttpURLConnection.HTTP_OK) {
				return null;
			}else if(rescode >= 300 && rescode < 400){
				//Input == null̓_CNg킷
				return new Connection(con,null,-1);
			}
			InputStream is = con.getInputStream();
			//t@C̒擾B
			String content_length_str = con.getHeaderField("Content-length");
			int max_size = -1;
			if (content_length_str != null && !content_length_str.equals("")) {
				try {
					max_size = Integer.parseInt(content_length_str);
				} catch (NumberFormatException e) {
					max_size = -1;
				}
			}
			//IuWFNg𐶐ĕԂ
			return new Connection(con,is,max_size);
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (ProtocolException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * GET𗘗pRlNV𒣂
	 * @param url
	 * @return
	 */
	public Connection makeConnection(boolean last_failed, String url){
		return makeConnection(last_failed,true,true,url);
	}
	/**
	 * GET𗘗pNbL[pȂRlNV𒣂
	 * @param url
	 * @return
	 */
	protected Connection makeConnection(boolean last_failed,boolean follow_redirect, String url){
		return makeConnection(last_failed,follow_redirect,url);
	}
	/**
	 * GET𗘗pRlNV𒣂
	 * @param url
	 * @return
	 */
	protected Connection makeConnection(boolean last_failed, boolean use_proxy, boolean follow_redirect, String url){
		HttpURLConnection con;
		try {
			con = (HttpURLConnection) (new URL(url)).openConnection(Proxy.getProxy());
			con.setInstanceFollowRedirects(follow_redirect);
			//o͂̂
			con.setDoInput(true);
			con.setRequestMethod("GET");
			//jRjRȂ΃NbL[
			if(checkNicoURL(url)){
				String cookie = Cookie.getCookie(last_failed);
				if(cookie == null){
					return null;
				}
				con.addRequestProperty("Cookie", cookie);
			}
			//RlNV͖؂鎖ɂĂB
			con.addRequestProperty("Connection", "close");
			//ڑăX|XR[h̎擾
			con.connect();
			int rescode = con.getResponseCode();
			if (rescode != HttpURLConnection.HTTP_OK) {
				return null;
			}else if(rescode >= 300 && rescode < 400){
				//Input == null̓_CNg킷
				return new Connection(con,null,-1);
			}
			InputStream is = con.getInputStream();
			//t@C̒擾B
			String content_length_str = con.getHeaderField("Content-length");
			int max_size = -1;
			if (content_length_str != null && !content_length_str.equals("")) {
				try {
					max_size = Integer.parseInt(content_length_str);
				} catch (NumberFormatException e) {
					max_size = -1;
				}
			}
			//IuWFNg𐶐ĕԂ
			return new Connection(con,is,max_size);
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (ProtocolException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * URLjRjRAX}CrfIǂ̃`FbN
	 * @param url
	 * @return
	 */
	private static boolean checkNicoURL(String url){
		url = url.toLowerCase();
		if(!url.startsWith("http://")){
			return false;
		}
		int idx = url.indexOf("/",7);
		if(url.indexOf(NicoUtil.NICO_DOMAIN) < idx){
			return true;
		}
		return false;
	}
}
