﻿// //////////////////////////////////////////////////////////////////////////
//
// HResult.cs
//              Sarbo Project
//          Powerd by CACTUS SOFTWARE <http://www.cactussoft.co.jp/>
//
//                                              ver 1.0  2009/08/28
// This file is part of Sarbo.
//
// Sarbo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Sarbo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Sarbo.  If not, see <http://www.gnu.org/licenses/>.
//
// //////////////////////////////////////////////////////////////////////////
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;

namespace DShowCAC
{
	/// <summary>
	/// HResult
	/// </summary>
    [ComVisible(false)]
	public class HResult
	{
		public static bool Succeeded(int hr)
		{
			return (hr >= 0) ? true : false;
		}

		public static bool Failed(int hr)
		{
			return (hr < 0) ? true : false;
		}

		public const int	OK = 0x0;
        public const int	False = 0x1;

		public const int	Unexpected    = unchecked((int)0x8000FFFF);
		public const int	NotImpl       = unchecked((int)0x80004001);
		public const int	OutOfMemory   = unchecked((int)0x8007000E);
		public const int	InvalidArg    = unchecked((int)0x80070057);
		public const int	NoInterface   = unchecked((int)0x80004002);
		public const int	Pointer       = unchecked((int)0x80004003);
		public const int	Handle        = unchecked((int)0x80070006);
		public const int	Abort         = unchecked((int)0x80004004);
		public const int	Fail          = unchecked((int)0x80004005);
		public const int	AccessDenied  = unchecked((int)0x80070005);

        public const int	VfwENotConnected = unchecked((int)0x80040209);
	}
}

// //////////////////////////////////////////////////////////////////////////
