﻿// //////////////////////////////////////////////////////////////////////////
//
// strmif.cs
//              Sarbo Project
//          Powerd by CACTUS SOFTWARE <http://www.cactussoft.co.jp/>
//
//                                              ver 1.0  2009/08/15
// This file is part of Sarbo.
//
// Sarbo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Sarbo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Sarbo.  If not, see <http://www.gnu.org/licenses/>.
//
// //////////////////////////////////////////////////////////////////////////
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;

namespace DShowCAC
{
	// //////////////////////////////////////////////////////////////////////
	// ICreateDevEnum
	// DShowNET support

	#region "ICreateDevEnum C++ version"
	//MIDL_INTERFACE("29840822-5B84-11D0-BD3B-00A0C911CE86")
	//ICreateDevEnum : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE CreateClassEnumerator( 
	//        /* [in] */ REFCLSID clsidDeviceClass,
	//        /* [out] */ IEnumMoniker **ppEnumMoniker,
	//        /* [in] */ DWORD dwFlags) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("29840822-5B84-11D0-BD3B-00A0C911CE86")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ICreateDevEnum
    {
		[PreserveSig]
		int CreateClassEnumerator(
			[In] ref Guid			clsidDeviceClass,
			[Out] out IEnumMoniker	ppEnumMoniker,
			CdefDevMon				dwFlags);
	}

	[Flags]
	public enum CdefDevMon : uint
	{
		CmgrDevice		= 0x0010,
		DMO				= 0x0020,
		PnpDevice		= 0x0040,
		Filter			= 0x0080,
		SelectiveMask	= 0x00f0,
	}

	// //////////////////////////////////////////////////////////////////////
	// IPin
	// DShowNET support

	#region "IPin C++ version"
	//MIDL_INTERFACE("56a86891-0ad4-11ce-b03a-0020af0ba770")
	//IPin : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Connect( 
	//        /* [in] */ IPin *pReceivePin,
	//        /* [in] */ const AM_MEDIA_TYPE *pmt) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE ReceiveConnection( 
	//        /* [in] */ IPin *pConnector,
	//        /* [in] */ const AM_MEDIA_TYPE *pmt) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Disconnect( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE ConnectedTo( 
	//        /* [out] */ IPin **pPin) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE ConnectionMediaType( 
	//        /* [out] */ AM_MEDIA_TYPE *pmt) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE QueryPinInfo( 
	//        /* [out] */ PIN_INFO *pInfo) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE QueryDirection( 
	//        /* [out] */ PIN_DIRECTION *pPinDir) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE QueryId( 
	//        /* [out] */ LPWSTR *Id) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE QueryAccept( 
	//        /* [in] */ const AM_MEDIA_TYPE *pmt) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE EnumMediaTypes( 
	//        /* [out] */ IEnumMediaTypes **ppEnum) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE QueryInternalConnections( 
	//        /* [out] */ IPin **apPin,
	//        /* [out][in] */ ULONG *nPin) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE EndOfStream( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE BeginFlush( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE EndFlush( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE NewSegment( 
	//        /* [in] */ REFERENCE_TIME tStart,
	//        /* [in] */ REFERENCE_TIME tStop,
	//        /* [in] */ double dRate) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a86891-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IPin
	{
		[PreserveSig]
		int Connect(
			IPin pReceivePin,
			[In, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);

		[PreserveSig]
		int ReceiveConnection(
			IPin pReceivePin,
			[In, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);

		[PreserveSig]
		int Disconnect();

		[PreserveSig]
		int ConnectedTo([Out] out IPin ppPin);

		[PreserveSig]
		int ConnectionMediaType(
			[Out, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);

		[PreserveSig]
		int QueryPinInfo([Out, MarshalAs(UnmanagedType.LPStruct)] PinInfo pInfo);

		[PreserveSig]
		int QueryDirection([Out] out PinDirection pPinDir);

		[PreserveSig]
		int QueryId([Out, MarshalAs(UnmanagedType.LPWStr)] out string Id);

		[PreserveSig]
		int QueryAccept(
			[In, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);

		[PreserveSig]
		int EnumMediaTypes([Out] out IEnumMediaTypes ppEnum);

		[PreserveSig]
		int QueryInternalConnections([Out] out IPin apPin, [In, Out] ref int nPin);

		[PreserveSig]
		int EndOfStream();

		[PreserveSig]
		int BeginFlush();

		[PreserveSig]
		int EndFlush();

		[PreserveSig]
		int NewSegment(long tStart, long tStop, double dRate);
	}

	// //////////////////////////////////////////////////////////////////////
	// IEnumPins
	// DShowNET support

	#region "IEnumPins C++ version"
	//MIDL_INTERFACE("56a86892-0ad4-11ce-b03a-0020af0ba770")
	//IEnumPins : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Next( 
	//        /* [in] */ ULONG cPins,
	//        /* [size_is][out] */ IPin **ppPins,
	//        /* [out] */ ULONG *pcFetched) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Skip( 
	//        /* [in] */ ULONG cPins) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Reset( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Clone( 
	//        /* [out] */ IEnumPins **ppEnum) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a86892-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IEnumPins
	{
		[PreserveSig]
		int Next(
			int cPins,
			[Out, MarshalAs(UnmanagedType.LPArray)] IPin[] ppPins,
			[Out] out int pcFetched);

		[PreserveSig]
		int Skip(int cPins);

		[PreserveSig]
		int Reset();

		[PreserveSig]
		int Clone([Out] out IEnumPins ppEnum);
	}

	// //////////////////////////////////////////////////////////////////////
	// IEnumMediaTypes

	#region "IEnumMediaTypes C++ version"
	//MIDL_INTERFACE("89c31040-846b-11ce-97d3-00aa0055595a")
	//IEnumMediaTypes : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Next( 
	//        /* [in] */ ULONG cMediaTypes,
	//        /* [size_is][out] */ AM_MEDIA_TYPE **ppMediaTypes,
	//        /* [out] */ ULONG *pcFetched) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Skip( 
	//        /* [in] */ ULONG cMediaTypes) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Reset( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Clone( 
	//        /* [out] */ IEnumMediaTypes **ppEnum) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("89c31040-846b-11ce-97d3-00aa0055595a")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IEnumMediaTypes
    {
		[PreserveSig]
		int Next(
			int cMediaTypes,
			[Out, MarshalAs(UnmanagedType.LPArray)] AMMediaType[] ppMediaTypes,
			[Out] out int pcFetched);

		[PreserveSig]
		int Skip(int cMediaTypes);

		[PreserveSig]
		int Reset();

		[PreserveSig]
		int Clone([Out] out IEnumMediaTypes ppEnum);
	}

	// //////////////////////////////////////////////////////////////////////
	// IFilterGraph
	// DShowNET support

	#region "IFilterGraph C++ version"
	//MIDL_INTERFACE("56a8689f-0ad4-11ce-b03a-0020af0ba770")
	//IFilterGraph : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE AddFilter( 
	//        /* [in] */ IBaseFilter *pFilter,
	//        /* [string][in] */ LPCWSTR pName) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE RemoveFilter( 
	//        /* [in] */ IBaseFilter *pFilter) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE EnumFilters( 
	//        /* [out] */ IEnumFilters **ppEnum) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE FindFilterByName( 
	//        /* [string][in] */ LPCWSTR pName,
	//        /* [out] */ IBaseFilter **ppFilter) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE ConnectDirect( 
	//        /* [in] */ IPin *ppinOut,
	//        /* [in] */ IPin *ppinIn,
	//        /* [unique][in] */ const AM_MEDIA_TYPE *pmt) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Reconnect( 
	//        /* [in] */ IPin *ppin) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Disconnect( 
	//        /* [in] */ IPin *ppin) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetDefaultSyncSource( void) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a8689f-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IFilterGraph
	{
		[PreserveSig]
		int AddFilter(
			IBaseFilter pFilter,
			[MarshalAs(UnmanagedType.LPWStr)] string pName);

		[PreserveSig]
		int RemoveFilter(IBaseFilter pFilter);

		[PreserveSig]
		int EnumFilters([Out] out IEnumFilters ppEnum);

		[PreserveSig]
		int FindFilterByName(
			[MarshalAs(UnmanagedType.LPWStr)] string pName,
			[Out] out IBaseFilter ppFilter);

		[PreserveSig]
		int ConnectDirect(
			IPin ppinOut,
			IPin ppinIn,
			[In, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);

		[PreserveSig]
		int Reconnect(IPin ppin);

		[PreserveSig]
		int Disconnect(IPin ppin);

		[PreserveSig]
		int SetDefaultSyncSource();
	}

	// //////////////////////////////////////////////////////////////////////
	// IEnumFilters
	// DShowNET support

	#region "IEnumFilters C++ version"
	//MIDL_INTERFACE("56a86893-0ad4-11ce-b03a-0020af0ba770")
	//IEnumFilters : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Next( 
	//        /* [in] */ ULONG cFilters,
	//        /* [out] */ IBaseFilter **ppFilter,
	//        /* [out] */ ULONG *pcFetched) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Skip( 
	//        /* [in] */ ULONG cFilters) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Reset( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Clone( 
	//        /* [out] */ IEnumFilters **ppEnum) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a86893-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IEnumFilters
	{
		[PreserveSig]
		int Next(
			int cFilters,
			[Out, MarshalAs(UnmanagedType.LPArray)] IBaseFilter[] ppFilter,
			[Out] out int pcFetched);

		[PreserveSig]
		int Skip(int cFilters);

		[PreserveSig]
		int Reset();

		[PreserveSig]
		int Clone([Out] out IEnumFilters ppEnum);
	}

	// //////////////////////////////////////////////////////////////////////
	// IMediaFilter
	// DShowNET support

	#region "IMediaFilter C++ version"
	//MIDL_INTERFACE("56a86899-0ad4-11ce-b03a-0020af0ba770")
	//IMediaFilter : public IPersist
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Stop( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Pause( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Run( 
	//        REFERENCE_TIME tStart) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetState( 
	//        /* [in] */ DWORD dwMilliSecsTimeout,
	//        /* [out] */ FILTER_STATE *State) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetSyncSource( 
	//        /* [in] */ IReferenceClock *pClock) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetSyncSource( 
	//        /* [out] */ IReferenceClock **pClock) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a86899-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IMediaFilter
	{
		#region "IPersist Methods"
		[PreserveSig]
		int GetClassID([Out] out Guid pClassID);
		#endregion

		[PreserveSig]
		int Stop();

		[PreserveSig]
		int Pause();

		[PreserveSig]
		int Run(long tStart);

		[PreserveSig]
		int GetState(int dwMilliSecsTimeout, [Out] out FilterState State);

		[PreserveSig]
		int SetSyncSource(IReferenceClock pClock);

		[PreserveSig]
		int GetSyncSource([Out] out IReferenceClock pClock);
	}

	// //////////////////////////////////////////////////////////////////////
	// IBaseFilter
	// DShowNET support

	#region "IBaseFilter C++ version"
	//MIDL_INTERFACE("56a86895-0ad4-11ce-b03a-0020af0ba770")
	//IBaseFilter : public IMediaFilter
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE EnumPins( 
	//        /* [out] */ IEnumPins **ppEnum) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE FindPin( 
	//        /* [string][in] */ LPCWSTR Id,
	//        /* [out] */ IPin **ppPin) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE QueryFilterInfo( 
	//        /* [out] */ FILTER_INFO *pInfo) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE JoinFilterGraph( 
	//        /* [in] */ IFilterGraph *pGraph,
	//        /* [string][in] */ LPCWSTR pName) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE QueryVendorInfo( 
	//        /* [string][out] */ LPWSTR *pVendorInfo) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a86895-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IBaseFilter
	{
		#region "IPersist Methods"
		[PreserveSig]
		int GetClassID([Out] out Guid pClassID);
		#endregion

		#region "IMediaFilter Methods"
		[PreserveSig]
		int Stop();

		[PreserveSig]
		int Pause();

		[PreserveSig]
		int Run(long tStart);

		[PreserveSig]
		int GetState(int dwMilliSecsTimeout, [Out] out FilterState State);

		[PreserveSig]
		int SetSyncSource(IReferenceClock pClock);

		[PreserveSig]
		int GetSyncSource([Out] out IReferenceClock pClock);
		#endregion

		[PreserveSig]
		int EnumPins(
			[Out] out IEnumPins ppEnum);

		[PreserveSig]
		int FindPin(
			[MarshalAs(UnmanagedType.LPWStr)] string Id,
			[Out] out IPin ppPin);

		[PreserveSig]
		int QueryFilterInfo(
			[Out, MarshalAs(UnmanagedType.LPStruct)] FilterInfo pInfo);

		[PreserveSig]
		int JoinFilterGraph(
			IFilterGraph pGraph,
			[MarshalAs(UnmanagedType.LPWStr)] string pName);

		[PreserveSig]
		int QueryVendorInfo(
			[MarshalAs(UnmanagedType.LPWStr)] out string pVendorInfo);
	}

	// //////////////////////////////////////////////////////////////////////
	// IReferenceClock
	// DShowNET support

	#region "IReferenceClock C++ version"
	//MIDL_INTERFACE("56a86897-0ad4-11ce-b03a-0020af0ba770")
	//IReferenceClock : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE GetTime( 
	//        /* [out] */ REFERENCE_TIME *pTime) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE AdviseTime( 
	//        /* [in] */ REFERENCE_TIME baseTime,
	//        /* [in] */ REFERENCE_TIME streamTime,
	//        /* [in] */ HEVENT hEvent,
	//        /* [out] */ DWORD_PTR *pdwAdviseCookie) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE AdvisePeriodic( 
	//        /* [in] */ REFERENCE_TIME startTime,
	//        /* [in] */ REFERENCE_TIME periodTime,
	//        /* [in] */ HSEMAPHORE hSemaphore,
	//        /* [out] */ DWORD_PTR *pdwAdviseCookie) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Unadvise( 
	//        /* [in] */ DWORD_PTR dwAdviseCookie) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a86897-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IReferenceClock
	{
		[PreserveSig]
		int GetTime([Out] out long pTime);

		[PreserveSig]
		int AdviseTime(long baseTime, long streamTime, IntPtr hEvent, [Out] out int pdwAdviseCookie);

		[PreserveSig]
		int AdvisePeriodic(long startTime, long periodTime, IntPtr hSemaphore, [Out] out int pdwAdviseCookie);

		[PreserveSig]
		int Unadvise(int dwAdviseCookie);
	}

	// //////////////////////////////////////////////////////////////////////
	// IReferenceClockTimerControl

	// //////////////////////////////////////////////////////////////////////
	// IReferenceClock2

	// //////////////////////////////////////////////////////////////////////
	// IMediaSample
	// DShowNET support

	#region "IMediaSample C++ version"
	//MIDL_INTERFACE("56a8689a-0ad4-11ce-b03a-0020af0ba770")
	//IMediaSample : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE GetPointer( 
	//        /* [out] */ BYTE **ppBuffer) = 0;
        
	//    virtual long STDMETHODCALLTYPE GetSize( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetTime( 
	//        /* [out] */ REFERENCE_TIME *pTimeStart,
	//        /* [out] */ REFERENCE_TIME *pTimeEnd) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetTime( 
	//        /* [in] */ REFERENCE_TIME *pTimeStart,
	//        /* [in] */ REFERENCE_TIME *pTimeEnd) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE IsSyncPoint( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetSyncPoint( 
	//        BOOL bIsSyncPoint) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE IsPreroll( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetPreroll( 
	//        BOOL bIsPreroll) = 0;
        
	//    virtual long STDMETHODCALLTYPE GetActualDataLength( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetActualDataLength( 
	//        long __MIDL_0010) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetMediaType( 
	//        AM_MEDIA_TYPE **ppMediaType) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetMediaType( 
	//        AM_MEDIA_TYPE *pMediaType) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE IsDiscontinuity( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetDiscontinuity( 
	//        BOOL bDiscontinuity) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetMediaTime( 
	//        /* [out] */ LONGLONG *pTimeStart,
	//        /* [out] */ LONGLONG *pTimeEnd) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetMediaTime( 
	//        /* [in] */ LONGLONG *pTimeStart,
	//        /* [in] */ LONGLONG *pTimeEnd) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a8689a-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IMediaSample
	{
		[PreserveSig]
		int GetPointer([Out] out IntPtr ppBuffer);

		[PreserveSig]
		int GetSize();

		[PreserveSig]
		int GetTime([Out] out long pTimeStart, [Out] out long pTimeEnd);

		[PreserveSig]
		int SetTime(
			[MarshalAs(UnmanagedType.LPStruct)] ReferenceTime pTimeStart,
			[MarshalAs(UnmanagedType.LPStruct)] ReferenceTime pTimeEnd);

		[PreserveSig]
		int IsSyncPoint();

		[PreserveSig]
		int SetSyncPoint([MarshalAs(UnmanagedType.Bool)] bool bIsSyncPoint);

		[PreserveSig]
		int IsPreroll();

		[PreserveSig]
		int SetPreroll([MarshalAs(UnmanagedType.Bool)] bool bIsPreroll);

		[PreserveSig]
		int GetActualDataLength();

		[PreserveSig]
		int SetActualDataLength(int len);

		[PreserveSig]
		int GetMediaType(
			[Out, MarshalAs(UnmanagedType.LPStruct)] out AMMediaType ppMediaType);

		[PreserveSig]
		int SetMediaType(
			[In, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pMediaType);

		[PreserveSig]
		int IsDiscontinuity();

		[PreserveSig]
		int SetDiscontinuity([MarshalAs(UnmanagedType.Bool)] bool bDiscontinuity);

		[PreserveSig]
		int GetMediaTime([Out] out long pTimeStart, [Out] out long pTimeEnd);

		[PreserveSig]
		int SetMediaTime(
			[MarshalAs(UnmanagedType.LPStruct)] ReferenceTime pTimeStart,
			[MarshalAs(UnmanagedType.LPStruct)] ReferenceTime pTimeEnd);
	}

	// //////////////////////////////////////////////////////////////////////
	// IMediaSample2

	// //////////////////////////////////////////////////////////////////////
	// IMediaSample2Config

	// //////////////////////////////////////////////////////////////////////
	// IMemAllocator

	// //////////////////////////////////////////////////////////////////////
	// IMemAllocatorCallbackTemp

	// //////////////////////////////////////////////////////////////////////
	// IMemAllocatorNotifyCallbackTemp

	// //////////////////////////////////////////////////////////////////////
	// IMemInputPin

	// //////////////////////////////////////////////////////////////////////
	// IAMovieSetup

	// //////////////////////////////////////////////////////////////////////
	// IMediaSeeking
	// DShowNET support

	#region "IMediaSeeking C++ version"
	//MIDL_INTERFACE("36b73880-c2c8-11cf-8b46-00805f6cef60")
	//IMediaSeeking : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE GetCapabilities( 
	//        /* [out] */ DWORD *pCapabilities) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE CheckCapabilities( 
	//        /* [out][in] */ DWORD *pCapabilities) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE IsFormatSupported( 
	//        /* [in] */ const GUID *pFormat) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE QueryPreferredFormat( 
	//        /* [out] */ GUID *pFormat) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetTimeFormat( 
	//        /* [out] */ GUID *pFormat) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE IsUsingTimeFormat( 
	//        /* [in] */ const GUID *pFormat) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetTimeFormat( 
	//        /* [in] */ const GUID *pFormat) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetDuration( 
	//        /* [out] */ LONGLONG *pDuration) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetStopPosition( 
	//        /* [out] */ LONGLONG *pStop) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetCurrentPosition( 
	//        /* [out] */ LONGLONG *pCurrent) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE ConvertTimeFormat( 
	//        /* [out] */ LONGLONG *pTarget,
	//        /* [in] */ const GUID *pTargetFormat,
	//        /* [in] */ LONGLONG Source,
	//        /* [in] */ const GUID *pSourceFormat) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetPositions( 
	//        /* [out][in] */ LONGLONG *pCurrent,
	//        /* [in] */ DWORD dwCurrentFlags,
	//        /* [out][in] */ LONGLONG *pStop,
	//        /* [in] */ DWORD dwStopFlags) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetPositions( 
	//        /* [out] */ LONGLONG *pCurrent,
	//        /* [out] */ LONGLONG *pStop) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetAvailable( 
	//        /* [out] */ LONGLONG *pEarliest,
	//        /* [out] */ LONGLONG *pLatest) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetRate( 
	//        /* [in] */ double dRate) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetRate( 
	//        /* [out] */ double *pdRate) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetPreroll( 
	//        /* [out] */ LONGLONG *pllPreroll) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("36b73880-c2c8-11cf-8b46-00805f6cef60")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IMediaSeeking
	{
		[PreserveSig]
		int GetCapabilities([Out] out SeekingCapabilities pCapabilities);

		[PreserveSig]
		int CheckCapabilities([In, Out] ref SeekingCapabilities pCapabilities);

		[PreserveSig]
		int IsFormatSupported([In] ref Guid pFormat);

		[PreserveSig]
		int QueryPreferredFormat([Out] out Guid pFormat);

		[PreserveSig]
		int GetTimeFormat([Out] out Guid pFormat);

		[PreserveSig]
		int IsUsingTimeFormat([In] ref Guid pFormat);

		[PreserveSig]
		int SetTimeFormat([In] ref Guid pFormat);

		[PreserveSig]
		int GetDuration([Out] out long pDuration);

		[PreserveSig]
		int GetStopPosition([Out] out long pStop);

		[PreserveSig]
		int GetCurrentPosition([Out] out long pCurrent);

		[PreserveSig]
		int ConvertTimeFormat(
			[Out] out long		pTarget,
			[In] ref Guid		pTargetFormat,
			long				Source,
			[In] ref Guid		pSourceFormat);

		[PreserveSig]
		int SetPositions(
			[In, Out, MarshalAs(UnmanagedType.LPStruct)] ReferenceTime	pCurrent,
			SeekingFlags												dwCurrentFlags,
			[In, Out, MarshalAs(UnmanagedType.LPStruct)] ReferenceTime	pStop,
			SeekingFlags												dwStopFlags);

		[PreserveSig]
		int GetPositions([Out] out long pCurrent, [Out] out long pStop);

		[PreserveSig]
		int GetAvailable([Out] out long pEarliest, [Out] out long pLatest);

		[PreserveSig]
		int SetRate(double dRate);

		[PreserveSig]
		int GetRate([Out] out double pdRate);

		[PreserveSig]
		int GetPreroll([Out] out long pllPreroll);
	}

	[Flags]
	public enum SeekingFlags : uint
	{
		NoPositioning			= 0,
		AbsolutePositioning		= 0x1,
		RelativePositioning		= 0x2,
		IncrementalPositioning	= 0x3,
		PositioningBitsMask		= 0x3,
		SeekToKeyFrame			= 0x4,
		ReturnTime				= 0x8,
		Segment					= 0x10,
		NoFlush					= 0x20
	}

	[Flags]
	public enum SeekingCapabilities : uint
	{
		CanSeekAbsolute		= 0x1,
		CanSeekForwards		= 0x2,
		CanSeekBackwards	= 0x4,
		CanGetCurrentPos	= 0x8,
		CanGetStopPos		= 0x10,
		CanGetDuration		= 0x20,
		CanPlayBackwards	= 0x40,
		CanDoSegments		= 0x80,
		Source				= 0x100
	}

	// //////////////////////////////////////////////////////////////////////
	// IEnumRegFilters

	// //////////////////////////////////////////////////////////////////////
	// IFilterMapper

	// //////////////////////////////////////////////////////////////////////
	// IFilterMapper2

	// //////////////////////////////////////////////////////////////////////
	// IFilterMapper3

	// //////////////////////////////////////////////////////////////////////
	// IQualityControl

	// //////////////////////////////////////////////////////////////////////
	// IOverlayNotify

	// //////////////////////////////////////////////////////////////////////
	// IOverlayNotify2

	// //////////////////////////////////////////////////////////////////////
	// IOverlay

	// //////////////////////////////////////////////////////////////////////
	// IMediaEventSink

	// //////////////////////////////////////////////////////////////////////
	// IFileSourceFilter

	#region "IFileSourceFilter C++ version"
	//MIDL_INTERFACE("56a868a6-0ad4-11ce-b03a-0020af0ba770")
	//IFileSourceFilter : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Load( 
	//        /* [in] */ LPCOLESTR pszFileName,
	//        /* [unique][in] */ 
	//        __in_opt  const AM_MEDIA_TYPE *pmt) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetCurFile( 
	//        /* [out] */ 
	//        __out  LPOLESTR *ppszFileName,
	//        /* [out] */ 
	//        __out_opt  AM_MEDIA_TYPE *pmt) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a868a6-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IFileSourceFilter
	{
		[PreserveSig]
		int Load(
			[MarshalAs(UnmanagedType.LPWStr)] string pszFileName,
			[In, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);
	    
		[PreserveSig]
		int GetCurFile(
			[Out, MarshalAs(UnmanagedType.LPWStr)] out string ppszFileName,
			[Out, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);
	}

	// //////////////////////////////////////////////////////////////////////
	// IFileSinkFilter
	// DShowNET support

	#region "IFileSinkFilter C++ version"
	//MIDL_INTERFACE("a2104830-7c70-11cf-8bce-00aa00a3f1a6")
	//IFileSinkFilter : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE SetFileName( 
	//        /* [in] */ LPCOLESTR pszFileName,
	//        /* [unique][in] */ const AM_MEDIA_TYPE *pmt) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetCurFile( 
	//        /* [out] */ LPOLESTR *ppszFileName,
	//        /* [out] */ AM_MEDIA_TYPE *pmt) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("a2104830-7c70-11cf-8bce-00aa00a3f1a6")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IFileSinkFilter
	{
		[PreserveSig]
		int SetFileName(
			[MarshalAs(UnmanagedType.LPWStr)] string pszFileName,
			[In, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);

		[PreserveSig]
		int GetCurFile(
			[Out, MarshalAs(UnmanagedType.LPWStr)] out string ppszFileName,
			[Out, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);
	}

	// //////////////////////////////////////////////////////////////////////
	// IFileSinkFilter2

	// //////////////////////////////////////////////////////////////////////
	// IGraphBuilder
	// DShowNET support

	#region "IGraphBuilder C++ version"
	//MIDL_INTERFACE("56a868a9-0ad4-11ce-b03a-0020af0ba770")
	//IGraphBuilder : public IFilterGraph
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Connect( 
	//        /* [in] */ IPin *ppinOut,
	//        /* [in] */ IPin *ppinIn) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Render( 
	//        /* [in] */ IPin *ppinOut) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE RenderFile( 
	//        /* [in] */ LPCWSTR lpcwstrFile,
	//        /* [unique][in] */ LPCWSTR lpcwstrPlayList) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE AddSourceFilter( 
	//        /* [in] */ LPCWSTR lpcwstrFileName,
	//        /* [unique][in] */ LPCWSTR lpcwstrFilterName,
	//        /* [out] */ IBaseFilter **ppFilter) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetLogFile( 
	//        /* [in] */ DWORD_PTR hFile) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Abort( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE ShouldOperationContinue( void) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a868a9-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IGraphBuilder
	{
		#region "IFilterGraph Methods"
		[PreserveSig]
		int AddFilter(
			IBaseFilter pFilter,
			[MarshalAs(UnmanagedType.LPWStr)] string pName);

		[PreserveSig]
		int RemoveFilter(IBaseFilter pFilter);

		[PreserveSig]
		int EnumFilters([Out] out IEnumFilters ppEnum);

		[PreserveSig]
		int FindFilterByName(
			[MarshalAs(UnmanagedType.LPWStr)] string pName,
			[Out] out IBaseFilter ppFilter);

		[PreserveSig]
		int ConnectDirect(
			IPin ppinOut,
			IPin ppinIn,
			[MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);

		[PreserveSig]
		int Reconnect(IPin ppin);

		[PreserveSig]
		int Disconnect(IPin ppin);

		[PreserveSig]
		int SetDefaultSyncSource();
		#endregion

		[PreserveSig]
		int Connect(IPin ppinOut, IPin ppinIn);

		[PreserveSig]
		int Render(IPin ppinOut);

		[PreserveSig]
		int RenderFile(
			[MarshalAs(UnmanagedType.LPWStr)] string lpcwstrFile,
			[MarshalAs(UnmanagedType.LPWStr)] string lpcwstrPlayList);

		[PreserveSig]
		int AddSourceFilter(
			[MarshalAs(UnmanagedType.LPWStr)] string lpcwstrFileName,
			[MarshalAs(UnmanagedType.LPWStr)] string lpcwstrFilterName,
			[Out] out IBaseFilter ppFilter);

		[PreserveSig]
		int SetLogFile(IntPtr hFile);

		[PreserveSig]
		int Abort();

		[PreserveSig]
		int ShouldOperationContinue();
	}

	// //////////////////////////////////////////////////////////////////////
	// ICaptureGraphBuilder

	// //////////////////////////////////////////////////////////////////////
	// IAMCopyCaptureFileProgress
	// DShowNET support

	#region "IAMCopyCaptureFileProgress C++ version"
	//MIDL_INTERFACE("670d1d20-a068-11d0-b3f0-00aa003761c5")
	//IAMCopyCaptureFileProgress : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Progress( 
	//        /* [in] */ int iProgress) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("670d1d20-a068-11d0-b3f0-00aa003761c5")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IAMCopyCaptureFileProgress
	{
		[PreserveSig]
		int Progress(int iProgress);
	}

	// //////////////////////////////////////////////////////////////////////
	// ICaptureGraphBuilder2
	// DShowNET support

	#region "ICaptureGraphBuilder2 C++ version"
	//MIDL_INTERFACE("93E5A4E0-2D50-11d2-ABFA-00A0C9C6E38D")
	//ICaptureGraphBuilder2 : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE SetFiltergraph( 
	//        /* [in] */ IGraphBuilder *pfg) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetFiltergraph( 
	//        /* [out] */ IGraphBuilder **ppfg) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetOutputFileName( 
	//        /* [in] */ const GUID *pType,
	//        /* [in] */ LPCOLESTR lpstrFile,
	//        /* [out] */ IBaseFilter **ppf,
	//        /* [out] */ IFileSinkFilter **ppSink) = 0;
        
	//    virtual /* [local] */ HRESULT STDMETHODCALLTYPE FindInterface( 
	//        /* [in] */ const GUID *pCategory,
	//        /* [in] */ const GUID *pType,
	//        /* [in] */ IBaseFilter *pf,
	//        /* [in] */ REFIID riid,
	//        /* [out] */ void **ppint) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE RenderStream( 
	//        /* [in] */ const GUID *pCategory,
	//        /* [in] */ const GUID *pType,
	//        /* [in] */ IUnknown *pSource,
	//        /* [in] */ IBaseFilter *pfCompressor,
	//        /* [in] */ IBaseFilter *pfRenderer) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE ControlStream( 
	//        /* [in] */ const GUID *pCategory,
	//        /* [in] */ const GUID *pType,
	//        /* [in] */ IBaseFilter *pFilter,
	//        /* [in] */ REFERENCE_TIME *pstart,
	//        /* [in] */ REFERENCE_TIME *pstop,
	//        /* [in] */ WORD wStartCookie,
	//        /* [in] */ WORD wStopCookie) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE AllocCapFile( 
	//        /* [in] */ LPCOLESTR lpstr,
	//        /* [in] */ DWORDLONG dwlSize) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE CopyCaptureFile( 
	//        /* [in] */ LPOLESTR lpwstrOld,
	//        /* [in] */ LPOLESTR lpwstrNew,
	//        /* [in] */ int fAllowEscAbort,
	//        /* [in] */ IAMCopyCaptureFileProgress *pCallback) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE FindPin( 
	//        /* [in] */ IUnknown *pSource,
	//        /* [in] */ PIN_DIRECTION pindir,
	//        /* [in] */ const GUID *pCategory,
	//        /* [in] */ const GUID *pType,
	//        /* [in] */ BOOL fUnconnected,
	//        /* [in] */ int num,
	//        /* [out] */ IPin **ppPin) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("93E5A4E0-2D50-11d2-ABFA-00A0C9C6E38D")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ICaptureGraphBuilder2
	{
		[PreserveSig]
		int SetFiltergraph(IGraphBuilder pfg);

		[PreserveSig]
		int GetFiltergraph([Out] out IGraphBuilder ppfg);

		[PreserveSig]
		int SetOutputFileName(
			[In] ref Guid								pType,
			[MarshalAs(UnmanagedType.LPWStr)] string	lpstrFile,
			[Out] out IBaseFilter						ppbf,
			[Out] out IFileSinkFilter					ppSink);

		[PreserveSig]
		int FindInterface(
			[In] ref Guid		pCategory,
			[In] ref Guid		pType,
			IBaseFilter			pbf,
			[In] ref Guid		riid,
			[Out] out IntPtr	ppint);

		[PreserveSig]
		int RenderStream(
			[In] ref Guid								pCategory,
			[In] ref Guid								pType,
			[MarshalAs(UnmanagedType.IUnknown)] object	pSource,
			IBaseFilter									pfCompressor,
			IBaseFilter									pfRenderer);

		[PreserveSig]
		int ControlStream(
			[In] ref Guid								pCategory,
			[In] ref Guid								pType,
			IBaseFilter									pFilter,
			[MarshalAs(UnmanagedType.LPStruct)] ReferenceTime	pstart,
			[MarshalAs(UnmanagedType.LPStruct)] ReferenceTime	pstop,
			short										wStartCookie,
			short										wStopCookie);

		[PreserveSig]
		int AllocCapFile([MarshalAs(UnmanagedType.LPWStr)] string lpstrFile, long dwlSize);

		[PreserveSig]
		int CopyCaptureFile(
			[MarshalAs(UnmanagedType.LPWStr)] string	lpwstrOld,
			[MarshalAs(UnmanagedType.LPWStr)] string	lpwstrNew,
			int											fAllowEscAbort,
			IAMCopyCaptureFileProgress					pFilter);

		[PreserveSig]
		int FindPin(
			[MarshalAs(UnmanagedType.IUnknown)] object	pSource,
			PinDirection								pindir,
			[In] ref Guid								pCategory,
			[In] ref Guid								pType,
			[MarshalAs(UnmanagedType.Bool)] bool		fUnconnected,
			int											num,
			[Out] out IPin								ppPin);
	}

	// //////////////////////////////////////////////////////////////////////
	// IFilterGraph2

	#region "IFilterGraph2 C++ version"
	//MIDL_INTERFACE("36b73882-c2c8-11cf-8b46-00805f6cef60")
	//IFilterGraph2 : public IGraphBuilder
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE AddSourceFilterForMoniker( 
	//        /* [in] */ IMoniker *pMoniker,
	//        /* [in] */ IBindCtx *pCtx,
	//        /* [unique][in] */ LPCWSTR lpcwstrFilterName,
	//        /* [out] */ IBaseFilter **ppFilter) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE ReconnectEx( 
	//        /* [in] */ IPin *ppin,
	//        /* [unique][in] */ const AM_MEDIA_TYPE *pmt) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE RenderEx( 
	//        /* [in] */ IPin *pPinOut,
	//        /* [in] */ DWORD dwFlags,
	//        /* [out][in] */ DWORD *pvContext) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("36b73882-c2c8-11cf-8b46-00805f6cef60")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IFilterGraph2
	{
		#region "IFilterGraph Methods"
		[PreserveSig]
		int AddFilter(
			IBaseFilter pFilter,
			[MarshalAs(UnmanagedType.LPWStr)] string pName);

		[PreserveSig]
		int RemoveFilter(IBaseFilter pFilter);

		[PreserveSig]
		int EnumFilters([Out] out IEnumFilters ppEnum);

		[PreserveSig]
		int FindFilterByName(
			[MarshalAs(UnmanagedType.LPWStr)] string pName,
			[Out] out IBaseFilter ppFilter);

		[PreserveSig]
		int ConnectDirect(
			IPin ppinOut,
			IPin ppinIn,
			[MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);

		[PreserveSig]
		int Reconnect(IPin ppin);

		[PreserveSig]
		int Disconnect(IPin ppin);

		[PreserveSig]
		int SetDefaultSyncSource();
		#endregion

		#region "IGraphBuilder Methods"
		[PreserveSig]
		int Connect(IPin ppinOut, IPin ppinIn);

		[PreserveSig]
		int Render(IPin ppinOut);

		[PreserveSig]
		int RenderFile(
			[MarshalAs(UnmanagedType.LPWStr)] string lpcwstrFile,
			[MarshalAs(UnmanagedType.LPWStr)] string lpcwstrPlayList);

		[PreserveSig]
		int AddSourceFilter(
			[MarshalAs(UnmanagedType.LPWStr)] string lpcwstrFileName,
			[MarshalAs(UnmanagedType.LPWStr)] string lpcwstrFilterName,
			[Out] out IBaseFilter ppFilter);

		[PreserveSig]
		int SetLogFile(IntPtr hFile);

		[PreserveSig]
		int Abort();

		[PreserveSig]
		int ShouldOperationContinue();
		#endregion

		[PreserveSig]
		int AddSourceFilterForMoniker(
			IMoniker									pMoniker,
			IBindCtx									pCtx,
			[MarshalAs(UnmanagedType.LPWStr)] string	lpcwstrFilterName,
			[Out] out IBaseFilter						ppFilter);

		[PreserveSig]
		int ReconnectEx(
			IPin ppin,
			[In, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);

		[PreserveSig]
		int RenderEx(
			IPin pPinOut,
			AMRensderexFlags dwFlags,
			[In, Out] ref int pvContext);
	}

	[Flags]
	public enum AMRensderexFlags
	{
		Default						= 0x0,
		RenderToExistingRenderers	= 0x1,
	}

	// //////////////////////////////////////////////////////////////////////
	// IFilterGraph3

	// //////////////////////////////////////////////////////////////////////
	// IStreamBuilder

	// //////////////////////////////////////////////////////////////////////
	// IAsyncReader

	// //////////////////////////////////////////////////////////////////////
	// IGraphVersion

	// //////////////////////////////////////////////////////////////////////
	// IResourceConsumer

	// //////////////////////////////////////////////////////////////////////
	// IResourceManager

	// //////////////////////////////////////////////////////////////////////
	// IDistributorNotify

	// //////////////////////////////////////////////////////////////////////
	// IAMStreamControl

	#region "IAMStreamControl C++ version"
	//MIDL_INTERFACE("36b73881-c2c8-11cf-8b46-00805f6cef60")
	//IAMStreamControl : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE StartAt( 
	//        /* [in] */ const REFERENCE_TIME *ptStart,
	//        /* [in] */ DWORD dwCookie) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE StopAt( 
	//        /* [in] */ const REFERENCE_TIME *ptStop,
	//        /* [in] */ BOOL bSendExtra,
	//        /* [in] */ DWORD dwCookie) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetInfo( 
	//        /* [out] */ AM_STREAM_INFO *pInfo) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("36b73881-c2c8-11cf-8b46-00805f6cef60")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IAMStreamControl
	{
		[PreserveSig]
		int StartAt(
			[MarshalAs(UnmanagedType.LPStruct)] ReferenceTime ptStart,
			int dwCookie);

		[PreserveSig]
		int StopAt(
			[MarshalAs(UnmanagedType.LPStruct)] ReferenceTime ptStop,
			[MarshalAs(UnmanagedType.Bool)] bool bSendExtra,
			int dwCookie);

		[PreserveSig]
		int GetInfo([Out] out AMStreamInfo pInfo);
	}

	[Flags]
	public enum AMStreamInfoFlags : uint
	{
		StartDefined	= 0x00000001,
		StopDefined		= 0x00000002,
		Discarding		= 0x00000004,
		StopSendExtra	= 0x00000010
	}

	[StructLayout(LayoutKind.Sequential, Pack=4), ComVisible(false)]
	public struct AMStreamInfo
	{
		public long						tStart;
		public long						tStop;
		public int						dwStartCookie;
		public int						dwStopCookie;
		public AMStreamInfoFlags		dwFlags;
	}

	// //////////////////////////////////////////////////////////////////////
	// ISeekingPassThru

	// //////////////////////////////////////////////////////////////////////
	// IAMStreamConfig
	// DShowNET support

	#region "IAMStreamConfig C++ version"
	//MIDL_INTERFACE("C6E13340-30AC-11d0-A18C-00A0C9118956")
	//IAMStreamConfig : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE SetFormat( 
	//        /* [in] */ AM_MEDIA_TYPE *pmt) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetFormat( 
	//        /* [out] */ AM_MEDIA_TYPE **ppmt) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetNumberOfCapabilities( 
	//        /* [out] */ int *piCount,
	//        /* [out] */ int *piSize) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetStreamCaps( 
	//        /* [in] */ int iIndex,
	//        /* [out] */ AM_MEDIA_TYPE **ppmt,
	//        /* [out] */ BYTE *pSCC) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("C6E13340-30AC-11d0-A18C-00A0C9118956")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IAMStreamConfig
	{
		[PreserveSig]
		int SetFormat(
			[In, MarshalAs(UnmanagedType.LPStruct)] AMMediaType pmt);

		[PreserveSig]
		int GetFormat(
			[Out, MarshalAs(UnmanagedType.LPStruct)] out AMMediaType ppmt);

		[PreserveSig]
		int GetNumberOfCapabilities([Out] out int piCount, [Out] out int piSize);

		[PreserveSig]
		int GetStreamCaps(
			int															iIndex,
			[Out, MarshalAs(UnmanagedType.LPStruct)] out AMMediaType	ppmt,
			IntPtr														pSCC);
	}

	// //////////////////////////////////////////////////////////////////////
	// IConfigInterleaving

	// //////////////////////////////////////////////////////////////////////
	// IConfigAviMux

	// //////////////////////////////////////////////////////////////////////
	// IAMVideoCompression

	// //////////////////////////////////////////////////////////////////////
	// IAMVfwCaptureDialogs

	// //////////////////////////////////////////////////////////////////////
	// IAMVfwCompressDialogs

	// //////////////////////////////////////////////////////////////////////
	// IAMDroppedFrames

	// //////////////////////////////////////////////////////////////////////
	// IAMAudioInputMixer

	// //////////////////////////////////////////////////////////////////////
	// IAMBufferNegotiation

	// //////////////////////////////////////////////////////////////////////
	// IAMAnalogVideoDecoder

	// //////////////////////////////////////////////////////////////////////
	// IAMVideoProcAmp

	#region "IAMVideoProcAmp C++ version"
	//MIDL_INTERFACE("C6E13360-30AC-11d0-A18C-00A0C9118956")
	//IAMVideoProcAmp : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE GetRange( 
	//        /* [in] */ long Property,
	//        /* [out] */ long *pMin,
	//        /* [out] */ long *pMax,
	//        /* [out] */ long *pSteppingDelta,
	//        /* [out] */ long *pDefault,
	//        /* [out] */ long *pCapsFlags) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Set( 
	//        /* [in] */ long Property,
	//        /* [in] */ long lValue,
	//        /* [in] */ long Flags) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Get( 
	//        /* [in] */ long Property,
	//        /* [out] */ long *lValue,
	//        /* [out] */ long *Flags) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("C6E13360-30AC-11d0-A18C-00A0C9118956")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IAMVideoProcAmp
	{
		[PreserveSig]
		int GetRange(
			VideoProcAmpProperty			Property,
			[Out] out int					pMin,
			[Out] out int					pMax,
			[Out] out int					pSteppingDelta,
			[Out] out int					pDefault,
			[Out] out VideoProcAmpFlags		pCapsFlags);

		[PreserveSig]
		int Set(VideoProcAmpProperty Property, int lValue, VideoProcAmpFlags Flags);

		[PreserveSig]
		int Get(VideoProcAmpProperty Property, [Out] out int lValue, [Out] out VideoProcAmpFlags Flags);
	}

	public enum VideoProcAmpProperty
	{
		Brightness				= 0,
		Contrast				= Brightness + 1,
		Hue						= Contrast + 1,
		Saturation				= Hue + 1,
		Sharpness				= Saturation + 1,
		Gamma					= Sharpness + 1,
		ColorEnable				= Gamma + 1,
		WhiteBalance			= ColorEnable + 1,
		BacklightCompensation	= WhiteBalance + 1,
		Gain					= BacklightCompensation + 1
	}

	public enum VideoProcAmpFlags
	{
		Auto	= 0x1,
		Manual	= 0x2
	}

	// //////////////////////////////////////////////////////////////////////
	// IAMCameraControl

	// //////////////////////////////////////////////////////////////////////
	// IAMVideoControl

	// //////////////////////////////////////////////////////////////////////
	// IAMCrossbar

	// //////////////////////////////////////////////////////////////////////
	// IAMTuner
	// DShowNET support

	// //////////////////////////////////////////////////////////////////////
	// IAMTunerNotification
	// DShowNET support

	// //////////////////////////////////////////////////////////////////////
	// IAMTVTuner
	// DShowNET support

	// //////////////////////////////////////////////////////////////////////
	// IBPCSatelliteTuner

	// //////////////////////////////////////////////////////////////////////
	// IAMTVAudio

	// //////////////////////////////////////////////////////////////////////
	// IAMTVAudioNotification

	// //////////////////////////////////////////////////////////////////////
	// IAMAnalogVideoEncoder

	// //////////////////////////////////////////////////////////////////////
	// IKsPropertySet

	// //////////////////////////////////////////////////////////////////////
	// IMediaPropertyBag

	// //////////////////////////////////////////////////////////////////////
	// IPersistMediaPropertyBag

	// //////////////////////////////////////////////////////////////////////
	// IAMPhysicalPinInfo

	// //////////////////////////////////////////////////////////////////////
	// IAMExtDevice

	// //////////////////////////////////////////////////////////////////////
	// IAMExtTransport

	// //////////////////////////////////////////////////////////////////////
	// IAMTimecodeReader

	// //////////////////////////////////////////////////////////////////////
	// IAMTimecodeGenerator

	// //////////////////////////////////////////////////////////////////////
	// IAMTimecodeDisplay

	// //////////////////////////////////////////////////////////////////////
	// IAMDevMemoryAllocator

	// //////////////////////////////////////////////////////////////////////
	// IAMDevMemoryControl

	// //////////////////////////////////////////////////////////////////////
	// IAMStreamSelect

	#region "IAMStreamSelect C++ version"
	//MIDL_INTERFACE("c1960960-17f5-11d1-abe1-00a0c905f375")
	//IAMStreamSelect : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Count( 
	//        /* [out] */ DWORD *pcStreams) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Info( 
	//        /* [in] */ long lIndex,
	//        /* [out] */ AM_MEDIA_TYPE **ppmt,
	//        /* [out] */ DWORD *pdwFlags,
	//        /* [out] */ LCID *plcid,
	//        /* [out] */ DWORD *pdwGroup,
	//        /* [out] */ WCHAR **ppszName,
	//        /* [out] */ IUnknown **ppObject,
	//        /* [out] */ IUnknown **ppUnk) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Enable( 
	//        /* [in] */ long lIndex,
	//        /* [in] */ DWORD dwFlags) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("c1960960-17f5-11d1-abe1-00a0c905f375")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IAMStreamSelect
	{
		[PreserveSig]
		int Count([Out] out int pcStreams);

		[PreserveSig]
		int Info(
			int															lIndex,
			[Out, MarshalAs(UnmanagedType.LPStruct)] out AMMediaType	ppmt,
			[Out] out AMStreamSelectInfoFlags							pdwFlags,
			[Out, MarshalAs(UnmanagedType.LPStruct)] ReferenceInt		plcid,
			[Out, MarshalAs(UnmanagedType.LPStruct)] ReferenceInt		pdwGroup,
			[Out, MarshalAs(UnmanagedType.LPStruct)] ReferenceStr		ppszName,
			[Out, MarshalAs(UnmanagedType.IUnknown)] out object			ppObject,
			[Out, MarshalAs(UnmanagedType.IUnknown)] out object			ppUnk);

		[PreserveSig]
		int Enable(
			int lIndex,
			AMStreamSelectEnableFlags dwFlags);
	}

	public enum AMStreamSelectInfoFlags : uint
	{
		Disabled	= 0x0,
		Enabled		= 0x1,
		Exclusive	= 0x2
	}

	public enum AMStreamSelectEnableFlags : uint
	{
		Disable		= 0x0,
		Enable		= 0x1,
		EnableAll	= 0x2
	}

	// //////////////////////////////////////////////////////////////////////
	// IAMResourceControl

	// //////////////////////////////////////////////////////////////////////
	// IAMClockAdjust

	// //////////////////////////////////////////////////////////////////////
	// IAMFilterMiscFlags

	// //////////////////////////////////////////////////////////////////////
	// IDrawVideoImage

	// //////////////////////////////////////////////////////////////////////
	// IDecimateVideoImage

	// //////////////////////////////////////////////////////////////////////
	// IAMVideoDecimationProperties

	// //////////////////////////////////////////////////////////////////////
	// IVideoFrameStep
	// DShowNET support

	// //////////////////////////////////////////////////////////////////////
	// IAMLatency

	// //////////////////////////////////////////////////////////////////////
	// IAMPushSource

	// //////////////////////////////////////////////////////////////////////
	// IAMDeviceRemoval

	// //////////////////////////////////////////////////////////////////////
	// IDVEnc

	// //////////////////////////////////////////////////////////////////////
	// IIPDVDec

	// //////////////////////////////////////////////////////////////////////
	// IDVRGB219

	// //////////////////////////////////////////////////////////////////////
	// IDVSplitter

	// //////////////////////////////////////////////////////////////////////
	// IAMAudioRendererStats

	// //////////////////////////////////////////////////////////////////////
	// IAMGraphStreams

	// //////////////////////////////////////////////////////////////////////
	// IAMOverlayFX

	// //////////////////////////////////////////////////////////////////////
	// IAMOpenProgress

	// //////////////////////////////////////////////////////////////////////
	// IMpeg2Demultiplexer

	// //////////////////////////////////////////////////////////////////////
	// IEnumStreamIdMap

	// //////////////////////////////////////////////////////////////////////
	// IMPEG2StreamIdMap

	// //////////////////////////////////////////////////////////////////////
	// IRegisterServiceProvider

	// //////////////////////////////////////////////////////////////////////
	// IAMClockSlave

	// //////////////////////////////////////////////////////////////////////
	// IAMGraphBuilderCallback

	// //////////////////////////////////////////////////////////////////////
	// ICodecAPI

	// //////////////////////////////////////////////////////////////////////
	// IGetCapabilitiesKey

	// //////////////////////////////////////////////////////////////////////
	// IEncoderAPI

	// //////////////////////////////////////////////////////////////////////
	// IVideoEncoder

	// //////////////////////////////////////////////////////////////////////
	// IAMDecoderCaps

	// //////////////////////////////////////////////////////////////////////
	// IAMCertifiedOutputProtection

	// //////////////////////////////////////////////////////////////////////
	// IDvdControl

	// //////////////////////////////////////////////////////////////////////
	// IDvdInfo

	// //////////////////////////////////////////////////////////////////////
	// IDvdCmd
	// DShowNET support

	// //////////////////////////////////////////////////////////////////////
	// IDvdState
	// DShowNET support

	// //////////////////////////////////////////////////////////////////////
	// IDvdControl2
	// DShowNET support

	// //////////////////////////////////////////////////////////////////////
	// IDvdInfo2
	// DShowNET support

	// //////////////////////////////////////////////////////////////////////
	// IDvdGraphBuilder
	// DShowNET support

	#region "IDvdGraphBuilder C++ version"
	//MIDL_INTERFACE("FCC152B6-F372-11d0-8E00-00C04FD7C08B")
	//IDvdGraphBuilder : public IUnknown
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE GetFiltergraph( 
	//        /* [out] */ IGraphBuilder **ppGB) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetDvdInterface( 
	//        /* [in] */ REFIID riid,
	//        /* [out] */ void **ppvIF) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE RenderDvdVideoVolume( 
	//        /* [in] */ LPCWSTR lpcwszPathName,
	//        /* [in] */ DWORD dwFlags,
	//        /* [out] */ AM_DVD_RENDERSTATUS *pStatus) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("FCC152B6-F372-11d0-8E00-00C04FD7C08B")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IDvdGraphBuilder
	{
		[PreserveSig]
		int GetFiltergraph([Out] out IGraphBuilder ppGB);

		[PreserveSig]
		int GetDvdInterface([In] ref Guid riid, [Out] out IntPtr ppvIF);

		[PreserveSig]
		int RenderDvdVideoVolume(
			[MarshalAs(UnmanagedType.LPWStr)] string	lpcwszPathName,
			DvdGraphFlags								dwFlags,
			[Out] out DvdRenderStatus					pStatus);
	}

	[Flags]
	public enum DvdGraphFlags
	{
		Default		= 0x0,
		HwDecPrefer	= 0x1,
		HwDecOnly	= 0x2,
		SwDecPrefer	= 0x4,
		SwDecOnly	= 0x8,
		NoVpe		= 0x100,
		VMR9Only	= 0x800
	}

	[Flags]
	public enum DvdStreamFlags
	{
		None	= 0x0,
		Video	= 0x1,
		Audio	= 0x2,
		SubPic	= 0x4
    }

	[StructLayout(LayoutKind.Sequential, Pack=2), ComVisible(false)]
	public struct DvdRenderStatus
	{
		int					hrVPEStatus;
		[MarshalAs(UnmanagedType.Bool)]
		bool				bDvdVolInvalid;
		[MarshalAs(UnmanagedType.Bool)]
		bool				bDvdVolUnknown;
		[MarshalAs(UnmanagedType.Bool)]
		bool				bNoLine21In;
		[MarshalAs(UnmanagedType.Bool)]
		bool				bNoLine21Out;
		int					iNumStreams;
		int					iNumStreamsFailed;
		DvdStreamFlags		dwFailedStreamsFlag;
	}

	// //////////////////////////////////////////////////////////////////////
	// IDDrawExclModeVideo

	// //////////////////////////////////////////////////////////////////////
	// IDDrawExclModeVideoCallback

	// //////////////////////////////////////////////////////////////////////
	// IPinConnection

	// //////////////////////////////////////////////////////////////////////
	// IPinFlowControl

	// //////////////////////////////////////////////////////////////////////
	// IGraphConfig

	// //////////////////////////////////////////////////////////////////////
	// IGraphConfigCallback

	// //////////////////////////////////////////////////////////////////////
	// IFilterChain

	// //////////////////////////////////////////////////////////////////////
	// IVMRImagePresenter

	// //////////////////////////////////////////////////////////////////////
	// IVMRSurfaceAllocator

	// //////////////////////////////////////////////////////////////////////
	// IVMRSurfaceAllocatorNotify

	// //////////////////////////////////////////////////////////////////////
	// IVMRWindowlessControl

	// //////////////////////////////////////////////////////////////////////
	// IVMRMixerControl

	// //////////////////////////////////////////////////////////////////////
	// IVMRMonitorConfig

	// //////////////////////////////////////////////////////////////////////
	// IVMRFilterConfig

	// //////////////////////////////////////////////////////////////////////
	// IVMRAspectRatioControl

	// //////////////////////////////////////////////////////////////////////
	// IVMRDeinterlaceControl

	// //////////////////////////////////////////////////////////////////////
	// IVMRMixerBitmap

	// //////////////////////////////////////////////////////////////////////
	// IVMRImageCompositor

	// //////////////////////////////////////////////////////////////////////
	// IVMRVideoStreamControl

	// //////////////////////////////////////////////////////////////////////
	// IVMRSurface

	// //////////////////////////////////////////////////////////////////////
	// IVMRImagePresenterConfig

	// //////////////////////////////////////////////////////////////////////
	// IVMRImagePresenterExclModeConfig

	// //////////////////////////////////////////////////////////////////////
	// IVPManager

}

// //////////////////////////////////////////////////////////////////////////
