﻿// //////////////////////////////////////////////////////////////////////////
//
// MainForm.cs
//              Sarbo Project
//          Powerd by CACTUS SOFTWARE <http://www.cactussoft.co.jp/>
//
//                                              ver 1.0  2009/08/13
// This file is part of Sarbo.
//
// Sarbo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Sarbo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Sarbo.  If not, see <http://www.gnu.org/licenses/>.
//
// //////////////////////////////////////////////////////////////////////////
using System;
using System.Windows.Forms;
using DShowCAC;

namespace DShowPlay
{
	public partial class MainForm : Form
	{
		private SoundGraph		_soundGraph = null;

		public MainForm()
		{
			InitializeComponent();
		}

		// //////////////////////////////////////////////////////////////////
		// Load

		private void MainForm_Load(object sender, EventArgs e)
		{
			if (this.DesignMode)	return;

			comboDeviceOut.InitComboBox();
			_soundGraph = new SoundGraph();
		}

		private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
		{
			if (this.DesignMode)	return;

			comboDeviceOut.ExitComboBox();
			_soundGraph.StopAndExit();
		}

		// //////////////////////////////////////////////////////////////////
		// WndProc

		protected override void WndProc(ref Message m)
		{
			switch (m.Msg)
			{
			case WM.GraphNotify:
				OnGraphNotify(m.WParam, m.LParam);
				break;
			}
			base.WndProc(ref m);
		}

		// //////////////////////////////////////////////////////////////////
		// Filer

		private void btnFiler_Click(object sender, EventArgs e)
		{
	        openFileDialog.DefaultExt = ".mp3";
			openFileDialog.InitialDirectory = "";
			openFileDialog.Filter =
				"Windows Audio (*.wma)|*.wma|" +
				"MP3 audio (*.mp3)|*.mp3|" +
				"WAV audio (*.wav)|*.wav|" +
				"AU audio (*.au)|*.au|" +
				"AIFF audio (*.aif)|*.aif|" +
				"SND audio (*.snd)|*.snd|" +
				"MPEG audio (*.mpa)|*.mpa|" +
				"MPEG audio (*.mp1)|*.mp1|" +
				"MPEG audio (*.mp2)|*.mp2|" +
				"MIDI (*.mid)|*.mid|" +
				"MIDI (*.midi)|*.midi|" +
				"MIDI (*.rmi)|*.rmi|" +
				"All Files (*.*)|*.*";
	        openFileDialog.FileName = "";

			if (DialogResult.OK == openFileDialog.ShowDialog())
			{
				textFilePath.Text = openFileDialog.FileName;
				_soundGraph.StopAndExit();
				RenderSongFile(openFileDialog.FileName);
			}
		}

		// //////////////////////////////////////////////////////////////////
		// Button

		private void btnRewind_Click(object sender, EventArgs e)
		{
			_soundGraph.SeekPosition(0);
		}

		private void btnPlay_Click(object sender, EventArgs e)
		{
			StartProc();
		}

		private void btnStop_Click(object sender, EventArgs e)
		{
			StopProc();
		}

		private void btnExit_Click(object sender, EventArgs e)
		{
			Close();
		}

		// //////////////////////////////////////////////////////////////////
		// EnablePlayUI

		private void EnablePlayUI(bool enable)
		{
			comboDeviceOut.Enabled = enable;
			textFilePath.Enabled = enable;
			btnFiler.Enabled = enable;
		}

		// //////////////////////////////////////////////////////////////////
		// RenderSongFile

		private void RenderSongFile(string strFilePath)
		{
			if (_soundGraph.IsRenderFile())	return;

			FilterState fs = _soundGraph.GetState();
			if (fs != FilterState.Stopped)		return;

			try
			{
				_soundGraph.InitInstance();
				_soundGraph.RenderSongFile(strFilePath);
				_soundGraph.SetNotifyWindow(this.Handle);
			}
			catch (Exception)
			{
				_soundGraph.StopAndExit();
			}
		}

		// //////////////////////////////////////////////////////////////////
		// OnGraphNotify

		private int OnGraphNotify(
			IntPtr		wparam,
			IntPtr		lparam)
		{
			if (_soundGraph.IsComplete())
			{
				StopProc();
			}
			return 0;
		}

		// //////////////////////////////////////////////////////////////////
		// StartProc/StopProc

		private void StartProc()
		{
			EnablePlayUI(false);

			FilterState fs = _soundGraph.GetState();
			if (fs != FilterState.Stopped)		return;

			try
			{
				_soundGraph.StartPlay();
			}
			catch (Exception)
			{
				StopProc();
			}
		}

		private void StopProc()
		{
			FilterState fs = _soundGraph.GetState();

			try
			{
				if (fs == FilterState.Running)
				{
					_soundGraph.StopPlay();
					_soundGraph.WaitForStop();
				}
			}
			catch (Exception)
			{
			}
			EnablePlayUI(true);
		}
	}
}

// //////////////////////////////////////////////////////////////////////////
