﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

// private headers
#include "BehaviorSettingsForPattern.h"


namespace bearmini
{
    ///
    ///  INI ファイルから読み込んだ [ファイル名別動作] の設定のコレクション
    ///
    class BehaviorSettingsCollection
    {
    public:
        BehaviorSettingsCollection() {};
        virtual ~BehaviorSettingsCollection() throw() {};
    
        typedef std::vector<BehaviorSettingsForPattern>::iterator iterator;
        iterator begin() { return m_allBehaviorSettings.begin(); }
        iterator end() { return m_allBehaviorSettings.end(); }

        typedef std::vector<BehaviorSettingsForPattern>::const_iterator const_iterator;
        const_iterator begin() const { return m_allBehaviorSettings.begin(); }
        const_iterator end() const { return m_allBehaviorSettings.end(); }

        void Add(const BehaviorSettingsForPattern& bml);
        BehaviorSetting GetBehaviorSettingFor(const std::wstring& path);

    private:
        const BehaviorSetting offerChoice(const std::vector<BehaviorSetting>& behaviors);

    private:
        std::vector<BehaviorSettingsForPattern> m_allBehaviorSettings;

    };
}
