﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#include "Shortcut.h"

// private headers
#include "ScopedComLibrary.h"
#include "ScopedComObjectPointer.h"


namespace bearmini
{
    //
    //  ショートカットを作成します。
    //
    ::HRESULT Shortcut::Create(
        const std::wstring& pathLinkFile,   // ショートカットの絶対パス
        const std::wstring& pathTargetFile, // ターゲットファイル
        const std::wstring& description,    // 説明
        const std::wstring& args,           // 引数
        const std::wstring& workingDir,     // 作業ディレクトリ
        const std::wstring& pathIcon,       // アイコンの場所
        int iIcon,                          // アイコンのインデックス
        int iShowCmd,                       // ウィンドウスタイル
        bool runasAdmin                     // 互換性タブの「管理者として実行」をチェックするかどうか
    )
    {
        // このスコープ内で COM ライブラリを使用する
        ScopedComLibrary scl;

        ::HRESULT hr;

        ScopedComObjectPointer<::IShellLinkW> psl;
        ScopedComObjectPointer<::IShellLinkDataList> pdl;
        ScopedComObjectPointer<::IPersistFile> ppf;


        // IShellLink オブジェクトを作成しポインタを取得する
        hr = ::CoCreateInstance(::CLSID_ShellLink, 0, ::CLSCTX_INPROC_SERVER, ::IID_IShellLinkW, (void**)&psl);
        if (FAILED(hr))
        {
            throw std::domain_error("Failed to CoCreateInstance(CLSID_ShellLink).");
        }

        // ショートカットを二次記憶装置に保存するため IPersistFile インターフェイスの問い合わせをおこなう
        hr = psl->QueryInterface(::IID_IPersistFile, (void**)&ppf);
        if (FAILED(hr))
        {
            throw std::domain_error("Failed to QueryInterface(IID_IPersistFile).");
        }

        hr = psl->SetPath(pathTargetFile.c_str());           // ターゲットファイル
        if (FAILED(hr))
        {
            throw std::domain_error("Failed to SetPath().");
        }
        hr = psl->SetDescription(description.c_str());       // 説明
        if (FAILED(hr))
        {
            throw std::domain_error("Failed to SetDescription().");
        }
        hr = psl->SetArguments(args.c_str());                // 引数
        if (FAILED(hr))
        {
            throw std::domain_error("Failed to SetArguments().");
        }
        hr = psl->SetWorkingDirectory(workingDir.c_str());   // 作業ディレクトリ
        if (FAILED(hr))
        {
            throw std::domain_error("Failed to SetWorkingDirectory().");
        }
        hr = psl->SetIconLocation(pathIcon.c_str(), iIcon);  // アイコン
        if (FAILED(hr))
        {
            throw std::domain_error("Failed to SetIconLocation().");
        }
        hr = psl->SetShowCmd(iShowCmd);                      // ウィンドウスタイル
        if (FAILED(hr))
        {
            throw std::domain_error("Failed to SetShowCmd().");
        }

        if (runasAdmin)
        {
            hr = psl->QueryInterface(::IID_IShellLinkDataList, (void**)&pdl);
            if (FAILED(hr))
            {
                throw std::domain_error("Failed to QueryInterface(IID_IShellLinkDataList).");
            }

            DWORD dwFlags = 0;
            hr = pdl->GetFlags(&dwFlags);
            if (FAILED(hr))
            {
                throw std::domain_error("Failed to GetFlags().");
            }

            if ((dwFlags & SLDF_RUNAS_USER) == 0)
            {
                hr = pdl->SetFlags(dwFlags | SLDF_RUNAS_USER);
                if (FAILED(hr))
                {
                    throw std::domain_error("Failed to SetFlags().");
                }
            }
        }

        // ショートカットを保存する
        hr = ppf->Save(pathLinkFile.c_str(), TRUE);
        if (FAILED(hr))
        {
            throw std::domain_error("Failed to Save().");
        }

        hr = ppf->SaveCompleted(pathLinkFile.c_str());
        if (FAILED(hr))
        {
            throw std::domain_error("Failed to SaveCompleted().");
        }

        return hr;
    }

}
