package jp.ac.titech.sharp4k.cuten;

import java.util.List;

import android.content.Context;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.TextView;

public class PandaAdapter extends BaseExpandableListAdapter {
	public interface Child {
		public String getTitle();

		public String getSummary();
	}

	public interface Group {
		public List<? extends Child> getChildren();

		public String getLabel();
	}

	private List<? extends Group> groups;
	private LayoutInflater inflater;
	private boolean[] isGroupExpanded;

	public PandaAdapter(Context context, List<? extends Group> groups) {
		this.groups = groups;
		inflater = (LayoutInflater) context
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		isGroupExpanded = new boolean[groups.size()];
	}

	@Override
	public Object getChild(int groupPosition, int childPosition) {
		return groups.get(groupPosition).getChildren().get(childPosition);
	}

	@Override
	public long getChildId(int groupPosition, int childPosition) {
		return childPosition;
	}

	private View newView(int layoutId, ViewGroup parent) {
		return inflater.inflate(layoutId, parent, false);
	}

	@Override
	public View getChildView(int groupPosition, int childPosition,
			boolean isLastChild, View convertView, ViewGroup parent) {
		View v = convertView;
		if (v == null) {
			v = newView(android.R.layout.simple_expandable_list_item_2, parent);
		}
		Child c = groups.get(groupPosition).getChildren().get(childPosition);
		TextView tv1 = (TextView) v.findViewById(android.R.id.text1);
		TextView tv2 = (TextView) v.findViewById(android.R.id.text2);
		tv1.setText(c.getTitle());
		tv2.setText(c.getSummary());
		return v;
	}

	@Override
	public int getChildrenCount(int groupPosition) {
		return groups.get(groupPosition).getChildren().size();
	}

	@Override
	public Object getGroup(int groupPosition) {
		return groups.get(groupPosition);
	}

	@Override
	public int getGroupCount() {
		return groups.size();
	}

	@Override
	public long getGroupId(int groupPosition) {
		return groupPosition;
	}

	@Override
	public View getGroupView(int groupPosition, boolean isExpanded,
			View convertView, ViewGroup parent) {
		View v = convertView;
		if (v == null) {
			v = newView(android.R.layout.simple_expandable_list_item_1, parent);
		}
		TextView tv = (TextView) v.findViewById(android.R.id.text1);
		tv.setText(groups.get(groupPosition).getLabel());
		return v;
	}

	@Override
	public boolean hasStableIds() {
		return true;
	}

	@Override
	public boolean isChildSelectable(int groupPosition, int childPosition) {
		return true;
	}

	@Override
	public int getChildTypeCount() {
		return 1;
	}

	@Override
	public int getChildType(int groupPosition, int childPosition) {
		return 0;
	}

	@Override
	public int getGroupTypeCount() {
		return 2;
	}

	@Override
	public int getGroupType(int groupPosition) {
		return isGroupExpanded[groupPosition] ? 1 : 0;
	}

	@Override
	public void onGroupCollapsed(int groupPosition) {
		isGroupExpanded[groupPosition] = false;
	}

	@Override
	public void onGroupExpanded(int groupPosition) {
		isGroupExpanded[groupPosition] = true;
	}
}
