package your.example.folder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import your.example.folder.util.XmlUtility;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.InputType;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.BaseExpandableListAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ExpandableListView.OnChildClickListener;
import android.widget.ExpandableListView.OnGroupClickListener;
import android.widget.SimpleExpandableListAdapter;
import android.widget.TextView;
import android.widget.Toast;

public class LectureFolderActivity extends Activity{
    /** Called when the activity is first created. */
	public static final String PARENT_KEY = "TITLE";
	public static final String PARENT_DEFAULT = "DEFAULT";
	public static final String CHILD_KEY = "Title";
	public static final String CHILD_SUMMERY = "Summery";


	Button createBtn;
	ExpandableListView folderList;

	//�e�̃��X�g(�܂�t�H���_�̃��X�g)
	List<Map<String, Object>> parentList = new ArrayList<Map<String, Object>>();
	//���̃��X�g�̏W���̃��X�g(���g�̃��X�g�����ׂĂ܂Ƃ߂ĕێ�����)
	List<List<Map<String, Object>>> allChildList = new ArrayList<List<Map<String, Object>>>();

	Map<String, Object> defaultFolder;

	ExpandableListAdapter listAdapter ;
	TextView t;
	GroupClick gc;


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        setLayout();
        loadXml();
        if(parentList.size() <= 0){
        	makeDefaultList();
        }

        setActionListener();

    }

    private void setActionListener() {


		// TODO �����������ꂽ���\�b�h�E�X�^�u
    	folderList.setOnGroupClickListener(gc);

          // �O���[�v���̍��ڂ��N���b�N���ꂽ���ɌĂяo�����R�[���o�b�N��o�^
          folderList.setOnChildClickListener(new OnChildClickListener() {
            @Override
            public boolean onChildClick(ExpandableListView parent, View v,
                int groupPosition, int childPosition, long id) {
              // �N���b�N���ꂽ���̏���
            	Toast.makeText(LectureFolderActivity.this,
            			(String)allChildList.get(groupPosition).get(childPosition).get(CHILD_SUMMERY), Toast.LENGTH_LONG).show();
              return false;
            }
          });

          folderList.setOnItemLongClickListener(new LongClick(gc, t));

          createBtn.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				// TODO �����������ꂽ���\�b�h�E�X�^�u
				showCreateDialog();

			}});
	}

	private void setLayout(){
    	createBtn = (Button)findViewById(R.id.createFolderBtn);
    	folderList = (ExpandableListView)findViewById(R.id.folderList);
        t = (TextView)findViewById(R.id.MessageTextView);
        gc = new GroupClick(t);
    	getArrayAdapter();
    }

    private void makeDefaultList(){

    		Map<String, Object> parentNode = new HashMap<String, Object>();
    		parentNode.put(PARENT_KEY, "default");
    		parentNode.put(PARENT_DEFAULT, PARENT_DEFAULT);

    		parentList.add(parentNode);

    		defaultFolder = parentNode;

    		makeDefaultChildList();
    	}



    private void makeDefaultChildList(){
    	List<Map<String, Object>> childList = new ArrayList<Map<String, Object>>();

    	for(int j = 0; j < 5; j++){
    		Map<String, Object> childNode = new HashMap<String, Object>();
    		childNode.put(CHILD_KEY, "こうぎ-"+ j);
    		childNode.put(CHILD_SUMMERY, "さまりー" + j);
    		childList.add(childNode);
    	}
    	allChildList.add(childList);
    }

    private void getArrayAdapter(){

    	listAdapter = new SimpleExpandableListAdapter(
    			this,
    			parentList,
    			android.R.layout.simple_expandable_list_item_1,
    			new String[]{PARENT_KEY},
    			new int[]{android.R.id.text1},
    			allChildList,
    			android.R.layout.simple_expandable_list_item_2,
    			new String[]{CHILD_KEY, CHILD_SUMMERY},
    			new int[]{android.R.id.text1, android.R.id.text2});

    	folderList.setAdapter(listAdapter);
    }

    private void showCreateDialog(){
    	final EditText editText = new EditText(this);
    	editText.setInputType(InputType.TYPE_CLASS_TEXT);
    	editText.setText("新しいフォルダ");
    	AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this);
    	alertDialogBuilder.setTitle("新規作成");
    	alertDialogBuilder.setView(editText);

    	alertDialogBuilder.setPositiveButton("作成", new DialogInterface.OnClickListener(){

			@Override
			public void onClick(DialogInterface dialog, int which) {
				// TODO �����������ꂽ���\�b�h�E�X�^�u
				Map<String, Object> newNode = new HashMap<String, Object>();
				newNode.put(PARENT_KEY, editText.getText().toString());
				parentList.add(newNode);
				List<Map<String, Object>> newChildList = new ArrayList<Map<String, Object>>();
				allChildList.add(newChildList);
				writeListToXml();
				getArrayAdapter();

			}});

    	alertDialogBuilder.setCancelable(true);
    	AlertDialog alertDialog = alertDialogBuilder.create();
    	alertDialog.show();
    }

	// GROUP�̃X���b�v
    public void swapGroup(int position1, int position2) {
    	Map<String, Object> tmp1 = parentList.get(position1);
    	parentList.set(position1, parentList.get(position2));
    	parentList.set(position2, tmp1);
    	List<Map<String, Object>> tmp2 = allChildList.get(position1);
    	allChildList.set(position1, allChildList.get(position2));
    	allChildList.set(position2, tmp2);
    	((BaseExpandableListAdapter) listAdapter).notifyDataSetChanged();
    	writeListToXml();
    }
    // CHILD�̈ړ�
    public void moveChild(int toGroup, int fromGroup, int fromChild) {
    	Map<String, Object> tmp = allChildList.get(fromGroup).get(fromChild);
    	allChildList.get(fromGroup).remove(fromChild);
    	allChildList.get(toGroup).add(tmp);
    	((BaseExpandableListAdapter) listAdapter).notifyDataSetChanged();
    	writeListToXml();
    }

    // �O���[�v���N���b�N���ꂽ�Ƃ�
    class GroupClick implements OnGroupClickListener {
		boolean moveMode;
		int group, child;
		TextView t;
		GroupClick(TextView t) {
			moveMode = false;
			this.t = t;
		}
    	@Override
		public boolean onGroupClick(ExpandableListView parent, View v, int groupPosition, long id) {
			if(moveMode) {
				if(child == -1) {
					swapGroup(group, groupPosition);
				} else {
					moveChild(groupPosition, group, child);
				}
				t.setText("テストでござる!");
				moveMode = false;
			} else {
				if(parent.expandGroup(groupPosition))
        			for(int i=0; i<parentList.size(); i++) {
        				if(i != groupPosition) parent.collapseGroup(i);
        			}
        		else
        			 parent.collapseGroup(groupPosition);
			}
			return true;
		}
    	public void setMoveMode(int group, int child) {
    		moveMode = true;
    		this.group = group;
    		this.child = child;
    	}
    }
    // ���������ꂽ�Ƃ�
    class LongClick implements OnItemLongClickListener {
		GroupClick gc;
		TextView t;
		LongClick(GroupClick gc, TextView t) {
			this.gc = gc;
			this.t = t;
		}
    	@Override
		public boolean onItemLongClick(AdapterView<?> parent, View v, int position, long id) {
			ExpandableListView listView = (ExpandableListView) parent;
			long packed = listView.getExpandableListPosition(position);
			int group = ExpandableListView.getPackedPositionGroup(packed);
			int child = ExpandableListView.getPackedPositionChild(packed);
			// child�̎�(�Ԃ�l���P)
			if(ExpandableListView.getPackedPositionType(packed) == ExpandableListView.PACKED_POSITION_TYPE_CHILD) {
				t.setText("移す先のフォルダを選ぶどん!");
				gc.setMoveMode(group, child);
			} else if(ExpandableListView.getPackedPositionType(packed) == ExpandableListView.PACKED_POSITION_TYPE_GROUP){
				showSelectDialog(group, child);

			}
			return true;
		}


    }

    private void showSelectDialog(int group, int child){

    		final int numberOfSelectedListItem = group;
    		final int finalChild = child;
    		String[] SelectList = {"リネーム", "削除", "スワップ"};

    		AlertDialog.Builder builder = new AlertDialog.Builder(LectureFolderActivity.this);
    		builder.setItems(SelectList, new DialogInterface.OnClickListener() {

				@Override
				public void onClick(DialogInterface dialog, int which) {
					// TODO �����������ꂽ���\�b�h�E�X�^�u
					switch(which){
					case 0:{
						showRenameDialog(numberOfSelectedListItem);
						break;
					}
					case 1:{
						deleteFolderElement(numberOfSelectedListItem);

						break;
					}
					case 2:{
						//�ʒu���ړ����鍀�ڂ�I�������ꍇ
						t.setText("スワップする");
						gc.setMoveMode(numberOfSelectedListItem, finalChild);
						break;
					}
					}
				}
			});

    		builder.setCancelable(true);
        	builder.create().show();
    	}

    private void deleteFolderElement(int numberOfSelectedListItem){
    	//�t�H���_���폜����
		if(parentList.get(numberOfSelectedListItem).containsKey(PARENT_DEFAULT)){
			Toast.makeText(this, "It is default folder! can't delete.", Toast.LENGTH_LONG).show();
		}else{
			List<Map<String, Object>> deletedFolderElement = allChildList.remove(numberOfSelectedListItem);
			List<Map<String, Object>> childListToMove = allChildList.get(allChildList.size()-1);

		for(int i = 0; i < deletedFolderElement.size(); i++){
			Map<String, Object> element = deletedFolderElement.get(i);
			childListToMove.add(element);
		}
		parentList.remove(numberOfSelectedListItem);
		writeListToXml();
		getArrayAdapter();
		}
    }

    private void showRenameDialog(int group){
    	final EditText editText = new EditText(this);
    	final int finalGroup = group;
    	editText.setInputType(InputType.TYPE_CLASS_TEXT);
    	editText.setText((String)parentList.get(group).get(PARENT_KEY));
    	AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this);
    	alertDialogBuilder.setTitle("リネーム");
    	alertDialogBuilder.setView(editText);

    	alertDialogBuilder.setPositiveButton("リネーム", new DialogInterface.OnClickListener(){

			@Override
			public void onClick(DialogInterface dialog, int which) {
				// TODO �����������ꂽ���\�b�h�E�X�^�u
				parentList.get(finalGroup).remove(PARENT_KEY);
				parentList.get(finalGroup).put(PARENT_KEY, editText.getText().toString());
				writeListToXml();
				getArrayAdapter();
			}});

    	alertDialogBuilder.setCancelable(true);
    	AlertDialog alertDialog = alertDialogBuilder.create();
    	alertDialog.show();
    }

    public void writeListToXml(){
    	Map<String, Object> listMap = new HashMap<String, Object>();
    	listMap.put("PARENT", parentList);
    	listMap.put("LECTURE", allChildList);
    	listMap.put("DEFAULT", defaultFolder);

    	XmlUtility.writeXmlFile(this, listMap);
    }

    public void loadXml(){
    	Map<String, Object> listMap = XmlUtility.readXmlFile(this);

    	parentList = (List<Map<String, Object>>)listMap.get("PARENT");
    	allChildList = (List<List<Map<String, Object>>>)listMap.get("LECTURE");
    	defaultFolder = (Map<String, Object>)listMap.get("DEFAULT");
    	getArrayAdapter();
    }
}