//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// EB01.cpp: EB01 NX̃Cve[V
//	F
// $Log: EB01.cpp,v $
// Revision 1.1  2001/10/28 21:40:35  fujiwara
// DLLɕ
//
// Revision 1.7  2001/07/09 20:30:08  fujiwara
// Ȏgݍ
//
// Revision 1.6  2001/07/01 21:30:33  fujiwara
// [N`FbN
//
// Revision 1.5  2001/07/01 01:03:43  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.4  2001/05/29 01:12:55  fujiwara
// GL(sj̍쐬BzuGfB^̃oOC
//
// Revision 1.3  2001/05/17 12:34:10  fujiwara
// nGTv쐬
//
// Revision 1.2  2001/05/13 20:04:23  fujiwara
// [[N̂Ŏ菜B
// ẽTEheXg
//
// Revision 1.1  2001/05/12 22:26:16  fujiwara
// GeNXVKǉ
//
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
// Copyright (C) 2000 Satoshi Fujiwara. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
#pragma warning( disable : 4786 )	//STĽxO

// [[Nop
#include "sfdebug.h"

// System Includes //

#include <string>
#include <vector>
#include <memory>
#include <stack>
#include <list>
#include <iostream>
#include <fstream>
#include <map>
#include "stdio.h"
#include "math.h"

// Project Includes  //

#include "exception.h"
#include "singleton.h"
#include "system.h"
#include "console.h"
#include "input.h"
#include "sound.h"

#include "Obj.h"
#include "Obj2D.h"
#include "Obj3D.h"
#include "Obj3DL.h"
#include "ObjRectangle.h"
#include "ObjQuadrangle.h"

#include "Background.h"
#include "Scene.h"
#include "main.h"

#include "character.h"
#include "Hit.h"
#include "MyShip.h"
#include "Game.h"
#include "Enemys.h"
#include "Armys.h"
#include "EnemyBullets.h"
#include "DispositionControl.h"
#include "Effects.h"
#include "Explosion.h"
#include "EB01.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


using namespace sf::application;
using namespace sf::application::enemy;

sf::system::console::sprite::PSprite EB01::mspSprite;

const sf::system::console::sprite::Info EB01::msSpriteInfo = 
{
	"media\\EB01.tga",0.0f,0.0f,0.0f,0.0f,0xff000000,console::sprite::SPRITE2D
};

const int EB01::SCORE = 20;
int		EB01::msSoundID = 0;

// RXgN^ |||||||||||||||||||||||||||||
EB01::EB01()
{

}// EB01()

// fXgN^ ||||||||||||||||||||||||||||||
EB01::~EB01()
{
	Bullets::instance()->clear(index());
}// ~EB01()


//  |||||||||||||||||||||||||||||||||
void EB01::initialize()
{
	// 蔻 
	mHitRect.offsetTop(-8.0f);
	mHitRect.offsetBottom(8.0f);
	mHitRect.offsetLeft(-8.0f);
	mHitRect.offsetRight(8.0f);

	mHitRect.isChecking(true);
	mHitRect.characterPtr(this);
	float dtime = sf::system::instance()->deltaTime();
	speed(8.0f * dtime);
	
	mObj.index(0);
	mObj.sprite(mspSprite.get());
	
	mObj.z(z());
	mObj.x(x());
	mObj.y(y());
	mObj.visibility(true);
	mObj.color(0xffffffff);
	mObj.drawMode(sf::system::console::DRAW_ADD);

	mbHit = false;
	mDirCount = 18;
	mDirSpeed = (rand() & 1) ? -0.2f * dtime : 0.2f * dtime;
	mState = MOVE;
	sf::system::instance()->sound()->play(msSoundID,1,false,false);
}// initialize()

// eNX`̃[h |||||||||||||||||||||||||||
void EB01::load(void){
	using namespace sf::system::console::sprite;
	if(!mspSprite.get()){
		PSprite ptemp(sf::system::instance()->console()->createSprite(&msSpriteInfo)); 
		mspSprite = ptemp;
	}
	// TEh̃[h
	msSoundID = sf::system::instance()->sound()->load("EB01.WAV") ;
}// load()

// eNX`̃A[h |||||||||||||||||||||||||
void EB01::unload(void){
	using namespace sf::system::console::sprite;
	PSprite ptmp(NULL);
	mspSprite = ptmp;
}// unload()

// G̓ ||||||||||||||||||||||||||||||||
void EB01::move()
{
	
	using namespace sf::system::console;

	y(y() + mDy);
	x(x() + mDx);

	switch(mState){
	case MOVE:

		mObj.x(x());
		mObj.y(y());
				
		mObj.angle(mObj.angle() + mDirSpeed);
		
		if(mObj.angle() > 2.0f * sf::system::PI)
			mObj.angle(mObj.angle() - 2 * sf::system::PI);

		if(mObj.angle() < 0.0f)
			mObj.angle(2 * sf::system::PI - mObj.angle() );

		if(mbHit)
		{
			die();
			return;
		}
		break;
	case DEAD:
		delete this;
		return;
	}

	if(Util::checkArea(x(),y(),mObj.sprite()))
		delete this;

}//move()



// @ɂƂ̏ |||||||||||||||||||||||||
void EB01::hit(Character * const pDest)
{
	mHitRect.isChecking(false);
	mbHit = true;

};

// Ge̐ ||||||||||||||||||||||||||||||||
sf::application::Character * const EB01::create(float x,float y ,float z,sf::application::scene::Game * const pGame,int index)
{
	EB01 * ptemp = new EB01;
	ptemp->x(x);
	ptemp->y(y);
	ptemp->z(z);
	ptemp->index(index);
	ptemp->game(pGame);
	ptemp->initialize();
	return ptemp;
;}// create

//@񂾂Ƃ̏  |||||||||||||||||||||||||||
void EB01::die(void)
{
	effect::Explosion *pExp = (effect::Explosion*)effect::Effects::instance()->create(effect::Effects::EXPLOSION,x(),y(),0.1f,game(),this);
	if(pExp){
		pExp->scaling(1.5f);
	}
	mDirCount = 2;
	mState = DEAD;
	game()->score(game()->score() + SCORE);

};// die()

//  SCxg ||||||||||||||||||||||||||||
void EB01::allBomb(void)
{
	die();
}// allBomb()

// ړ (WAj
const float EB01::direction(void){return AbstractCharacter::direction();};
void EB01::direction(const float value)
{   AbstractCharacter::direction(value);
	mDx = cosf(value) * speed();
	mDy = sinf(value) * speed();
	mObj.angle(value + sf::system::PI / 2.0f);
};
