//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// Manager.h: Manager NX̃C^[tFCX
//	F
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
///////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MANAGER_H__54ECBFD0_103D_4D71_83BB_83D948FD2892__INCLUDED_)
#define AFX_MANAGER_H__54ECBFD0_103D_4D71_83BB_83D948FD2892__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "windows.h"
#include "Exception.h"
#include <iosfwd>
#include "stdafx.h"
namespace sf {
	namespace application {
		namespace scene {
			// ----------------------------------------------------------------
			// ReiNX 
			// ----------------------------------------------------------------
			typedef std::list<Scene *> SceneContainer;

			class Container : public Listener
			{
				DECLARE_SINGLETON(Container)

				Container();
			public:
				~Container();

				void add(Scene * const pScene)
				{  
					mContainer.push_back(pScene);
					pScene->addListener(this);
				};

				// V[|C^̎擾
				void move(void)
				{
					
					if(mContainer.empty()){
						throw sf::system::RecoverbleErrorException("Scene is Empty",__FILE__,__LINE__,sf::system::Exception::SCENE_IS_EMPTY);
					};

					for(SceneContainer::iterator it = mContainer.begin();it != mContainer.end();++it)
					{
						if(*it != NULL){
							if((*it)->isActive()){
								(*it)->move();
							}
						}
					}
				};

				// NULL|C^̍폜
				void eraseNull(void)
				{
					for(SceneContainer::iterator it = mContainer.begin();it != mContainer.end();++it)
					{
						if(*it == NULL){
							it = mContainer.erase(it);
						}
					}

				};

				// V[Ȉ 
				virtual void endOfScene(Scene * const pScene)
				{	
					for(SceneContainer::iterator it = mContainer.begin();it != mContainer.end();++it)
					{
						if(*it == pScene){
							*it = NULL;
							break;
						}
					}

				};

				// V[Ȉ 
				const bool findScene(Scene * const pScene)
				{	
					for(SceneContainer::iterator it = mContainer.begin();it != mContainer.end();++it)
					{
						if(*it == pScene){
							return true;
						}
					}
					return false;
				};
				
				virtual void exitKeyPressed(Scene * const pScene)
				{	endOfScene(pScene);};
			private:
				 SceneContainer mContainer;
			};// Container
			
			
			// |||||||||||||||||||||||||||||||
			// V[ckkpNX
			// IѐÓIɃV[ckk[hAJdg݂񋟂
			// |||||||||||||||||||||||||||||||

			class DLL;

			std::ostream & operator <<
                ( std::ostream &rOStrm    
                , const sf::application::scene::DLL & rDll);  
			
			std::istream& operator >> 
				(	std::istream& rIStrm, 
				sf::application::scene::DLL &rDLL);

			// DLL
			class DLL : public sf::application::scene::Listener
			{
			public:
				friend std::ostream & operator <<
                ( std::ostream &rOStrm    // cStrStrm
	                , const sf::application::scene::DLL & rDll);
				friend std::istream& operator >> 
				(	std::istream& rIStrm, 
				sf::application::scene::DLL &rDLL);
				
				// LIFE CYCLE;
				DLL()
				{
					mbPreLoad = false;
					mhModule = NULL;
					mpCreateFunc = NULL;
				};

				DLL(const char * pDLLName,const bool bPreLoad = false)
				{
					mDLLName = pDLLName;
					if(bPreLoad){
						mbPreLoad = true;
						mhModule = LoadLibrary(pDLLName);
						mpCreateFunc = (CreateSceneMethod)GetProcAddress(mhModule,"createScene");

					} else {
						mbPreLoad = false;
						mhModule = NULL;
						mpCreateFunc = NULL;
					}
				};

				~DLL()
				{
					// 폜OTalkerւListnero^폜
					std::vector<Scene *>::iterator it = mSceneList.begin();
					while(it != mSceneList.end()){
						(*it)->removeListener(this);
						it = mSceneList.erase(it);
						it++;
					}
					// ێĂ郉CuJ
					if(mhModule){
						FreeLibrary(mhModule);
					}

				};

				// OPERATORS //
				// OPERATIONS //
				// DLL̃[h
				void load()
				{
					if(mhModule) return;
					mhModule = LoadLibrary(mDLLName.c_str());
					mpCreateFunc = (CreateSceneMethod)GetProcAddress(mhModule,"createScene");
				};

				// DLL̃V[̍쐬
				Scene * const createScene(const int id,const bool bAddSceneContainer = true)
				{
					if(mhModule){
						Scene * pscene = (*mpCreateFunc)(id);
						pscene->addListener(this);
						mSceneList.push_back(pscene);
						addRef();
						if(bAddSceneContainer){
							Container::instance()->add(pscene);
						}
						return pscene;
					};
					return NULL;
				}

				// m[}I
				void endOfScene(Scene * const pScene)
				{
					std::vector<Scene *>::iterator it = mSceneList.begin();
					while(it != mSceneList.end()){
						if(*it == pScene){
							mSceneList.erase(it);
							break;
						}
						it++;
					}
					release();
				};

				// ExitL[ꂽ
				void exitKeyPressed(Scene * const pScene){;};

				// INQUIRY //
				// DLL[hĂ邩ǂ
				const bool isLoad() const {return (mhModule != NULL);};
				const std::string & name(void){return mDLLName;};
			private:
				// DLL̊J
				void freeLibrary()
				{	FreeLibrary(mhModule);
					mhModule = NULL;
				};

				// QƃJE^̉Z 
				void addRef(){mRefCount++;};

				// QƃJE^̌ZA[X 
				void release()
				{	if(mRefCount){
						mRefCount--;
						if(!mRefCount && !mbPreLoad){
							freeLibrary();
						}
					}
				};

				std::string mDLLName;
				HMODULE mhModule;
				bool mbPreLoad;
				CreateSceneMethod mpCreateFunc;
				int mRefCount;

				// Talkerւ̃|C^ێ //
				std::vector<Scene *> mSceneList;

			};// DLL NX;
			
			// DLL[fBOpIy[^I[o[[h
			std::ostream& operator <<
                ( std::ostream &rOStrm    
                , const sf::application::scene::DLL & rDLL)   
			{
				rOStrm << rDLL.mDLLName;
				if(rDLL.mbPreLoad){
					rOStrm << " PRELOAD";
				} else {
					rOStrm << " DELAYLOAD";
				}
				return rOStrm;
			};// std::ostream & operator<<;

			std::istream& operator >> 
				(	std::istream& rIStrm, 
				sf::application::scene::DLL &rDLL)
			{
				std::string tmp;
				rIStrm >> rDLL.mDLLName;
				rIStrm >> tmp;
				
				if(tmp == "PRELOAD"){
					rDLL.mbPreLoad = true;
				} else {
					rDLL.mbPreLoad = false;
				}
				return rIStrm;
			};// std::istream& operator >> 
			
			// ||||||||||||||||||||||||||||||||||
			// DLLǗNX 
			// ||||||||||||||||||||||||||||||||||
			class DLLManager
			{
				DECLARE_SINGLETON(DLLManager)
			public:
				~DLLManager(){
					unload();
				};//

				// V[DLL̃[h //
				void load(const char * pFileName)
				{
					std::fstream dll_conf(pFileName,std::ios::in);
					if(!dll_conf.is_open()){
						throw sf::system::FatalErrorException("Scene Def File Not Found",__FILE__,__LINE__);
					}
					
					int i = 0;
					int scene_index;

					while(!dll_conf.eof())
					{
						dll_conf >> scene_index;
						DLL* pdll = new DLL;
						dll_conf >> (*pdll);
						int j;
						int dll_index = i;
						
						for(j = 0;j < mDLLs.size();j++){
							if(mDLLs[j]->name() == pdll->name()){
								dll_index = j;
								break;
							}
						}
						
						if(dll_index == i){
							mDLLs.push_back(pdll);
						} else {
							delete pdll;
						};

						Node* nd = new Node;
						nd->mDLLIndex = dll_index;
						nd->mDLLInternalIndex = scene_index;
						mSceneIndex.push_back(nd);
					};

				};// load()
				
				// A[h //
				void unload(){

					std::vector<Node *>::iterator it = mSceneIndex.begin();
					while(!mSceneIndex.empty()){
						delete *it;
						it = mSceneIndex.erase(it);
					}

					std::vector<sf::application::scene::DLL *>::iterator it1 = mDLLs.begin();
					while(!mDLLs.empty()){
						delete *it1;
						it1 = mDLLs.erase(it1);
					}

				};// unload()

				// V[CX^X̐ //
				Scene * const createScene(const int id,const bool bAddSceneContainer = true){
					return mDLLs[mSceneIndex[id]->mDLLIndex]->createScene(mSceneIndex[id]->mDLLInternalIndex,bAddSceneContainer); 
				};// createScene()

			private:
				
				struct Node {
					int mDLLIndex;
					int mDLLInternalIndex;
				};

				// DLL̃Xg
				std::vector<sf::application::scene::DLL *> mDLLs;
				// V[DLLΉ\
				std::vector<Node *> mSceneIndex;
			};// DLLManager
			
/*
			// ----------------------------------------------------------------
			// ҏWʃp[^ NX 
			// ----------------------------------------------------------------
			class Game;

			SF_INTERFACE BGEditor
			{
			public:
				BGEditor(){;};
				virtual ~BGEditor(){;};
				// OPERATORS //
				// OPERATIONS //
				// ACCESS //
				virtual void game(Game * const pGame) = 0;
				virtual Game * const game(void) const = 0;
			};

			SF_INTERFACE DispositionEditor
			{
			public:
				DispositionEditorParameter(){;};
				virtual ~DispositionEditorParameter(){;};
				// OPERATORS //
				// OPERATIONS //
				// ACCESS //
				
				virtual void game(Game * const pGame) = 0;
				virtual Game * const game(void) const  = 0; 
			};
*/

		}
	}
}

#endif // !defined(AFX_MANAGER_H__54ECBFD0_103D_4D71_83BB_83D948FD2892__INCLUDED_)
