/**
 * @file
 * @brief Sprite2DNX֘A̒`s.
 * 
 * 
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */


/// dCN[hh~}N
#if !defined(AFX_SPRITE2D_H__6DA7673D_29FF_4B0A_838E_FE14D70C7E27__INCLUDED_)
#define AFX_SPRITE2D_H__6DA7673D_29FF_4B0A_838E_FE14D70C7E27__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "sf.h" 
#include "Console.h"
extern "C" {
namespace sf{
	namespace system{
		namespace console {
			namespace sprite {
				/** 2DXvCg̒`s.
 					2DXvCgp̃eNX`ێIuWFNgłB<br>
				*/
				class Sprite2D : public AbstractSprite  
				{
					// LIFECYCLE //
				public:
					/** RXgN^ 
					 * @param pD3DDevice Direct3D Deviceւ̃|C^ */
					Sprite2D(LPDIRECT3DDEVICE9 pD3DDevice);
					/** fXgN^.*/
					virtual ~Sprite2D();
					// OPERATIONS //
					
					/// Sprite2DNX̏s
					void initialize(void);
					
					/** Sprite2DNX̏s.
					 *  @param pD3DDevice Direct3D Deviceւ̃|C^*/ 
					void initialize(LPDIRECT3DDEVICE9	pD3DDevice);
					/** Is */
					void uninitialize(void);
					/** eNX`f[^̃[h 
					 @param pInfo sprite::Info ̃|C^ 
					 @textureFormat D3DFORMAT  
					 @color console::COLOR */
					void load(const sprite::Info *pInfo,const D3DFORMAT textureFormat,const COLOR color);
					void draw(const ObjRectangle * const pObj);
					void draw(const ObjQuadrangle * const pObj);
					void draw(const Obj3DL * const pObj){return;};
					
					const float width(void) const 
					{
						if(mCellWidth != 0.0f)
							return mCellWidth;
						return mWidth;
					};

					const float height(void) const {
						if(mCellHeight != 0.0f)
							return mCellHeight;
						return mHeight;
					};

				private:
					/** eNX`UVWvZ.
					 * sprite::Obj2D ̏ɁA\͈͂߂܂B
					 * @param pObj Obj2D ̃|C^ 
					 * @param u1 JnuW 
					 * @param u2 IuW 
					 * @param v1 JnvW 
					 * @param v2 IvW */
					void calcUVPos(const Obj2D * const pObj,float& u1,float& u2,float& v1,float& v2);
					IDirect3DTexture9* mpSpriteTexture;///< XvCgeNX`̃|C^
					IDirect3DVertexBuffer8* mpSpriteVtBuf;///< VertexBuffer8 ̃|C^

					float mCellWidth;///< Z̕(eNX`͂̕Ř_Iɕ)
					float mCellHeight;///< Z̍(eNX`͂̍Ř_Iɕ)
					float mCellCount;///< Z̐(_Iɕꂽ̃eNX`̐j

				};// SpriteImpl
			}
		}
	}
}
}
#endif // !defined(AFX_SPRITE2D_H__6DA7673D_29FF_4B0A_838E_FE14D70C7E27__INCLUDED_)
