/**
 * @file AbstractSprite.h
 * @brief SpriteC^[tF[X̋ʎ`s.
 * 
 * hNXŋʂŎgpłȃ\bhAoŋLq܂B
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dCN[hh~}N
#if !defined(AFX_ABSTRACTSPRITE_H__13F6E957_5370_42BC_B5F5_FEF71D80C1DE__INCLUDED_)
#define AFX_ABSTRACTSPRITE_H__13F6E957_5370_42BC_B5F5_FEF71D80C1DE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "sf.h"
#include "Console.h"

extern "C" {

namespace sf{
	namespace system{
		namespace console {
			namespace sprite {

/** SpriteC^[tF[X̋ʎ 
 * hNX͂̒ۃNXpA܂B	*/
class AbstractSprite : public Sprite  
{
public:
	/// RXgN^
	AbstractSprite();
	/// fXgN^
	virtual ~AbstractSprite();
	// OPERATIONS //
	/// s
	virtual void initialize(void) = 0;
	/** s.
	 * @param pD3DDevice Direct3D@foCX̃|C^ */
	virtual void initialize(LPDIRECT3DDEVICE9	pD3DDevice) = 0;
	
	/** Is */
	virtual void uninitialize(void) = 0;

	/** eNX`f[^̃[hs.
	 @param pInfo sprite::Info ̃|C^ 
	 @textureFormat D3DFORMAT  
	 @color console::COLOR */
	virtual void load(const sprite::Info *pInfo,const D3DFORMAT textureFormat,const COLOR color) = 0;

	/** `p_OXe[gݒ肷.
	 * @param value sprite::DrawMode */
	void setRenderState(const DrawMode value);
	
	// ACCESS //
	
	/** XvCg̎gpԂ擾
	 * @return XvCg̎gp */
	const bool use(void) const {return mbUse;};
	/** XvCg̎gpԂ擾
	 * @param value XvCg̎gp */
	void use(const bool value){mbUse = value;};
	
	const float width(void) const {return mWidth;};
	void  width(const float value) {mWidth = value;};
	
	const float height(void) const {return mHeight;};
	void height(const float value) {mHeight = value;};

	const float centerX(void) const {return mCenterX;};
	void centerX(const float value) {mCenterX = value;};

	const float centerY(void)  const {return mCenterY;};
	void centerY(const float value) {mCenterY = value;};


	// INQUIRY //
	/// XvCg̎gpԂ̎擾
	const bool isUsed() const {return mbUse;};
protected:

	bool mbUse;///< gpĂ邩ǂ
	LPDIRECT3DDEVICE9		mpD3DDevice;///< D3DfoCX̃|C^

	float mWidth;///< XvCg̕
	float mHeight;///< XvCg̍
	float mCenterX;///< SXW
	float mCenterY;///< SYW

	TYPE			mType;///< XvCg̃^Cv

};
			}
		}
	}
}
}
#endif // !defined(AFX_ABSTRACTSPRITE_H__13F6E957_5370_42BC_B5F5_FEF71D80C1DE__INCLUDED_)
