/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.connect;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jdbcacsess2.connect.ConfigConnect;
import jdbcacsess2.connect.ConfigDbms;
import jdbcacsess2.connect.ConnectTableModel;
import jdbcacsess2.connect.ConnectView;
import jdbcacsess2.main.Config;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.main.ShowDialog;
import jdbcacsess2.sqlService.DataBaseConnection;
import jdbcacsess2.sqlService.DataBaseConnectionListener;
import jdbcacsess2.sqlService.DataBaseListener;
import jdbcacsess2.sqlService.DataBaseTransactionListener;
import net.java.ao.DBParam;

public class ConnectController {
    private Config config;
    private final List<DataBaseListener> requestListeners = new CopyOnWriteArrayList<DataBaseListener>();
    private ConnectView view;
    private ConnectTableModel connectTableModel;
    private final ListSelectionListener selectionConnectList = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Jdbcacsess2.logger.finer(e.toString());
            if (e.getValueIsAdjusting()) {
                return;
            }
            ConfigConnect row = ConnectController.this.view.getSelectedConfigConnect();
            if (row == null) {
                return;
            }
            ConnectController.this.view.getJTextFieldConnectName().setText(row.getConnectName());
            ConnectController.this.view.getJComboBoxDBMS().setSelectedItem(row.getConfigDbms());
            ConnectController.this.view.getJTextFieldUser().setText(row.getConnectUser());
            ConnectController.this.view.getJPasswordFieldPassword().setText(row.getPassword());
            ConnectController.this.view.getJTextFieldHostName().setText(row.getHostName());
            ConnectController.this.view.getJTextFieldPortNumber().setText(row.getPortNumber());
            ConnectController.this.view.getJTextFieldDatabaseName().setText(row.getDatabaseName());
            ConnectController.this.view.getJTextFieldClassName().setText(row.getClassName());
            ConnectController.this.view.getJTextAreaDriverFile().setText(row.getDriverFile());
            ConnectController.this.view.getJTextFieldUrlOption().setText(row.getUrlOption());
        }
    };
    private final JdbcUrlChnageListener changeJdbcUrl = new JdbcUrlChnageListener();
    private final ItemListener changeDbms = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                return;
            }
            ConfigDbms selectDbms = (ConfigDbms)ConnectController.this.view.getJComboBoxDBMS().getSelectedItem();
            if (selectDbms == null) {
                return;
            }
            ConnectController.this.view.getJTextFieldClassName().setEditable(selectDbms.getDriverclass().equals(""));
            ConnectController.this.view.getJTextFieldClassName().setOpaque(selectDbms.getDriverclass().equals(""));
            ConnectController.this.view.getJTextFieldClassName().setText(selectDbms.getDriverclass());
        }
    };
    private final Action actionFileChoose = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("ApproveSelection")) {
                        ConnectController.this.addDriverFile(jFileChooser);
                    }
                }
            });
            jFileChooser.showOpenDialog(ConnectController.this.view);
        }
    };
    private final WindowAdapter windowClosing = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            try {
                ConnectView.ConfigViewConnect configViewConnect = ConnectController.this.config.getConfigWindow(ConnectView.ConfigViewConnect.class);
                ConnectController.this.view.collectViewConnect(configViewConnect);
                configViewConnect.save();
            }
            catch (SQLException ex) {
                ShowDialog.errorMessage(ex);
            }
        }
    };
    private final Action actionClose = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ConnectView.ConfigViewConnect configViewConnect = ConnectController.this.config.getConfigWindow(ConnectView.ConfigViewConnect.class);
                ConnectController.this.view.collectViewConnect(configViewConnect);
                configViewConnect.save();
            }
            catch (SQLException ex) {
                ShowDialog.errorMessage(ex);
            }
            ConnectController.this.view.dispose();
        }
    };
    private final MouseListener connectClickMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2) {
                ConnectController.this.view.getJButtonConnect().doClick();
            }
        }
    };
    private final Action actionConnect = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DataBaseConnection dbc = new DataBaseConnection(ConnectController.this.view.getJTextAreaURL().getText(), ConnectController.this.view.getJTextFieldUser().getText(), new String(ConnectController.this.view.getJPasswordFieldPassword().getPassword()), ConnectController.this.view.getJTextFieldClassName().getText(), DataBaseConnection.splitPath(ConnectController.this.view.getJTextAreaDriverFile().getText()), ConnectController.this.view.getJTextFieldConnectName().getText());
                new DbOpen(dbc).execute();
            }
            catch (Exception e1) {
                ShowDialog.errorMessage(e1);
            }
        }
    };
    private final Action actionConnectTest = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DataBaseConnection dbc = new DataBaseConnection(ConnectController.this.view.getJTextAreaURL().getText(), ConnectController.this.view.getJTextFieldUser().getText(), new String(ConnectController.this.view.getJPasswordFieldPassword().getPassword()), ConnectController.this.view.getJTextFieldClassName().getText(), DataBaseConnection.splitPath(ConnectController.this.view.getJTextAreaDriverFile().getText()), ConnectController.this.view.getJTextFieldConnectName().getText());
                new DbTestOpen(dbc).execute();
            }
            catch (Exception ex) {
                ShowDialog.errorMessage(ex);
            }
        }
    };
    private final Action actionNewSave = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DBParam dbParam = new DBParam("connectname", (Object)ConnectController.this.view.getJTextFieldConnectName().getText());
                ConfigConnect configConnect = (ConfigConnect)ConnectController.this.config.getEntityManager().create(ConfigConnect.class, new DBParam[]{dbParam});
                ConnectController.this.collectInputData(configConnect);
                ConnectController.this.connectTableModel.append(configConnect);
            }
            catch (SQLException e1) {
                ShowDialog.errorMessage(e1);
            }
            catch (ConnectTableModel.AlreadyExistsException e2) {
                ShowDialog.errorMessage(e2);
            }
        }
    };
    private final Action actionSave = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigConnect configConnect = ConnectController.this.view.getSelectedConfigConnect();
            if (configConnect == null) {
                return;
            }
            ConnectController.this.collectInputData(configConnect);
            ConnectController.this.connectTableModel.update(configConnect);
        }
    };
    private final Action actionRemove = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigConnect configConnect = ConnectController.this.view.getSelectedConfigConnect();
            if (configConnect == null) {
                return;
            }
            int ans = JOptionPane.showConfirmDialog(ConnectController.this.view, String.valueOf(configConnect.getConnectName()) + "\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "\u524a\u9664\u78ba\u8a8d", 0);
            if (ans == 0) {
                try {
                    ConnectController.this.connectTableModel.remove(configConnect);
                }
                catch (SQLException e1) {
                    ShowDialog.errorMessage(e1);
                }
            }
        }
    };

    private void addDriverFile(JFileChooser jFileChooser) {
        ArrayList<String> files = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.view.getJTextAreaDriverFile().getText(), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("")) continue;
            files.add(s);
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            files.add(f.getAbsolutePath());
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        for (String f : files) {
            if (sb.length() != 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(f);
        }
        this.view.getJTextAreaDriverFile().setText(sb.toString());
    }

    public ConnectController(Config config, JFrame owner) throws SQLException {
        this.config = config;
        this.view = new ConnectView(owner);
        this.addListener();
        this.view.getJComboBoxDBMS().setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -6249257421893883408L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value != null) {
                    ConfigDbms dbms = (ConfigDbms)value;
                    return super.getListCellRendererComponent(list, dbms.getDbmsName(), index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
            }
        });
        this.view.getJComboBoxDBMS().setModel(new DefaultComboBoxModel<ConfigDbms>(config.getConfigDbms()));
        this.view.getJComboBoxDBMS().setSelectedItem(null);
        this.connectTableModel = new ConnectTableModel(config);
        this.view.getJTableConnect().setModel(this.connectTableModel);
        this.view.getJTableConnect().getRowSorter().toggleSortOrder(0);
        ConnectView.ConfigViewConnect[] c = (ConnectView.ConfigViewConnect[])config.getEntityManager().find(ConnectView.ConfigViewConnect.class);
        if (c.length != 0) {
            this.view.setViewConnect(c[0]);
        }
    }

    private void addListener() throws SQLException {
        this.view.getJTableConnect().getSelectionModel().addListSelectionListener(this.selectionConnectList);
        this.view.getJTableConnect().addMouseListener(this.connectClickMouseListener);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.view.getJTableConnect().getInputMap().put(enter, "enter");
        this.view.getJTableConnect().getActionMap().put("enter", this.actionConnect);
        this.view.getJButtonConnect().addActionListener(this.actionConnect);
        this.view.getJButtonClose().addActionListener(this.actionClose);
        this.view.getJButtonFileChoose().addActionListener(this.actionFileChoose);
        this.view.getJButtonConnectTest().addActionListener(this.actionConnectTest);
        this.view.getJButtonNewSave().addActionListener(this.actionNewSave);
        this.view.getJButtonSave().addActionListener(this.actionSave);
        this.view.getJButtonRemove().addActionListener(this.actionRemove);
        this.view.getJComboBoxDBMS().addItemListener(this.changeDbms);
        this.view.getJComboBoxDBMS().addActionListener(this.changeJdbcUrl);
        this.view.getJTextFieldHostName().getDocument().addDocumentListener(this.changeJdbcUrl);
        this.view.getJTextFieldPortNumber().getDocument().addDocumentListener(this.changeJdbcUrl);
        this.view.getJTextFieldDatabaseName().getDocument().addDocumentListener(this.changeJdbcUrl);
        this.view.getJTextFieldUrlOption().getDocument().addDocumentListener(this.changeJdbcUrl);
        this.view.addWindowListener(this.windowClosing);
    }

    private void collectInputData(ConfigConnect row) {
        row.setConnectName(this.view.getJTextFieldConnectName().getText().trim());
        row.setConfigDbms((ConfigDbms)this.view.getJComboBoxDBMS().getSelectedItem());
        row.setConnectUser(this.view.getJTextFieldUser().getText().trim());
        row.setPassword(new String(this.view.getJPasswordFieldPassword().getPassword()));
        row.setHostName(this.view.getJTextFieldHostName().getText().trim());
        row.setPortNumber(this.view.getJTextFieldPortNumber().getText().trim());
        row.setDatabaseName(this.view.getJTextFieldDatabaseName().getText().trim());
        row.setClassName(this.view.getJTextFieldClassName().getText().trim());
        row.setDriverFile(this.view.getJTextAreaDriverFile().getText().trim());
        row.setUrlOption(this.view.getJTextFieldUrlOption().getText().trim());
    }

    public void setVisible(boolean b) {
        this.view.setVisible(b);
    }

    public void addReauestDataBaseListener(DataBaseListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.requestListeners.add(listener);
    }

    private class DbOpen
    extends SwingWorker<Object, Object>
    implements DataBaseConnectionListener {
        private final DataBaseConnection dbc;

        DbOpen(DataBaseConnection dbc) {
            this.dbc = dbc;
            ConnectController.this.view.getJProgressBar().setIndeterminate(true);
        }

        @Override
        public Object doInBackground() {
            for (DataBaseListener listener : ConnectController.this.requestListeners) {
                if (listener instanceof DataBaseConnectionListener) {
                    this.dbc.addConnectionListener((DataBaseConnectionListener)listener);
                }
                if (!(listener instanceof DataBaseTransactionListener)) continue;
                this.dbc.addTransactionListener((DataBaseTransactionListener)listener);
            }
            this.dbc.addConnectionListener(this);
            try {
                this.dbc.open();
            }
            catch (Exception ex) {
                ShowDialog.errorMessage(ex);
            }
            return null;
        }

        @Override
        protected void done() {
            ConnectController.this.view.getJProgressBar().setIndeterminate(false);
        }

        @Override
        public void dataBaseConnectionOpened(DataBaseConnection dataBaseConnection) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ConnectController.this.view.getJCheckBoxAutosave().isSelected()) {
                            ConfigConnect rowSave = ConnectController.this.config.getConfigConnectRow(ConnectController.this.view.getJTextFieldConnectName().getText());
                            ConnectController.this.collectInputData(rowSave);
                            ConnectController.this.connectTableModel.save(rowSave);
                        }
                        ConfigConnect[] row = ConnectController.this.config.getConfigConnect();
                        ConfigConnect connectedConfigConnect = null;
                        int i = 0;
                        while (i < row.length) {
                            if (row[i].getConnectName().equals(ConnectController.this.view.getJTextFieldConnectName().getText())) {
                                Date lastConnectdate = new Date();
                                row[i].setLastConnectdate(lastConnectdate);
                                row[i].save();
                                connectedConfigConnect = row[i];
                                break;
                            }
                            ++i;
                        }
                        ConnectView.ConfigViewConnect configViewConnect = ConnectController.this.config.getConfigWindow(ConnectView.ConfigViewConnect.class);
                        ConnectController.this.view.collectViewConnect(configViewConnect);
                        if (connectedConfigConnect != null) {
                            configViewConnect.setConfigConnect(connectedConfigConnect);
                        }
                        configViewConnect.save();
                    }
                    catch (SQLException e) {
                        ShowDialog.errorMessage(e);
                    }
                    ConnectController.this.requestListeners.clear();
                    ConnectController.this.view.dispose();
                }
            });
        }

        @Override
        public void dataBaseConnectionClosing(DataBaseConnection dataBaseConnection) {
            dataBaseConnection.removeConnectionlisteners(this);
        }

        @Override
        public void dataBaseConnectionClosed(DataBaseConnection dataBaseConnection) {
        }
    }

    private class DbTestOpen
    extends SwingWorker<Object, Object>
    implements DataBaseConnectionListener {
        private final DataBaseConnection dbc;

        DbTestOpen(DataBaseConnection dbc) {
            this.dbc = dbc;
            ConnectController.this.view.getJProgressBar().setIndeterminate(true);
        }

        @Override
        public Object doInBackground() {
            this.dbc.addConnectionListener(this);
            try {
                this.dbc.open();
                this.dbc.close();
            }
            catch (Exception ex) {
                ShowDialog.errorMessage(ex);
            }
            return null;
        }

        @Override
        protected void done() {
            ConnectController.this.view.getJProgressBar().setIndeterminate(false);
        }

        @Override
        public void dataBaseConnectionOpened(DataBaseConnection dataBaseConnection) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ShowDialog.infomationMessage(ConnectController.this.view, "url[" + DbTestOpen.this.dbc.getUrl() + "]\u306b\u3001\n" + "user[" + DbTestOpen.this.dbc.getUser() + "]\u3067\u63a5\u7d9a\u6210\u529f\u3057\u307e\u3057\u305f\u3002", "\u63a5\u7d9a\u30c6\u30b9\u30c8\u306b\u6210\u529f\u3057\u307e\u3057\u305f");
                    if (ConnectController.this.view.getJCheckBoxAutosave().isSelected()) {
                        try {
                            ConfigConnect row = ConnectController.this.config.getConfigConnectRow(ConnectController.this.view.getJTextFieldConnectName().getText());
                            ConnectController.this.collectInputData(row);
                            ConnectController.this.connectTableModel.save(row);
                        }
                        catch (SQLException e) {
                            ShowDialog.errorMessage(e);
                        }
                    }
                }
            });
        }

        @Override
        public void dataBaseConnectionClosing(DataBaseConnection dataBaseConnection) {
            dataBaseConnection.removeConnectionlisteners(this);
        }

        @Override
        public void dataBaseConnectionClosed(DataBaseConnection dataBaseConnection) {
        }
    }

    private class JdbcUrlChnageListener
    implements DocumentListener,
    ActionListener {
        private JdbcUrlChnageListener() {
        }

        private void jdbcUrlConvert() {
            ConfigDbms selectDbms = (ConfigDbms)ConnectController.this.view.getJComboBoxDBMS().getSelectedItem();
            if (selectDbms == null) {
                return;
            }
            String subprotocol = selectDbms.getSubprotocol();
            String subname = selectDbms.getSubname();
            String portNumber = ConnectController.this.view.getJTextFieldPortNumber().getText();
            StringBuffer url = new StringBuffer("jdbc" + ("".equals(subprotocol) ? "" : ":" + subprotocol) + ("".equals(subname) ? "" : ":" + subname));
            this.replaceString(url, "%HostName%", ConnectController.this.view.getJTextFieldHostName().getText());
            this.replaceString(url, "%DataBaseName%", ConnectController.this.view.getJTextFieldDatabaseName().getText());
            this.replaceString(url, "%PortNumber%", String.valueOf("".equals(portNumber) ? "" : ":") + portNumber);
            this.replaceString(url, "%PortNumberRAW%", portNumber);
            url.append(ConnectController.this.view.getJTextFieldUrlOption().getText());
            ConnectController.this.view.getJTextAreaURL().setText(url.toString());
        }

        private void replaceString(StringBuffer org, String b, String a) {
            int start = org.indexOf(b);
            if (start == -1) {
                return;
            }
            org.replace(start, start + b.length(), a);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.jdbcUrlConvert();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.jdbcUrlConvert();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.jdbcUrlConvert();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.jdbcUrlConvert();
        }
    }
}

