/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import jdbcacsess2.main.FontZoom;
import jdbcacsess2.main.JmyTable;
import jdbcacsess2.main.ShowDialog;
import jdbcacsess2.main.TabbedPaneMousePointer;
import jdbcacsess2.main.icon.IconImage;
import jdbcacsess2.sqlService.DataBaseConnection;
import jdbcacsess2.sqlService.dbobject.DBObject;
import jdbcacsess2.sqlService.dbobject.DBObjects;
import jdbcacsess2.sqlService.dbobject.DBobjectChangeListener;
import jdbcacsess2.sqlService.dbobject.DBobjectMutableTreeTableNode;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class JPanelSession
extends JPanel {
    private DataBaseConnection dataBaseConnection;
    public TabbedPaneMousePointer tabbedPaneMousePointer;
    private int jTabbedPanelSqlCounter = 1;
    private static final long serialVersionUID = 4124766267642610593L;
    JLabel jLabelStatus = null;
    private JSplitPane jSplitPaneTree = null;
    private JXTreeTable jxTreeTableDBObjects = null;
    private JPanel jPanel1 = null;
    private JTabbedPane jTabbedPaneSql = null;
    private JPopupMenu jPopupTabbedSql = null;
    private JMenuItem jMenuTabbedSqlNew = null;
    private JMenuItem jMenuTabbedSqlClose = null;
    private JMenuItem jMenuTabbedSqlCloseOther = null;
    private JScrollPane jScrollPaneDBObjects = null;
    private JSplitPane jSplitPaneDBObjects = null;
    private JScrollPane jScrollPaneProperty = null;
    private JmyTable jTableProperty = null;
    private JTabbedPane jTabbedPane = null;
    private JScrollPane jScrollPaneExportedKey = null;
    private JmyTable jTableExportedKey = null;
    private JPopupMenu jPopupMenu = null;
    private JMenuItem jMenuDBobjectsRefresh = null;

    void setDataBaseConnection(DataBaseConnection dataBaseConnection) {
        this.dataBaseConnection = dataBaseConnection;
    }

    DataBaseConnection getDataBaseConnection() {
        return this.dataBaseConnection;
    }

    public int increaseJTabbedPanelSqlCount() {
        return this.jTabbedPanelSqlCounter++;
    }

    void addChildren(DBobjectMutableTreeTableNode treeNode) {
        DBObject parent = treeNode.getDBObject();
        if (parent.isBottom() || !parent.isNoCache()) {
            return;
        }
        parent.getAsyncChildren(this.getDataBaseConnection(), new DBobjectChangeListener(treeNode){

            @Override
            public void exception(Throwable t) {
                ShowDialog.errorMessage(t);
            }

            @Override
            public void valueChanged(final DBObjects dbObjects) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DefaultTreeTableModel treeTableModel = (DefaultTreeTableModel)JPanelSession.this.getJXTreetableDBObjects().getTreeTableModel();
                        Iterator<? extends DBObject> iterator = dbObjects.getDBObjects().iterator();
                        while (iterator.hasNext()) {
                            DBObject dbObject;
                            DBobjectMutableTreeTableNode child = new DBobjectMutableTreeTableNode(dbObject, !(dbObject = iterator.next()).isBottom());
                            treeTableModel.insertNodeInto((MutableTreeTableNode)child, (MutableTreeTableNode)this.getParentNode(), this.getParentNode().getChildCount());
                        }
                    }
                });
            }
        });
    }

    public JPanelSession() {
        this.initialize();
    }

    private void initialize() {
        this.jLabelStatus = new JLabel();
        this.jLabelStatus.setText("");
        this.setLayout(new BorderLayout());
        this.add((Component)this.jLabelStatus, "South");
        this.add((Component)this.getJSplitPaneTree(), "Center");
    }

    JSplitPane getJSplitPaneTree() {
        if (this.jSplitPaneTree == null) {
            this.jSplitPaneTree = new JSplitPane();
            this.jSplitPaneTree.setOneTouchExpandable(true);
            this.jSplitPaneTree.setDividerLocation(250);
            this.jSplitPaneTree.setLeftComponent(this.getJSplitPaneDBObjects());
            this.jSplitPaneTree.setRightComponent(this.getJPanel1());
        }
        return this.jSplitPaneTree;
    }

    JXTreeTable getJXTreetableDBObjects() {
        if (this.jxTreeTableDBObjects == null) {
            this.jxTreeTableDBObjects = new JXTreeTable();
            this.jxTreeTableDBObjects.setTreeTableModel((TreeTableModel)new DefaultTreeTableModel());
            this.jxTreeTableDBObjects.setToggleClickCount(0);
            this.jxTreeTableDBObjects.setTreeCellRenderer((TreeCellRenderer)new ObjectsTreeCellRenderer());
            this.jxTreeTableDBObjects.setAutoResizeMode(0);
            this.jxTreeTableDBObjects.setShowVerticalLines(false);
            this.jxTreeTableDBObjects.setShowHorizontalLines(false);
            this.jxTreeTableDBObjects.setOpaque(true);
            this.jxTreeTableDBObjects.setHighlighters(new Highlighter[]{HighlighterFactory.createSimpleStriping()});
            this.jxTreeTableDBObjects.setComponentPopupMenu(this.getJPopupMenu());
            FontZoom.setMouseWheel((Component)this.jxTreeTableDBObjects);
        }
        return this.jxTreeTableDBObjects;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BorderLayout());
            this.jPanel1.add((Component)this.getJTabbedPaneSql(), "Center");
        }
        return this.jPanel1;
    }

    public JTabbedPane getJTabbedPaneSql() {
        if (this.jTabbedPaneSql == null) {
            this.jTabbedPaneSql = new JTabbedPane();
            this.jTabbedPaneSql.setComponentPopupMenu(this.getJPopupTabbedSql());
            this.tabbedPaneMousePointer = new TabbedPaneMousePointer(this.jTabbedPaneSql);
        }
        return this.jTabbedPaneSql;
    }

    JPopupMenu getJPopupTabbedSql() {
        if (this.jPopupTabbedSql == null) {
            this.jPopupTabbedSql = new JPopupMenu();
            this.jPopupTabbedSql.add(this.getJMenuTabbedSqlNew());
            this.jPopupTabbedSql.add(this.getJMenuTabbedSqlClose());
            this.jPopupTabbedSql.add(this.getJMenuTabbedSqlCloseOther());
        }
        return this.jPopupTabbedSql;
    }

    JMenuItem getJMenuTabbedSqlNew() {
        if (this.jMenuTabbedSqlNew == null) {
            this.jMenuTabbedSqlNew = new JMenuItem(IconImage.TAB_ADD.getValue());
            this.jMenuTabbedSqlNew.setText("New");
        }
        return this.jMenuTabbedSqlNew;
    }

    JMenuItem getJMenuTabbedSqlClose() {
        if (this.jMenuTabbedSqlClose == null) {
            this.jMenuTabbedSqlClose = new JMenuItem(IconImage.TAB_DELETE.getValue());
            this.jMenuTabbedSqlClose.setText("Close");
        }
        return this.jMenuTabbedSqlClose;
    }

    JMenuItem getJMenuTabbedSqlCloseOther() {
        if (this.jMenuTabbedSqlCloseOther == null) {
            this.jMenuTabbedSqlCloseOther = new JMenuItem(IconImage.TAB_DELETE.getValue());
            this.jMenuTabbedSqlCloseOther.setText("CloseOther");
        }
        return this.jMenuTabbedSqlCloseOther;
    }

    private JScrollPane getJScrollPaneDBObjects() {
        if (this.jScrollPaneDBObjects == null) {
            this.jScrollPaneDBObjects = new JScrollPane();
            this.jScrollPaneDBObjects.setViewportView((Component)this.getJXTreetableDBObjects());
        }
        return this.jScrollPaneDBObjects;
    }

    JSplitPane getJSplitPaneDBObjects() {
        if (this.jSplitPaneDBObjects == null) {
            this.jSplitPaneDBObjects = new JSplitPane();
            this.jSplitPaneDBObjects.setOrientation(0);
            this.jSplitPaneDBObjects.setDividerLocation(450);
            this.jSplitPaneDBObjects.setBottomComponent(this.getJTabbedPane());
            this.jSplitPaneDBObjects.setTopComponent(this.getJScrollPaneDBObjects());
        }
        return this.jSplitPaneDBObjects;
    }

    private JScrollPane getJScrollPaneProperty() {
        if (this.jScrollPaneProperty == null) {
            this.jScrollPaneProperty = new JScrollPane();
            this.jScrollPaneProperty.setViewportView((Component)((Object)this.getJTableProperty()));
        }
        return this.jScrollPaneProperty;
    }

    JmyTable getJTableProperty() {
        if (this.jTableProperty == null) {
            this.jTableProperty = new JmyTable();
        }
        return this.jTableProperty;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Properties", null, this.getJScrollPaneProperty(), null);
            this.jTabbedPane.addTab("ExportedKeys", null, this.getJScrollPaneExportedKey(), null);
        }
        return this.jTabbedPane;
    }

    private JScrollPane getJScrollPaneExportedKey() {
        if (this.jScrollPaneExportedKey == null) {
            this.jScrollPaneExportedKey = new JScrollPane();
            this.jScrollPaneExportedKey.setViewportView((Component)((Object)this.getJTableExportedKey()));
        }
        return this.jScrollPaneExportedKey;
    }

    JmyTable getJTableExportedKey() {
        if (this.jTableExportedKey == null) {
            this.jTableExportedKey = new JmyTable();
        }
        return this.jTableExportedKey;
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJMenuDBobjectsRefresh());
        }
        return this.jPopupMenu;
    }

    JMenuItem getJMenuDBobjectsRefresh() {
        if (this.jMenuDBobjectsRefresh == null) {
            this.jMenuDBobjectsRefresh = new JMenuItem(IconImage.REFRESH.getValue());
            this.jMenuDBobjectsRefresh.setText("Refresh");
        }
        return this.jMenuDBobjectsRefresh;
    }

    static class ObjectsTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 988648723443010093L;

        ObjectsTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DBObject o = ((DBobjectMutableTreeTableNode)((Object)value)).getDBObject();
            Icon icon = o.getIconImage();
            this.setOpenIcon(icon);
            this.setClosedIcon(icon);
            this.setLeafIcon(icon);
            Font font = this.getFont();
            if (font != null) {
                if (o.isStrong()) {
                    this.setFont(this.getFont().deriveFont(1));
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                }
            }
            super.getTreeCellRendererComponent(tree, o.isCaching() ? "LOADONG... " + o.getSummary() : o.getSummary(), selected, expanded, leaf, row, hasFocus);
            return this;
        }
    }
}

