/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.main;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class OneLinenFormatter
extends Formatter {
    private final SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer message = new StringBuffer();
        message.append(this.sdFormat.format(new Date(record.getMillis())));
        message.append(' ').append(record.getLevel().toString());
        String className = record.getSourceClassName();
        message.append(' ').append(className != null ? className : record.getLoggerName());
        String methodName = record.getSourceMethodName();
        message.append(" [").append(methodName != null ? methodName : "N/A").append("] ");
        message.append(this.formatMessage(record)).append('\n');
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            message.append(throwable.toString()).append('\n');
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement trace = stackTraceElementArray[n2];
                message.append('\t').append(trace.toString()).append('\n');
                ++n2;
            }
        }
        return message.toString();
    }
}

