/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.main;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableColumnFit
implements TableColumnModelListener,
TableModelListener,
MouseMotionListener,
PropertyChangeListener {
    private final JTable jTable;
    private boolean autoFit = false;

    public TableColumnFit(JTable jTable) {
        this.jTable = jTable;
        this.jTable.setAutoResizeMode(0);
    }

    public boolean isAutoFit() {
        return this.autoFit;
    }

    public void setEnableAutoFit(boolean autoFit) {
        if (autoFit) {
            this.setPreferredWidthFromHeader();
            int row = 0;
            while (row < this.jTable.getModel().getRowCount()) {
                this.setPreferredSizeFromRoW(row);
                ++row;
            }
            this.jTable.doLayout();
            if (this.autoFit != autoFit) {
                JTableHeader jTableHeader = this.jTable.getTableHeader();
                if (jTableHeader != null) {
                    jTableHeader.addMouseMotionListener(this);
                }
                this.jTable.getModel().addTableModelListener(this);
                if (jTableHeader != null) {
                    jTableHeader.getColumnModel().addColumnModelListener(this);
                }
                this.jTable.addPropertyChangeListener("font", this);
            }
        } else {
            this.jTable.getTableHeader().removeMouseMotionListener(this);
            this.jTable.getModel().removeTableModelListener(this);
            this.jTable.getTableHeader().getColumnModel().removeColumnModelListener(this);
            this.jTable.removePropertyChangeListener(this);
        }
        this.autoFit = autoFit;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setEnableAutoFit(false);
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        if (!this.autoFit) {
            return;
        }
        this.setPreferredWidthFromHeader();
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        if (!this.autoFit) {
            return;
        }
        switch (event.getType()) {
            case 0: {
                if (event.getFirstRow() == -1) {
                    this.setPreferredWidthFromHeader();
                    break;
                }
                int cnt = this.jTable.getModel().getRowCount();
                if (event.getLastRow() < cnt) {
                    cnt = event.getLastRow();
                }
                int row = event.getFirstRow();
                while (row < cnt) {
                    this.setPreferredSizeFromRoW(row);
                    ++row;
                }
                break;
            }
            case 1: {
                int row = event.getFirstRow();
                while (row <= event.getLastRow()) {
                    this.setPreferredSizeFromRoW(row);
                    ++row;
                }
                break;
            }
        }
    }

    private void setPreferredWidthFromHeader() {
        JTableHeader tableHeader = this.jTable.getTableHeader();
        TableCellRenderer defrenderer = null;
        if (tableHeader != null) {
            defrenderer = tableHeader.getDefaultRenderer();
        }
        TableColumnModel tcm = this.jTable.getColumnModel();
        Enumeration<TableColumn> e = tcm.getColumns();
        while (e.hasMoreElements()) {
            TableColumn tableColumn = e.nextElement();
            TableCellRenderer r = tableColumn.getCellRenderer();
            if (r == null) {
                if (defrenderer != null) {
                    r = defrenderer;
                } else {
                    return;
                }
            }
            JComponent c = (JComponent)r.getTableCellRendererComponent(this.jTable, tableColumn.getHeaderValue(), false, false, -1, 0);
            int w = this.preferredWidth(c);
            tableColumn.setPreferredWidth(w);
        }
        this.jTable.setRowHeight(1);
    }

    private void setPreferredSizeFromRoW(int row) {
        int column = 0;
        while (column < this.jTable.getColumnCount()) {
            TableColumn tableColumn = this.jTable.getColumnModel().getColumn(column);
            TableCellRenderer r = this.jTable.getCellRenderer(row, column);
            JComponent c = (JComponent)r.getTableCellRendererComponent(this.jTable, this.jTable.getModel().getValueAt(row, column), false, false, row, column);
            int w = this.preferredWidth(c);
            if (tableColumn.getPreferredWidth() < w) {
                tableColumn.setPreferredWidth(w);
            }
            int h = this.preferredHeight(c);
            if (this.jTable.getRowHeight() < h) {
                this.jTable.setRowHeight(h);
            }
            ++column;
        }
    }

    private int preferredWidth(JComponent jComponent) {
        int rtn = jComponent.getPreferredSize().width + jComponent.getInsets().left + jComponent.getInsets().right + this.jTable.getIntercellSpacing().width;
        return rtn;
    }

    private int preferredHeight(JComponent jComponent) {
        int rtn = jComponent.getPreferredSize().height;
        return rtn;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setPreferredWidthFromHeader();
        int row = 0;
        while (row < this.jTable.getModel().getRowCount()) {
            this.setPreferredSizeFromRoW(row);
            ++row;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }
}

