/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.sqlService.DataBaseConnectionListener;
import jdbcacsess2.sqlService.DataBaseTransactionListener;
import jdbcacsess2.sqlService.exception.DbConnectAlreadyException;
import jdbcacsess2.sqlService.exception.DbConnectDriverLoadException;
import jdbcacsess2.sqlService.exception.DbConnectIllgalStateException;
import jdbcacsess2.sqlService.exception.DbConnectNotConectException;

public class DataBaseConnection {
    static final int TIMEOUT_SECONDS = 3;
    private Connection connection;
    private final String url;
    private final String user;
    private final String password;
    private final String driverClassName;
    private final URL[] driverUrlPaths;
    private Driver driver;
    private String connectName;
    private final EventListenerList listeners = new EventListenerList();
    private volatile boolean use = false;
    private String sql;
    static final Map<String, Driver> driverCaches = new HashMap<String, Driver>();
    private ExecutorService executorService;

    public synchronized void lockConnection(String sql) throws DbConnectIllgalStateException {
        if (this.use) {
            throw new DbConnectIllgalStateException("database connection in use.[" + this.toString() + "]" + this.sql);
        }
        this.use = true;
        this.sql = sql;
    }

    public synchronized void unlockConnection() throws DbConnectIllgalStateException {
        if (!this.use) {
            throw new DbConnectIllgalStateException("database connection not in use.[" + this.toString() + "]" + this.sql);
        }
        this.use = false;
    }

    public void addConnectionListener(DataBaseConnectionListener listener) {
        this.listeners.add(DataBaseConnectionListener.class, listener);
    }

    public void removeConnectionlisteners(DataBaseConnectionListener listener) {
        this.listeners.remove(DataBaseConnectionListener.class, listener);
    }

    public void addTransactionListener(DataBaseTransactionListener listener) {
        this.listeners.add(DataBaseTransactionListener.class, listener);
    }

    public void removeTransactionlisteners(DataBaseTransactionListener listener) {
        this.listeners.remove(DataBaseTransactionListener.class, listener);
    }

    public DataBaseConnection(String url, String user, String password, String driverClassName, URL[] driverUrlPaths, String connectName) throws DbConnectDriverLoadException, FileNotFoundException {
        this.url = url;
        this.user = user;
        this.password = password;
        this.driverClassName = driverClassName;
        this.driverUrlPaths = driverUrlPaths;
        this.connectName = connectName == null ? "" : connectName;
        this.loadDriver();
    }

    public DataBaseConnection(DataBaseConnection dataBaseConnection) throws DbConnectDriverLoadException, FileNotFoundException {
        this.url = dataBaseConnection.getUrl();
        this.user = dataBaseConnection.getUser();
        this.password = dataBaseConnection.password;
        this.driverClassName = dataBaseConnection.getDriverClassName();
        this.driverUrlPaths = dataBaseConnection.driverUrlPaths;
        this.connectName = dataBaseConnection.connectName;
        this.loadDriver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDriver() throws DbConnectDriverLoadException, FileNotFoundException {
        try {
            String key;
            if (this.driverUrlPaths.length == 0) {
                key = "";
            } else {
                List<URL> list = Arrays.asList(this.driverUrlPaths);
                for (URL url : list) {
                    File f = new File(url.toURI());
                    if (f.canRead()) continue;
                    throw new FileNotFoundException("not found or can't read:" + f.toString());
                }
                key = String.valueOf(list.toString()) + this.driverClassName;
            }
            Map<String, Driver> map = driverCaches;
            synchronized (map) {
                if (driverCaches.containsKey(key)) {
                    this.driver = driverCaches.get(key);
                } else {
                    this.driver = this.driverUrlPaths.length == 0 ? (Driver)Class.forName(this.driverClassName).newInstance() : (Driver)Class.forName(this.driverClassName, true, new URLClassLoader(this.driverUrlPaths)).newInstance();
                    driverCaches.put(key, this.driver);
                    Jdbcacsess2.logger.info(driverCaches + " size=" + driverCaches.size());
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DbConnectDriverLoadException(e);
        }
    }

    public void open() throws SQLException, DbConnectAlreadyException {
        if (this.connection != null) {
            throw new DbConnectAlreadyException("Already opend.[" + this.url + "]");
        }
        Properties info = new Properties();
        info.put("user", this.user);
        info.put("password", this.password);
        this.connection = this.driver.connect(this.url, info);
        this.executorService = Executors.newSingleThreadExecutor();
        DataBaseConnectionListener[] dataBaseConnectionListenerArray = (DataBaseConnectionListener[])this.listeners.getListeners(DataBaseConnectionListener.class);
        int n = dataBaseConnectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataBaseConnectionListener listener = dataBaseConnectionListenerArray[n2];
            Jdbcacsess2.logger.fine("***opened*** " + listener.toString());
            listener.dataBaseConnectionOpened(this);
            ++n2;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getConnectName() {
        return this.connectName;
    }

    public void close() throws DbConnectIllgalStateException {
        DataBaseConnectionListener[] dataBaseConnectionListenerArray = (DataBaseConnectionListener[])this.listeners.getListeners(DataBaseConnectionListener.class);
        int n = dataBaseConnectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataBaseConnectionListener listener = dataBaseConnectionListenerArray[n2];
            Jdbcacsess2.logger.fine("***closing*** " + listener.toString());
            listener.dataBaseConnectionClosing(this);
            ++n2;
        }
        if (this.use) {
            throw new DbConnectIllgalStateException("database connection in use.[close]");
        }
        if (this.connection != null) {
            List<Runnable> task = this.executorService.shutdownNow();
            Jdbcacsess2.logger.log(Level.INFO, "shutdownNow rtn:" + task.toString() + " isTerminated:" + this.executorService.isTerminated());
            try {
                Executors.newSingleThreadExecutor().submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        DataBaseConnection.this.connection.close();
                        return null;
                    }
                }).get(3L, TimeUnit.SECONDS);
                DataBaseConnectionListener[] dataBaseConnectionListenerArray2 = (DataBaseConnectionListener[])this.listeners.getListeners(DataBaseConnectionListener.class);
                int n3 = dataBaseConnectionListenerArray2.length;
                n = 0;
                while (n < n3) {
                    DataBaseConnectionListener listener = dataBaseConnectionListenerArray2[n];
                    Jdbcacsess2.logger.fine("***closed*** " + listener.toString());
                    listener.dataBaseConnectionClosed(this);
                    ++n;
                }
            }
            catch (InterruptedException e) {
                Jdbcacsess2.logger.log(Level.WARNING, "connection close exception " + this.getConnectName(), e);
            }
            catch (ExecutionException e) {
                Jdbcacsess2.logger.log(Level.WARNING, "connection close exception " + this.getConnectName(), e);
            }
            catch (TimeoutException e) {
                Jdbcacsess2.logger.log(Level.WARNING, "connection close exception " + this.getConnectName(), e);
            }
            this.connection = null;
        }
    }

    public static URL[] splitPath(String urls) throws MalformedURLException {
        StringTokenizer st = new StringTokenizer(urls, File.pathSeparator);
        ArrayList<URL> jarUrlList = new ArrayList<URL>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("")) continue;
            File file = new File(s);
            jarUrlList.add(file.toURI().toURL());
        }
        return jarUrlList.toArray(new URL[jarUrlList.size()]);
    }

    public void commit() throws Exception {
        if (this.isClosed()) {
            throw new DbConnectNotConectException();
        }
        this.getExecutorService().submit(new Callable<Object>(){

            @Override
            public Object call() throws SQLException {
                DataBaseConnection.this.connection.commit();
                return null;
            }
        }).get(3L, TimeUnit.SECONDS);
        DataBaseTransactionListener[] dataBaseTransactionListenerArray = (DataBaseTransactionListener[])this.listeners.getListeners(DataBaseTransactionListener.class);
        int n = dataBaseTransactionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataBaseTransactionListener listener = dataBaseTransactionListenerArray[n2];
            listener.commitEnd(this);
            ++n2;
        }
    }

    public void rollback() throws Exception {
        if (this.isClosed()) {
            throw new DbConnectNotConectException();
        }
        this.getExecutorService().submit(new Callable<Object>(){

            @Override
            public Object call() throws SQLException {
                DataBaseConnection.this.connection.rollback();
                return null;
            }
        }).get(3L, TimeUnit.SECONDS);
        DataBaseTransactionListener[] dataBaseTransactionListenerArray = (DataBaseTransactionListener[])this.listeners.getListeners(DataBaseTransactionListener.class);
        int n = dataBaseTransactionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataBaseTransactionListener listener = dataBaseTransactionListenerArray[n2];
            listener.rollbackEnd(this);
            ++n2;
        }
    }

    public boolean getAutoCommit() throws SQLException, DbConnectNotConectException {
        if (this.isClosed()) {
            throw new DbConnectNotConectException();
        }
        return this.connection.getAutoCommit();
    }

    public void setAutoCommit(final boolean autoCommit) throws Exception {
        if (this.isClosed()) {
            throw new DbConnectNotConectException();
        }
        this.getExecutorService().submit(new Callable<Object>(){

            @Override
            public Object call() throws SQLException {
                DataBaseConnection.this.connection.setAutoCommit(autoCommit);
                return null;
            }
        }).get(3L, TimeUnit.SECONDS);
        DataBaseTransactionListener[] dataBaseTransactionListenerArray = (DataBaseTransactionListener[])this.listeners.getListeners(DataBaseTransactionListener.class);
        int n = dataBaseTransactionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataBaseTransactionListener listener = dataBaseTransactionListenerArray[n2];
            listener.autoCommitChange(this, autoCommit);
            ++n2;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException, DbConnectNotConectException {
        if (this.isClosed()) {
            throw new DbConnectNotConectException();
        }
        return this.connection.getMetaData();
    }

    public boolean isClosed() throws SQLException {
        if (this.connection == null) {
            return true;
        }
        return this.connection.isClosed();
    }

    public CallableStatement prepareCall(String sql) throws SQLException, DbConnectNotConectException, DbConnectIllgalStateException {
        if (this.connection == null) {
            throw new DbConnectNotConectException();
        }
        CallableStatement statement = this.connection.prepareCall(sql);
        return (CallableStatement)this.newProxyStatementInstance(CallableStatement.class, statement);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException, DbConnectNotConectException, DbConnectIllgalStateException {
        if (this.connection == null) {
            throw new DbConnectNotConectException();
        }
        PreparedStatement statement = this.connection.prepareStatement(sql);
        return (PreparedStatement)this.newProxyStatementInstance(PreparedStatement.class, statement);
    }

    private Object newProxyStatementInstance(Class<?> c, Statement statement) {
        return Proxy.newProxyInstance(statement.getClass().getClassLoader(), new Class[]{c}, (InvocationHandler)new StatementeHandler(statement));
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private static class StatementeHandler
    implements InvocationHandler {
        Object target;

        StatementeHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Jdbcacsess2.logger.fine("---" + method.getName() + " start");
            Object o = this.send(this.target, method, args);
            Jdbcacsess2.logger.fine("---" + method.getName() + " end");
            return o;
        }

        private Object send(Object target, Method m, Object[] args) throws Throwable {
            try {
                return m.invoke(target, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
    }
}

