/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import javax.swing.Icon;
import jdbcacsess2.sqlService.ConstSqlTypes;
import jdbcacsess2.sqlService.DataBaseConnection;
import jdbcacsess2.sqlService.dbobject.DBObjects;
import jdbcacsess2.sqlService.dbobject.DBobjectChangeListener;
import jdbcacsess2.sqlService.dbobject.SchemaTableName;

public abstract class DBObject {
    private volatile DBobjectCacheState state = DBobjectCacheState.NOCACHE;
    DBObjects list;

    public boolean isNoCache() {
        return this.state == DBobjectCacheState.NOCACHE;
    }

    public boolean isCaching() {
        return this.state == DBobjectCacheState.CACHING;
    }

    public void clearCache() {
        this.state = DBobjectCacheState.NOCACHE;
    }

    public void getAsyncChildren(final DataBaseConnection dataBaseConnection, final DBobjectChangeListener listener) {
        if (this.isBottom()) {
            throw new IllegalStateException("node is bottom(leaf)");
        }
        if (this.state == DBobjectCacheState.CACHED) {
            listener.valueChanged(this.list);
            return;
        }
        if (this.state == DBobjectCacheState.CACHING) {
            return;
        }
        this.state = DBobjectCacheState.CACHING;
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                try {
                    DBObject.this.list = DBObject.this.getChildren(dataBaseConnection.getMetaData());
                }
                catch (Throwable t) {
                    listener.exception(t);
                    return;
                }
                DBObject.this.state = DBobjectCacheState.CACHED;
                listener.valueChanged(DBObject.this.list);
            }
        };
        dataBaseConnection.getExecutorService().execute(worker);
    }

    public abstract List<Property> getProperties();

    public abstract DBObjects getChildren(DatabaseMetaData var1) throws SQLException;

    public SchemaTableName getSchemaTableName() throws SQLException {
        return new SchemaTableName();
    }

    public abstract String getName();

    public abstract Icon getIconImage();

    public abstract boolean isStrong();

    public abstract boolean isBottom();

    public abstract String getSummary();

    public String getProperty1() {
        return "";
    }

    public String getProperty2() {
        return "";
    }

    public String getProperty3() {
        return "";
    }

    public String getProperty4() {
        return "";
    }

    public abstract boolean isPropertyEnable();

    public StringBuilder editAttrString(int dataType, int columnSize, int decimalDigits) {
        StringBuilder attr = new StringBuilder();
        ConstSqlTypes constSqlTypes = ConstSqlTypes.searchTypes(dataType);
        attr.append(constSqlTypes.name()).append('(').append(columnSize);
        if (constSqlTypes.getCategoly() == ConstSqlTypes.Categoly.NUM && decimalDigits != 0) {
            attr.append('.').append(decimalDigits);
        }
        attr.append(')');
        return attr;
    }

    static enum DBobjectCacheState {
        NOCACHE,
        CACHING,
        CACHED;

    }

    public static class Property {
        private final String name;
        private final String value;

        public Property(String name, String value) {
            this.name = name;
            this.value = value == null ? "" : value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

