/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import jdbcacsess2.sqlService.dbobject.DBObject;
import jdbcacsess2.sqlService.dbobject.DBObjectSchemas;
import jdbcacsess2.sqlService.dbobject.DBObjectTableTypes;
import jdbcacsess2.sqlService.dbobject.DBObjects;
import jdbcacsess2.sqlService.dbobject.icon.DbObjectIconImage;

public class DBObjectCatalogs
extends DBObjects {
    private final ArrayList<DBObject> catalogs = new ArrayList();

    public DBObjectCatalogs(DatabaseMetaData dmd) throws SQLException {
        ResultSet rs = dmd.getCatalogs();
        while (rs.next()) {
            this.catalogs.add(new DBObjectCatalog(rs));
        }
        rs.close();
    }

    public ArrayList<DBObject> getDBObjects() {
        return this.catalogs;
    }

    @Override
    public String toString() {
        return "CATALOG";
    }

    public static class DBObjectCatalog
    extends DBObject {
        public String catalogName;
        private final List<DBObject.Property> properties = new ArrayList<DBObject.Property>();

        @Override
        public List<DBObject.Property> getProperties() {
            return this.properties;
        }

        public DBObjectCatalog(ResultSet rs) throws SQLException {
            int colCnt = rs.getMetaData().getColumnCount();
            int i = 0;
            if (colCnt > i) {
                this.catalogName = rs.getString(++i);
                this.properties.add(new DBObject.Property("TABLE_CAT", this.catalogName));
            }
        }

        @Override
        public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
            DBObjects dbObjects = new DBObjectSchemas(this, dmd);
            if (((DBObjects)dbObjects).getDBObjects().size() == 0) {
                dbObjects = new DBObjectTableTypes(this, null, dmd);
            }
            return dbObjects;
        }

        @Override
        public String getName() {
            return this.catalogName;
        }

        @Override
        public Icon getIconImage() {
            return DbObjectIconImage.CATALOG.getValue();
        }

        @Override
        public boolean isStrong() {
            return false;
        }

        @Override
        public boolean isBottom() {
            return false;
        }

        @Override
        public String getSummary() {
            if (this.catalogName == null) {
                return "(\u7121\u3057)";
            }
            return this.catalogName;
        }

        @Override
        public boolean isPropertyEnable() {
            return false;
        }
    }
}

