/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import jdbcacsess2.sqlService.dbobject.DBObject;
import jdbcacsess2.sqlService.dbobject.DBObjectProcedures;
import jdbcacsess2.sqlService.dbobject.DBObjects;
import jdbcacsess2.sqlService.dbobject.icon.DbObjectIconImage;

public class DBObjectProcedureColumns
extends DBObjects {
    private final ArrayList<DBObjectProcedureColumn> procedureColumns = new ArrayList();

    public DBObjectProcedureColumns(DBObjectProcedures.DBObjectProcedure procedure, DatabaseMetaData dmd) throws SQLException {
        ResultSet rs = dmd.getProcedureColumns(procedure.getProcedureCatalog(), procedure.getProcedureSchema(), procedure.getProcedureName(), null);
        while (rs.next()) {
            this.procedureColumns.add(new DBObjectProcedureColumn(rs));
        }
        rs.close();
    }

    @Override
    public ArrayList<? extends DBObject> getDBObjects() {
        return this.procedureColumns;
    }

    @Override
    public String toString() {
        return "PROCEDURE_COLUMNS";
    }

    public static class DBObjectProcedureColumn
    extends DBObject {
        public String procedureCatalog;
        public String procedureSchema;
        public String procedureName;
        public String columnName;
        public Short columnType;
        public int dataType;
        public String typeName;
        public int precision;
        public int length;
        public short scale;
        public short radix;
        public short nullable;
        public String remarks;
        public String columnDef;
        public int charOctetLength;
        public int ordinalPosition;
        public String isNullable;
        public String specificName;
        private final StringBuilder attr;
        private final List<DBObject.Property> properties = new ArrayList<DBObject.Property>();

        private String getColumnTypeName() {
            switch (this.columnType) {
                case 0: {
                    return "ColumnUnknown";
                }
                case 1: {
                    return "ColumnIn";
                }
                case 2: {
                    return "ColumnInOut";
                }
                case 4: {
                    return "ColumnOut";
                }
                case 5: {
                    return "ColumnReturn";
                }
                case 3: {
                    return "ColumnResult";
                }
            }
            return "?";
        }

        private String getNullableName() {
            switch (this.nullable) {
                case 0: {
                    return "NoNulls";
                }
                case 1: {
                    return "Nullable";
                }
                case 2: {
                    return "NullableUnknown";
                }
            }
            return "?";
        }

        @Override
        public List<DBObject.Property> getProperties() {
            return this.properties;
        }

        public DBObjectProcedureColumn(ResultSet rs) throws SQLException {
            int colCnt = rs.getMetaData().getColumnCount();
            int i = 0;
            if (colCnt > i) {
                this.procedureCatalog = rs.getString(++i);
                this.properties.add(new DBObject.Property("PROCEDURE_CAT", this.procedureCatalog));
            }
            if (colCnt > i) {
                this.procedureSchema = rs.getString(++i);
                this.properties.add(new DBObject.Property("PROCEDURE_SCHEM", this.procedureSchema));
            }
            if (colCnt > i) {
                this.procedureName = rs.getString(++i);
                this.properties.add(new DBObject.Property("PROCEDURE_NAME", this.procedureName));
            }
            if (colCnt > i) {
                this.columnName = rs.getString(++i);
                this.properties.add(new DBObject.Property("COLUMN_NAME", this.columnName));
            }
            if (colCnt > i) {
                this.columnType = rs.getShort(++i);
                this.properties.add(new DBObject.Property("COLUMN_TYPE", this.getColumnTypeName()));
            }
            if (colCnt > i) {
                this.dataType = rs.getInt(++i);
                this.properties.add(new DBObject.Property("DATA_TYPE", Integer.toString(this.dataType)));
            }
            if (colCnt > i) {
                this.typeName = rs.getString(++i);
                this.properties.add(new DBObject.Property("TYPE_NAME", this.typeName));
            }
            if (colCnt > i) {
                this.precision = rs.getInt(++i);
                this.properties.add(new DBObject.Property("PRECISION", Integer.toString(this.precision)));
            }
            if (colCnt > i) {
                this.length = rs.getInt(++i);
                this.properties.add(new DBObject.Property("LENGTH", Integer.toString(this.length)));
            }
            if (colCnt > i) {
                this.scale = rs.getShort(++i);
                this.properties.add(new DBObject.Property("SCALE", Short.toString(this.scale)));
            }
            if (colCnt > i) {
                this.radix = rs.getShort(++i);
                this.properties.add(new DBObject.Property("RADIX", Short.toString(this.radix)));
            }
            if (colCnt > i) {
                this.nullable = rs.getShort(++i);
                this.properties.add(new DBObject.Property("NULLABLE", this.getNullableName()));
            }
            if (colCnt > i) {
                this.remarks = rs.getString(++i);
                this.properties.add(new DBObject.Property("REMARKS", this.remarks));
            }
            if (colCnt > i) {
                this.columnDef = rs.getString(++i);
                this.properties.add(new DBObject.Property("COLUMN_DEF", this.columnDef));
            }
            if (colCnt > i) {
                ++i;
            }
            if (colCnt > i) {
                ++i;
            }
            if (colCnt > i) {
                this.charOctetLength = rs.getInt(++i);
                this.properties.add(new DBObject.Property("CHAR_OCTET_LENGTH", Integer.toString(this.charOctetLength)));
            }
            if (colCnt > i) {
                this.ordinalPosition = rs.getInt(++i);
                this.properties.add(new DBObject.Property("ORDINAL_POSITION", Integer.toString(this.ordinalPosition)));
            }
            if (colCnt > i) {
                this.isNullable = rs.getString(++i);
                this.properties.add(new DBObject.Property("IS_NULLABLE", this.isNullable));
            }
            if (colCnt > i) {
                this.specificName = rs.getString(++i);
                this.properties.add(new DBObject.Property("SPECIFIC_NAME", this.specificName));
            }
            this.attr = this.editAttrString(this.dataType, this.precision, this.scale);
        }

        @Override
        public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
            return null;
        }

        @Override
        public String getName() {
            return this.columnName;
        }

        @Override
        public Icon getIconImage() {
            return DbObjectIconImage.TABLECOLUMN.getValue();
        }

        @Override
        public boolean isStrong() {
            return false;
        }

        @Override
        public boolean isBottom() {
            return true;
        }

        @Override
        public String getSummary() {
            return this.getName();
        }

        @Override
        public String getProperty1() {
            return this.attr.toString();
        }

        @Override
        public String getProperty2() {
            return this.remarks;
        }

        @Override
        public boolean isPropertyEnable() {
            return true;
        }
    }
}

