/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.sqlService.ReferenceColumnResult;
import jdbcacsess2.sqlService.dbobject.DBObject;
import jdbcacsess2.sqlService.dbobject.DBObjectTables;
import jdbcacsess2.sqlService.dbobject.DBObjects;
import jdbcacsess2.sqlService.dbobject.SchemaTableName;
import jdbcacsess2.sqlService.dbobject.icon.DbObjectIconImage;

public class DBObjectTableColumns
extends DBObjects {
    private final ArrayList<DBObjectTableColumn> tableColumns = new ArrayList();
    private final boolean storesLowerCaseIdentifiers;
    private final boolean storesUpperCaseQuotedIdentifiers;

    public DBObjectTableColumns(DBObjectTables.DBObjectTable table, DatabaseMetaData dmd) throws SQLException {
        this.storesLowerCaseIdentifiers = dmd.storesLowerCaseIdentifiers();
        this.storesUpperCaseQuotedIdentifiers = dmd.storesUpperCaseQuotedIdentifiers();
        HashMap<String, Short> pkmap = new HashMap<String, Short>();
        ResultSet pkrs = dmd.getPrimaryKeys(table.tableCatalog, table.tableSchema, table.getTableName());
        while (pkrs.next()) {
            pkmap.put(pkrs.getString(4), pkrs.getShort(5));
        }
        pkrs.close();
        HashMap<String, ReferenceColumnResult> fkmap = new HashMap<String, ReferenceColumnResult>();
        ResultSet fkrs = dmd.getImportedKeys(table.tableCatalog, table.tableSchema, table.getTableName());
        List<ReferenceColumnResult> list = ReferenceColumnResult.convReferenceColumnResult(fkrs);
        for (ReferenceColumnResult rcr : list) {
            fkmap.put(rcr.getFkcolumnName(), rcr);
        }
        fkrs.close();
        ResultSet rs = dmd.getColumns(table.tableCatalog, table.tableSchema, table.getTableName(), null);
        while (rs.next()) {
            this.tableColumns.add(new DBObjectTableColumn(rs, pkmap, fkmap));
        }
        rs.close();
    }

    @Override
    public ArrayList<? extends DBObject> getDBObjects() {
        return this.tableColumns;
    }

    @Override
    public String toString() {
        return "TABLE_COLUMNS";
    }

    public class DBObjectTableColumn
    extends DBObject {
        public String tableCatalog;
        public String tableSchema;
        public String tableName = "";
        public String columnName = "";
        public int dataType;
        public String typeName = "";
        public int columnSize;
        public int decimalDigits;
        public int numPrecRadix;
        public int nullable;
        public String remarks;
        public String columnDef;
        public int charOctetLength;
        public int ordinalPosition;
        public String isNullable = "";
        public String scopeCatalog = "";
        public String scopeSchema = "";
        public String scopeTable = "";
        public short sourceDataType;
        public String isAutoincrement = "";
        private final StringBuilder attr;
        private final Short primaryKeySeqNo;
        private final ReferenceColumnResult forginKey;
        private final List<DBObject.Property> properties = new ArrayList<DBObject.Property>();

        private String getNullableName() {
            switch (this.nullable) {
                case 0: {
                    return "NoNulls";
                }
                case 1: {
                    return "Nullable";
                }
                case 2: {
                    return "NullableUnknown";
                }
            }
            return "?";
        }

        public boolean isPrimaryKey() {
            return this.primaryKeySeqNo != null;
        }

        public String getForginKey() {
            if (this.forginKey != null) {
                return String.valueOf(this.forginKey.getPktableName()) + "." + this.forginKey.getPkcolumnName();
            }
            return "";
        }

        @Override
        public List<DBObject.Property> getProperties() {
            return this.properties;
        }

        public DBObjectTableColumn(ResultSet rs, Map<String, Short> pkmap, Map<String, ReferenceColumnResult> fkmap) throws SQLException {
            int colCnt = rs.getMetaData().getColumnCount();
            int i = 0;
            try {
                if (colCnt > i) {
                    this.tableCatalog = rs.getString(++i);
                    this.properties.add(new DBObject.Property("TABLE_CAT", this.tableCatalog));
                }
                if (colCnt > i) {
                    this.tableSchema = rs.getString(++i);
                    this.properties.add(new DBObject.Property("TABLE_SCHEM", this.tableSchema));
                }
                if (colCnt > i) {
                    this.tableName = rs.getString(++i);
                    this.properties.add(new DBObject.Property("TABLE_NAME", this.tableName));
                }
                if (colCnt > i) {
                    this.columnName = rs.getString(++i);
                    this.properties.add(new DBObject.Property("COLUMN_NAME", this.columnName));
                }
                if (colCnt > i) {
                    this.dataType = rs.getInt(++i);
                    this.properties.add(new DBObject.Property("DATA_TYPE", Integer.toString(this.dataType)));
                }
                if (colCnt > i) {
                    this.typeName = rs.getString(++i);
                    this.properties.add(new DBObject.Property("TYPE_NAME", this.typeName));
                }
                if (colCnt > i) {
                    this.columnSize = rs.getInt(++i);
                    this.properties.add(new DBObject.Property("COLUMN_SIZE", Integer.toString(this.columnSize)));
                }
                if (colCnt > i) {
                    ++i;
                }
                if (colCnt > i) {
                    this.decimalDigits = rs.getInt(++i);
                    this.properties.add(new DBObject.Property("DECIMAL_DIGITS", Integer.toString(this.decimalDigits)));
                }
                if (colCnt > i) {
                    this.numPrecRadix = rs.getInt(++i);
                    this.properties.add(new DBObject.Property("NUM_PREC_RADIX", Integer.toString(this.numPrecRadix)));
                }
                if (colCnt > i) {
                    this.nullable = rs.getInt(++i);
                    this.properties.add(new DBObject.Property("NULLABLE", this.getNullableName()));
                }
                if (colCnt > i) {
                    this.remarks = rs.getString(++i);
                    this.properties.add(new DBObject.Property("REMARKS", this.remarks));
                }
                if (colCnt > i) {
                    this.columnDef = rs.getString(++i);
                    this.properties.add(new DBObject.Property("COLUMN_DEF", this.columnDef));
                }
                if (colCnt > i) {
                    ++i;
                }
                if (colCnt > i) {
                    ++i;
                }
                if (colCnt > i) {
                    this.charOctetLength = rs.getInt(++i);
                    this.properties.add(new DBObject.Property("CHAR_OCTET_LENGTH", Integer.toString(this.charOctetLength)));
                }
                if (colCnt > i) {
                    this.ordinalPosition = rs.getInt(++i);
                    this.properties.add(new DBObject.Property("ORDINAL_POSITION", Integer.toString(this.ordinalPosition)));
                }
                if (colCnt > i) {
                    this.isNullable = rs.getString(++i);
                    this.properties.add(new DBObject.Property("IS_NULLABLE", this.isNullable));
                }
                if (colCnt > i) {
                    this.scopeCatalog = rs.getString(++i);
                    this.properties.add(new DBObject.Property("SCOPE_CATLOG", this.scopeCatalog));
                }
                if (colCnt > i) {
                    this.scopeSchema = rs.getString(++i);
                    this.properties.add(new DBObject.Property("SCOPE_SCHEMA", this.scopeSchema));
                }
                if (colCnt > i) {
                    this.scopeTable = rs.getString(++i);
                    this.properties.add(new DBObject.Property("SCOPE_TABLE", this.scopeTable));
                }
                if (colCnt > i) {
                    this.sourceDataType = rs.getShort(++i);
                    this.properties.add(new DBObject.Property("SOURCE_DATA_TYPE", Short.toString(this.sourceDataType)));
                }
                if (colCnt > i) {
                    this.isAutoincrement = rs.getString(++i);
                    this.properties.add(new DBObject.Property("IS_AUTOINCREMENT", this.isAutoincrement));
                }
            }
            catch (SQLException e) {
                Jdbcacsess2.logger.warning(e.toString());
            }
            this.primaryKeySeqNo = pkmap.get(this.columnName);
            this.properties.add(new DBObject.Property("isPrimaryKey", Boolean.toString(this.isPrimaryKey())));
            this.forginKey = fkmap.get(this.columnName);
            this.properties.add(new DBObject.Property("forginKey", this.getForginKey()));
            this.attr = this.editAttrString(this.dataType, this.columnSize, this.decimalDigits);
        }

        @Override
        public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
            return null;
        }

        @Override
        public SchemaTableName getSchemaTableName() throws SQLException {
            return new SchemaTableName(DBObjectTableColumns.this.storesLowerCaseIdentifiers, DBObjectTableColumns.this.storesUpperCaseQuotedIdentifiers, this.tableSchema, this.tableName);
        }

        @Override
        public String getName() {
            return this.columnName;
        }

        @Override
        public Icon getIconImage() {
            return DbObjectIconImage.TABLECOLUMN.getValue();
        }

        @Override
        public boolean isStrong() {
            return this.isPrimaryKey();
        }

        @Override
        public boolean isBottom() {
            return true;
        }

        @Override
        public String getSummary() {
            return this.getName();
        }

        @Override
        public String getProperty1() {
            return this.attr.toString();
        }

        @Override
        public String getProperty2() {
            return this.remarks;
        }

        @Override
        public String getProperty3() {
            return this.getForginKey();
        }

        @Override
        public String getProperty4() {
            return "";
        }

        @Override
        public boolean isPropertyEnable() {
            return true;
        }
    }
}

