/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.sqlService.dbobject.DBObject;
import jdbcacsess2.sqlService.dbobject.DBObjectCatalogs;
import jdbcacsess2.sqlService.dbobject.DBObjectProcedures;
import jdbcacsess2.sqlService.dbobject.DBObjectSchemas;
import jdbcacsess2.sqlService.dbobject.DBObjectTables;
import jdbcacsess2.sqlService.dbobject.DBObjects;
import jdbcacsess2.sqlService.dbobject.icon.DbObjectIconImage;

public class DBObjectTableTypes
extends DBObjects {
    private final ArrayList<DBObjectTableType> tableTypes = new ArrayList();
    private final DBObjectCatalogs.DBObjectCatalog dbCatalog;
    private final DBObjectSchemas.DBObjectSchema dbObjectSchema;

    public DBObjectTableTypes(DBObjectCatalogs.DBObjectCatalog catalog, DBObjectSchemas.DBObjectSchema schema, DatabaseMetaData dmd) throws SQLException {
        this.dbCatalog = catalog;
        this.dbObjectSchema = schema;
        ResultSet rs = dmd.getTableTypes();
        while (rs.next()) {
            this.tableTypes.add(new DBObjectTableType(rs));
        }
        rs.close();
        this.tableTypes.add(new DBObjectTableTypeProcedure("PROCEDURE"));
    }

    @Override
    public ArrayList<? extends DBObject> getDBObjects() {
        return this.tableTypes;
    }

    @Override
    public String toString() {
        return "TABLETYPE";
    }

    public class DBObjectTableType
    extends DBObject {
        private final List<DBObject.Property> properties = new ArrayList<DBObject.Property>();
        public String tableTypeName;

        public DBObjectTableType(String typeName) {
            this.tableTypeName = typeName;
        }

        public DBObjectTableType(ResultSet rs) {
            try {
                int colCnt = rs.getMetaData().getColumnCount();
                int i = 0;
                if (colCnt > i) {
                    this.tableTypeName = rs.getString(++i);
                    this.properties.add(new DBObject.Property("TABLE_TYPE", this.tableTypeName));
                }
            }
            catch (SQLException e) {
                Jdbcacsess2.logger.warning(e.toString());
            }
        }

        @Override
        public List<DBObject.Property> getProperties() {
            return this.properties;
        }

        @Override
        public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
            return new DBObjectTables(DBObjectTableTypes.this.dbCatalog, DBObjectTableTypes.this.dbObjectSchema, this, dmd);
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Icon getIconImage() {
            return DbObjectIconImage.TABLETYPE.getValue();
        }

        @Override
        public boolean isStrong() {
            return false;
        }

        @Override
        public boolean isBottom() {
            return false;
        }

        @Override
        public String getSummary() {
            return this.tableTypeName;
        }

        @Override
        public boolean isPropertyEnable() {
            return false;
        }
    }

    public class DBObjectTableTypeProcedure
    extends DBObjectTableType {
        DBObjectTableTypeProcedure(String name) {
            super(name);
        }

        @Override
        public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
            return new DBObjectProcedures(DBObjectTableTypes.this.dbCatalog, DBObjectTableTypes.this.dbObjectSchema, dmd);
        }
    }
}

